/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.util.ToString;

public class DataValue<T> {
    private final T value_;
    private final Type type_;
    private final String format_;

    public DataValue(T value, Type type, String format) {
        this.value_ = value;
        this.type_ = type;
        this.format_ = format;
    }

    public T getValue() {
        return this.value_;
    }

    public Type getType() {
        return this.type_;
    }

    public String getFormat() {
        return this.format_;
    }

    public static <T> DataValue<T> of(T value, Type type, String format) {
        return new DataValue<T>(value, type, format);
    }

    public void accept(DataValueVisitor visitor) {
        throw new UnsupportedOperationException("Can't visit a generic DataValue");
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getValue()).toString();
    }

    public boolean equals(Object object) {
        DataValue other = Optional.ofNullable(object).map(Object::getClass).filter(otherClass -> this.getClass().isAssignableFrom((Class<?>)otherClass)).map(otherClass -> (DataValue)object).orElse(null);
        return other != null && Objects.equals(other.getValue(), this.getValue()) && Objects.equals((Object)other.getType(), (Object)this.getType()) && Objects.equals(other.getFormat(), this.getFormat());
    }

    public int hashCode() {
        return DataValue.class.hashCode() ^ Objects.hashCode(this.getValue()) ^ Objects.hashCode((Object)this.getType()) ^ Objects.hashCode(this.getFormat());
    }

    public static enum Type {
        ARRAY,
        BOOLEAN,
        INTEGER,
        NULL,
        NUMBER,
        OBJECT,
        STRING;


        public boolean isComposite() {
            return this == ARRAY || this == OBJECT;
        }

        public static Type[] only(Type type) {
            return new Type[]{type};
        }

        public static Type[] not(Type ... excluded) {
            return (Type[])Arrays.stream(Type.values()).filter(type -> !type.equals((Object)NULL) && Arrays.stream(excluded).noneMatch(e -> type.equals(e) || type.equals((Object)INTEGER) && e == NUMBER)).toArray(Type[]::new);
        }

        public static Type[] any() {
            return Type.not(NULL);
        }
    }
}

