/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.SequenceDomain;

public class BinaryDomain
extends SequenceDomain<byte[]> {
    public BinaryDomain() {
        this(8192);
    }

    public BinaryDomain(int maxLength) {
        super(maxLength);
    }

    @Override
    protected DataValue<byte[]> dataValueOf(byte[] value) {
        return new BinaryValue(value);
    }

    @Override
    public void setExcludedStrings(Set<String> excluded) {
        this.setExcluded(excluded.stream().map(Base64Domain::decoded).collect(Collectors.toSet()));
    }

    @Override
    protected int getLength(byte[] value) {
        return value.length;
    }

    @Override
    protected boolean valuesEqual(byte[] value1, byte[] value2) {
        return Arrays.equals(value1, value2);
    }

    private byte[] newValue(ResolverContext context) {
        byte[] bytes = new byte[((Integer)this.getLengthRange().selectValue(context)).intValue()];
        context.getRandom().nextBytes(bytes);
        return bytes;
    }

    @Override
    protected Stream<byte[]> candidates(ResolverContext context) {
        return Stream.generate(() -> this.newValue(context));
    }
}

