/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.Base64Value;
import org.cornutum.tcases.openapi.resolver.BinaryDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.LengthDomain;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.SequenceDomain;

public class Base64Domain
extends SequenceDomain<String> {
    private BinaryDomain bytes_;

    public Base64Domain() {
        this(8192);
    }

    public Base64Domain(int maxLength) {
        super(maxLength);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new Base64Value(value);
    }

    @Override
    public void setExcludedStrings(Set<String> excluded) {
        this.setExcluded(excluded);
    }

    @Override
    protected int getLength(String value) {
        return Base64Domain.decoded(value).length;
    }

    @Override
    public void setLengthRange(Integer length) {
        this.getBytes().setLengthRange(length);
    }

    @Override
    public void setLengthRange(Integer min, Integer max) {
        this.getBytes().setLengthRange(min, max);
    }

    @Override
    public void setLengthRange(NumberDomain.Range range) {
        this.getBytes().setLengthRange(range);
    }

    @Override
    protected LengthDomain getLengthRange() {
        return this.getBytes().getLengthRange();
    }

    @Override
    public void setExcluded(Set<String> excluded) {
        this.getBytes().setExcluded(Optional.ofNullable(excluded).orElse(Collections.emptySet()).stream().map(Base64Domain::decoded).collect(Collectors.toSet()));
    }

    @Override
    public Set<String> getExcluded() {
        return this.getBytes().getExcluded().stream().map(Base64Domain::encoded).collect(Collectors.toSet());
    }

    private BinaryDomain getBytes() {
        if (this.bytes_ == null) {
            this.bytes_ = new BinaryDomain(this.getMaxLength());
        }
        return this.bytes_;
    }

    public static String encoded(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decoded(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    @Override
    public boolean contains(String value) {
        try {
            return this.getBytes().contains(Base64Domain.decoded(value));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Stream<String> candidates(ResolverContext context) {
        return this.getBytes().values(context).map(DataValue::getValue).map(Base64Domain::encoded);
    }
}

