/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.stream.Stream;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class AsciiStringDomain
extends AbstractStringDomain {
    private final String allowedChars_;

    public AsciiStringDomain() {
        this(Characters.ASCII);
    }

    public AsciiStringDomain(int maxLength) {
        this(maxLength, Characters.ASCII);
    }

    public AsciiStringDomain(Characters chars) {
        this(256, chars);
    }

    public AsciiStringDomain(int maxLength, Characters chars) {
        super(maxLength, chars);
        this.allowedChars_ = chars.filtered(Characters.Ascii.chars()).orElseThrow(() -> new ValueDomainException(String.format("Character set=%s does not accept any ASCII characters", chars)));
    }

    @Override
    protected Stream<String> matchingCandidates(ResolverContext context, AbstractStringDomain.PatternResolver patternResolver) {
        return this.generateMatchingValues(context, patternResolver);
    }

    @Override
    protected String newValue(ResolverContext context, int length) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            value.append(this.allowedChars_.charAt(context.getRandom().nextInt(this.allowedChars_.length())));
        }
        return value.toString();
    }
}

