/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.IntegerConstant;
import org.cornutum.tcases.openapi.resolver.IntegerDomain;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomain;
import org.cornutum.tcases.util.ToString;

public class ArrayDomain<T>
extends AbstractValueDomain<List<DataValue<T>>> {
    private final int maxItems_;
    private ValueDomain<Integer> itemCount_;
    private ValueDomain<T> itemValues_;
    private ValueDomain<T> otherItemValues_;
    private boolean itemsUnique_;

    public ArrayDomain() {
        this(256);
    }

    public ArrayDomain(int maxItems) {
        this.maxItems_ = maxItems;
        this.setItemCount(null, null);
        this.setItemValues(null);
        this.setOtherItemValues(null);
    }

    public int getMaxItems() {
        return this.maxItems_;
    }

    public void setItemCount(Integer itemCount) {
        this.setItemCount(new IntegerConstant(Optional.ofNullable(itemCount).map(m -> Math.max(0, m)).orElse(0)));
    }

    public void setItemCount(Integer min, Integer max) {
        IntegerDomain itemCount = new IntegerDomain(this.getMaxItems());
        itemCount.setRange(Optional.ofNullable(min).orElse(0), Optional.ofNullable(max).orElse(this.getMaxItems()));
        this.setItemCount(itemCount);
    }

    public void setItemCount(NumberDomain.Range range) {
        if (range == null) {
            this.setItemCount(null, null);
        } else if (range.isConstant()) {
            this.setItemCount(Integer.valueOf(range.getMin()));
        } else {
            Integer min = Optional.ofNullable(range.getMin()).map(Integer::valueOf).map(i -> range.isMinExclusive() ? i + 1 : i).orElse(null);
            Integer max = Optional.ofNullable(range.getMax()).map(Integer::valueOf).map(i -> range.isMaxExclusive() ? i - 1 : i).orElse(null);
            this.setItemCount(min, max);
        }
    }

    protected void setItemCount(ValueDomain<Integer> domain) {
        this.itemCount_ = domain;
    }

    protected ValueDomain<Integer> getItemCount() {
        return this.itemCount_;
    }

    public void setItemValues(ValueDomain<T> itemValues) {
        this.itemValues_ = itemValues;
    }

    public ValueDomain<T> getItemValues() {
        return this.itemValues_;
    }

    public void setOtherItemValues(ValueDomain<?> otherItemValues) {
        this.otherItemValues_ = otherItemValues;
    }

    public ValueDomain<T> getOtherItemValues() {
        return this.otherItemValues_;
    }

    public void setItemsUnique(boolean unique) {
        this.itemsUnique_ = unique;
    }

    public boolean isItemsUnique() {
        return this.itemsUnique_;
    }

    @Override
    public Stream<DataValue<List<DataValue<T>>>> values(ResolverContext context) {
        return Stream.generate(() -> this.dataValueOf(this.newArray(context)));
    }

    @Override
    protected DataValue<List<DataValue<T>>> dataValueOf(List<DataValue<T>> value) {
        return new ArrayValue<T>(value);
    }

    private List<DataValue<T>> newArray(ResolverContext context) {
        ArrayList<DataValue<T>> items = new ArrayList<DataValue<T>>();
        boolean itemsUnique = this.isItemsUnique();
        ValueDomain<T> nextItemValues = this.getItemValues();
        ValueDomain<T> otherItemValues = Optional.ofNullable(this.getOtherItemValues()).orElse(nextItemValues);
        int itemCount = this.getItemCount().selectValue(context);
        while (items.size() < itemCount) {
            DataValue<T> nextItem = this.getNextItem(context, nextItemValues, itemCount, items, itemsUnique);
            items.add(nextItem);
            nextItemValues = otherItemValues;
        }
        if (!itemsUnique && items.size() > 1) {
            int source;
            int target = context.getRandom().nextInt(items.size() - 1) + 1;
            while ((source = context.getRandom().nextInt(items.size())) == target) {
            }
            items.set(target, (DataValue<T>)items.get(source));
        }
        return items;
    }

    private DataValue<T> getNextItem(ResolverContext context, ValueDomain<T> nextItemValues, int itemCount, List<DataValue<T>> items, boolean itemsUnique) {
        return context.resultFor(String.format("%sitem[%s] of %s", itemsUnique ? "unique " : "", items.size(), itemCount), () -> (DataValue)context.tryUntil(() -> Optional.of(nextItemValues.select(context)).filter(item -> !itemsUnique || !items.contains(item))));
    }

    @Override
    public boolean contains(List<DataValue<T>> value) {
        int size = value.size();
        return this.getItemCount().contains(size) && value.stream().allMatch(item -> this.getItemValues().contains((DataValue<?>)item)) && (size < 2 || this.isItemsUnique() == (value.stream().collect(Collectors.toSet()).size() == size));
    }

    @Override
    public DataValue.Type[] getTypes() {
        return DataValue.Type.only(DataValue.Type.ARRAY);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getItemCount()).append(this.getItemValues()).toString();
    }
}

