/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cornutum.regexpgen.RandomGen;
import org.cornutum.regexpgen.RegExpGen;
import org.cornutum.regexpgen.js.Parser;
import org.cornutum.regexpgen.random.RandomBoundsGen;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.LengthDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ResolverSkipException;
import org.cornutum.tcases.openapi.resolver.SequenceDomain;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class AbstractStringDomain
extends SequenceDomain<String> {
    private final Characters chars_;
    private List<String> matching_ = Collections.emptyList();
    private List<String> notMatching_ = Collections.emptyList();

    protected AbstractStringDomain(int maxLength, Characters chars) {
        super(maxLength);
        this.chars_ = chars;
    }

    public Characters getCharacters() {
        return this.chars_;
    }

    @Override
    public void setExcludedStrings(Set<String> excluded) {
        this.setExcluded(excluded);
    }

    @Override
    protected int getLength(String value) {
        return value.length();
    }

    public void setMatching(List<String> patterns) {
        this.matching_ = patterns;
    }

    public void setMatching(String ... patterns) {
        this.setMatching(Arrays.asList(patterns));
    }

    protected List<String> getMatching() {
        return this.matching_;
    }

    public void setNotMatching(List<String> patterns) {
        this.notMatching_ = patterns;
    }

    public void setNotMatching(String ... patterns) {
        this.setNotMatching(Arrays.asList(patterns));
    }

    protected List<String> getNotMatching() {
        return this.notMatching_;
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new StringValue(value);
    }

    protected Stream<String> matchingValues(ResolverContext context, PatternResolver patternResolver) {
        return Stream.generate(() -> (String)context.tryUntil(this.newValues(context).map(value -> Optional.of(value).filter(v -> patternResolver.matchesAll((String)v)))));
    }

    protected Stream<String> generateMatchingValues(ResolverContext context, PatternResolver patternResolver) {
        return patternResolver.generatedMatches(this.getLengthRange()).orElse(this.matchingValues(context, patternResolver));
    }

    protected Stream<String> newValues(ResolverContext context) {
        return Stream.generate(() -> this.newValue(context, (Integer)this.getLengthRange().selectValue(context)));
    }

    protected abstract String newValue(ResolverContext var1, int var2);

    @Override
    protected Stream<String> candidates(ResolverContext context) {
        PatternResolver patternResolver = new PatternResolver(context);
        patternResolver.patternInfeasible(this.getLengthRange()).ifPresent(pattern -> {
            throw new ResolverSkipException(context.getLocation(), String.format("Can't match pattern=%s with length=%s", pattern, this.getLengthRange()));
        });
        return this.matchingCandidates(context, patternResolver);
    }

    protected Stream<String> matchingCandidates(ResolverContext context, PatternResolver patternResolver) {
        return this.matchingValues(context, patternResolver);
    }

    @Override
    public boolean contains(String value) {
        return super.contains(value) && this.getCharacters().allowed(value) && this.matchesPatterns(value);
    }

    protected boolean matchesPatterns(String value) {
        return new PatternResolver().matchesAll(value);
    }

    protected class PatternResolver {
        private final ResolverContext context_;
        private final List<RegExpGen> generators_;
        private final List<Pattern> matchingPatterns_;
        private final List<Pattern> notMatchingPatterns_;
        private final List<Pattern> filtering_;
        private String generatedBy_;
        private RegExpGen generator_;
        private RandomGen random_;

        public PatternResolver() {
            this(null);
        }

        public PatternResolver(ResolverContext context) {
            this.context_ = context;
            List<String> matching = AbstractStringDomain.this.getMatching();
            List<String> notMatching = AbstractStringDomain.this.getNotMatching();
            List generatorsIndexed = IntStream.range(0, matching.size()).mapToObj(i -> Optional.ofNullable(this.generatorFor((String)matching.get(i))).map(gen -> new AbstractMap.SimpleEntry<Integer, RegExpGen>(i, (RegExpGen)gen)).orElse(null)).filter(Objects::nonNull).sorted(Comparator.nullsLast(Comparator.comparing(AbstractMap.SimpleEntry::getValue))).collect(Collectors.toList());
            this.generators_ = generatorsIndexed.stream().map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList());
            Optional<Integer> generatedBy = generatorsIndexed.stream().findFirst().map(AbstractMap.SimpleEntry::getKey);
            if (generatedBy.isPresent()) {
                this.generatedBy_ = matching.get(generatedBy.get());
                this.filtering_ = this.toPatterns(context, CollectionUtils.restOf(matching, (int)generatedBy.get()));
                this.matchingPatterns_ = this.toPatterns(null, matching);
            } else {
                this.generatedBy_ = matching.stream().findFirst().orElse(null);
                this.filtering_ = Collections.emptyList();
                this.matchingPatterns_ = this.toPatterns(context, matching);
            }
            this.notMatchingPatterns_ = this.toPatterns(context, notMatching);
        }

        public boolean matchesAll(String value) {
            return this.matches(value, this.matchingPatterns_, this.notMatchingPatterns_);
        }

        public boolean matchesRemaining(String match) {
            return this.matches(match, this.filtering_, this.notMatchingPatterns_);
        }

        private boolean matches(String value, List<Pattern> matching, List<Pattern> notMatching) {
            return matching.stream().allMatch(pattern -> pattern.matcher(value).find()) && notMatching.stream().noneMatch(pattern -> pattern.matcher(value).find());
        }

        public Optional<String> patternInfeasible(LengthDomain length) {
            return this.generators_.stream().filter(gen -> !gen.getLength().intersects(length.getMin(), length.getMax())).findFirst().map(gen -> gen.getOptions().getRegExp());
        }

        private List<Pattern> toPatterns(ResolverContext context, List<String> regexps) {
            return regexps.stream().map(regexp -> {
                try {
                    return Pattern.compile(regexp);
                }
                catch (PatternSyntaxException e) {
                    if (context != null) {
                        context.error(String.format("Can't use pattern='%s' to select values -- %s", regexp, e.getMessage()), "Ignoring this pattern");
                    }
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public RegExpGen getGenerator() {
            if (this.generator_ == null && this.generatedBy_ != null) {
                try {
                    this.generator_ = Parser.parseRegExp((String)this.generatedBy_);
                    this.generator_.getOptions().setAnyPrintableChars(AbstractStringDomain.this.getCharacters().filtered(Characters.Ascii.chars()).get());
                    this.random_ = new RandomBoundsGen(this.context_.getRandom());
                }
                catch (IllegalArgumentException e) {
                    if (this.context_ != null) {
                        this.context_.error(String.format("Can't use pattern='%s' to generate values -- %s", this.generatedBy_, e.getMessage()), "Ignoring this pattern");
                    }
                }
                finally {
                    this.generatedBy_ = null;
                }
            }
            return this.generator_;
        }

        public Optional<Stream<String>> generatedMatches(LengthDomain length) {
            return Optional.ofNullable(this.getGenerator()).map(generator -> Stream.generate(() -> (String)this.context_.tryUntil(() -> Optional.of(generator.generate(this.random_, Integer.valueOf(length.getMin()), Integer.valueOf(length.getMax()))).filter(value -> this.matchesRemaining((String)value)))));
        }

        private RegExpGen generatorFor(String regexp) {
            try {
                return Parser.parseRegExp((String)regexp);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

