/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.math.BigDecimal;
import java.util.Arrays;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValues;
import org.cornutum.tcases.openapi.resolver.MessageData;

public abstract class AbstractMessageDataBuilder<T extends AbstractMessageDataBuilder<T>> {
    private DataValue<?> value_;
    private String mediaType_;
    private boolean valid_ = true;

    public T mediaType(String mediaType) {
        this.mediaType_ = mediaType;
        return (T)this;
    }

    public T valid(boolean valid) {
        this.valid_ = valid;
        return (T)this;
    }

    public MessageData build() {
        return new MessageData(this.value_, this.mediaType_, this.valid_);
    }

    public T arrayData(DataValue<?> ... itemValues) {
        this.value_ = DataValues.arrayOfAny(Arrays.asList(itemValues));
        return (T)this;
    }

    public T binaryData(byte[] value) {
        this.value_ = DataValues.valueOf(value);
        return (T)this;
    }

    public T booleanData(boolean value) {
        this.value_ = DataValues.valueOf(value);
        return (T)this;
    }

    public T decimalData(BigDecimal value) {
        this.value_ = DataValues.valueOf(value);
        return (T)this;
    }

    public T integerData(int value) {
        this.value_ = DataValues.valueOf(value);
        return (T)this;
    }

    public T longData(long value) {
        this.value_ = DataValues.valueOf(value);
        return (T)this;
    }

    public T nullData() {
        this.value_ = DataValues.nullValue();
        return (T)this;
    }

    public T objectData(DataValues.ObjectValueBuilder builder) {
        this.value_ = builder.build();
        return (T)this;
    }

    public T stringData(String value) {
        this.value_ = DataValues.stringOf(value);
        return (T)this;
    }

    public T base64Data(String value) {
        this.value_ = DataValues.base64Of(value);
        return (T)this;
    }

    public T dateTimeData(String value) {
        this.value_ = DataValues.dateTimeOf(value);
        return (T)this;
    }

    public T dateData(String value) {
        this.value_ = DataValues.dateOf(value);
        return (T)this;
    }

    public T emailData(String value) {
        this.value_ = DataValues.emailOf(value);
        return (T)this;
    }

    public T uuidData(String value) {
        this.value_ = DataValues.uuidOf(value);
        return (T)this;
    }
}

