/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.reader;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.OpenApiException;

public class OpenApiReaderException
extends OpenApiException {
    private static final long serialVersionUID = 4942175897026283955L;
    private List<String> errors_;

    public OpenApiReaderException(URL location, Throwable cause) {
        super(OpenApiReaderException.basicReasonFor(location), cause);
    }

    public OpenApiReaderException(URL location, List<String> errors) {
        super(OpenApiReaderException.errorReasonFor(location, errors));
        this.errors_ = errors;
    }

    public List<String> getErrors() {
        return this.errors_;
    }

    private static String basicReasonFor(URL location) {
        return String.format("Can't read Open API definition%s", OpenApiReaderException.locationId(location));
    }

    private static String errorReasonFor(URL location, List<String> errors) {
        return Stream.concat(Stream.of(String.format("%s conformance problem(s) found in Open API definition%s", errors.size(), OpenApiReaderException.locationId(location))), IntStream.range(0, errors.size()).mapToObj(i -> String.format("[%s] %s", i, errors.get(i)))).collect(Collectors.joining("\n"));
    }

    private static String locationId(URL location) {
        return location == null ? "" : String.format("=%s", location);
    }
}

