/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.openapi.reader.OpenApiReaderException;

public class OpenApiReader
implements Closeable {
    private Reader reader_;
    private URL location_;
    private String docType_;

    public OpenApiReader() {
        this((InputStream)null);
    }

    public OpenApiReader(InputStream input) {
        this(input, null, null);
    }

    public OpenApiReader(InputStream input, String docType) {
        this(input, null, docType);
    }

    public OpenApiReader(InputStream input, URL location) {
        this(input, location, null);
    }

    public OpenApiReader(InputStream input, URL location, String defaultDocType) {
        this(input == null ? null : OpenApiReader.readerFor(input), location, defaultDocType);
    }

    public OpenApiReader(File input) {
        this(input, null);
    }

    public OpenApiReader(File input, String defaultDocType) {
        this(OpenApiReader.inputFor(input), OpenApiReader.toUrl(input), defaultDocType);
    }

    public OpenApiReader(Reader input) {
        this(input, null, null);
    }

    public OpenApiReader(Reader input, String docType) {
        this(input, null, docType);
    }

    public OpenApiReader(Reader input, URL location) {
        this(input, location, null);
    }

    public OpenApiReader(Reader input, URL location, String defaultDocType) {
        this.reader_ = input;
        this.location_ = location;
        this.docType_ = OpenApiReader.docTypeFor(location).orElse(Optional.ofNullable(StringUtils.trimToNull((String)defaultDocType)).map(String::toLowerCase).orElse("json"));
    }

    public URL getLocation() {
        return this.location_;
    }

    public String getDocType() {
        return this.docType_;
    }

    public OpenAPI read() {
        JsonNode json;
        try {
            ObjectMapper mapper = this.isYaml() ? ObjectMapperFactory.createYaml() : ObjectMapperFactory.createJson();
            json = mapper.readTree(this.getReader());
        }
        catch (Exception e) {
            throw new OpenApiReaderException(this.getLocation(), (Throwable)e);
        }
        String location = Objects.toString(this.getLocation(), null);
        SwaggerParseResult parseResult = new OpenAPIDeserializer().deserialize(json, location);
        Optional.of(parseResult).map(SwaggerParseResult::getMessages).filter(messages -> !messages.isEmpty()).map(messages -> new OpenApiReaderException(this.getLocation(), (List<String>)messages)).ifPresent(failure -> {
            throw failure;
        });
        OpenAPI api = parseResult.getOpenAPI();
        try {
            api = new OpenAPIResolver(api, null, location).resolve();
            new ResolverFully(false).resolveFully(api);
        }
        catch (Exception e) {
            throw new OpenApiReaderException(this.getLocation(), (Throwable)e);
        }
        return api;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.reader_, null);
    }

    private Reader getReader() {
        return this.reader_ != null ? this.reader_ : OpenApiReader.readerFor(System.in);
    }

    private boolean isYaml() {
        return OpenApiReader.isYaml(this.getDocType());
    }

    private static boolean isYaml(String ext) {
        return "yml".equals(ext) || "yaml".equals(ext);
    }

    private static URL toUrl(File file) {
        try {
            return file == null ? null : file.toURI().toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't get URL for file=" + file);
        }
    }

    private static InputStream inputFor(File file) {
        try {
            return file == null ? null : new FileInputStream(file);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't open file=" + file);
        }
    }

    private static Reader readerFor(InputStream input) {
        return new InputStreamReader(input, StandardCharsets.UTF_8);
    }

    private static Optional<String> docTypeFor(URL location) {
        return Optional.ofNullable(location).flatMap(url -> Optional.ofNullable(StringUtils.trimToNull((String)FilenameUtils.getExtension((String)url.getPath())))).map(String::toLowerCase).filter(ext -> "json".equals(ext) || OpenApiReader.isYaml(ext));
    }
}

