/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.cornutum.tcases.util.ToString;

public abstract class ServerSelector {
    public Optional<Integer> select(List<String> serverDescriptions) {
        List candidates = Optional.ofNullable(serverDescriptions).orElse(Collections.emptyList());
        return IntStream.range(0, candidates.size()).mapToObj(Integer::valueOf).filter(i -> this.matches((Integer)i, (String)candidates.get((int)i))).findFirst();
    }

    public static ServerSelector atIndex(int index) {
        return new AtIndex(index);
    }

    public static ServerSelector containing(String text) {
        return new Containing(text);
    }

    protected abstract boolean matches(Integer var1, String var2);

    private static class Containing
    extends ServerSelector {
        private final String text_;

        public Containing(String text) {
            this.text_ = text;
        }

        @Override
        protected boolean matches(Integer index, String description) {
            return Optional.ofNullable(this.text_).map(t -> Optional.ofNullable(description).map(d -> d.contains((CharSequence)t)).orElse(false)).orElse(false);
        }

        public String toString() {
            return ToString.getBuilder((Object)this).append((Object)this.text_).toString();
        }
    }

    private static class AtIndex
    extends ServerSelector {
        private final int index_;

        public AtIndex(int index) {
            this.index_ = index;
        }

        @Override
        protected boolean matches(Integer index, String description) {
            return index == this.index_;
        }

        public String toString() {
            return ToString.getBuilder((Object)this).append(this.index_).toString();
        }
    }
}

