/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.text.WordUtils;
import org.cornutum.regexpgen.Bounds;
import org.cornutum.regexpgen.RegExpGen;
import org.cornutum.regexpgen.js.Parser;
import org.cornutum.tcases.openapi.OpenApiContext;
import org.cornutum.tcases.openapi.SchemaExtensions;
import org.cornutum.tcases.util.CollectionUtils;

public final class SchemaUtils {
    public static final Set<String> SCHEMA_TYPES = Arrays.asList("array", "boolean", "integer", "number", "object", "string").stream().collect(Collectors.toSet());
    public static final Schema<?> EMPTY_SCHEMA = SchemaUtils.emptySchema();
    public static final Schema<?> FALSE_SCHEMA = SchemaUtils.falseSchema();
    private static final OpenApiContext DEFAULT_CONTEXT = new OpenApiContext();

    private SchemaUtils() {
    }

    public static String asserts(Schema<?> schema) {
        return Optional.ofNullable(schema).map(s -> {
            String type = SchemaUtils.assertsType(s);
            return WordUtils.capitalize((String)type) + SchemaUtils.assertsList(SchemaUtils.assertsMap(type, s).entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())));
        }).orElse(null);
    }

    private static String assertsType(Schema<?> schema) {
        return schema.getType() == null ? "any" : (!"string".equals(schema.getType()) ? schema.getType() : ("binary".equals(schema.getFormat()) ? "binary" : ("byte".equals(schema.getFormat()) ? "byte" : "string")));
    }

    private static Map<String, String> assertsMap(String type, Schema<?> schema) {
        LinkedHashMap<String, String> asserts = new LinkedHashMap<String, String>();
        if (!type.equals("binary") && !type.equals("byte")) {
            Optional.ofNullable(schema.getEnum()).ifPresent(v -> asserts.put("enum", SchemaUtils.assertsList(v.stream().map(e -> Objects.toString(e, "")))));
            Optional.ofNullable(schema.getAdditionalProperties()).ifPresent(v -> asserts.put("additionalProperties", Optional.ofNullable(SchemaUtils.additionalPropertiesSchema(schema)).map(SchemaUtils::asserts).orElse(Objects.toString(v, ""))));
            Optional.ofNullable(schema.getExclusiveMaximum()).ifPresent(v -> asserts.put("exclusiveMaximum", Objects.toString(v, "")));
            Optional.ofNullable(schema.getExclusiveMinimum()).ifPresent(v -> asserts.put("exclusiveMinimum", Objects.toString(v, "")));
            Optional.ofNullable(schema.getFormat()).ifPresent(v -> asserts.put("format", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMaxLength()).ifPresent(v -> asserts.put("maxLength", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMaxProperties()).ifPresent(v -> asserts.put("maxProperties", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMaximum()).ifPresent(v -> asserts.put("maximum", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMinLength()).ifPresent(v -> asserts.put("minLength", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMinProperties()).ifPresent(v -> asserts.put("minProperties", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMinimum()).ifPresent(v -> asserts.put("minimum", Objects.toString(v, "")));
            Optional.ofNullable(schema.getMultipleOf()).ifPresent(v -> asserts.put("multipleOf", Objects.toString(v, "")));
            Optional.ofNullable(schema.getNullable()).ifPresent(v -> asserts.put("nullable", Objects.toString(v, "")));
            Optional.ofNullable(schema.getProperties()).ifPresent(v -> asserts.put("properties", SchemaUtils.assertsList(v.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), SchemaUtils.asserts((Schema)e.getValue()))))));
            Optional.ofNullable(schema.getRequired()).ifPresent(v -> asserts.put("required", SchemaUtils.assertsList(v.stream().map(e -> Objects.toString(e, "")))));
            Optional.ofNullable(schema.getReadOnly()).ifPresent(v -> asserts.put("readOnly", Objects.toString(v, "")));
            Optional.ofNullable(schema.getWriteOnly()).ifPresent(v -> asserts.put("writeOnly", Objects.toString(v, "")));
            Optional.ofNullable(schema.getExtensions()).ifPresent(v -> v.entrySet().stream().forEach(e -> asserts.put((String)e.getKey(), Objects.toString(e.getValue(), ""))));
            Optional.ofNullable(SchemaUtils.asArraySchema(schema)).ifPresent(array -> {
                Optional.ofNullable(array.getItems()).ifPresent(v -> asserts.put("items", SchemaUtils.asserts(v)));
                Optional.ofNullable(array.getMaxItems()).ifPresent(v -> asserts.put("maxItems", Objects.toString(v, "")));
                Optional.ofNullable(array.getMinItems()).ifPresent(v -> asserts.put("minItems", Objects.toString(v, "")));
                Optional.ofNullable(array.getUniqueItems()).ifPresent(v -> asserts.put("uniqueItems", Objects.toString(v, "")));
            });
            Optional.ofNullable(schema.getNot()).ifPresent(not -> asserts.put("not", SchemaUtils.asserts(not)));
            Optional.ofNullable(SchemaUtils.asComposedSchema(schema)).ifPresent(composed -> {
                Optional.ofNullable(composed.getAllOf()).ifPresent(v -> Optional.of(v).filter(schemas -> !schemas.isEmpty()).ifPresent(schemas -> asserts.put("allOf", SchemaUtils.assertsList(schemas.stream().map(SchemaUtils::asserts)))));
                Optional.ofNullable(composed.getAnyOf()).ifPresent(v -> Optional.of(v).filter(schemas -> !schemas.isEmpty()).ifPresent(schemas -> asserts.put("anyOf", SchemaUtils.assertsList(schemas.stream().map(SchemaUtils::asserts)))));
                Optional.ofNullable(composed.getOneOf()).ifPresent(v -> Optional.of(v).filter(schemas -> !schemas.isEmpty()).ifPresent(schemas -> asserts.put("oneOf", SchemaUtils.assertsList(schemas.stream().map(SchemaUtils::asserts)))));
            });
        }
        return asserts;
    }

    public static String assertsList(Stream<String> assertions) {
        return '[' + assertions.collect(Collectors.joining(", ")) + ']';
    }

    public static Schema<?> resolveSchemaType(Schema<?> schema) {
        String declaredType = schema.getType();
        List impliedTypes = Stream.of(SchemaUtils.impliedType("array", schema, Schema::getMaxItems, Schema::getMinItems, Schema::getUniqueItems), SchemaUtils.impliedType("number", schema, Schema::getMaximum, Schema::getExclusiveMaximum, Schema::getMinimum, Schema::getExclusiveMinimum, Schema::getMultipleOf), SchemaUtils.impliedType("object", schema, Schema::getMaxProperties, Schema::getMinProperties, Schema::getRequired, Schema::getProperties, Schema::getAdditionalProperties), SchemaUtils.impliedType("string", schema, Schema::getMaxLength, Schema::getMinLength, Schema::getPattern)).filter(Objects::nonNull).collect(Collectors.toList());
        if (impliedTypes.size() == 1) {
            String impliedType = (String)impliedTypes.get(0);
            if (declaredType == null) {
                schema.setType(impliedType);
            } else if (!(impliedType.equals(declaredType) || impliedType.equals("number") && declaredType.equals("integer"))) {
                throw new IllegalStateException(String.format("Schema declares type=%s but has implied type=%s", declaredType, impliedType));
            }
        } else if (impliedTypes.size() > 1) {
            throw new IllegalStateException(String.format("Ambiguous schema type -- could be any of %s", impliedTypes.stream().collect(Collectors.joining(", "))));
        }
        return schema;
    }

    @SafeVarargs
    private static String impliedType(String type, Schema<?> schema, Function<Schema<?>, Object> ... accessors) {
        return Stream.of(accessors).map(accessor -> accessor.apply(schema)).filter(Objects::nonNull).findFirst().map(value -> type).orElse(null);
    }

    public static boolean isSchemaType(String type) {
        return type == null || SCHEMA_TYPES.contains(type);
    }

    public static ComposedSchema asComposedSchema(Schema<?> schema) {
        return schema instanceof ComposedSchema ? (ComposedSchema)schema : null;
    }

    public static ArraySchema asArraySchema(Schema<?> schema) {
        return schema instanceof ArraySchema ? (ArraySchema)schema : null;
    }

    public static Schema<?> additionalPropertiesSchema(Schema<?> schema) {
        return schema.getAdditionalProperties() instanceof Schema ? (Schema)schema.getAdditionalProperties() : null;
    }

    public static Schema<?> toPropertySchema(Schema<?> schema) {
        SchemaExtensions.setPropertySchema(schema, true);
        return schema;
    }

    public static boolean isLeafSchema(Schema<?> schema) {
        return SchemaUtils.asComposedSchema(schema) == null && schema.getNot() == null;
    }

    public static boolean isNotLeafSchema(Schema<?> schema) {
        return !SchemaUtils.isLeafSchema(schema);
    }

    public static boolean isLeafEmpty(Schema<?> schema) {
        return SchemaUtils.isEmpty(SchemaUtils.withExtensions(SchemaUtils.copySchema(schema).type(null).properties((Map)Optional.ofNullable(schema.getProperties()).filter(p -> !p.isEmpty()).orElse(null)), new String[0]));
    }

    public static Optional<Object> schemaExample(Schema<?> schema) {
        return Optional.ofNullable(schema).map(Schema::getExampleSetFlag).orElse(false) != false ? Optional.ofNullable(schema.getExample()) : null;
    }

    public static Schema<?> combineSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema<?> combined;
        if (base == null) {
            combined = additional;
        } else if (additional == null) {
            combined = base;
        } else {
            String additionalType;
            String baseType = Optional.ofNullable(base.getType()).orElse(additional.getType());
            if (!Objects.equals(baseType, additionalType = Optional.ofNullable(additional.getType()).orElse(base.getType()))) {
                throw SchemaUtils.inconsistentAssertions("type: %s", additionalType, baseType);
            }
            combined = "object".equals(baseType) ? SchemaUtils.combineObjectSchemas(context, base, additional) : ("string".equals(baseType) ? SchemaUtils.combineStringSchemas(context, base, additional) : ("integer".equals(baseType) ? SchemaUtils.combineIntegerSchemas(context, base, additional) : ("boolean".equals(baseType) ? SchemaUtils.combineBooleanSchemas(context, base, additional) : ("array".equals(baseType) ? SchemaUtils.combineArraySchemas(context, base, additional) : ("number".equals(baseType) ? SchemaUtils.combineNumberSchemas(context, base, additional) : SchemaUtils.combineGenericSchemas(context, base, additional))))));
        }
        return combined;
    }

    private static Schema<?> combineObjectSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema combined = SchemaUtils.combineGenericSchemas(context, base, additional);
        Schema<?> baseExtraSchema = SchemaUtils.additionalPropertiesSchema(base);
        Schema<?> additionalExtraSchema = SchemaUtils.additionalPropertiesSchema(additional);
        if (baseExtraSchema != null) {
            combined.setAdditionalProperties(additionalExtraSchema != null ? context.resultFor("additionalProperties", () -> SchemaUtils.combineSchemas(context, baseExtraSchema, additionalExtraSchema)) : (!Boolean.FALSE.equals(additional.getAdditionalProperties()) ? baseExtraSchema : Boolean.FALSE));
        } else if (additionalExtraSchema != null) {
            combined.setAdditionalProperties(!Boolean.FALSE.equals(base.getAdditionalProperties()) ? additionalExtraSchema : Boolean.FALSE);
        } else {
            combined.setAdditionalProperties(base.getAdditionalProperties() == null ? additional.getAdditionalProperties() : (additional.getAdditionalProperties() == null ? base.getAdditionalProperties() : SchemaUtils.combineAssertions("additionalProperties: %s", (Boolean)base.getAdditionalProperties(), (Boolean)additional.getAdditionalProperties())));
        }
        combined.setMaxProperties(base.getMaxProperties() == null ? additional.getMaxProperties() : (additional.getMaxProperties() == null ? base.getMaxProperties() : (base.getMaxProperties().compareTo(additional.getMaxProperties()) < 0 ? base.getMaxProperties() : additional.getMaxProperties())));
        combined.setMinProperties(base.getMinProperties() == null ? additional.getMinProperties() : (additional.getMinProperties() == null ? base.getMinProperties() : (base.getMinProperties().compareTo(additional.getMinProperties()) > 0 ? base.getMinProperties() : additional.getMinProperties())));
        List combinedRequired = ((Set)Stream.concat(Optional.ofNullable(base.getRequired()).map(required -> required.stream()).orElse(Stream.empty()), Optional.ofNullable(additional.getRequired()).map(required -> required.stream()).orElse(Stream.empty())).collect(CollectionUtils.toOrderedSet())).stream().collect(Collectors.toList());
        combined.setRequired(combinedRequired);
        SchemaExtensions.setNotRequired(combined, SchemaExtensions.getNotRequired(base));
        SchemaExtensions.addNotRequired(combined, SchemaExtensions.getNotRequired(additional));
        Optional.ofNullable(SchemaExtensions.getNotRequired(combined)).flatMap(nr -> combinedRequired.stream().filter(p -> nr.contains(p)).findFirst()).ifPresent(p -> {
            throw SchemaUtils.inconsistentNotAssertion("required: [%s]", p);
        });
        Map basePropertyDefs = Optional.ofNullable(base.getProperties()).orElse(Collections.emptyMap());
        Map additionalPropertyDefs = Optional.ofNullable(additional.getProperties()).orElse(Collections.emptyMap());
        Map combinedPropertyDefs = context.resultFor("properties", () -> ((Set)Stream.concat(basePropertyDefs.keySet().stream(), additionalPropertyDefs.keySet().stream()).collect(CollectionUtils.toOrderedSet())).stream().collect(() -> new LinkedHashMap(), (map, p) -> map.put(p, context.resultFor((String)p, () -> SchemaUtils.combineSchemas(context, (Schema)basePropertyDefs.get(p), (Schema)additionalPropertyDefs.get(p)))), (map, other) -> map.putAll(other)));
        combined.setProperties(combinedPropertyDefs);
        return combined;
    }

    private static Schema<?> combineStringSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema combined = SchemaUtils.combineGenericSchemas(context, base, additional);
        if (base.getFormat() != null && additional.getFormat() != null && !base.getFormat().equals(additional.getFormat())) {
            throw SchemaUtils.inconsistentAssertions("format: %s", additional.getFormat(), base.getFormat());
        }
        combined.setMaxLength(base.getMaxLength() == null ? additional.getMaxLength() : (additional.getMaxLength() == null ? base.getMaxLength() : (base.getMaxLength().compareTo(additional.getMaxLength()) < 0 ? base.getMaxLength() : additional.getMaxLength())));
        combined.setMinLength(base.getMinLength() == null ? additional.getMinLength() : (additional.getMinLength() == null ? base.getMinLength() : (base.getMinLength().compareTo(additional.getMinLength()) > 0 ? base.getMinLength() : additional.getMinLength())));
        SchemaExtensions.setPatterns(combined, SchemaExtensions.getPatterns(base));
        SchemaExtensions.addPatterns(combined, SchemaExtensions.getPatterns(additional));
        Optional.ofNullable(combined.getMaxLength()).ifPresent(maxLength -> Optional.ofNullable(SchemaUtils.maxLengthPattern(combined)).ifPresent(generator -> {
            Integer patternMax = Bounds.bounded((int)generator.getMaxLength()).orElse(null);
            if (patternMax != null && patternMax.compareTo((Integer)maxLength) < 0) {
                combined.setMaxLength(patternMax);
            }
            if (combined.getMinLength() != null && combined.getMaxLength() < combined.getMinLength()) {
                throw SchemaUtils.inconsistentAssertions("minLength: %s", combined.getMinLength(), "pattern: %s", generator.getOptions().getRegExp());
            }
        }));
        Optional.ofNullable(combined.getMinLength()).ifPresent(minLength -> Optional.ofNullable(SchemaUtils.minLengthPattern(combined)).ifPresent(generator -> {
            Integer patternMin = Optional.of(generator.getMinLength()).filter(min -> min > 0).orElse(null);
            if (patternMin != null && patternMin.compareTo(combined.getMinLength()) > 0) {
                combined.setMinLength(patternMin);
            }
            if (combined.getMaxLength() != null && combined.getMinLength() > combined.getMaxLength()) {
                throw SchemaUtils.inconsistentAssertions("maxLength: %s", combined.getMaxLength(), "pattern: %s", generator.getOptions().getRegExp());
            }
        }));
        SchemaExtensions.setNotPatterns(combined, SchemaExtensions.getNotPatterns(base));
        SchemaExtensions.addNotPatterns(combined, SchemaExtensions.getNotPatterns(additional));
        Optional.ofNullable(SchemaExtensions.getPatterns(combined)).flatMap(ps -> Optional.ofNullable(SchemaExtensions.getNotPatterns(combined)).flatMap(nps -> ps.stream().filter(p -> nps.contains(p)).findFirst())).ifPresent(p -> {
            throw SchemaUtils.inconsistentNotAssertion("pattern: '%s'", p);
        });
        return combined;
    }

    private static Schema<?> combineIntegerSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema<?> combined = SchemaUtils.combineNumericSchemas(context, base, additional);
        combined.setFormat(base.getFormat() == null ? additional.getFormat() : (additional.getFormat() == null ? base.getFormat() : (base.getFormat().equals("int32") ? base.getFormat() : additional.getFormat())));
        return combined;
    }

    private static Schema<?> combineBooleanSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        return SchemaUtils.combineGenericSchemas(context, base, additional);
    }

    private static Schema<?> combineArraySchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        ArraySchema combined = SchemaUtils.combineGenericSchemas(context, new ArraySchema(), base, additional);
        combined.setMaxItems(base.getMaxItems() == null ? additional.getMaxItems() : (additional.getMaxItems() == null ? base.getMaxItems() : (base.getMaxItems().compareTo(additional.getMaxItems()) < 0 ? base.getMaxItems() : additional.getMaxItems())));
        combined.setMinItems(base.getMinItems() == null ? additional.getMinItems() : (additional.getMinItems() == null ? base.getMinItems() : (base.getMinItems().compareTo(additional.getMinItems()) > 0 ? base.getMinItems() : additional.getMinItems())));
        combined.setUniqueItems(base.getUniqueItems() == null ? additional.getUniqueItems() : (additional.getUniqueItems() == null ? base.getUniqueItems() : SchemaUtils.combineAssertions("uniqueItems: %s", base.getUniqueItems(), additional.getUniqueItems())));
        Schema baseItems = Optional.ofNullable(SchemaUtils.asArraySchema(base)).map(ArraySchema::getItems).orElse(null);
        Schema additionalItems = Optional.ofNullable(SchemaUtils.asArraySchema(additional)).map(ArraySchema::getItems).orElse(null);
        combined.setItems(context.resultFor("items", () -> SchemaUtils.combineSchemas(context, baseItems, additionalItems)));
        return combined;
    }

    private static Schema<?> combineNumberSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema<?> combined = SchemaUtils.combineNumericSchemas(context, base, additional);
        combined.setFormat(base.getFormat() == null ? additional.getFormat() : (additional.getFormat() == null ? base.getFormat() : (base.getFormat().equals("float") ? base.getFormat() : additional.getFormat())));
        return combined;
    }

    private static Schema<?> combineNumericSchemas(OpenApiContext context, Schema<?> base, Schema<?> additional) {
        Schema combined = SchemaUtils.combineGenericSchemas(context, base, additional);
        combined.setMaximum(base.getMaximum() == null ? additional.getMaximum() : (additional.getMaximum() == null ? base.getMaximum() : (base.getMaximum().compareTo(additional.getMaximum()) < 0 ? base.getMaximum() : additional.getMaximum())));
        combined.setMinimum(base.getMinimum() == null ? additional.getMinimum() : (additional.getMinimum() == null ? base.getMinimum() : (base.getMinimum().compareTo(additional.getMinimum()) > 0 ? base.getMinimum() : additional.getMinimum())));
        combined.setExclusiveMaximum(base.getExclusiveMaximum() == null ? additional.getExclusiveMaximum() : (additional.getExclusiveMaximum() == null ? base.getExclusiveMaximum() : SchemaUtils.combineAssertions("exclusiveMaximum: %s", base.getExclusiveMaximum(), additional.getExclusiveMaximum())));
        combined.setExclusiveMinimum(base.getExclusiveMinimum() == null ? additional.getExclusiveMinimum() : (additional.getExclusiveMinimum() == null ? base.getExclusiveMinimum() : SchemaUtils.combineAssertions("exclusiveMinimum: %s", base.getExclusiveMinimum(), additional.getExclusiveMinimum())));
        combined.setMultipleOf(base.getMultipleOf() == null ? additional.getMultipleOf() : (additional.getMultipleOf() == null ? base.getMultipleOf() : SchemaUtils.combineMultipleOf(base.getMultipleOf(), additional.getMultipleOf())));
        SchemaExtensions.setNotMultipleOfs(combined, SchemaExtensions.getNotMultipleOfs(base));
        SchemaExtensions.addNotMultipleOfs(combined, SchemaExtensions.getNotMultipleOfs(additional));
        Optional.ofNullable(combined.getMultipleOf()).flatMap(m -> Optional.ofNullable(SchemaExtensions.getNotMultipleOfs(combined)).flatMap(nms -> nms.stream().filter(nm -> SchemaUtils.isMultipleOf(m, nm)).findFirst())).ifPresent(nm -> {
            throw SchemaUtils.inconsistentNotAssertion("multipleOf: %s", combined.getMultipleOf(), nm);
        });
        return combined;
    }

    private static BigDecimal combineMultipleOf(BigDecimal base, BigDecimal additional) {
        BigDecimal min;
        BigDecimal max = base.compareTo(additional) > 0 ? base : additional;
        BigDecimal bigDecimal = min = base.compareTo(additional) < 0 ? base : additional;
        if (!SchemaUtils.isMultipleOf(max, min)) {
            throw SchemaUtils.inconsistentAssertions("multipleOf: %s", additional, base);
        }
        return max;
    }

    public static boolean isMultipleOf(BigDecimal value, BigDecimal factor) {
        return value.compareTo(BigDecimal.ZERO) == 0 || value.remainder(factor).compareTo(BigDecimal.ZERO) == 0;
    }

    private static Schema combineGenericSchemas(OpenApiContext context, Schema base, Schema additional) {
        return SchemaUtils.combineGenericSchemas(context, SchemaUtils.emptySchema(), base, additional);
    }

    private static <T extends Schema> T combineGenericSchemas(OpenApiContext context, T combined, Schema base, Schema additional) {
        String baseType = base.getType();
        String additionalType = additional.getType();
        if (baseType == null) {
            Optional.ofNullable(SchemaExtensions.getNotTypes(base)).filter(notTypes -> notTypes.contains(additionalType)).ifPresent(notTypes -> {
                throw SchemaUtils.inconsistentNotAssertion("type: %s", additionalType);
            });
        }
        if (additionalType == null) {
            Optional.ofNullable(SchemaExtensions.getNotTypes(additional)).filter(notTypes -> notTypes.contains(baseType)).ifPresent(notTypes -> {
                throw SchemaUtils.inconsistentNotAssertion("type: %s", baseType);
            });
        }
        combined.setType(Optional.ofNullable(baseType).orElse(additionalType));
        if (combined.getType() == null) {
            SchemaExtensions.setNotTypes(combined, SchemaExtensions.getNotTypes(base));
            SchemaExtensions.addNotTypes(combined, SchemaExtensions.getNotTypes(additional));
        }
        combined.setDefault(Optional.ofNullable(additional.getDefault()).orElse(base.getDefault()));
        combined.setFormat(base.getFormat() == null ? additional.getFormat() : (additional.getFormat() == null ? base.getFormat() : additional.getFormat()));
        combined.setEnum(base.getEnum() == null ? additional.getEnum() : (additional.getEnum() == null ? base.getEnum() : Optional.of(base.getEnum()).map(enums -> {
            Set baseEnums = (Set)enums.stream().collect(CollectionUtils.toOrderedSet());
            baseEnums.retainAll(additional.getEnum());
            return baseEnums;
        }).filter(enums -> !enums.isEmpty()).map(enums -> enums.stream().collect(Collectors.toList())).orElseThrow(() -> SchemaUtils.inconsistentAssertions("enum: %s", additional.getEnum(), base.getEnum()))));
        SchemaExtensions.setNotEnums(combined, SchemaExtensions.getNotEnums(base));
        SchemaExtensions.addNotEnums(combined, SchemaExtensions.getNotEnums(additional));
        Optional.ofNullable(combined.getEnum()).flatMap(es -> Optional.ofNullable(SchemaExtensions.getNotEnums(combined)).flatMap(nes -> es.stream().filter(e -> nes.contains(e)).findFirst())).ifPresent(e -> {
            throw SchemaUtils.inconsistentNotAssertion("enum: %s", e);
        });
        combined.setNullable(base.getNullable() == null ? additional.getNullable() : (additional.getNullable() == null ? base.getNullable() : SchemaUtils.combineAssertions("nullable: %s", base.getNullable(), additional.getNullable())));
        SchemaExtensions.setPropertySchema(combined, SchemaExtensions.isPropertySchema(base) || SchemaExtensions.isPropertySchema(additional));
        if (SchemaExtensions.isPropertySchema(combined)) {
            combined.setReadOnly(base.getReadOnly() == null ? additional.getReadOnly() : (additional.getReadOnly() == null ? base.getReadOnly() : SchemaUtils.combineAssertions("readOnly: %s", base.getReadOnly(), additional.getReadOnly())));
            combined.setWriteOnly(base.getWriteOnly() == null ? additional.getWriteOnly() : (additional.getWriteOnly() == null ? base.getWriteOnly() : SchemaUtils.combineAssertions("writeOnly: %s", base.getWriteOnly(), additional.getWriteOnly())));
            if (Boolean.TRUE.equals(combined.getReadOnly()) && Boolean.TRUE.equals(combined.getWriteOnly())) {
                String baseProp = Boolean.TRUE.equals(base.getReadOnly()) ? "readOnly" : "writeOnly";
                String additionalProp = Boolean.TRUE.equals(additional.getReadOnly()) ? "readOnly" : "writeOnly";
                throw SchemaUtils.inconsistentAssertions("%s: true", additionalProp, baseProp);
            }
        }
        return combined;
    }

    private static Boolean combineAssertions(String assertionFormat, boolean base, boolean additional) {
        if (base != additional) {
            throw SchemaUtils.inconsistentAssertions(assertionFormat, additional, base);
        }
        return base;
    }

    private static RegExpGen maxLengthPattern(Schema<?> stringSchema) {
        return SchemaUtils.patternGenerators(stringSchema).min(Comparator.comparing(RegExpGen::getMaxLength)).orElse(null);
    }

    private static RegExpGen minLengthPattern(Schema<?> stringSchema) {
        return SchemaUtils.patternGenerators(stringSchema).max(Comparator.comparing(RegExpGen::getMinLength)).orElse(null);
    }

    public static Stream<RegExpGen> patternGenerators(Schema<?> stringSchema) {
        return SchemaExtensions.getPatterns(stringSchema).stream().map(pattern -> {
            try {
                return Parser.parseRegExp((String)pattern);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull);
    }

    private static <T> IllegalStateException inconsistentAssertions(String assertFormat, T value, String otherFormat, T otherValue) {
        return new IllegalStateException(String.format("Can't combine schema requiring {" + assertFormat + "} with schema requiring {" + otherFormat + "}", value, otherValue));
    }

    private static <T> IllegalStateException inconsistentAssertions(String assertFormat, T value, T otherValue) {
        return SchemaUtils.inconsistentAssertions(assertFormat, value, assertFormat, otherValue);
    }

    private static <T> IllegalStateException inconsistentNotAssertion(String assertFormat, T value, T otherValue) {
        return SchemaUtils.inconsistentAssertions(assertFormat, value, String.format("not: {%s}", assertFormat), otherValue);
    }

    private static <T> IllegalStateException inconsistentNotAssertion(String assertFormat, T value) {
        return SchemaUtils.inconsistentNotAssertion(assertFormat, value, value);
    }

    public static Schema<?> copySchema(Schema<?> schema) {
        return SchemaUtils.combineSchemas(DEFAULT_CONTEXT, schema, EMPTY_SCHEMA);
    }

    public static boolean equalsExtended(Schema<?> schema1, Schema<?> schema2, String ... extensions) {
        Schema<?> compare1 = SchemaUtils.withExtensions(SchemaUtils.copySchema(schema1), extensions);
        Schema<?> compare2 = SchemaUtils.withExtensions(SchemaUtils.copySchema(schema2), extensions);
        return compare1.equals(compare2);
    }

    private static Schema<?> withExtensions(Schema<?> schema, String ... extensions) {
        Map extAll = schema.getExtensions();
        if (extAll != null) {
            schema.setExtensions(null);
            for (String ext : extensions) {
                if (!extAll.containsKey(ext)) continue;
                schema.addExtension(ext, extAll.get(ext));
            }
        }
        return schema;
    }

    public static Schema<?> emptySchema() {
        return new Schema();
    }

    public static boolean isEmpty(Schema<?> schema) {
        return Optional.ofNullable(schema).map(s -> s.equals(EMPTY_SCHEMA)).orElse(true);
    }

    public static boolean isFalse(Schema<?> schema) {
        return SchemaUtils.equalsExtended(schema, FALSE_SCHEMA, "x-tcases-not-types");
    }

    private static Schema<?> falseSchema() {
        Schema<?> falsifier = SchemaUtils.emptySchema();
        SchemaExtensions.setNotTypes(falsifier, SCHEMA_TYPES);
        falsifier.setNullable(Boolean.valueOf(false));
        return falsifier;
    }
}

