/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.Dnf;
import org.cornutum.tcases.util.CollectionUtils;

public final class SchemaExtensions {
    static final String EXT_DNF = "x-tcases-dnf";
    static final String EXT_MAX_VALUES = "x-tcases-max-values";
    static final String EXT_MODELLING_INPUT = "x-tcases-modelling-input";
    static final String EXT_NOT_ENUMS = "x-tcases-not-enums";
    static final String EXT_NOT_MULTIPLEOFS = "x-tcases-not-multipleOfs";
    static final String EXT_NOT_PATTERNS = "x-tcases-not-patterns";
    static final String EXT_NOT_REQUIRED = "x-tcases-not-required";
    static final String EXT_NOT_TYPES = "x-tcases-not-types";
    static final String EXT_NULL_CHECKED = "x-tcases-null-checked";
    static final String EXT_PATTERNS = "x-tcases-patterns";
    static final String EXT_PROPERTY_SCHEMA = "x-tcases-property-schema";
    static final String EXT_RESOLVED_ALL = "x-tcases-resolved-all";
    static final String EXT_TYPE_CHECKED = "x-tcases-type-checked";
    static final String EXT_VALID_TYPES = "x-tcases-valid-types";
    static final String EXT_VALID_TYPES_ALL = "x-tcases-valid-types-all";

    private SchemaExtensions() {
    }

    public static boolean hasValidTypes(Schema<?> schema) {
        return SchemaExtensions.hasExtension(schema, EXT_VALID_TYPES);
    }

    public static Set<String> getValidTypes(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_VALID_TYPES);
    }

    public static Set<String> getNotTypes(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_NOT_TYPES);
    }

    public static void setNotTypes(Schema<?> schema, Iterable<String> notTypes) {
        SchemaExtensions.removeExtension(schema, EXT_NOT_TYPES);
        SchemaExtensions.addNotTypes(schema, notTypes);
    }

    public static void addNotType(Schema<?> schema, String type) {
        LinkedHashSet<String> notTypes = (LinkedHashSet<String>)SchemaExtensions.getExtension(schema, EXT_NOT_TYPES);
        if (notTypes == null) {
            notTypes = new LinkedHashSet<String>();
            SchemaExtensions.setExtension(schema, EXT_NOT_TYPES, notTypes);
        }
        notTypes.add(type);
    }

    public static void addNotTypes(Schema<?> schema, Iterable<String> notTypes) {
        if (notTypes != null) {
            for (String type : notTypes) {
                SchemaExtensions.addNotType(schema, type);
            }
        }
    }

    public static Set<String> getRequiredTypes(Schema<?> schema) {
        return Optional.ofNullable(schema.getType()).map(type -> (Set)Stream.concat(Stream.of(type), Optional.ofNullable(SchemaExtensions.getNotTypes(schema)).map(notTypes -> notTypes.stream()).orElse(Stream.empty())).collect(CollectionUtils.toOrderedSet())).orElse(null);
    }

    public static void setValidTypes(Schema<?> schema, Set<String> validTypes) {
        SchemaExtensions.setExtension(schema, EXT_VALID_TYPES, validTypes);
    }

    public static boolean isTypeChecked(Schema<?> schema) {
        Boolean checked = (Boolean)SchemaExtensions.getExtension(schema, EXT_TYPE_CHECKED);
        return Optional.ofNullable(checked).orElse(true);
    }

    public static void setTypeChecked(Schema<?> schema, boolean checked) {
        SchemaExtensions.setExtension(schema, EXT_TYPE_CHECKED, checked);
    }

    public static boolean isNullChecked(Schema<?> schema) {
        Boolean checked = (Boolean)SchemaExtensions.getExtension(schema, EXT_NULL_CHECKED);
        return Optional.ofNullable(checked).orElse(true);
    }

    public static void setNullChecked(Schema<?> schema, boolean checked) {
        SchemaExtensions.setExtension(schema, EXT_NULL_CHECKED, checked);
    }

    public static Dnf getDnf(Schema<?> schema) {
        return (Dnf)SchemaExtensions.getExtension(schema, EXT_DNF);
    }

    public static void setDnf(Schema<?> schema, Dnf dnf) {
        SchemaExtensions.setExtension(schema, EXT_DNF, dnf);
    }

    public static boolean hasResolvedAll(Schema<?> schema) {
        return SchemaExtensions.hasExtension(schema, EXT_RESOLVED_ALL);
    }

    public static Boolean getResolvedAll(Schema<?> schema) {
        return (Boolean)SchemaExtensions.getExtension(schema, EXT_RESOLVED_ALL);
    }

    public static void setResolvedAll(Schema<?> schema, Boolean resolved) {
        SchemaExtensions.setExtension(schema, EXT_RESOLVED_ALL, resolved);
    }

    public static boolean hasValidTypesAll(Schema<?> schema) {
        return SchemaExtensions.hasExtension(schema, EXT_VALID_TYPES_ALL);
    }

    public static Boolean getValidTypesAll(Schema<?> schema) {
        return (Boolean)SchemaExtensions.getExtension(schema, EXT_VALID_TYPES_ALL);
    }

    public static void setValidTypesAll(Schema<?> schema, Boolean validTypes) {
        SchemaExtensions.setExtension(schema, EXT_VALID_TYPES_ALL, validTypes);
    }

    public static boolean isModellingInput(Schema<?> schema) {
        return SchemaExtensions.hasExtension(schema, EXT_MODELLING_INPUT);
    }

    public static void setModellingInput(Schema<?> schema, boolean modelling) {
        if (modelling) {
            SchemaExtensions.setExtension(schema, EXT_MODELLING_INPUT, true);
        } else {
            SchemaExtensions.removeExtension(schema, EXT_MODELLING_INPUT);
        }
    }

    public static Set<String> getPatterns(Schema<?> schema) {
        return SchemaExtensions.hasExtension(schema, EXT_PATTERNS) ? (Set)SchemaExtensions.getExtension(schema, EXT_PATTERNS) : Optional.ofNullable(schema.getPattern()).map(Collections::singleton).orElse(Collections.emptySet());
    }

    public static void setPatterns(Schema<?> schema, Iterable<String> patterns) {
        SchemaExtensions.removeExtension(schema, EXT_PATTERNS);
        schema.setPattern(null);
        SchemaExtensions.addPatterns(schema, patterns);
    }

    public static void setPatterns(Schema<?> schema, String ... patterns) {
        SchemaExtensions.setPatterns(schema, Arrays.asList(patterns));
    }

    public static void addPatterns(Schema<?> schema, Iterable<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                SchemaExtensions.addPattern(schema, pattern);
            }
        }
    }

    public static void addPattern(Schema<?> schema, String pattern) {
        if (pattern != null) {
            LinkedHashSet<String> patterns;
            if (schema.getPattern() == null) {
                schema.setPattern(pattern);
            }
            if ((patterns = (LinkedHashSet<String>)SchemaExtensions.getExtension(schema, EXT_PATTERNS)) == null) {
                patterns = new LinkedHashSet<String>();
                SchemaExtensions.setExtension(schema, EXT_PATTERNS, patterns);
            }
            patterns.add(pattern);
        }
    }

    public static Set<String> getNotPatterns(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_NOT_PATTERNS);
    }

    public static void setNotPatterns(Schema<?> schema, Iterable<String> patterns) {
        SchemaExtensions.removeExtension(schema, EXT_NOT_PATTERNS);
        SchemaExtensions.addNotPatterns(schema, patterns);
    }

    public static void setNotPatterns(Schema<?> schema, String ... patterns) {
        SchemaExtensions.setNotPatterns(schema, Arrays.asList(patterns));
    }

    public static void addNotPatterns(Schema<?> schema, Iterable<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                SchemaExtensions.addNotPattern(schema, pattern);
            }
        }
    }

    public static void addNotPattern(Schema<?> schema, String pattern) {
        if (pattern != null) {
            LinkedHashSet<String> patterns = (LinkedHashSet<String>)SchemaExtensions.getExtension(schema, EXT_NOT_PATTERNS);
            if (patterns == null) {
                patterns = new LinkedHashSet<String>();
                SchemaExtensions.setExtension(schema, EXT_NOT_PATTERNS, patterns);
            }
            patterns.add(pattern);
        }
    }

    public static Set<BigDecimal> getNotMultipleOfs(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_NOT_MULTIPLEOFS);
    }

    public static void setNotMultipleOfs(Schema<?> schema, Iterable<BigDecimal> multipleOfs) {
        SchemaExtensions.removeExtension(schema, EXT_NOT_MULTIPLEOFS);
        SchemaExtensions.addNotMultipleOfs(schema, multipleOfs);
    }

    public static void setNotMultipleOfs(Schema<?> schema, BigDecimal ... multipleOfs) {
        SchemaExtensions.setNotMultipleOfs(schema, Arrays.asList(multipleOfs));
    }

    public static void addNotMultipleOf(Schema<?> schema, BigDecimal multipleOf) {
        if (multipleOf != null) {
            LinkedHashSet<BigDecimal> multipleOfs = (LinkedHashSet<BigDecimal>)SchemaExtensions.getExtension(schema, EXT_NOT_MULTIPLEOFS);
            if (multipleOfs == null) {
                multipleOfs = new LinkedHashSet<BigDecimal>();
                SchemaExtensions.setExtension(schema, EXT_NOT_MULTIPLEOFS, multipleOfs);
            }
            multipleOfs.add(multipleOf);
        }
    }

    public static void addNotMultipleOfs(Schema<?> schema, Iterable<BigDecimal> multipleOfs) {
        if (multipleOfs != null) {
            for (BigDecimal multipleOf : multipleOfs) {
                SchemaExtensions.addNotMultipleOf(schema, multipleOf);
            }
        }
    }

    public static Set<Object> getNotEnums(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_NOT_ENUMS);
    }

    public static void setNotEnums(Schema<?> schema, Iterable<?> enums) {
        SchemaExtensions.removeExtension(schema, EXT_NOT_ENUMS);
        SchemaExtensions.addNotEnums(schema, enums);
    }

    public static void addNotEnum(Schema<?> schema, Object enumValue) {
        if (enumValue != null) {
            LinkedHashSet<Object> enums = (LinkedHashSet<Object>)SchemaExtensions.getExtension(schema, EXT_NOT_ENUMS);
            if (enums == null) {
                enums = new LinkedHashSet<Object>();
                SchemaExtensions.setExtension(schema, EXT_NOT_ENUMS, enums);
            }
            enums.add(enumValue);
        }
    }

    public static void addNotEnums(Schema<?> schema, Iterable<?> enums) {
        if (enums != null) {
            for (Object enumValue : enums) {
                SchemaExtensions.addNotEnum(schema, enumValue);
            }
        }
    }

    public static Set<String> getNotRequired(Schema<?> schema) {
        return (Set)SchemaExtensions.getExtension(schema, EXT_NOT_REQUIRED);
    }

    public static void setNotRequired(Schema<?> schema, Iterable<String> notRequired) {
        SchemaExtensions.removeExtension(schema, EXT_NOT_REQUIRED);
        SchemaExtensions.addNotRequired(schema, notRequired);
    }

    public static void addNotRequired(Schema<?> schema, String property) {
        LinkedHashSet<String> notRequired = (LinkedHashSet<String>)SchemaExtensions.getExtension(schema, EXT_NOT_REQUIRED);
        if (notRequired == null) {
            notRequired = new LinkedHashSet<String>();
            SchemaExtensions.setExtension(schema, EXT_NOT_REQUIRED, notRequired);
        }
        notRequired.add(property);
    }

    public static void addNotRequired(Schema<?> schema, Iterable<String> notRequired) {
        if (notRequired != null) {
            for (String property : notRequired) {
                SchemaExtensions.addNotRequired(schema, property);
            }
        }
    }

    public static Integer getMaxValues(Schema<?> schema) {
        return (Integer)SchemaExtensions.getExtension(schema, EXT_MAX_VALUES);
    }

    public static void setMaxValues(Schema<?> schema, Integer maxValues) {
        SchemaExtensions.setExtension(schema, EXT_MAX_VALUES, maxValues);
    }

    public static boolean isPropertySchema(Schema<?> schema) {
        Boolean forProperty = (Boolean)SchemaExtensions.getExtension(schema, EXT_PROPERTY_SCHEMA);
        return Optional.ofNullable(forProperty).orElse(false);
    }

    public static void setPropertySchema(Schema<?> schema, boolean forProperty) {
        SchemaExtensions.setExtension(schema, EXT_PROPERTY_SCHEMA, forProperty);
    }

    private static boolean hasExtension(Schema<?> schema, String key) {
        return SchemaExtensions.getExtensions(schema).containsKey(key);
    }

    private static void removeExtension(Schema<?> schema, String key) {
        if (SchemaExtensions.hasExtension(schema, key)) {
            SchemaExtensions.getExtensions(schema).remove(key);
        }
    }

    private static <T> T getExtension(Schema<?> schema, String key) {
        return (T)SchemaExtensions.getExtensions(schema).get(key);
    }

    private static void setExtension(Schema<?> schema, String key, Object value) {
        Map extensions = Optional.ofNullable(schema.getExtensions()).orElse(new HashMap());
        extensions.put(key, value);
        schema.setExtensions(extensions);
    }

    private static Map<String, Object> getExtensions(Schema<?> schema) {
        return Optional.ofNullable(schema.getExtensions()).orElse(Collections.emptyMap());
    }
}

