/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import org.cornutum.tcases.openapi.ConditionReporter;
import org.cornutum.tcases.openapi.Dnf;
import org.cornutum.tcases.openapi.OpenApiContext;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.SchemaExtensions;
import org.cornutum.tcases.openapi.SchemaUtils;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.MapBuilder;

public class SchemaAnalyzer
extends ConditionReporter<OpenApiContext> {
    public SchemaAnalyzer(OpenApiContext context) {
        super(context);
    }

    public Schema<?> analyze(OpenAPI api, Schema<?> schema) {
        Schema<?> resolved = this.resolve(api, schema);
        this.analyzeValidTypes(api, resolved);
        if (Dnf.unsatisfiable(this.analyzeDnf(resolved))) {
            throw new IllegalStateException("This schema can't be satisfied by any instance");
        }
        return resolved;
    }

    private Schema<?> resolve(OpenAPI api, Schema<?> schema) {
        Schema<?> resolved = OpenApiUtils.resolveSchema(api, schema);
        if (resolved != null && !SchemaExtensions.hasResolvedAll(resolved)) {
            SchemaExtensions.setResolvedAll(resolved, false);
            Optional.ofNullable(resolved.getNot()).ifPresent(not -> resolved.setNot(this.resultFor("not", () -> this.resolve(api, (Schema<?>)not))));
            Optional.ofNullable(SchemaUtils.asComposedSchema(resolved)).ifPresent(composed -> this.resolveMembers(api, (ComposedSchema)composed));
            Optional.ofNullable(SchemaUtils.asArraySchema(resolved)).ifPresent(array -> this.resolveItems(api, (ArraySchema)array));
            this.resolveProperties(api, resolved);
            SchemaExtensions.setResolvedAll(resolved, true);
        }
        return resolved;
    }

    private void resolveMembers(OpenAPI api, ComposedSchema composed) {
        composed.setAllOf(Optional.ofNullable(composed.getAllOf()).orElse(Collections.emptyList()).stream().map(member -> this.resultFor("allOf", () -> this.resolve(api, (Schema<?>)member))).collect(Collectors.toList()));
        composed.setAnyOf(Optional.ofNullable(composed.getAnyOf()).orElse(Collections.emptyList()).stream().map(member -> this.resultFor("anyOf", () -> this.resolve(api, (Schema<?>)member))).collect(Collectors.toList()));
        composed.setOneOf(Optional.ofNullable(composed.getOneOf()).orElse(Collections.emptyList()).stream().map(member -> this.resultFor("oneOf", () -> this.resolve(api, (Schema<?>)member))).collect(Collectors.toList()));
    }

    private void resolveItems(OpenAPI api, ArraySchema array) {
        array.setItems(this.resultFor("items", () -> this.resolve(api, array.getItems())));
    }

    private void resolveProperties(OpenAPI api, Schema<?> object) {
        Optional.ofNullable(object.getProperties()).ifPresent(properties -> properties.keySet().stream().forEach(p -> properties.put(p, this.resultFor((String)p, () -> this.resolve(api, (Schema)properties.get(p))))));
        Optional.ofNullable(object.getAdditionalProperties()).filter(additional -> additional instanceof Schema).ifPresent(additional -> object.setAdditionalProperties((Object)this.resultFor("additionalProperties", () -> this.resolve(api, (Schema)additional))));
    }

    private void analyzeValidTypes(OpenAPI api, Schema<?> schema) {
        if (schema != null && !SchemaExtensions.hasValidTypesAll(schema)) {
            this.validTypes(api, schema);
            SchemaExtensions.setValidTypesAll(schema, false);
            Optional.ofNullable(schema.getNot()).ifPresent(not -> this.doFor("not", () -> this.analyzeValidTypes(api, (Schema<?>)not)));
            Optional.ofNullable(SchemaUtils.asArraySchema(schema)).ifPresent(array -> this.doFor("items", () -> this.analyzeValidTypes(api, array.getItems())));
            Optional.ofNullable(schema.getProperties()).ifPresent(properties -> properties.keySet().stream().forEach(p -> this.doFor((String)p, () -> this.analyzeValidTypes(api, (Schema)properties.get(p)))));
            Optional.ofNullable(schema.getAdditionalProperties()).filter(additional -> additional instanceof Schema).ifPresent(additional -> this.doFor("additionalProperties", () -> this.analyzeValidTypes(api, (Schema)additional)));
            SchemaExtensions.setValidTypesAll(schema, true);
        }
    }

    private Set<String> validTypes(OpenAPI api, Schema<?> schema) {
        if (!SchemaExtensions.hasValidTypes(schema)) {
            SchemaExtensions.setValidTypes(schema, this.findValidTypes(api, schema));
        }
        return SchemaExtensions.getValidTypes(schema);
    }

    private Set<String> findValidTypes(OpenAPI api, Schema<?> schema) {
        Set validTypes = Optional.ofNullable(schema.getType()).map(type -> Stream.of(type).collect(Collectors.toSet())).orElse(null);
        ComposedSchema composedSchema = SchemaUtils.asComposedSchema(schema);
        if (composedSchema != null) {
            List oneOfMembers;
            Set oneOfTypes;
            OpenApiUtils.resolveSchemaMembers(api, composedSchema);
            List allOfMembers = composedSchema.getAllOf();
            Set allOfTypes = IntStream.range(0, allOfMembers.size()).mapToObj(i -> new AbstractMap.SimpleEntry<Integer, Set>(i, this.resultFor(String.format("allOf[%s]", i), () -> this.validTypes(api, (Schema)allOfMembers.get(i))))).filter(memberTypes -> memberTypes.getValue() != null).reduce((allTypes, memberTypes) -> this.resultFor(String.format("allOf[%s]", memberTypes.getKey()), () -> {
                Set allAccepted = SetUtils.intersection((Set)((Set)allTypes.getValue()), (Set)((Set)memberTypes.getValue())).toSet();
                if (allAccepted.isEmpty()) {
                    throw new IllegalStateException(String.format("Valid types=%s for this member are not accepted by other \"allOf\" members", memberTypes.getValue()));
                }
                allTypes.setValue(allAccepted);
                return allTypes;
            })).map(allTypes -> (Set)allTypes.getValue()).orElse(null);
            if (validTypes == null) {
                validTypes = allOfTypes;
            } else if (allOfTypes != null) {
                if (SetUtils.intersection((Set)validTypes, (Set)allOfTypes).isEmpty()) {
                    throw new IllegalStateException(String.format("\"allOf\" members accept types=%s but not required types=%s", allOfTypes, validTypes));
                }
                validTypes.retainAll(allOfTypes);
            }
            List anyOfMembers = composedSchema.getAnyOf();
            Set anyOfTypes = IntStream.range(0, anyOfMembers.size()).mapToObj(i -> this.resultFor(String.format("anyOf[%s]", i), () -> this.validTypes(api, (Schema)anyOfMembers.get(i)))).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            if (!anyOfTypes.isEmpty()) {
                if (validTypes == null) {
                    validTypes = anyOfTypes;
                } else {
                    if (SetUtils.intersection(validTypes, anyOfTypes).isEmpty()) {
                        throw new IllegalStateException(String.format("\"anyOf\" members accept types=%s but not types=%s", anyOfTypes, validTypes));
                    }
                    validTypes.retainAll(anyOfTypes);
                }
            }
            if (!(oneOfTypes = IntStream.range(0, (oneOfMembers = composedSchema.getOneOf()).size()).mapToObj(i -> this.resultFor(String.format("oneOf[%s]", i), () -> this.validTypes(api, (Schema)oneOfMembers.get(i)))).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet())).isEmpty()) {
                if (validTypes == null) {
                    validTypes = oneOfTypes;
                } else {
                    if (SetUtils.intersection(validTypes, oneOfTypes).isEmpty()) {
                        throw new IllegalStateException(String.format("\"oneOf\" members accept types=%s but not types=%s", oneOfTypes, validTypes));
                    }
                    validTypes.retainAll(oneOfTypes);
                }
            }
        }
        return validTypes;
    }

    private Stream<Schema<?>> applicableMembers(String containerType, Set<String> validTypes, List<Schema> memberSchemas) {
        return IntStream.range(0, memberSchemas.size()).filter(i -> this.resultFor(String.format("%s[%s]", containerType, i), () -> {
            boolean applicable = this.isApplicableInput((Schema)memberSchemas.get(i), validTypes);
            if (!applicable) {
                this.notifyWarning(String.format("Ignoring this schema -- not applicable when only instance types=%s can be valid", validTypes));
            }
            return applicable;
        })).mapToObj(i -> (Schema)memberSchemas.get(i));
    }

    private boolean isApplicableInput(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(validTypes).flatMap(required -> Optional.ofNullable(SchemaExtensions.getValidTypes(schema)).map(valid -> !SetUtils.intersection((Set)valid, (Set)required).isEmpty())).orElse(true);
    }

    private Dnf analyzeDnf(Schema<?> schema) {
        return Optional.ofNullable(schema).map(s -> this.dnfFor((Schema<?>)s, SchemaExtensions.getValidTypes(s))).orElse(Dnf.NONEXISTENT);
    }

    private Dnf dnfFor(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(SchemaExtensions.getDnf(schema)).orElseGet(() -> {
            SchemaExtensions.setDnf(schema, this.withWarningIf(this.toDnf(schema, validTypes), Dnf::unsatisfiable, String.format("This schema can't be satisfied by any instance of types=%s", validTypes)));
            this.analyzeSubDnfs(schema);
            return SchemaExtensions.getDnf(schema);
        });
    }

    private Dnf toDnf(Schema<?> schema, Set<String> validTypes) {
        return this.allOf(this.leafDnf(schema), this.getNotDnf(schema, validTypes), this.resultFor("allOf", () -> this.withWarningIf(this.allOf(this.getAllOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")), this.resultFor("oneOf", () -> this.withWarningIf(this.oneOf(this.getOneOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")), this.resultFor("anyOf", () -> this.withWarningIf(this.anyOf(this.getAnyOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")));
    }

    private Dnf dnfForNot(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(SchemaExtensions.getDnf(schema)).orElseGet(() -> {
            SchemaExtensions.setDnf(schema, this.withWarningIf(this.toNotDnf(schema, validTypes), Dnf::unsatisfiable, String.format("This schema can't be satisfied by any instance of types=%s", validTypes)));
            this.analyzeSubDnfs(schema);
            return SchemaExtensions.getDnf(schema);
        });
    }

    private Dnf leafDnf(Schema<?> schema) {
        return Optional.ofNullable(this.leafSchemaOf(schema)).map(xva$0 -> Dnf.of(xva$0)).orElse(Dnf.NONEXISTENT);
    }

    private void analyzeSubDnfs(Schema<?> schema) {
        Optional undefinedArrayItems = Optional.ofNullable(SchemaUtils.asArraySchema(schema)).flatMap(array -> this.resultFor("items", () -> Optional.of(this.analyzeDnf(array.getItems())).filter(Dnf::undefined)));
        Optional undefinedProperties = Optional.ofNullable(schema.getProperties()).flatMap(properties -> properties.keySet().stream().map(p -> this.resultFor((String)p, () -> this.analyzeDnf(SchemaUtils.toPropertySchema((Schema)schema.getProperties().get(p))))).collect(Collectors.toList()).stream().filter(Dnf::undefined).findFirst());
        Optional<Dnf> undefinedAdditionalProperties = Optional.ofNullable(SchemaUtils.additionalPropertiesSchema(schema)).map(ap -> this.resultFor("additionalProperties", () -> this.analyzeDnf(SchemaUtils.toPropertySchema(ap)))).filter(Dnf::undefined);
        if (undefinedArrayItems.isPresent() || undefinedProperties.isPresent() || undefinedAdditionalProperties.isPresent()) {
            SchemaExtensions.setDnf(schema, Dnf.UNDEFINED);
        }
    }

    private Dnf toNotDnf(Schema<?> schema, Set<String> validTypes) {
        return this.unionOf(this.not(this.leafDnf(schema)), this.not(this.getNotDnf(schema, validTypes)), this.resultFor("allOf", () -> this.withWarningIf(this.notAllOf(this.getAllOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")), this.resultFor("oneOf", () -> this.withWarningIf(this.noneOf(this.getOneOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")), this.resultFor("anyOf", () -> this.withWarningIf(this.noneOf(this.getAnyOfDnfs(schema, validTypes)), Dnf::unsatisfiable, "This combination of schemas can't be satisfied")));
    }

    private Dnf getNotDnf(Schema<?> schema, Set<String> validTypes) {
        return this.resultFor("not", () -> Optional.ofNullable(schema.getNot()).map(not -> this.dnfForNot((Schema<?>)not, validTypes)).orElse(Dnf.NONEXISTENT));
    }

    private List<Dnf> getAllOfDnfs(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(SchemaUtils.asComposedSchema(schema)).map(composed -> this.combinedAllOf(composed.getAllOf()).stream().map(member -> this.dnfFor((Schema<?>)member, validTypes)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<Dnf> getOneOfDnfs(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(SchemaUtils.asComposedSchema(schema)).map(composed -> this.applicableMembers("oneOf", validTypes, composed.getOneOf()).map(member -> this.dnfFor((Schema<?>)member, validTypes)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<Dnf> getAnyOfDnfs(Schema<?> schema, Set<String> validTypes) {
        return Optional.ofNullable(SchemaUtils.asComposedSchema(schema)).map(composed -> this.applicableMembers("anyOf", validTypes, composed.getAnyOf()).map(member -> this.dnfFor((Schema<?>)member, validTypes)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private Dnf allOf(Dnf ... dnfs) {
        return this.allOf(Arrays.asList(dnfs));
    }

    private Dnf allOf(List<Dnf> dnfs) {
        return dnfs.stream().filter(Dnf::exists).reduce((dnf1, dnf2) -> Dnf.undefined(dnf1) ? dnf1 : (Dnf.undefined(dnf2) ? dnf2 : Dnf.of(dnf1.getAlternatives().stream().flatMap(a1 -> {
            List<Schema<?>> c2 = dnf2.getCompatibleAlternatives(a1.getType());
            return c2.isEmpty() ? Stream.of(a1) : c2.stream().map(a2 -> this.combined((Schema<?>)a1, (Schema<?>)a2)).filter(Objects::nonNull);
        })))).orElse(Dnf.NONEXISTENT);
    }

    private Dnf oneOf(List<Dnf> dnfs) {
        List oneOfOnly = IntStream.range(0, dnfs.size()).mapToObj(i -> {
            Dnf member = (Dnf)dnfs.get(i);
            return !Dnf.exists(member) ? Dnf.NONEXISTENT : this.withWarningIf(this.allOf(member, this.noneOf(CollectionUtils.restOf((List)dnfs, (int)i))), Dnf::undefined, String.format("oneOf[%s] can't be satisfied exclusively -- ignoring this schema", i));
        }).filter(Dnf::exists).collect(Collectors.toList());
        return oneOfOnly.isEmpty() ? Dnf.NONEXISTENT : Dnf.of(oneOfOnly.stream().flatMap(dnf -> dnf.getAlternatives().stream()));
    }

    private Dnf noneOf(List<Dnf> dnfs) {
        return dnfs.stream().filter(Dnf::exists).flatMap(dnf -> dnf.getAlternatives().stream().map(alternative -> Dnf.of(this.getInvalidators((Schema<?>)alternative)))).reduce((xva$0, xva$1) -> this.allOf((Dnf)xva$0, (Dnf)xva$1)).orElse(Dnf.NONEXISTENT);
    }

    private Dnf notAllOf(List<Dnf> dnfs) {
        return Optional.of(dnfs.stream().filter(Dnf::exists).collect(Collectors.toList())).filter(exist -> exist.size() == 1).map(this::noneOf).orElse(this.anyOf(dnfs));
    }

    private Dnf anyOf(List<Dnf> dnfs) {
        List<Dnf> choices = dnfs.stream().filter(Dnf::exists).collect(Collectors.toList());
        ArrayList pairs = new ArrayList();
        Set unpaired = (Set)IntStream.range(0, choices.size()).mapToObj(Integer::valueOf).collect(CollectionUtils.toOrderedSet());
        if (choices.size() >= 3) {
            IntStream.range(0, choices.size()).forEach(i -> {
                if (unpaired.contains(i)) {
                    IntStream.range(0, choices.size()).mapToObj(j -> {
                        Dnf pair;
                        Dnf dnf = pair = i == j ? Dnf.UNDEFINED : this.allOf((Dnf)choices.get(i), (Dnf)choices.get(j), this.noneOf(CollectionUtils.restOf((List)CollectionUtils.restOf((List)choices, (int)Math.max(i, j)), (int)Math.min(i, j))));
                        if (Dnf.defined(pair)) {
                            unpaired.remove(i);
                            unpaired.remove(j);
                        }
                        return pair;
                    }).filter(Dnf::defined).findFirst().ifPresent(pair -> pairs.add(pair));
                }
            });
        }
        return pairs.isEmpty() ? this.oneOf(choices) : Dnf.of(Stream.concat(pairs.stream().flatMap(dnf -> dnf.getAlternatives().stream()), unpaired.stream().map(i -> this.allOf((Dnf)choices.get((int)i), this.noneOf(CollectionUtils.restOf((List)choices, (int)i)))).flatMap(dnf -> dnf.getAlternatives().stream())));
    }

    private Dnf not(Dnf dnf) {
        return this.noneOf(Arrays.asList(dnf));
    }

    private Dnf unionOf(List<Dnf> dnfs) {
        return Optional.of(dnfs.stream().filter(Dnf::exists).collect(Collectors.toList())).filter(exist -> !exist.isEmpty()).map(exist -> Dnf.of(exist.stream().flatMap(dnf -> dnf.getAlternatives().stream()))).orElse(Dnf.NONEXISTENT);
    }

    private Dnf unionOf(Dnf ... dnfs) {
        return this.unionOf(Arrays.asList(dnfs));
    }

    private List<Schema> combinedAllOf(List<Schema> members) {
        List memberEquivalents = IntStream.range(0, members.size()).mapToObj(i -> this.resultFor(String.format("allOf[%s]", i), () -> (Schema)Optional.ofNullable(SchemaUtils.asComposedSchema((Schema)members.get(i))).flatMap(c -> this.combinedAllOf((ComposedSchema)c)).orElse(members.get(i)))).collect(Collectors.toList());
        List<Schema> consolidated = memberEquivalents.stream().filter(SchemaUtils::isNotLeafSchema).collect(Collectors.toList());
        IntStream.range(0, memberEquivalents.size()).mapToObj(i -> new AbstractMap.SimpleEntry(i, memberEquivalents.get(i))).filter(memberEntry -> SchemaUtils.isLeafSchema((Schema)memberEntry.getValue())).reduce((combinedEntry, memberEntry) -> this.resultFor(String.format("allOf[%s]", memberEntry.getKey()), () -> new AbstractMap.SimpleEntry(memberEntry.getKey(), SchemaUtils.combineSchemas((OpenApiContext)this.getContext(), (Schema)combinedEntry.getValue(), (Schema)memberEntry.getValue())))).map(combinedEntry -> (Schema)combinedEntry.getValue()).ifPresent(combined -> consolidated.add(0, (Schema)combined));
        return consolidated;
    }

    private Optional<Schema> combinedAllOf(ComposedSchema schema) {
        return schema.getAllOf().isEmpty() || !schema.getAnyOf().isEmpty() || !schema.getOneOf().isEmpty() || schema.getNot() != null ? Optional.empty() : Optional.of(this.combinedAllOf(schema.getAllOf())).filter(members -> members.size() == 1).map(members -> (Schema)members.get(0)).filter(SchemaUtils::isLeafSchema).map(member -> SchemaUtils.combineSchemas((OpenApiContext)this.getContext(), schema, member));
    }

    private Schema<?> combined(Schema<?> schema1, Schema<?> schema2) {
        try {
            return SchemaUtils.combineSchemas((OpenApiContext)this.getContext(), schema1, schema2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Schema<?>> getInvalidators(Schema<?> schema) {
        ArrayList alternatives;
        String type = Optional.ofNullable(schema).map(Schema::getType).orElse(null);
        List<Schema<?>> list = schema == null ? new ArrayList() : ("object".equals(type) ? this.getObjectInvalidators(schema) : ("string".equals(type) ? this.getStringInvalidators(schema) : ("integer".equals(type) ? this.getIntegerInvalidators(schema) : ("boolean".equals(type) ? this.getBooleanInvalidators(schema) : ("array".equals(type) ? this.getArrayInvalidators(schema) : (alternatives = "number".equals(type) ? this.getNumberInvalidators(schema) : this.getGenericInvalidators(schema)))))));
        if (alternatives.isEmpty()) {
            alternatives.add(SchemaUtils.FALSE_SCHEMA);
        }
        return alternatives;
    }

    private List<Schema<?>> getSubSchemaInvalidators(String context, Schema<?> schema) {
        return this.resultFor(context, () -> SchemaUtils.isLeafSchema(schema) ? this.getInvalidators(schema) : Optional.ofNullable(SchemaExtensions.getDnf(schema)).orElse(Dnf.UNDEFINED).getAlternatives().stream().flatMap(s -> this.getInvalidators((Schema<?>)s).stream()).collect(Collectors.toList()));
    }

    private List<Schema<?>> getObjectInvalidators(Schema<?> schema) {
        List<Schema<?>> alternatives = this.getGenericInvalidators(schema);
        Optional.ofNullable(schema.getMaxProperties()).map(maxProperties -> this.assertNot(schema, maxProperties, (s, v) -> s.setMinProperties(Integer.valueOf(v + 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getMinProperties()).filter(minProperties -> minProperties > 0).map(minProperties -> this.assertNot(schema, minProperties, (s, v) -> s.setMaxProperties(Integer.valueOf(v - 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getProperties()).orElse(Collections.emptyMap()).forEach((property, propertySchema) -> {
            List<String> notRequired = Optional.ofNullable(schema.getRequired()).map(required -> required.contains(property)).orElse(false) != false ? null : Arrays.asList(property);
            this.getSubSchemaInvalidators((String)property, (Schema<?>)propertySchema).stream().map(notSchema -> this.assertNot(schema, notSchema, (s, v) -> {
                s.setProperties(MapBuilder.of((Object)property, (Object)v).build());
                s.setRequired(notRequired);
            })).forEach(s -> alternatives.add((Schema<?>)s));
        });
        Optional.ofNullable(schema.getRequired()).orElse(Collections.emptyList()).stream().map(property -> this.assertNot(schema, property, (s, v) -> SchemaExtensions.addNotRequired(s, v))).forEach(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getAdditionalProperties()).ifPresent(ap -> {
            if (ap instanceof Schema) {
                this.getSubSchemaInvalidators("additionalProperties", (Schema)ap).stream().map(notSchema -> this.assertNot(schema, notSchema, (s, v) -> s.setAdditionalProperties(v))).forEach(s -> alternatives.add((Schema<?>)s));
            } else {
                alternatives.add(this.assertNot(schema, (Boolean)ap, (s, v) -> s.setAdditionalProperties((Object)(v == false ? 1 : 0))));
            }
        });
        return alternatives;
    }

    private List<Schema<?>> getStringInvalidators(Schema<?> schema) {
        List<Schema<?>> alternatives = this.getGenericInvalidators(schema);
        Optional.ofNullable(schema.getMaxLength()).map(maxLength -> this.assertNot(schema, maxLength, (s, v) -> s.setMinLength(Integer.valueOf(v + 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getMinLength()).filter(minLength -> minLength > 0).map(minLength -> this.assertNot(schema, minLength, (s, v) -> s.setMaxLength(Integer.valueOf(v - 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(SchemaExtensions.getPatterns(schema)).ifPresent(patterns -> patterns.stream().map(pattern -> this.assertNot(schema, pattern, (s, v) -> SchemaExtensions.addNotPattern(s, v))).forEach(s -> alternatives.add((Schema<?>)s)));
        Optional.ofNullable(SchemaExtensions.getNotPatterns(schema)).ifPresent(patterns -> patterns.stream().map(pattern -> this.assertNot(schema, pattern, (s, v) -> SchemaExtensions.addPattern(s, v))).forEach(s -> alternatives.add((Schema<?>)s)));
        return alternatives;
    }

    private List<Schema<?>> getIntegerInvalidators(Schema<?> schema) {
        return this.getNumericInvalidators(schema);
    }

    private List<Schema<?>> getBooleanInvalidators(Schema<?> schema) {
        return this.getGenericInvalidators(schema);
    }

    private List<Schema<?>> getArrayInvalidators(Schema<?> schema) {
        List<Schema<?>> alternatives = this.getGenericInvalidators(schema);
        Optional.ofNullable(schema.getMinItems()).filter(max -> max > 0).map(max -> this.assertNot(schema, max, (s, v) -> s.setMaxItems(Integer.valueOf(v - 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getMaxItems()).map(min -> this.assertNot(schema, min, (s, v) -> s.setMinItems(Integer.valueOf(v + 1)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getUniqueItems()).map(unique -> this.assertNot(schema, unique, (s, v) -> s.setUniqueItems(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(SchemaUtils.asArraySchema(schema)).ifPresent(array -> Optional.ofNullable(array.getItems()).ifPresent(items -> this.getSubSchemaInvalidators("items", (Schema<?>)items).stream().map(notItems -> this.assertNot((Schema)array, (Object)notItems, (s, v) -> s.setItems(notItems))).forEach(s -> alternatives.add((Schema<?>)s))));
        return alternatives;
    }

    private List<Schema<?>> getNumberInvalidators(Schema<?> schema) {
        return this.getNumericInvalidators(schema);
    }

    private List<Schema<?>> getNumericInvalidators(Schema<?> schema) {
        List<Schema<?>> alternatives = this.getGenericInvalidators(schema);
        boolean exclusiveMaximum = !Boolean.TRUE.equals(schema.getExclusiveMinimum());
        Optional.ofNullable(schema.getMinimum()).map(max -> this.assertNot(schema, max, (s, v) -> s.setMaximum(max))).ifPresent(s -> {
            s.setExclusiveMaximum(Boolean.valueOf(exclusiveMaximum));
            alternatives.add((Schema<?>)s);
        });
        boolean exclusiveMinimum = !Boolean.TRUE.equals(schema.getExclusiveMaximum());
        Optional.ofNullable(schema.getMaximum()).map(min -> this.assertNot(schema, min, (s, v) -> s.setMinimum(min))).ifPresent(s -> {
            s.setExclusiveMinimum(Boolean.valueOf(exclusiveMinimum));
            alternatives.add((Schema<?>)s);
        });
        Optional.ofNullable(schema.getExclusiveMaximum()).map(exclusive -> this.assertNot(schema, exclusive, (s, v) -> s.setExclusiveMaximum(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getExclusiveMinimum()).map(exclusive -> this.assertNot(schema, exclusive, (s, v) -> s.setExclusiveMinimum(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getMultipleOf()).map(multipleOf -> this.assertNot(schema, multipleOf, (s, v) -> SchemaExtensions.addNotMultipleOf(s, v))).ifPresent(s -> alternatives.add((Schema<?>)s));
        return alternatives;
    }

    private List<Schema<?>> getGenericInvalidators(Schema<?> schema) {
        ArrayList alternatives = new ArrayList();
        Optional.ofNullable(schema.getType()).map(type -> this.assertNot(SchemaUtils.EMPTY_SCHEMA, type, (s, v) -> SchemaExtensions.addNotType(s, v))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getNullable()).map(nullable -> this.assertNot(schema, nullable, (s, v) -> s.setNullable(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getEnum()).map(enums -> this.assertNot(schema, enums, (s, v) -> SchemaExtensions.setNotEnums(s, v))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getReadOnly()).map(readOnly -> this.assertNot(schema, readOnly, (s, v) -> s.setReadOnly(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        Optional.ofNullable(schema.getWriteOnly()).map(writeOnly -> this.assertNot(schema, writeOnly, (s, v) -> s.setWriteOnly(Boolean.valueOf(v == false)))).ifPresent(s -> alternatives.add((Schema<?>)s));
        return alternatives;
    }

    private <S extends Schema<?>, V> Schema<?> assertNot(S original, V asserted, BiConsumer<S, V> negater) {
        Class<?> schemaType = original.getClass();
        try {
            Schema alternative = (Schema)schemaType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            alternative.setType(original.getType());
            SchemaExtensions.setPropertySchema(alternative, SchemaExtensions.isPropertySchema(original));
            alternative.setFormat(null);
            negater.accept(alternative, asserted);
            return alternative;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't create alternative schema of type=%s", schemaType.getSimpleName()), e);
        }
    }

    private Schema<?> leafSchemaOf(Schema<?> schema) {
        return Optional.of(SchemaUtils.copySchema(schema)).filter(leafSchema -> !SchemaUtils.isEmpty(leafSchema) || SchemaUtils.isLeafSchema(schema)).map(this::normalize).orElse(null);
    }

    private Schema<?> normalize(Schema<?> schema) {
        if (!SchemaExtensions.isPropertySchema(schema)) {
            schema.setReadOnly(null);
            schema.setWriteOnly(null);
        }
        return schema;
    }

    private <T> T withWarningIf(T result, Predicate<T> isWarning, String reason) {
        if (isWarning.test(result)) {
            this.notifyWarning(reason);
        }
        return result;
    }
}

