/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.InvalidStyleException;
import org.cornutum.tcases.openapi.OpenApiException;
import org.cornutum.tcases.openapi.SchemaUtils;

public final class OpenApiUtils {
    private static final String COMPONENTS_PARAMETERS_REF = "#/components/parameters/";
    private static final String COMPONENTS_REQUEST_BODIES_REF = "#/components/requestBodies/";
    private static final String COMPONENTS_RESPONSES_REF = "#/components/responses/";
    private static final String COMPONENTS_SCHEMAS_REF = "#/components/schemas/";
    private static final String COMPONENTS_HEADERS_REF = "#/components/headers/";
    private static final String COMPONENTS_EXAMPLES_REF = "#/components/examples/";

    private OpenApiUtils() {
    }

    public static <T> T expectedValueOf(T value, String description, Object ... descriptionArgs) {
        if (value == null) {
            throw new IllegalStateException(String.format(description, descriptionArgs) + " is not defined");
        }
        return value;
    }

    public static Integer stringFormatMax(String format) {
        return "email".equals(format) ? Integer.valueOf(320) : ("date".equals(format) ? Integer.valueOf(10) : ("date-time".equals(format) ? Integer.valueOf(29) : ("uuid".equals(format) ? Integer.valueOf(36) : null)));
    }

    public static Integer stringFormatMin(String format) {
        return "email".equals(format) ? Integer.valueOf(7) : ("date".equals(format) ? Integer.valueOf(10) : ("date-time".equals(format) ? Integer.valueOf(29) : ("uuid".equals(format) ? Integer.valueOf(36) : null)));
    }

    public static Characters getParamCharacters(String location, String style) {
        Characters.Base locationChars;
        Characters.Base base = locationChars = "cookie".equals(location) ? Characters.COOKIE_VALUE : Characters.ANY;
        Character delimiter = "spaceDelimited".equals(style) ? Character.valueOf(' ') : ("pipeDelimited".equals(style) ? Character.valueOf('|') : null);
        return Optional.ofNullable(delimiter).map(d -> Characters.delimited(locationChars, d.charValue())).orElse(locationChars);
    }

    public static Parameter resolveParameter(OpenAPI api, Parameter parameter) {
        return Optional.ofNullable(parameter.get$ref()).map(ref -> OpenApiUtils.componentParameterRef(api, ref)).orElse(parameter);
    }

    public static Schema<?> resolveSchema(OpenAPI api, Schema<?> schema) {
        return schema == null ? null : SchemaUtils.resolveSchemaType(Optional.ofNullable(schema.get$ref()).map(ref -> OpenApiUtils.componentSchemaRef(api, ref)).orElse(schema));
    }

    public static ComposedSchema resolveSchemaMembers(OpenAPI api, ComposedSchema composed) {
        composed.setAllOf(Optional.ofNullable(composed.getAllOf()).orElse(Collections.emptyList()).stream().map(member -> OpenApiUtils.resolveSchema(api, member)).collect(Collectors.toList()));
        composed.setAnyOf(Optional.ofNullable(composed.getAnyOf()).orElse(Collections.emptyList()).stream().map(member -> OpenApiUtils.resolveSchema(api, member)).collect(Collectors.toList()));
        composed.setOneOf(Optional.ofNullable(composed.getOneOf()).orElse(Collections.emptyList()).stream().map(member -> OpenApiUtils.resolveSchema(api, member)).collect(Collectors.toList()));
        return composed;
    }

    public static RequestBody resolveRequestBody(OpenAPI api, RequestBody requestBody) {
        return Optional.ofNullable(requestBody.get$ref()).map(ref -> OpenApiUtils.componentRequestBodyRef(api, ref)).orElse(requestBody);
    }

    public static ApiResponse resolveResponse(OpenAPI api, ApiResponse response) {
        return Optional.ofNullable(response.get$ref()).map(ref -> OpenApiUtils.componentResponseRef(api, ref)).orElse(response);
    }

    public static Header resolveHeader(OpenAPI api, Header header) {
        return Optional.ofNullable(header.get$ref()).map(ref -> OpenApiUtils.componentHeaderRef(api, ref)).orElse(header);
    }

    public static Example resolveExample(OpenAPI api, Example example) {
        return Optional.ofNullable(example.get$ref()).map(ref -> OpenApiUtils.componentExampleRef(api, ref)).orElse(example);
    }

    public static Object exampleValue(Example example) {
        Object value;
        String externalUrl = Optional.ofNullable(example.getExternalValue()).orElse(null);
        if (externalUrl != null) {
            try {
                value = IOUtils.toString((URL)new URL(externalUrl), (String)"UTF-8");
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Can't get example value for url=%s", externalUrl), e);
            }
        } else {
            value = example.getValue();
        }
        return value;
    }

    public static Parameter componentParameterRef(OpenAPI api, String reference) {
        return (Parameter)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_PARAMETERS_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getParameters(), "Component parameters", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve parameter reference=%s", reference)));
    }

    public static Schema componentSchemaRef(OpenAPI api, String reference) {
        return (Schema)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_SCHEMAS_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getSchemas(), "Component schemas", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve schema reference=%s", reference)));
    }

    public static RequestBody componentRequestBodyRef(OpenAPI api, String reference) {
        return (RequestBody)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_REQUEST_BODIES_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getRequestBodies(), "Component request bodies", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve request body reference=%s", reference)));
    }

    public static ApiResponse componentResponseRef(OpenAPI api, String reference) {
        return (ApiResponse)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_RESPONSES_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getResponses(), "Component responses", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve response reference=%s", reference)));
    }

    public static Header componentHeaderRef(OpenAPI api, String reference) {
        return (Header)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_HEADERS_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getHeaders(), "Component headers", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve header reference=%s", reference)));
    }

    public static Example componentExampleRef(OpenAPI api, String reference) {
        return (Example)Optional.ofNullable(reference).flatMap(ref -> Optional.ofNullable(OpenApiUtils.componentName(COMPONENTS_EXAMPLES_REF, ref))).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getExamples(), "Component examples", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't resolve example reference=%s", reference)));
    }

    public static String componentName(String refType, String ref) {
        return ref.startsWith(refType) ? ref.substring(refType.length()) : null;
    }

    public static SecurityScheme getSecurityScheme(OpenAPI api, String scheme) {
        return (SecurityScheme)Optional.ofNullable(scheme).flatMap(name -> Optional.ofNullable(OpenApiUtils.expectedValueOf(OpenApiUtils.expectedValueOf(api.getComponents(), "Components", new Object[0]).getSecuritySchemes(), "Component security schemes", new Object[0]).get(name))).orElseThrow(() -> new IllegalStateException(String.format("Can't find security scheme=%s", scheme)));
    }

    public static String ifApplicableStyle(String style, String in, String type) throws InvalidStyleException {
        return String.valueOf(OpenApiUtils.ifApplicableStyle(Parameter.StyleEnum.valueOf((String)style.toUpperCase()), in, type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Parameter.StyleEnum ifApplicableStyle(Parameter.StyleEnum style, String in, String type) throws InvalidStyleException {
        Parameter.StyleEnum specified = style;
        type = Optional.ofNullable(type).orElse("null");
        if ("query".equals(in) || "cookie".equals(in)) {
            switch (specified) {
                case FORM: {
                    return specified;
                }
                case DEEPOBJECT: {
                    if ("object".equals(type)) return specified;
                    if ("null".equals(type)) {
                        return specified;
                    }
                    Parameter.StyleEnum applicable = Parameter.StyleEnum.FORM;
                    throw new InvalidStyleException(String.format("style=%s is not applicable for parameter type=%s", specified, type), applicable.toString());
                }
                case PIPEDELIMITED: 
                case SPACEDELIMITED: {
                    if (!"array".equals(type) && !"null".equals(type)) {
                        Parameter.StyleEnum applicable = Parameter.StyleEnum.FORM;
                        throw new InvalidStyleException(String.format("style=%s is not applicable for parameter type=%s", specified, type), applicable.toString());
                    }
                    if (specified != Parameter.StyleEnum.SPACEDELIMITED) return specified;
                    if (!"cookie".equals(in)) return specified;
                    Parameter.StyleEnum applicable = Parameter.StyleEnum.FORM;
                    throw new InvalidStyleException(String.format("style=%s is not applicable for a %s parameter", specified, in), applicable.toString());
                }
                default: {
                    Parameter.StyleEnum applicable = Parameter.StyleEnum.FORM;
                    throw new InvalidStyleException(String.format("style=%s is not applicable for a %s parameter", specified, in), applicable.toString());
                }
            }
        }
        if ("path".equals(in)) {
            switch (specified) {
                case SIMPLE: 
                case MATRIX: 
                case LABEL: {
                    return specified;
                }
                default: {
                    Parameter.StyleEnum applicable = Parameter.StyleEnum.SIMPLE;
                    throw new InvalidStyleException(String.format("style=%s is not applicable for a %s parameter", specified, in), applicable.toString());
                }
            }
        }
        if (!"header".equals(in)) throw new OpenApiException(String.format("'%s' is not a valid parameter location", in));
        switch (specified) {
            case SIMPLE: {
                return specified;
            }
            default: {
                Parameter.StyleEnum applicable = Parameter.StyleEnum.SIMPLE;
                throw new InvalidStyleException(String.format("style=%s is not applicable for a %s parameter", specified, in), applicable.toString());
            }
        }
    }
}

