/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.net.URI;
import java.util.Optional;
import org.cornutum.tcases.openapi.ModelConditionNotifier;
import org.cornutum.tcases.openapi.ServerSelector;
import org.cornutum.tcases.util.ToString;

public class ModelOptions {
    private ModelConditionNotifier notifier_;
    private boolean readOnlyEnforced_;
    private boolean writeOnlyEnforced_;
    private Source source_;
    private URI serverUri_;
    private ServerSelector serverSelector_;

    public ModelOptions() {
        this.setConditionNotifier(ModelConditionNotifier.log());
        this.setSource(Source.SCHEMAS);
        this.setServerSelector(ServerSelector.atIndex(0));
    }

    public void setConditionNotifier(ModelConditionNotifier notifier) {
        this.notifier_ = Optional.ofNullable(notifier).orElse(ModelConditionNotifier.ignore());
    }

    public ModelConditionNotifier getConditionNotifier() {
        return this.notifier_;
    }

    public void setReadOnlyEnforced(boolean enforced) {
        this.readOnlyEnforced_ = enforced;
    }

    public boolean isReadOnlyEnforced() {
        return this.readOnlyEnforced_;
    }

    public void setWriteOnlyEnforced(boolean enforced) {
        this.writeOnlyEnforced_ = enforced;
    }

    public boolean isWriteOnlyEnforced() {
        return this.writeOnlyEnforced_;
    }

    public void setSource(Source source) {
        this.source_ = source;
    }

    public Source getSource() {
        return this.source_;
    }

    public void setServerUri(URI uri) {
        this.serverUri_ = uri;
    }

    public URI getServerUri() {
        return this.serverUri_;
    }

    public void setServerSelector(ServerSelector serverSelector) {
        this.serverSelector_ = serverSelector;
    }

    public ServerSelector getServerSelector() {
        return this.serverSelector_;
    }

    public static Builder builder() {
        return ModelOptions.builder(null);
    }

    public static Builder builder(ModelOptions defaults) {
        return new Builder(defaults);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append("source", (Object)this.getSource()).append("conditionNotifier", (Object)this.getConditionNotifier()).append("readOnlyEnforced", this.isReadOnlyEnforced()).append("writeOnlyEnforced", this.isWriteOnlyEnforced()).append("server", (Object)Optional.ofNullable(String.valueOf(this.getServerUri())).orElse(String.valueOf(this.getServerSelector()))).toString();
    }

    public static class Builder {
        private ModelOptions modelOptions_ = new ModelOptions();

        public Builder() {
            this(null);
        }

        public Builder(ModelOptions defaults) {
            if (defaults != null) {
                this.notifier(defaults.getConditionNotifier()).readOnlyEnforced(defaults.isReadOnlyEnforced()).writeOnlyEnforced(defaults.isWriteOnlyEnforced()).source(defaults.getSource()).serverUri(defaults.getServerUri()).serverSelector(defaults.getServerSelector());
            }
        }

        public Builder notifier(ModelConditionNotifier notifier) {
            this.modelOptions_.setConditionNotifier(notifier);
            return this;
        }

        public Builder readOnlyEnforced(boolean enforced) {
            this.modelOptions_.setReadOnlyEnforced(enforced);
            return this;
        }

        public Builder readOnlyEnforced() {
            return this.readOnlyEnforced(true);
        }

        public Builder writeOnlyEnforced(boolean enforced) {
            this.modelOptions_.setWriteOnlyEnforced(enforced);
            return this;
        }

        public Builder writeOnlyEnforced() {
            return this.writeOnlyEnforced(true);
        }

        public Builder source(Source source) {
            this.modelOptions_.setSource(source);
            return this;
        }

        public Builder serverUri(URI uri) {
            this.modelOptions_.setServerUri(uri);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.modelOptions_.setServerSelector(serverSelector);
            return this;
        }

        public ModelOptions build() {
            return this.modelOptions_;
        }
    }

    public static enum Source {
        EXAMPLES,
        SCHEMAS;

    }
}

