/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.regexpgen.Bounds;
import org.cornutum.regexpgen.RegExpGen;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionInputDef;
import org.cornutum.tcases.FunctionInputDefBuilder;
import org.cornutum.tcases.IVarDef;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemInputDefBuilder;
import org.cornutum.tcases.VarBindingDef;
import org.cornutum.tcases.VarDef;
import org.cornutum.tcases.VarDefBuilder;
import org.cornutum.tcases.VarDefIterator;
import org.cornutum.tcases.VarSet;
import org.cornutum.tcases.VarSetBuilder;
import org.cornutum.tcases.VarValueDef;
import org.cornutum.tcases.VarValueDefBuilder;
import org.cornutum.tcases.conditions.AssertNotLess;
import org.cornutum.tcases.conditions.Conditions;
import org.cornutum.tcases.conditions.ICondition;
import org.cornutum.tcases.conditions.Not;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.ConditionReporter;
import org.cornutum.tcases.openapi.Dnf;
import org.cornutum.tcases.openapi.ExampleException;
import org.cornutum.tcases.openapi.FormattedString;
import org.cornutum.tcases.openapi.InvalidStyleException;
import org.cornutum.tcases.openapi.ModelOptions;
import org.cornutum.tcases.openapi.OpenApiContext;
import org.cornutum.tcases.openapi.OpenApiException;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.SchemaAnalyzer;
import org.cornutum.tcases.openapi.SchemaExtensions;
import org.cornutum.tcases.openapi.SchemaUtils;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.ListBuilder;

public abstract class InputModeller
extends ConditionReporter<OpenApiContext> {
    private final View view_;
    private final ModelOptions options_;
    private final SchemaAnalyzer analyzer_;
    private static final Pattern uriSegmentPattern_ = Pattern.compile("([^{}]+)|\\{([^}]+)\\}");
    private static final Pattern combinedAlternativeVarPattern_ = Pattern.compile("(?:.*\\.)?Alternative\\.\\d+\\.(.*)");

    protected InputModeller(View view) {
        this(view, null);
    }

    protected InputModeller(View view, ModelOptions options) {
        super(new OpenApiContext());
        this.view_ = OpenApiUtils.expectedValueOf(view, "Model view", new Object[0]);
        this.options_ = Optional.ofNullable(options).orElse(new ModelOptions());
        this.setNotifier(this.getOptions().getConditionNotifier());
        this.analyzer_ = new SchemaAnalyzer((OpenApiContext)this.getContext());
        this.analyzer_.setNotifier(this.getNotifier());
    }

    protected SystemInputDef requestInputModel(OpenAPI api) {
        return this.getOptions().getSource() == ModelOptions.Source.EXAMPLES ? this.requestExamplesModel(api) : this.requestSchemasModel(api);
    }

    private SystemInputDef requestSchemasModel(OpenAPI api) {
        String title;
        Info info;
        try {
            info = OpenApiUtils.expectedValueOf(api.getInfo(), "API info", new Object[0]);
            title = OpenApiUtils.expectedValueOf(StringUtils.trimToNull((String)info.getTitle()), "API title", new Object[0]);
        }
        catch (Exception e) {
            throw new OpenApiException("Invalid API definition", (Throwable)e);
        }
        return this.resultFor(title, () -> {
            SystemInputDef inputDef = ((SystemInputDefBuilder)((SystemInputDefBuilder)((SystemInputDefBuilder)SystemInputDefBuilder.with((String)DefUtils.toIdentifier((String)title)).has("title", (Object)title)).has("version", (Object)info.getVersion())).hasIf("server", this.serverUriUsed(api.getServers()))).functions(CollectionUtils.entriesOf((Map)api.getPaths()).flatMap(path -> this.pathRequestDefs(api, (String)path.getKey(), (PathItem)path.getValue()))).build();
            return inputDef.getFunctionInputDefs().hasNext() ? inputDef : null;
        });
    }

    private SystemInputDef requestExamplesModel(OpenAPI api) {
        String title;
        Info info;
        try {
            info = OpenApiUtils.expectedValueOf(api.getInfo(), "API info", new Object[0]);
            title = OpenApiUtils.expectedValueOf(StringUtils.trimToNull((String)info.getTitle()), "API title", new Object[0]);
        }
        catch (Exception e) {
            throw new OpenApiException("Invalid API definition", (Throwable)e);
        }
        return this.resultFor(title, () -> {
            SystemInputDef inputDef = ((SystemInputDefBuilder)((SystemInputDefBuilder)((SystemInputDefBuilder)SystemInputDefBuilder.with((String)DefUtils.toIdentifier((String)title)).has("title", (Object)title)).has("version", (Object)info.getVersion())).hasIf("server", this.serverUriUsed(api.getServers()))).functions(CollectionUtils.entriesOf((Map)api.getPaths()).flatMap(path -> this.pathRequestExamples(api, (String)path.getKey(), (PathItem)path.getValue()))).build();
            return inputDef.getFunctionInputDefs().hasNext() ? inputDef : null;
        });
    }

    private Stream<FunctionInputDef> pathRequestDefs(OpenAPI api, String path, PathItem pathItem) {
        return this.resultFor(path, () -> Stream.of(this.opRequestDef(api, path, pathItem, "GET", pathItem.getGet()), this.opRequestDef(api, path, pathItem, "PUT", pathItem.getPut()), this.opRequestDef(api, path, pathItem, "POST", pathItem.getPost()), this.opRequestDef(api, path, pathItem, "DELETE", pathItem.getDelete()), this.opRequestDef(api, path, pathItem, "OPTIONS", pathItem.getOptions()), this.opRequestDef(api, path, pathItem, "HEAD", pathItem.getHead()), this.opRequestDef(api, path, pathItem, "PATCH", pathItem.getPatch()), this.opRequestDef(api, path, pathItem, "TRACE", pathItem.getTrace())).filter(Objects::nonNull));
    }

    private Stream<FunctionInputDef> pathRequestExamples(OpenAPI api, String path, PathItem pathItem) {
        return this.resultFor(path, () -> Stream.of(this.opRequestExamples(api, path, pathItem, "GET", pathItem.getGet()), this.opRequestExamples(api, path, pathItem, "PUT", pathItem.getPut()), this.opRequestExamples(api, path, pathItem, "POST", pathItem.getPost()), this.opRequestExamples(api, path, pathItem, "DELETE", pathItem.getDelete()), this.opRequestExamples(api, path, pathItem, "OPTIONS", pathItem.getOptions()), this.opRequestExamples(api, path, pathItem, "HEAD", pathItem.getHead()), this.opRequestExamples(api, path, pathItem, "PATCH", pathItem.getPatch()), this.opRequestExamples(api, path, pathItem, "TRACE", pathItem.getTrace())).filter(Objects::nonNull));
    }

    private FunctionInputDef opRequestDef(OpenAPI api, String path, PathItem pathItem, String opName, Operation op) {
        return this.resultFor(opName, () -> op == null ? null : ((FunctionInputDefBuilder)((FunctionInputDefBuilder)((FunctionInputDefBuilder)((FunctionInputDefBuilder)FunctionInputDefBuilder.with((String)String.format("%s_%s", opName, InputModeller.functionPathName(path))).hasIf("server", this.serverUriUsed(pathItem.getServers()))).hasIf("server", this.serverUriUsed(op.getServers()))).has("path", (Object)path)).has("operation", (Object)opName)).vars(this.opRequestVars(api, pathItem, op)).build());
    }

    private Stream<IVarDef> opRequestVars(OpenAPI api, PathItem pathItem, Operation op) {
        return this.hasInputs(api, pathItem, op) ? Stream.concat(this.opParameters(pathItem, op).map(p -> this.parameterVarDef(api, OpenApiUtils.resolveParameter(api, p))), Stream.concat(this.requestBodyVarDef(api, op.getRequestBody()).map(Stream::of).orElse(Stream.empty()), this.authVarDef(api, op.getSecurity()).map(Stream::of).orElse(Stream.empty()))) : Stream.of(this.noInputs());
    }

    private FunctionInputDef opRequestExamples(OpenAPI api, String path, PathItem pathItem, String opName, Operation op) {
        return this.resultFor(opName, () -> op == null ? null : this.withoutFailures(((FunctionInputDefBuilder)((FunctionInputDefBuilder)((FunctionInputDefBuilder)((FunctionInputDefBuilder)FunctionInputDefBuilder.with((String)String.format("%s_%s", opName, InputModeller.functionPathName(path))).hasIf("server", this.serverUriUsed(pathItem.getServers()))).hasIf("server", this.serverUriUsed(op.getServers()))).has("path", (Object)path)).has("operation", (Object)opName)).vars(this.opExampleVars(api, pathItem, op)).build()));
    }

    private Stream<IVarDef> opExampleVars(OpenAPI api, PathItem pathItem, Operation op) {
        return this.hasInputs(api, pathItem, op) ? Stream.concat(this.opParameters(pathItem, op).map(p -> this.parameterExamples(api, OpenApiUtils.resolveParameter(api, p))), Stream.concat(this.requestBodyExamples(api, op.getRequestBody()).map(Stream::of).orElse(Stream.empty()), this.authVarDef(api, op.getSecurity()).map(Stream::of).orElse(Stream.empty()))) : Stream.of(this.noInputs());
    }

    private boolean hasInputs(OpenAPI api, PathItem pathItem, Operation op) {
        return this.opParameters(pathItem, op).findAny().isPresent() || op.getRequestBody() != null || Optional.ofNullable(op.getSecurity()).map(secReqs -> !secReqs.isEmpty()).orElse(Optional.ofNullable(api.getSecurity()).filter(secReqs -> !secReqs.isEmpty()).isPresent()) != false;
    }

    private IVarDef noInputs() {
        String none = "None";
        return VarSetBuilder.with((String)none).type("implicit").members(new IVarDef[]{this.instanceDefinedVar(none, Definition.NEVER, new String[0])}).build();
    }

    private Stream<Parameter> opParameters(PathItem pathItem, Operation op) {
        return Stream.concat(CollectionUtils.membersOf((Collection)pathItem.getParameters()), CollectionUtils.membersOf((Collection)op.getParameters())).collect(Collectors.toMap(Parameter::getName, Function.identity(), (pathParam, opParam) -> opParam, () -> new LinkedHashMap())).values().stream();
    }

    protected SystemInputDef responseInputModel(OpenAPI api) {
        String title;
        Info info;
        try {
            info = OpenApiUtils.expectedValueOf(api.getInfo(), "API info", new Object[0]);
            title = OpenApiUtils.expectedValueOf(StringUtils.trimToNull((String)info.getTitle()), "API title", new Object[0]);
        }
        catch (Exception e) {
            throw new OpenApiException("Invalid API definition", (Throwable)e);
        }
        return this.resultFor(title, () -> {
            SystemInputDef inputDef = ((SystemInputDefBuilder)((SystemInputDefBuilder)((SystemInputDefBuilder)SystemInputDefBuilder.with((String)DefUtils.toIdentifier((String)title)).has("title", (Object)title)).has("version", (Object)info.getVersion())).hasIf("server", this.serverUriUsed(api.getServers()))).functions(CollectionUtils.entriesOf((Map)api.getPaths()).flatMap(path -> this.pathResponseDefs(api, (String)path.getKey(), (PathItem)path.getValue()))).build();
            return inputDef.getFunctionInputDefs().hasNext() ? inputDef : null;
        });
    }

    private Stream<FunctionInputDef> pathResponseDefs(OpenAPI api, String path, PathItem pathItem) {
        return this.resultFor(path, () -> Stream.of(this.opResponseDef(api, path, pathItem, "GET", pathItem.getGet()), this.opResponseDef(api, path, pathItem, "PUT", pathItem.getPut()), this.opResponseDef(api, path, pathItem, "POST", pathItem.getPost()), this.opResponseDef(api, path, pathItem, "DELETE", pathItem.getDelete()), this.opResponseDef(api, path, pathItem, "OPTIONS", pathItem.getOptions()), this.opResponseDef(api, path, pathItem, "HEAD", pathItem.getHead()), this.opResponseDef(api, path, pathItem, "PATCH", pathItem.getPatch()), this.opResponseDef(api, path, pathItem, "TRACE", pathItem.getTrace())).filter(Objects::nonNull));
    }

    private FunctionInputDef withoutFailures(FunctionInputDef functionDef) {
        CollectionUtils.toStream((Iterator)new VarDefIterator(functionDef)).forEach(varDef -> CollectionUtils.toStream((Iterator)varDef.getFailureValues()).map(VarValueDef::getName).collect(Collectors.toList()).stream().forEach(value -> varDef.removeValue(value)));
        return functionDef;
    }

    private FunctionInputDef opResponseDef(OpenAPI api, String path, PathItem pathItem, String opName, Operation op) {
        return this.resultFor(opName, () -> op == null ? null : ((FunctionInputDefBuilder)((FunctionInputDefBuilder)FunctionInputDefBuilder.with((String)String.format("%s_%s", opName, InputModeller.functionPathName(path))).hasIf("server", this.serverUriUsed(pathItem.getServers()))).hasIf("server", this.serverUriUsed(op.getServers()))).vars(this.responsesVars(api, OpenApiUtils.expectedValueOf(op.getResponses(), "responses", new Object[0]))).build());
    }

    private Optional<IVarDef> requestBodyVarDef(OpenAPI api, RequestBody body) {
        return this.resultFor("requestBody", () -> Optional.ofNullable(body).map(b -> OpenApiUtils.resolveRequestBody(api, b)).map(b -> {
            String contentVarTag = "Content";
            Map mediaTypes = (Map)OpenApiUtils.expectedValueOf(b.getContent(), "Request body content", new Object[0]);
            return VarSetBuilder.with((String)"Body").type("request").members(new IVarDef[]{this.instanceDefinedVar(contentVarTag, Boolean.TRUE.equals(b.getRequired()), new String[0]), this.mediaTypeVar(contentVarTag, mediaTypes)}).members(this.mediaTypeContentVars(api, contentVarTag, mediaTypes)).build();
        }));
    }

    private Optional<IVarDef> requestBodyExamples(OpenAPI api, RequestBody body) {
        return this.resultFor("requestBody", () -> Optional.ofNullable(body).map(b -> OpenApiUtils.resolveRequestBody(api, b)).map(b -> {
            String contentVarTag = "Content";
            Map mediaTypes = (Map)OpenApiUtils.expectedValueOf(b.getContent(), "Request body content", new Object[0]);
            return VarSetBuilder.with((String)"Body").type("request").members(new IVarDef[]{this.instanceDefinedVar(contentVarTag, Boolean.TRUE.equals(b.getRequired()), new String[0]), this.mediaTypeVar(contentVarTag, mediaTypes)}).members(this.mediaTypeContentExamples(api, contentVarTag, mediaTypes)).build();
        }));
    }

    private IVarDef mediaTypeVar(String contentVarTag, Map<String, MediaType> mediaTypes) {
        return VarDefBuilder.with((String)"Media-Type").when(this.instanceDefinedCondition(contentVarTag)).values(mediaTypes.entrySet().stream().map(contentDef -> {
            String mediaType = (String)contentDef.getKey();
            String mediaTypeVarName = this.mediaTypeVarName(mediaType);
            String mediaTypeVarTag = this.mediaTypeVarTag(contentVarTag, mediaType);
            return ((VarValueDefBuilder)VarValueDefBuilder.with((Object)mediaTypeVarName).has("mediaType", (Object)mediaType)).properties(new String[]{mediaTypeVarTag}).build();
        })).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Other").type(VarValueDef.Type.FAILURE).has("excluded", mediaTypes.keySet().stream())).build()}).build();
    }

    private Stream<IVarDef> mediaTypeContentVars(OpenAPI api, String contentVarTag, Map<String, MediaType> mediaTypes) {
        return mediaTypes.entrySet().stream().map(contentDef -> {
            String mediaType = (String)contentDef.getKey();
            return (IVarDef)this.resultFor(mediaType, () -> {
                String mediaTypeVarName = this.mediaTypeVarName(mediaType);
                String mediaTypeVarTag = this.mediaTypeVarTag(contentVarTag, mediaType);
                VarSetBuilder contentVar = VarSetBuilder.with((String)mediaTypeVarName).when((ICondition)Conditions.has((String[])new String[]{mediaTypeVarTag}));
                Schema mediaTypeSchema = ((MediaType)contentDef.getValue()).getSchema();
                if (mediaTypeSchema == null) {
                    this.notifyWarning(String.format("No schema defined for media type=%s", mediaType));
                    contentVar.members(new IVarDef[]{this.instanceDefinedVar(mediaTypeVarTag, false, new String[0])});
                } else {
                    contentVar.members(this.instanceSchemaVars(mediaTypeVarTag, false, this.analyzeSchema(api, mediaTypeSchema)));
                }
                return contentVar.build();
            });
        });
    }

    private Stream<IVarDef> mediaTypeContentExamples(OpenAPI api, String contentVarTag, Map<String, MediaType> mediaTypes) {
        return mediaTypes.entrySet().stream().map(contentDef -> {
            String mediaTypeName = (String)contentDef.getKey();
            return (IVarDef)this.resultFor(mediaTypeName, () -> {
                String mediaTypeVarName = this.mediaTypeVarName(mediaTypeName);
                String mediaTypeVarTag = this.mediaTypeVarTag(contentVarTag, mediaTypeName);
                MediaType mediaType = (MediaType)contentDef.getValue();
                Schema mediaTypeSchema = Optional.ofNullable(mediaType.getSchema()).map(s -> this.exampleSchemaFor(mediaType.getExample(), mediaType.getExamples(), this.analyzeSchema(api, (Schema<?>)s))).orElse(null);
                return VarSetBuilder.with((String)mediaTypeVarName).when((ICondition)Conditions.has((String[])new String[]{mediaTypeVarTag})).members(this.instanceSchemaVars(mediaTypeVarTag, false, mediaTypeSchema)).build();
            });
        });
    }

    private Optional<IVarDef> authVarDef(OpenAPI api, List<SecurityRequirement> opSecurity) {
        return this.resultFor("security", () -> {
            List<SecurityRequirement> security = this.secReqsSupported(api, Optional.ofNullable(opSecurity).orElse(Optional.ofNullable(api.getSecurity()).orElse(Collections.emptyList())));
            return security.isEmpty() ? Optional.empty() : Optional.of(VarSetBuilder.with((String)"Auth").type("security").members(security.size() == 1 ? this.authReqVars(api, security.get(0)) : this.authReqVars(api, security)).build());
        });
    }

    private Stream<IVarDef> authReqVars(OpenAPI api, SecurityRequirement secReq) {
        return this.authReqVars(api, null, secReq);
    }

    private Stream<IVarDef> authReqVars(OpenAPI api, String secReqTag, SecurityRequirement secReq) {
        boolean schemesMany = secReq.size() > 1;
        boolean seqReqMany = secReqTag != null;
        boolean hasDefined = schemesMany || !seqReqMany;
        return secReq.keySet().stream().map(name -> (IVarDef)this.resultFor((String)name, () -> {
            Optional defined = hasDefined ? Optional.of(VarDefBuilder.with((String)"Defined").values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").properties(new String[]{this.secSchemeProperty(secReqTag, (String)name)}).build(), ((VarValueDefBuilder)VarValueDefBuilder.with((Object)"No").type(VarValueDef.Type.FAILURE).has("authFailure", (Object)true)).build()}).build()) : Optional.empty();
            Optional<ICondition> isDefined = hasDefined ? Optional.of(Conditions.has((String[])new String[]{this.secSchemeProperty(secReqTag, (String)name)})) : Optional.empty();
            return VarSetBuilder.with((String)name).when(Optional.ofNullable(secReqTag).map(srt -> Conditions.has((String[])new String[]{this.secReqProperty(secReqTag)}))).members(CollectionUtils.streamOf(defined)).members(this.authSchemeVars(isDefined, OpenApiUtils.getSecurityScheme(api, name))).build();
        }));
    }

    private Stream<IVarDef> authSchemeVars(Optional<ICondition> isDefined, SecurityScheme secScheme) {
        Stream.Builder<VarDef> vars = Stream.builder();
        switch (secScheme.getType()) {
            case APIKEY: {
                vars.add(VarDefBuilder.with((String)"Type").when(isDefined).values(new VarValueDef[]{VarValueDefBuilder.with((Object)secScheme.getType()).build()}).build());
                vars.add(VarDefBuilder.with((String)"Location").when(isDefined).values(new VarValueDef[]{VarValueDefBuilder.with((Object)secScheme.getIn()).build()}).build());
                vars.add(VarDefBuilder.with((String)"Name").when(isDefined).values(new VarValueDef[]{VarValueDefBuilder.with((Object)secScheme.getName()).build()}).build());
                break;
            }
            case HTTP: {
                vars.add(VarDefBuilder.with((String)"Type").when(isDefined).values(new VarValueDef[]{VarValueDefBuilder.with((Object)secScheme.getType()).build()}).build());
                vars.add(VarDefBuilder.with((String)"Scheme").when(isDefined).values(new VarValueDef[]{VarValueDefBuilder.with((Object)secScheme.getScheme().toLowerCase()).build()}).build());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Security type=%s is not supported in this version", secScheme.getType()));
            }
        }
        return vars.build();
    }

    private Stream<IVarDef> authReqVars(OpenAPI api, List<SecurityRequirement> security) {
        VarDef satisfied = VarDefBuilder.with((String)"Satisfied").values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").when((ICondition)Conditions.equalTo((String)this.secReqProperty(), (int)1)).build(), ((VarValueDefBuilder)VarValueDefBuilder.with((Object)"No").type(VarValueDef.Type.FAILURE).has("authFailure", (Object)true)).when((ICondition)Conditions.equalTo((String)this.secReqProperty(), (int)0)).build()}).build();
        return Stream.concat(Stream.of(satisfied), IntStream.range(0, security.size()).mapToObj(i -> {
            String secReqTag = String.valueOf(i);
            return this.resultFor(secReqTag, () -> {
                VarDef defined = VarDefBuilder.with((String)"Defined").values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").properties(new String[]{this.secReqProperty(), this.secReqProperty(secReqTag)}).build(), VarValueDefBuilder.with((Object)"No").build()}).build();
                return VarSetBuilder.with((String)secReqTag).members(Stream.concat(Stream.of(defined), this.authReqVars(api, secReqTag, (SecurityRequirement)security.get(i)))).build();
            });
        }));
    }

    private List<SecurityRequirement> secReqsSupported(OpenAPI api, List<SecurityRequirement> secReqs) {
        return secReqs.stream().map(secRec -> {
            List schemesSupported = secRec.keySet().stream().filter(name -> this.resultFor((String)name, () -> {
                boolean supported;
                SecurityScheme scheme = OpenApiUtils.getSecurityScheme(api, name);
                switch (scheme.getType()) {
                    case APIKEY: {
                        supported = true;
                        break;
                    }
                    case HTTP: {
                        boolean bl = supported = "basic".equalsIgnoreCase(scheme.getScheme()) || "bearer".equalsIgnoreCase(scheme.getScheme());
                        if (supported) break;
                        this.notifyError(String.format("HTTP authentication scheme=%s is not supported in this version", scheme.getScheme()), "Generated tests will not provide this type of authentication");
                        break;
                    }
                    default: {
                        supported = false;
                        this.notifyError(String.format("Security type=%s is not supported in this version", scheme.getType()), "Generated tests will not provide this type of authentication");
                    }
                }
                return supported;
            })).collect(Collectors.toList());
            SecurityRequirement supported = new SecurityRequirement();
            for (String scheme : schemesSupported) {
                supported.addList(scheme, (List)secRec.get((Object)scheme));
            }
            return supported;
        }).filter(secReq -> !secReq.isEmpty()).collect(Collectors.toList());
    }

    private IVarDef parameterVarDef(OpenAPI api, Parameter parameter) {
        String parameterName = parameter.getName();
        return (IVarDef)this.resultFor(parameterName, () -> {
            String parameterIn = OpenApiUtils.expectedValueOf(parameter.getIn(), "in", parameterName);
            if (parameterIn.equals("cookie") && !Characters.TOKEN.allowed(parameterName)) {
                throw new IllegalStateException(String.format("Parameter name='%s' contains characters not allowed in a cookie name", parameterName));
            }
            Schema<?> parameterSchema = this.parameterSchema(api, parameter);
            String parameterType = parameterSchema.getType();
            parameter.setStyle(this.parameterStyle(parameter, parameterType));
            parameter.setExplode(this.parameterExplode(parameter.getExplode(), SchemaExtensions.getValidTypes(parameterSchema), parameter.getStyle()));
            this.normalizeParameterDnf(parameter, parameterSchema);
            String parameterVarName = DefUtils.toIdentifier((String)parameterName);
            return ((VarSetBuilder)VarSetBuilder.with((String)parameterVarName).type(parameter.getIn()).has("paramName", (Object)parameterName)).members(new IVarDef[]{this.parameterDefinedVar(parameterVarName, parameter)}).members(this.instanceSchemaVars(parameterVarName, parameterSchema)).build();
        });
    }

    private IVarDef parameterExamples(OpenAPI api, Parameter parameter) {
        String parameterName = parameter.getName();
        return (IVarDef)this.resultFor(parameterName, () -> {
            String parameterIn = OpenApiUtils.expectedValueOf(parameter.getIn(), "in", parameterName);
            if (parameterIn.equals("cookie") && !Characters.TOKEN.allowed(parameterName)) {
                throw new IllegalStateException(String.format("Parameter name='%s' contains characters not allowed in a cookie name", parameterName));
            }
            Schema<?> parameterSchema = this.analyzeSchema(api, this.exampleSchemaFor(this.parameterContentExample(parameter), this.parameterContentExamples(parameter), this.parameterSchema(api, parameter)));
            String parameterType = parameterSchema.getType();
            parameter.setStyle(this.parameterStyle(parameter, parameterType));
            parameter.setExplode(this.parameterExplode(parameter.getExplode(), SchemaExtensions.getValidTypes(parameterSchema), parameter.getStyle()));
            this.normalizeParameterDnf(parameter, parameterSchema);
            String parameterVarName = DefUtils.toIdentifier((String)parameterName);
            return ((VarSetBuilder)VarSetBuilder.with((String)parameterVarName).type(parameterIn).has("paramName", (Object)parameterName)).members(new IVarDef[]{this.parameterDefinedVar(parameterVarName, parameter)}).members(this.instanceSchemaVars(parameterVarName, parameter.getRequired() == false, parameterSchema)).build();
        });
    }

    private Schema<?> parameterSchema(OpenAPI api, Parameter parameter) {
        Schema schema = Optional.ofNullable(parameter.getSchema()).orElseGet(() -> this.parameterMediaType(parameter).map(MediaType::getSchema).orElse(null));
        return this.analyzeSchema(api, schema);
    }

    private void normalizeParameterDnf(Parameter parameter, Schema<?> parameterSchema) {
        List<Schema> alternatives = Optional.ofNullable(SchemaExtensions.getDnf(parameterSchema)).map(Dnf::getAlternatives).orElse(Arrays.asList(parameterSchema));
        for (Schema schema : alternatives) {
            this.normalizeParameterSchema(parameter, schema);
        }
    }

    private void normalizeParameterSchema(Parameter parameter, Schema<?> parameterSchema) {
        if ("path".equals(parameter.getIn()) && Optional.ofNullable(parameterSchema.getNullable()).orElse(false).booleanValue()) {
            this.notifyError("Null values not allowed", "Using nullable=false");
            parameterSchema.setNullable(Boolean.valueOf(false));
        }
        if ("string".equals(parameterSchema.getType()) && Parameter.StyleEnum.SIMPLE.equals((Object)parameter.getStyle())) {
            if (Optional.ofNullable(this.minStringFormat(parameterSchema.getFormat(), parameterSchema.getMinLength(), false)).orElse(0) <= 0 && !Optional.ofNullable(parameterSchema.getNullable()).orElse(false).booleanValue()) {
                if (parameterSchema.getEnum() != null) {
                    parameterSchema.setEnum(parameterSchema.getEnum().stream().map(enumValue -> String.valueOf(enumValue).isEmpty() ? null : enumValue).collect(Collectors.toList()));
                } else {
                    this.notifyWarning("Empty string values not allowed for non-nullable parameter -- using minLength=1");
                    parameterSchema.setMinLength(Integer.valueOf(1));
                }
            } else if (Optional.ofNullable(this.minStringFormat(parameterSchema.getFormat(), parameterSchema.getMinLength(), false)).orElse(0) == 1 && Optional.ofNullable(parameterSchema.getNullable()).orElse(false).booleanValue()) {
                this.notifyWarning("Empty string values allowed for nullable parameter -- using minLength=0");
                parameterSchema.setMinLength(Integer.valueOf(0));
            }
        }
        if ("array".equals(parameterSchema.getType()) && Parameter.StyleEnum.SIMPLE.equals((Object)parameter.getStyle())) {
            if (Optional.ofNullable(parameterSchema.getMinItems()).orElse(0) <= 0 && !Optional.ofNullable(parameterSchema.getNullable()).orElse(false).booleanValue()) {
                this.notifyWarning("Empty array values not allowed for non-nullable parameter -- using minItems=1");
                parameterSchema.setMinItems(Integer.valueOf(1));
            } else if (Optional.ofNullable(parameterSchema.getMinItems()).orElse(0) == 1 && Optional.ofNullable(parameterSchema.getNullable()).orElse(false).booleanValue()) {
                this.notifyWarning("Empty array values allowed for nullable parameter -- using minItems=0");
                parameterSchema.setMinItems(Integer.valueOf(0));
            }
        }
    }

    private Optional<MediaType> parameterMediaType(Parameter parameter) {
        return Optional.ofNullable(parameter.getContent()).flatMap(content -> content.values().stream().findFirst());
    }

    private Object parameterContentExample(Parameter parameter) {
        return Optional.ofNullable(parameter.getExample()).orElseGet(() -> parameter.getExamples() == null ? this.parameterMediaType(parameter).map(MediaType::getExample).orElse(null) : null);
    }

    private Map<String, Example> parameterContentExamples(Parameter parameter) {
        return Optional.ofNullable(parameter.getExamples()).orElseGet(() -> parameter.getExample() == null ? (Map)this.parameterMediaType(parameter).map(MediaType::getExamples).orElse(null) : null);
    }

    private Parameter.StyleEnum parameterStyle(Parameter parameter, String parameterType) {
        String in = parameter.getIn();
        return parameter.getStyle() != null ? this.getApplicableStyle(parameter, parameterType) : (in.equals("path") ? Parameter.StyleEnum.SIMPLE : (in.equals("header") ? Parameter.StyleEnum.SIMPLE : Parameter.StyleEnum.FORM));
    }

    private Parameter.StyleEnum getApplicableStyle(Parameter parameter, String parameterType) {
        try {
            return OpenApiUtils.ifApplicableStyle(parameter.getStyle(), parameter.getIn(), parameterType);
        }
        catch (InvalidStyleException e) {
            this.notifyError(e.getMessage(), String.format("Using style=%s instead", e.getValidStyle()));
            return Parameter.StyleEnum.valueOf((String)e.getValidStyle().toUpperCase());
        }
    }

    private Boolean parameterExplode(Boolean explode, Set<String> parameterTypes, Parameter.StyleEnum parameterStyle) {
        return parameterTypes != null && !parameterTypes.contains("object") && !parameterTypes.contains("array") ? null : Boolean.valueOf(explode != null ? explode : parameterStyle == Parameter.StyleEnum.FORM);
    }

    private IVarDef parameterDefinedVar(String parameterVarTag, Parameter parameter) {
        return ((VarDefBuilder)((VarDefBuilder)VarDefBuilder.with((VarDef)this.instanceDefinedVar(parameterVarTag, Boolean.TRUE.equals(parameter.getRequired()), new String[0])).has("style", (Object)parameter.getStyle())).has("explode", (Object)parameter.getExplode())).build();
    }

    private Stream<IVarDef> responsesVars(OpenAPI api, ApiResponses responses) {
        return this.resultFor("responses", () -> Stream.concat(Stream.of(VarDefBuilder.with((String)"Status-Code").type("response").values(this.responseStatusValues(responses)).build()), this.responseVars(api, responses)));
    }

    private Stream<VarValueDef> responseStatusValues(ApiResponses responses) {
        List statusCodes = responses.keySet().stream().filter(status -> !status.equals("default")).collect(Collectors.toList());
        return Stream.concat(statusCodes.stream().map(status -> VarValueDefBuilder.with((Object)status).properties(new String[]{this.statusCodeProperty((String)status)}).build()), Stream.of(((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Other").has("excluded", statusCodes.stream())).properties(new String[]{this.statusCodeProperty("Other")}).build()));
    }

    private Stream<IVarDef> responseVars(OpenAPI api, ApiResponses responses) {
        return responses.keySet().stream().map(status -> (IVarDef)this.resultFor((String)status, () -> {
            ApiResponse response = OpenApiUtils.resolveResponse(api, (ApiResponse)responses.get(status));
            String statusValueName = status.equals("default") ? "Other" : status;
            return VarSetBuilder.with((String)statusValueName).when((ICondition)Conditions.has((String[])new String[]{this.statusCodeProperty(statusValueName)})).type("response").members((Iterable)CollectionUtils.iterableOf(this.responseHeadersVar(api, (String)status, response))).members(new IVarDef[]{this.responseContentVar(api, (String)status, response)}).build();
        }));
    }

    private Optional<IVarDef> responseHeadersVar(OpenAPI api, String status, ApiResponse response) {
        return this.resultFor("headers", () -> {
            List headerNames = Optional.ofNullable(response.getHeaders()).map(headers -> headers.keySet().stream().filter(name -> !name.equals("Content-Type")).collect(Collectors.toList())).orElse(Collections.emptyList());
            return Optional.ofNullable(headerNames.isEmpty() ? null : headerNames).map(names -> VarSetBuilder.with((String)"Headers").members(names.stream().map(name -> this.responseHeaderVar(api, status, (String)name, OpenApiUtils.resolveHeader(api, (Header)response.getHeaders().get(name))))).build());
        });
    }

    private IVarDef responseHeaderVar(OpenAPI api, String status, String headerName, Header header) {
        return (IVarDef)this.resultFor(headerName, () -> {
            String headerVarName = DefUtils.toIdentifier((String)headerName);
            String headerVarTag = status + "Header" + StringUtils.capitalize((String)headerVarName);
            Schema<?> headerSchema = this.analyzeSchema(api, header.getSchema());
            return VarSetBuilder.with((String)headerVarName).members(new IVarDef[]{this.headerDefinedVar(headerVarTag, header)}).members(this.instanceSchemaVars(headerVarTag, headerSchema)).build();
        });
    }

    private IVarDef headerDefinedVar(String headerVarTag, Header header) {
        return ((VarDefBuilder)((VarDefBuilder)VarDefBuilder.with((VarDef)this.instanceDefinedVar(headerVarTag, Boolean.TRUE.equals(header.getRequired()), new String[0])).has("style", (Object)header.getStyle())).has("explode", (Object)header.getExplode())).build();
    }

    private IVarDef responseContentVar(OpenAPI api, String status, ApiResponse response) {
        String contentVarName = "Content";
        String contentVarTag = status + contentVarName;
        return (IVarDef)this.resultFor("content", () -> Optional.ofNullable(response.getContent()).map(mediaTypes -> VarSetBuilder.with((String)contentVarName).members(new IVarDef[]{this.instanceDefinedVar(contentVarTag, true, new String[0]), this.mediaTypeVar(contentVarTag, (Map<String, MediaType>)mediaTypes)}).members(this.mediaTypeContentVars(api, contentVarTag, (Map<String, MediaType>)mediaTypes)).build()).orElse(VarSetBuilder.with((String)contentVarName).members(new IVarDef[]{this.instanceDefinedNever(contentVarTag)}).build()));
    }

    private Optional<String> serverUriUsed(List<Server> servers) {
        Optional<String> specified = Optional.ofNullable(this.getOptions().getServerUri()).map(String::valueOf);
        return specified.isPresent() ? specified : this.getOptions().getServerSelector().select(CollectionUtils.membersOf(servers).map(Server::getDescription).collect(Collectors.toList())).map(i -> InputModeller.getServerUrl((Server)servers.get((int)i)));
    }

    private VarDef instanceDefinedVar(String instanceVarTag, boolean required, String ... propertiesWhenDefined) {
        return this.instanceDefinedVar(instanceVarTag, required ? Definition.REQUIRED : Definition.OPTIONAL, propertiesWhenDefined);
    }

    private VarDef instanceDefinedNever(String instanceVarTag) {
        return this.instanceDefinedVar(instanceVarTag, Definition.NEVER, new String[0]);
    }

    private VarDef instanceDefinedVar(String instanceVarTag, Definition definition, String ... propertiesWhenDefined) {
        VarDefBuilder varDef = VarDefBuilder.with((String)"Defined");
        if (definition != Definition.NEVER) {
            VarValueDefBuilder yes = VarValueDefBuilder.with((Object)"Yes");
            if (definition == Definition.EXCLUDED) {
                yes.type(VarValueDef.Type.FAILURE);
            } else {
                yes.properties(new String[]{this.instanceDefinedProperty(instanceVarTag)}).properties(propertiesWhenDefined);
            }
            varDef.values(new VarValueDef[]{yes.build()});
        }
        if (definition != Definition.ALWAYS) {
            VarValueDefBuilder no = VarValueDefBuilder.with((Object)"No");
            if (definition == Definition.REQUIRED) {
                no.type(VarValueDef.Type.FAILURE);
            }
            varDef.values(new VarValueDef[]{no.build()});
        }
        return varDef.build();
    }

    private Stream<IVarDef> instanceSchemaVars(String instanceVarTag, Schema<?> instanceSchema) {
        return this.instanceSchemaVars(instanceVarTag, true, instanceSchema);
    }

    private Stream<IVarDef> instanceSchemaVars(String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema) {
        return this.instanceSchemaVars(instanceVarTag, instanceOptional, instanceSchema, false);
    }

    private Stream<IVarDef> instanceSchemaVars(String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema, boolean instanceItem) {
        String instanceType = Optional.ofNullable(instanceSchema).map(Schema::getType).orElse(null);
        return instanceSchema == null ? Stream.of(this.instanceTypeVar(instanceVarTag, instanceOptional, instanceSchema, instanceItem)) : (!SchemaUtils.isSchemaType(instanceType) ? this.unknownSchemaVars(instanceType) : this.allSchemaVars(instanceType, instanceVarTag, instanceOptional, instanceSchema, instanceItem));
    }

    private Stream<IVarDef> allSchemaVars(String instanceType, String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema, boolean instanceItem) {
        List<Schema<?>> alternatives = Optional.ofNullable(instanceSchema).flatMap(s -> Optional.ofNullable(SchemaExtensions.getDnf(s))).map(dnf -> this.simplified((Dnf)dnf).getAlternatives()).orElse(Collections.emptyList());
        return alternatives.isEmpty() ? this.typeSchemaVars(instanceType, instanceVarTag, instanceOptional, instanceSchema, instanceItem) : (alternatives.size() == 1 ? this.typeSchemaVars(instanceVarTag, instanceOptional, (Schema)alternatives.get(0), instanceItem) : this.alternativeSchemaVars(instanceVarTag, instanceOptional, alternatives, instanceItem));
    }

    private Stream<IVarDef> alternativeSchemaVars(String instanceVarTag, boolean instanceOptional, List<Schema<?>> alternatives, boolean instanceItem) {
        return Stream.of(this.combinedAlternativesVar(VarSetBuilder.with((String)"Alternative").members(new IVarDef[]{VarDefBuilder.with((String)"Used").values(IntStream.range(0, alternatives.size()).mapToObj(i -> VarValueDefBuilder.with((Object)String.valueOf(i)).properties(new String[]{this.alternativeProperty(instanceVarTag, i)}).build())).build()}).members(IntStream.range(0, alternatives.size()).mapToObj(i -> VarSetBuilder.with((String)String.valueOf(i)).when((ICondition)Conditions.has((String[])new String[]{this.alternativeProperty(instanceVarTag, i)})).members(this.typeSchemaVars(instanceVarTag, instanceOptional, (Schema)alternatives.get(i), instanceItem)).build())).build()));
    }

    private IVarDef combinedAlternativesVar(VarSet alternativesVar) {
        Map<String, List<VarBindingDef>> allFailures = CollectionUtils.toStream((Iterator)new VarDefIterator(alternativesVar.getMembers())).filter(var -> !"Used".equals(var.getName())).flatMap(var -> CollectionUtils.toStream((Iterator)var.getValues()).filter(value -> !value.isValid()).map(value -> new VarBindingDef(var, value))).collect(Collectors.groupingBy(binding -> this.alternativeVarName(binding.getVarDef())));
        allFailures.keySet().stream().filter(alternativeVar -> !alternativeVar.contains(".Alternative.")).forEach(alternativeVar -> ((List)allFailures.get(alternativeVar)).stream().collect(Collectors.groupingBy(VarBindingDef::getValueDef)).forEach((value, bindings) -> Optional.of(bindings).filter(b -> b.size() > 1).map(b -> b.subList(1, b.size()).stream()).ifPresent(dups -> dups.forEach(dup -> dup.getVarDef().removeValue(dup.getValueDef().getName())))));
        return alternativesVar;
    }

    private String alternativeVarName(VarDef var) {
        return Optional.of(combinedAlternativeVarPattern_.matcher(var.getPathName())).filter(Matcher::matches).map(matcher -> matcher.group(1)).orElseThrow(() -> new IllegalStateException(String.format("%s is not an alternative variable", var)));
    }

    private Stream<IVarDef> typeSchemaVars(String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema, boolean instanceItem) {
        return this.typeSchemaVars(instanceSchema.getType(), instanceVarTag, instanceOptional, instanceSchema, instanceItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<IVarDef> typeSchemaVars(String instanceType, String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema, boolean instanceItem) {
        if (SchemaExtensions.isModellingInput(instanceSchema)) {
            throw new IllegalStateException("Can't create an input model for a schema that references itself");
        }
        try {
            SchemaExtensions.setModellingInput(instanceSchema, true);
            Stream.Builder<IVarDef> typeVars = Stream.builder();
            typeVars.add(this.instanceTypeVar(instanceVarTag, instanceOptional, instanceSchema, instanceItem));
            if (instanceType != null) {
                typeVars.add(this.typeValueVar(instanceType, instanceVarTag, instanceSchema, instanceItem));
            }
            Stream<IVarDef> stream = typeVars.build();
            return stream;
        }
        finally {
            SchemaExtensions.setModellingInput(instanceSchema, false);
        }
    }

    private IVarDef typeValueVar(String instanceType, String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        return "object".equals(instanceType) ? this.objectValueVar(instanceVarTag, instanceSchema, instanceItem) : ("string".equals(instanceType) ? this.stringValueVar(instanceVarTag, instanceSchema, instanceItem) : ("integer".equals(instanceType) ? this.numberValueVar(instanceVarTag, instanceSchema, instanceItem) : ("boolean".equals(instanceType) ? this.booleanValueVar(instanceVarTag, instanceSchema, instanceItem) : ("array".equals(instanceType) ? this.arrayValueVar(instanceVarTag, instanceSchema, instanceItem) : this.numberValueVar(instanceVarTag, instanceSchema, instanceItem)))));
    }

    private Stream<IVarDef> unknownSchemaVars(String type) {
        this.notifyError(String.format("Unknown schema type=%s is not supported", type), "Ignoring unknown schema");
        return Stream.empty();
    }

    private IVarDef arrayValueVar(String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        VarDef valueVar;
        Set enums = this.nullableEnums(CollectionUtils.asOrderedSet((Iterable)instanceSchema.getEnum()), instanceSchema.getNullable());
        if (!enums.isEmpty()) {
            valueVar = ((VarDefBuilder)VarDefBuilder.with((String)"Value").hasIf("itemEnums", (Iterable)Optional.of(enums).filter(e -> instanceItem).orElse(null))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).values(enums.stream().map(i -> VarValueDefBuilder.with((Object)i).build())).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Other").type(VarValueDef.Type.FAILURE).has("excluded", enums)).build()}).build();
        } else {
            Schema itemSchema = Optional.ofNullable(SchemaUtils.asArraySchema(instanceSchema)).map(array -> array.getItems()).orElse(null);
            Optional<IVarDef> itemsVar = this.arrayItemsVar(instanceVarTag, instanceSchema, itemSchema);
            Optional<Boolean> maxUniqueItems = Optional.ofNullable(itemSchema).flatMap(s -> itemsVar).flatMap(items -> Optional.ofNullable(this.getMaxAlternativeValues(itemSchema)));
            boolean uniqueRequired = Boolean.TRUE.equals(instanceSchema.getUniqueItems());
            boolean failBelowMinItems = true;
            boolean failAboveMaxItems = true;
            if (uniqueRequired) {
                if (maxUniqueItems.map(maxUnique -> Optional.ofNullable(instanceSchema.getMinItems()).map(minItems -> minItems > maxUnique).orElse(true)).orElse(false).booleanValue()) {
                    this.notifyError(String.format("minItems=%s can exceed the number of unique item values possible", instanceSchema.getMinItems()), String.format("Adjusting to unique minItems=%s", maxUniqueItems.get()));
                    instanceSchema.setMinItems((Integer)maxUniqueItems.get());
                    failBelowMinItems = false;
                }
                if (maxUniqueItems.map(maxUnique -> Optional.ofNullable(instanceSchema.getMaxItems()).map(maxItems -> maxItems > maxUnique).orElse(true)).orElse(false).booleanValue()) {
                    this.notifyError(String.format("maxItems=%s can exceed the number of unique item values possible", instanceSchema.getMaxItems()), String.format("Adjusting to unique maxItems=%s", maxUniqueItems.get()));
                    instanceSchema.setMaxItems((Integer)maxUniqueItems.get());
                    failAboveMaxItems = false;
                }
            }
            valueVar = VarSetBuilder.with((String)"Items").when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).members(new IVarDef[]{this.arraySizeVar(instanceVarTag, instanceSchema, instanceItem, failBelowMinItems, failAboveMaxItems)}).members((Iterable)CollectionUtils.iterableOf(itemsVar)).members((Iterable)CollectionUtils.iterableOf(this.arrayUniqueItemsVar(instanceVarTag, instanceSchema))).build();
        }
        return valueVar;
    }

    private VarDef arraySizeVar(String instanceVarTag, Schema<?> arraySchema, boolean instanceItem, boolean failBelowMinItems, boolean failAboveMaxItems) {
        boolean uniqueRequired;
        VarDefBuilder size = VarDefBuilder.with((String)"Size");
        Integer minItems = arraySchema.getMinItems();
        Integer maxItems = arraySchema.getMaxItems();
        if (minItems == null && maxItems == null) {
            size.values(new VarValueDef[]{VarValueDefBuilder.with((Object)0).properties(new String[]{this.arrayItemsNoneProperty(instanceVarTag)}).build(), VarValueDefBuilder.with((Object)1).build(), VarValueDefBuilder.with((Object)"> 1").properties(new String[]{this.arrayItemsManyProperty(instanceVarTag)}).build()});
        } else {
            minItems = Optional.ofNullable(minItems).map(min -> Optional.ofNullable(maxItems).map(max -> this.adjustedMinOf("Items", min, max)).orElse((Integer)min)).orElse(null);
            TreeSet<Integer> sizeValues = new TreeSet<Integer>();
            if (minItems != null) {
                if (failBelowMinItems) {
                    sizeValues.add(minItems - 1);
                }
                sizeValues.add(minItems);
            }
            if (maxItems != null) {
                sizeValues.add(maxItems);
                if (failAboveMaxItems) {
                    sizeValues.add(maxItems + 1);
                }
            }
            boolean allowSizeZero = minItems == null || minItems == 0;
            for (Integer sizeValue : sizeValues) {
                if (sizeValue < 0) continue;
                VarValueDefBuilder sizeBuilder = VarValueDefBuilder.with((Object)sizeValue);
                if (minItems != null && sizeValue < minItems || maxItems != null && sizeValue > maxItems) {
                    sizeBuilder.type(VarValueDef.Type.FAILURE);
                } else {
                    sizeBuilder.properties(Optional.of(this.arrayItemsNoneProperty(instanceVarTag)).filter(p -> sizeValue == 0 && allowSizeZero)).properties(Optional.of(this.arrayItemsManyProperty(instanceVarTag)).filter(p -> sizeValue > 1));
                }
                size.values(new VarValueDef[]{sizeBuilder.build()});
            }
            if (maxItems == null) {
                int many = Math.max(1, minItems);
                size.values(new VarValueDef[]{VarValueDefBuilder.with((Object)String.format("> %s", many)).properties(new String[]{this.arrayItemsManyProperty(instanceVarTag)}).build()});
            } else if (minItems == null) {
                size.values(new VarValueDef[]{VarValueDefBuilder.with((Object)0).properties(new String[]{this.arrayItemsNoneProperty(instanceVarTag)}).build()});
                if (maxItems > 1) {
                    size.values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)String.format("< %s", maxItems)).has("rangeMin", (Object)1)).properties(Optional.ofNullable(maxItems > 2 ? this.arrayItemsManyProperty(instanceVarTag) : null)).build()});
                }
            }
        }
        if (instanceItem) {
            size.hasIf("itemMinItems", (Object)minItems);
            size.hasIf("itemMaxItems", (Object)maxItems);
        }
        if (uniqueRequired = Boolean.TRUE.equals(arraySchema.getUniqueItems())) {
            size.has("itemsUnique", (Object)true);
        }
        return size.build();
    }

    private Optional<IVarDef> arrayItemsVar(String instanceVarTag, Schema<?> arraySchema, Schema<?> itemSchema) {
        return Optional.ofNullable(arraySchema.getMaxItems()).map(maxItems -> maxItems <= 0).orElse(false) != false ? Optional.empty() : Optional.of(this.resultFor("items", () -> {
            boolean allowSizeZero = Optional.ofNullable(arraySchema.getMinItems()).map(min -> min == 0).orElse(true);
            Not itemsCondition = allowSizeZero ? Conditions.not((String[])new String[]{this.arrayItemsNoneProperty(instanceVarTag)}) : null;
            return VarSetBuilder.with((String)"Contains").when(itemsCondition).members(this.instanceSchemaVars(this.arrayItemsProperty(instanceVarTag), false, itemSchema, true)).build();
        }));
    }

    private Optional<IVarDef> arrayUniqueItemsVar(String instanceVarTag, Schema<?> arraySchema) {
        boolean uniqueRequired = Boolean.TRUE.equals(arraySchema.getUniqueItems());
        return Optional.ofNullable(arraySchema.getMaxItems()).map(maxItems -> maxItems <= 1).orElse(false) != false ? Optional.empty() : Optional.of(VarDefBuilder.with((String)"Unique").when((ICondition)Conditions.has((String[])new String[]{this.arrayItemsManyProperty(instanceVarTag)})).values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").build(), VarValueDefBuilder.with((Object)"No").type(uniqueRequired ? VarValueDef.Type.FAILURE : VarValueDef.Type.VALID).build()}).build());
    }

    private IVarDef instanceTypeVar(String instanceVarTag, boolean instanceOptional, Schema<?> instanceSchema, boolean instanceItem) {
        Optional<Schema<?>> schema = Optional.ofNullable(instanceSchema);
        Boolean nullable = schema.map(s -> s.getNullable()).orElse(Boolean.FALSE);
        boolean nullChecked = schema.map(s -> SchemaExtensions.isNullChecked(s)).orElse(true);
        Optional<Stream> type = schema.flatMap(s -> Optional.ofNullable(s.getType()));
        boolean typeChecked = schema.map(s -> SchemaExtensions.isTypeChecked(s)).orElse(true);
        Set notTypes = schema.flatMap(s -> Optional.ofNullable(SchemaExtensions.getNotTypes(s))).orElse(Collections.emptySet());
        Set requiredTypes = schema.flatMap(s -> Optional.ofNullable(SchemaExtensions.getRequiredTypes(s))).orElse(Collections.emptySet());
        String validTypes = type.orElse((Stream)((Object)String.format("Not %s", notTypes.isEmpty() ? "null" : notTypes.stream().collect(Collectors.joining(",")))));
        return ((VarDefBuilder)VarDefBuilder.with((String)"Type").when(this.instanceDefinedCondition(instanceVarTag, instanceOptional)).hasIf("itemType", Optional.of(validTypes).filter(itemType -> instanceItem))).values(new VarValueDef[]{VarValueDefBuilder.with((Object)validTypes).properties(new String[]{this.instanceValueProperty(instanceVarTag)}).build()}).values(CollectionUtils.streamOf(Optional.of(nullChecked).filter(checked -> checked).map(checked -> VarValueDefBuilder.with(null).type(Boolean.TRUE.equals(nullable) ? VarValueDef.Type.ONCE : VarValueDef.Type.FAILURE).build()))).values((typeChecked ? type.map(t -> Stream.of(String.format("Not %s", requiredTypes.stream().collect(Collectors.joining(","))))).orElse(notTypes.stream()) : Stream.empty()).map(invalidType -> VarValueDefBuilder.with((Object)invalidType).type(VarValueDef.Type.FAILURE).build())).build();
    }

    private IVarDef numberValueVar(String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        VarSetBuilder value = ((VarSetBuilder)((VarSetBuilder)VarSetBuilder.with((String)"Value").has("format", (Object)instanceSchema.getFormat())).has("default", (Object)Objects.toString(instanceSchema.getDefault(), null))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)}));
        VarDefBuilder quantity = VarDefBuilder.with((String)"Is");
        BigDecimal multipleOf = instanceSchema.getMultipleOf();
        Set<BigDecimal> notMultipleOfs = Optional.ofNullable(SchemaExtensions.getNotMultipleOfs(instanceSchema)).orElse(Collections.emptySet());
        boolean hasMultipleOfs = multipleOf != null || !notMultipleOfs.isEmpty();
        Optional<Object> unboundedProperty = Optional.ofNullable(hasMultipleOfs ? this.unboundedValueProperty(instanceVarTag) : null);
        BigDecimal effectiveMaximum = null;
        BigDecimal effectiveMinimum = null;
        Set<BigDecimal> enums = this.nullableEnums(this.getNumberEnum(instanceSchema), instanceSchema.getNullable());
        Set<BigDecimal> notEnums = this.getNumberEnum(SchemaExtensions.getNotEnums(instanceSchema));
        if (!enums.isEmpty()) {
            quantity.values(enums.stream().map(i -> VarValueDefBuilder.with((Object)i).build()));
            quantity.values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Other").type(VarValueDef.Type.FAILURE).has("excluded", enums)).build()});
            SchemaExtensions.setMaxValues(instanceSchema, enums.size());
        } else if (instanceSchema.getMinimum() == null && instanceSchema.getMaximum() == null) {
            TreeSet<BigDecimal> boundaryValues = new TreeSet<BigDecimal>();
            boundaryValues.add(BigDecimal.ZERO);
            boundaryValues.addAll(notEnums);
            quantity.values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"< 0").hasIf("excluded", notEnums)).properties(unboundedProperty).build()});
            for (BigDecimal n : boundaryValues) {
                quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)n).type(notEnums.contains(n) ? VarValueDef.Type.FAILURE : VarValueDef.Type.VALID).build()});
            }
            quantity.values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"> 0").hasIf("excluded", notEnums)).properties(unboundedProperty).build()});
        } else {
            BigDecimal maximum;
            BigDecimal unit = new BigDecimal(BigInteger.ONE, Math.max(Optional.ofNullable(multipleOf).map(BigDecimal::scale).orElse(0), Math.max(Optional.ofNullable(instanceSchema.getMinimum()).map(BigDecimal::scale).orElse(0), Optional.ofNullable(instanceSchema.getMaximum()).map(BigDecimal::scale).orElse(0))));
            BigDecimal effectiveMultipleOf = Optional.ofNullable(multipleOf).orElse(unit);
            BigDecimal minimum = Optional.ofNullable(instanceSchema.getMinimum()).map(m -> this.multipleAbove((BigDecimal)m, !Boolean.TRUE.equals(instanceSchema.getExclusiveMinimum()), effectiveMultipleOf, notMultipleOfs)).orElse(null);
            effectiveMaximum = maximum = (BigDecimal)Optional.ofNullable(instanceSchema.getMaximum()).map(m -> this.multipleBelow((BigDecimal)m, !Boolean.TRUE.equals(instanceSchema.getExclusiveMaximum()), effectiveMultipleOf, notMultipleOfs)).orElse(null);
            effectiveMinimum = Optional.ofNullable(minimum).map(min -> Optional.ofNullable(maximum).map(max -> this.adjustedMinOf("imum", min, max)).orElse((BigDecimal)min)).orElse(null);
            TreeSet<BigDecimal> boundaryValues = new TreeSet<BigDecimal>();
            if (effectiveMinimum != null) {
                boundaryValues.add(effectiveMinimum);
                boundaryValues.add(this.multipleBelow(effectiveMinimum, false, effectiveMultipleOf, notMultipleOfs));
            }
            if (maximum != null) {
                boundaryValues.add(maximum);
                boundaryValues.add(this.multipleAbove(maximum, false, effectiveMultipleOf, notMultipleOfs));
            }
            boundaryValues.addAll(notEnums);
            for (BigDecimal n : boundaryValues) {
                quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)n).type(notEnums.contains(n) || effectiveMinimum != null && n.compareTo(effectiveMinimum) < 0 || maximum != null && n.compareTo(maximum) > 0 ? VarValueDef.Type.FAILURE : VarValueDef.Type.VALID).build()});
            }
            if (effectiveMinimum == null) {
                quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)String.format("< %s", maximum)).properties(unboundedProperty).build()});
            } else if (maximum == null) {
                quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)String.format("> %s", effectiveMinimum)).properties(unboundedProperty).build()});
            } else {
                if (multipleOf != null) {
                    BigDecimal multipleOfFailure = effectiveMinimum.add(unit);
                    while (multipleOfFailure.compareTo(maximum) < 0 && SchemaUtils.isMultipleOf(multipleOfFailure, multipleOf)) {
                        multipleOfFailure = multipleOfFailure.add(unit);
                    }
                    if (multipleOfFailure.compareTo(maximum) < 0) {
                        quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)multipleOfFailure).type(VarValueDef.Type.FAILURE).build()});
                    }
                    SchemaExtensions.setMaxValues(instanceSchema, this.multiplesBetween(effectiveMinimum, maximum, multipleOf, notMultipleOfs));
                }
                BigDecimal nextMultiple = effectiveMinimum.add(effectiveMultipleOf);
                notMultipleOfs.stream().forEach(m -> {
                    BigDecimal notMultipleOfFailure = nextMultiple;
                    while (notMultipleOfFailure.compareTo(maximum) < 0 && !SchemaUtils.isMultipleOf(notMultipleOfFailure, m)) {
                        notMultipleOfFailure = notMultipleOfFailure.add(effectiveMultipleOf);
                    }
                    if (notMultipleOfFailure.compareTo(maximum) < 0) {
                        quantity.values(new VarValueDef[]{VarValueDefBuilder.with((Object)notMultipleOfFailure).type(VarValueDef.Type.FAILURE).build()});
                    }
                });
            }
        }
        if (instanceItem) {
            if (!enums.isEmpty()) {
                quantity.has("itemEnums", enums);
            } else {
                quantity.hasIf("itemMin", effectiveMinimum);
                quantity.hasIf("itemMax", effectiveMaximum);
                quantity.hasIf("itemNotEnums", notEnums);
                quantity.hasIf("itemMultipleOf", (Object)multipleOf);
                quantity.hasIf("itemNotMultipleOfs", notMultipleOfs);
            }
        }
        value.members(new IVarDef[]{quantity.build()});
        if (enums.isEmpty() && (instanceSchema.getMinimum() == null || instanceSchema.getMaximum() == null) && hasMultipleOfs) {
            VarSetBuilder multiples = VarSetBuilder.with((String)"Multiple-Of").when((ICondition)Conditions.has((String[])new String[]{this.unboundedValueProperty(instanceVarTag)}));
            if (multipleOf != null) {
                multiples.members(new IVarDef[]{VarDefBuilder.with((String)DefUtils.toIdentifier((Number)multipleOf)).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Yes").has("multipleOf", (Object)multipleOf)).build(), ((VarValueDefBuilder)VarValueDefBuilder.with((Object)"No").has("multipleOf", (Object)multipleOf)).type(VarValueDef.Type.FAILURE).build()}).build()});
            }
            for (BigDecimal m2 : notMultipleOfs) {
                multiples.members(new IVarDef[]{VarDefBuilder.with((String)DefUtils.toIdentifier((Number)m2)).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Yes").type(VarValueDef.Type.FAILURE).has("multipleOf", (Object)m2)).build(), ((VarValueDefBuilder)VarValueDefBuilder.with((Object)"No").has("multipleOf", (Object)m2)).build()}).build()});
            }
            value.members(new IVarDef[]{multiples.build()});
        }
        return value.build();
    }

    private IVarDef objectValueVar(String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        VarDef valueVar;
        Set enums = this.nullableEnums(CollectionUtils.asOrderedSet((Iterable)instanceSchema.getEnum()), instanceSchema.getNullable());
        if (!enums.isEmpty()) {
            valueVar = ((VarDefBuilder)VarDefBuilder.with((String)"Value").hasIf("itemEnums", (Iterable)Optional.of(enums).filter(e -> instanceItem).orElse(null))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).values(enums.stream().map(i -> VarValueDefBuilder.with((Object)i).build())).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Other").type(VarValueDef.Type.FAILURE).has("excluded", enums)).build()}).build();
        } else {
            Map propertyDefs = Optional.ofNullable(instanceSchema.getProperties()).orElse(new LinkedHashMap());
            Optional.ofNullable(instanceSchema.getRequired()).map(required -> required.stream().filter(property -> !propertyDefs.containsKey(property)).collect(Collectors.toList())).filter(undefined -> !undefined.isEmpty()).ifPresent(undefined -> {
                undefined.stream().forEach(required -> propertyDefs.put(required, SchemaUtils.emptySchema()));
                instanceSchema.setProperties(propertyDefs);
            });
            instanceSchema.setRequired(Optional.ofNullable(instanceSchema.getRequired()).orElse(Collections.emptyList()).stream().filter(property -> this.expectedInView((Schema)propertyDefs.get(property))).collect(Collectors.toList()));
            PropertyCountConstraints constraints = new PropertyCountConstraints();
            constraints.setRequiredCount(Optional.ofNullable(instanceSchema.getRequired()).orElse(Collections.emptyList()).size());
            constraints.setTotalCount(this.objectTotalProperties(instanceSchema));
            constraints.setHasAdditional(Optional.ofNullable(instanceSchema.getAdditionalProperties()).map(additional -> additional.getClass().equals(Boolean.class) ? (Boolean)additional : true).orElse(true) != false && Optional.ofNullable(instanceSchema.getMaxProperties()).map(max -> max > constraints.getRequiredCount()).orElse(true) != false);
            instanceSchema.setMinProperties((Integer)Optional.ofNullable(instanceSchema.getMinProperties()).map(min -> Optional.ofNullable(instanceSchema.getMaxProperties()).map(max -> this.adjustedMinOf("Properties", min, max)).orElse((Integer)min)).orElse(null));
            instanceSchema.setMinProperties((Integer)Optional.ofNullable(instanceSchema.getMinProperties()).filter(min -> this.isUsablePropertyLimit("minProperties", (int)min, constraints)).orElse(null));
            instanceSchema.setMaxProperties((Integer)Optional.ofNullable(instanceSchema.getMaxProperties()).filter(max -> this.isUsablePropertyMax("maxProperties", (int)max, constraints)).orElse(null));
            Integer minProperties = instanceSchema.getMinProperties();
            constraints.setRequiresAdditional(Optional.ofNullable(minProperties).map(min -> min > constraints.getTotalCount() && constraints.hasAdditional()).orElse(false));
            constraints.setAllRequired(Optional.ofNullable(minProperties).map(min -> min.intValue() == constraints.getTotalCount() && !constraints.hasAdditional()).orElse(false));
            valueVar = VarSetBuilder.with((String)"Value").when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).members((Iterable)CollectionUtils.iterableOf(this.objectPropertyCountVar(instanceVarTag, instanceSchema, constraints))).members(new IVarDef[]{this.objectPropertiesVar(instanceVarTag, instanceSchema, constraints)}).build();
        }
        return valueVar;
    }

    private Schema<?> exampleSchemaFor(Object instanceExample, Map<String, Example> instanceExamples, Schema<?> instanceSchema) {
        String exampleType = Optional.ofNullable(instanceSchema).map(Schema::getType).orElse(null);
        boolean exampleNullable = Optional.ofNullable(instanceSchema).flatMap(s -> Optional.ofNullable(s.getNullable())).orElse(false);
        Optional<Object> exampleObject = Optional.ofNullable(instanceExample);
        return exampleObject.isPresent() ? this.exampleSchemaFor(exampleObject.get(), exampleType, exampleNullable) : (Optional.ofNullable(instanceExamples).map(Map::isEmpty).orElse(true) == false ? this.exampleSchemaFor(instanceExamples.values().stream().map(Example::getValue).collect(Collectors.toList()), exampleType, exampleNullable) : this.exampleSchemaFor(instanceSchema, exampleType, exampleNullable));
    }

    private Schema<?> exampleSchemaFor(Schema<?> instanceSchema) {
        return this.exampleSchemaFor(instanceSchema, (String)Optional.ofNullable(instanceSchema).map(Schema::getType).orElse(null), (boolean)Optional.ofNullable(instanceSchema).flatMap(s -> Optional.ofNullable(s.getNullable())).orElse(false));
    }

    private Schema<?> exampleSchemaFor(Schema<?> instanceSchema, String exampleType, boolean exampleNullable) {
        Optional<Object> exampleObject;
        Set<Object> exampleEnum;
        return instanceSchema == null ? null : (!(exampleEnum = this.exampleEnum(instanceSchema)).isEmpty() ? this.exampleSchemaForEnum(exampleEnum, exampleType, exampleNullable) : ((exampleObject = SchemaUtils.schemaExample(instanceSchema)) != null ? this.exampleSchemaFor((Object)exampleObject.orElse(null), exampleType, exampleNullable) : this.derivedExampleSchemaFor(instanceSchema, exampleType)));
    }

    private Schema<?> exampleSchemaFor(Object exampleValue, String exampleType, boolean exampleNullable) {
        Set<Object> exampleEnum = this.nullableEnums(CollectionUtils.asOrderedSet(Arrays.asList(exampleValue)), exampleNullable);
        return this.exampleSchemaForEnum(exampleEnum, exampleType, exampleNullable);
    }

    private Schema<?> exampleSchemaFor(List<Object> exampleValues, String exampleType, boolean exampleNullable) {
        Map<String, List<Object>> exampleEnums = this.nullableEnums(CollectionUtils.asOrderedSet(exampleValues), exampleNullable).stream().collect(Collectors.groupingBy(v -> String.valueOf(this.exampleTypeOf(v))));
        List exampleSchemas = exampleEnums.keySet().stream().filter(type -> {
            boolean typeValid;
            boolean bl = typeValid = exampleType == null || exampleType.equals(type);
            if (!typeValid) {
                this.notifyError(String.format("Expecting example values of type=%s, but found values=%s", exampleType, exampleEnums.get(type)), "Ignoring unexpected example values");
            }
            return typeValid;
        }).map(type -> this.exampleSchemaForEnum(CollectionUtils.asOrderedSet((Iterable)((Iterable)exampleEnums.get(type))), (String)type, exampleNullable)).collect(Collectors.toList());
        return Optional.of(exampleSchemas).filter(s -> !s.isEmpty()).map(s -> s.size() == 1 ? (Schema)s.iterator().next() : new ComposedSchema().oneOf(s)).orElseThrow(() -> new IllegalStateException("No example values defined"));
    }

    private Schema<?> exampleSchemaForEnum(Set<Object> exampleValues, String exampleType, boolean exampleNullable) {
        Schema exampleSchema;
        if (exampleValues.isEmpty()) {
            exampleSchema = null;
        } else {
            exampleSchema = new Schema().type(exampleType).nullable(Boolean.valueOf(exampleNullable));
            exampleSchema.setEnum(exampleValues.stream().collect(Collectors.toList()));
        }
        return exampleSchema;
    }

    private String exampleTypeOf(Object exampleValue) {
        return exampleValue == null ? null : (exampleValue instanceof String ? "string" : (exampleValue instanceof Integer || exampleValue instanceof Long ? "integer" : (exampleValue instanceof Number ? "number" : (exampleValue instanceof Boolean ? "boolean" : (exampleValue instanceof ArrayNode ? "array" : "object")))));
    }

    private Set<Object> exampleEnum(Schema instanceSchema) {
        Set<Object> instanceEnum = this.nullableEnums(CollectionUtils.asOrderedSet((Iterable)instanceSchema.getEnum()), instanceSchema.getNullable());
        return !instanceEnum.isEmpty() ? instanceEnum : ("boolean".equals(instanceSchema.getType()) ? CollectionUtils.asOrderedSet(Arrays.asList(Boolean.TRUE, Boolean.FALSE)) : Collections.emptySet());
    }

    private Schema<?> derivedExampleSchemaFor(Schema<?> instanceSchema, String instanceType) {
        ComposedSchema exampleSchema;
        block10: {
            try {
                if (instanceSchema.getNot() != null) {
                    throw this.exampleException("'not' assertion defined");
                }
                ComposedSchema composed = SchemaUtils.asComposedSchema(instanceSchema);
                if (composed != null) {
                    boolean oneOf;
                    if (!composed.getAllOf().isEmpty()) {
                        throw this.exampleException("'allOf' assertion defined");
                    }
                    boolean anyOf = !composed.getAnyOf().isEmpty();
                    boolean bl = oneOf = !composed.getOneOf().isEmpty();
                    if (anyOf && oneOf) {
                        throw this.exampleException("both 'anyOf' and 'oneOf' assertions defined");
                    }
                    if (!SchemaUtils.isLeafEmpty(composed)) {
                        throw this.exampleException(String.format("if '%s' defined, no other assertions allowed", oneOf ? "oneOf" : "anyOf"));
                    }
                    List members = oneOf ? composed.getOneOf() : composed.getAnyOf();
                    exampleSchema = new ComposedSchema().oneOf(IntStream.range(0, members.size()).mapToObj(i -> this.resultFor(String.format("%s[%s]", oneOf ? "oneOf" : "anyOf", i), () -> this.exampleSchemaFor((Schema)members.get(i)))).collect(Collectors.toList()));
                    break block10;
                }
                if ("array".equals(instanceType)) {
                    exampleSchema = (ComposedSchema)Optional.of(SchemaUtils.asArraySchema(SchemaUtils.copySchema(instanceSchema))).map(s -> s.items(this.resultFor("items", () -> this.exampleSchemaFor(s.getItems())))).orElseThrow(() -> new IllegalStateException("Can't compose array schema examples"));
                    break block10;
                }
                if ("object".equals(instanceType) && (!Optional.ofNullable(instanceSchema.getProperties()).orElse(Collections.emptyMap()).isEmpty() || SchemaUtils.additionalPropertiesSchema(instanceSchema) != null)) {
                    exampleSchema = SchemaUtils.copySchema(instanceSchema).properties((Map)Optional.ofNullable(instanceSchema.getProperties()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.resultFor((String)e.getKey(), () -> this.exampleSchemaFor((Schema)e.getValue())), (s1, s2) -> s1, LinkedHashMap::new))).additionalProperties(Optional.ofNullable(SchemaUtils.additionalPropertiesSchema(instanceSchema)).map(s -> this.resultFor("additionalProperties", () -> this.exampleSchemaFor((Schema<?>)s))).orElse(instanceSchema.getAdditionalProperties()));
                    break block10;
                }
                if (instanceSchema.getDefault() != null) {
                    exampleSchema = this.exampleSchemaFor(instanceSchema.getDefault(), instanceType, (boolean)Optional.ofNullable(instanceSchema.getNullable()).orElse(false));
                    break block10;
                }
                throw this.exampleException(String.format("no example defined for schema of type=%s", instanceType));
            }
            catch (ExampleException e2) {
                this.notifyWarning(String.format("Example data unavailable -- %s. Inputs will be defined by schema", e2.getMessage()));
                exampleSchema = instanceSchema;
            }
        }
        return exampleSchema;
    }

    private ExampleException exampleException(String reason) {
        return new ExampleException(((OpenApiContext)this.getContext()).getLocation(), reason);
    }

    private boolean expectedInView(Schema<?> propertySchema) {
        return propertySchema == null ? true : (this.view_ == View.REQUEST ? !Optional.ofNullable(propertySchema.getReadOnly()).orElse(false).booleanValue() : Optional.ofNullable(propertySchema.getWriteOnly()).orElse(false) == false);
    }

    private boolean excludedFromView(Schema<?> propertySchema) {
        return !this.expectedInView(propertySchema) && (this.view_ == View.REQUEST ? this.getOptions().isReadOnlyEnforced() : this.getOptions().isWriteOnlyEnforced());
    }

    private Optional<IVarDef> objectPropertyCountVar(String instanceVarTag, Schema<?> instanceSchema, PropertyCountConstraints constraints) {
        ListBuilder countValues = ListBuilder.to();
        Integer minProperties = instanceSchema.getMinProperties();
        Integer maxProperties = instanceSchema.getMaxProperties();
        if (minProperties != null || maxProperties != null) {
            if (maxProperties != null) {
                if (minProperties != null) {
                    this.belowMinPropertiesFailure(instanceVarTag, minProperties, constraints).ifPresent(failure -> countValues.add(failure));
                } else if (constraints.getRequiredCount() == 0) {
                    countValues.add((Object)VarValueDefBuilder.with((Object)0).when((ICondition)Conditions.not((String[])new String[]{this.objectPropertiesProperty(instanceVarTag)})).type(VarValueDef.Type.ONCE).build());
                }
                Optional<Object> maxDefined = Optional.ofNullable(maxProperties > constraints.getTotalCount() ? Integer.valueOf(constraints.getTotalCount() + 1) : null);
                countValues.add((Object)VarValueDefBuilder.with((Object)String.format("%s%s", maxProperties.equals(minProperties) ? "" : "<= ", maxProperties)).when((ICondition)Conditions.notMoreThan((String)this.objectPropertiesProperty(instanceVarTag), (int)((Integer)maxDefined.orElse(maxProperties)).intValue())).build()).add((Object)VarValueDefBuilder.with((Object)String.format("> %s", maxProperties)).when((ICondition)Conditions.moreThan((String)this.objectPropertiesProperty(instanceVarTag), (int)maxDefined.map(md -> md - 1).orElse(maxProperties))).type(VarValueDef.Type.FAILURE).build());
            } else {
                AssertNotLess minSatisfied = constraints.allRequired() ? null : Conditions.notLessThan((String)this.objectPropertiesProperty(instanceVarTag), (int)Math.min(minProperties, constraints.getTotalCount()));
                countValues.add((Object)VarValueDefBuilder.with((Object)String.format(">= %s", minProperties)).when((ICondition)minSatisfied).build());
                this.belowMinPropertiesFailure(instanceVarTag, minProperties, constraints).ifPresent(failure -> countValues.add(failure));
            }
        } else if (constraints.getRequiredCount() == 0 && constraints.getTotalCount() > 0) {
            countValues.add((Object)VarValueDefBuilder.with((Object)0).when((ICondition)Conditions.not((String[])new String[]{this.objectPropertiesProperty(instanceVarTag)})).type(VarValueDef.Type.ONCE).build()).add((Object)VarValueDefBuilder.with((Object)"> 0").when((ICondition)Conditions.has((String[])new String[]{this.objectPropertiesProperty(instanceVarTag)})).type(VarValueDef.Type.VALID).build());
        }
        return Optional.of(countValues.build()).filter(values -> !values.isEmpty()).map(values -> VarDefBuilder.with((String)"Property-Count").values((Iterable)values).build());
    }

    private int objectTotalProperties(Schema<?> instanceSchema) {
        return (int)Optional.ofNullable(instanceSchema.getProperties()).orElse(Collections.emptyMap()).entrySet().stream().filter(e -> !this.excludedFromView((Schema)e.getValue())).count();
    }

    private boolean isUsablePropertyLimit(String description, int limit, PropertyCountConstraints constraints) {
        boolean usable = false;
        if (!constraints.hasAdditional() && limit > constraints.getTotalCount()) {
            this.notifyError(String.format("%s=%s exceeds the total number of properties", description, limit), String.format("Ignoring infeasible %s", description));
        } else if (limit < constraints.getRequiredCount()) {
            this.notifyError(String.format("%s=%s is less than required=%s", description, limit, constraints.getRequiredCount()), String.format("Ignoring infeasible %s", description));
        } else if (limit == constraints.getRequiredCount()) {
            this.notifyWarning(String.format("%s=%s is superfluous -- same as required", description, limit));
        } else {
            usable = true;
        }
        return usable;
    }

    private boolean isUsablePropertyMax(String description, int maximum, PropertyCountConstraints constraints) {
        boolean usable = false;
        if (!constraints.hasAdditional() && maximum == constraints.getTotalCount()) {
            this.notifyWarning(String.format("%s=%s is superfluous -- same as the total number of properties", description, maximum));
        } else {
            usable = this.isUsablePropertyLimit(description, maximum, constraints);
        }
        return usable;
    }

    private Optional<VarValueDef> belowMinPropertiesFailure(String instanceVarTag, int minProperties, PropertyCountConstraints constraints) {
        return constraints.requiresAdditional() || constraints.allRequired() ? Optional.empty() : Optional.of(VarValueDefBuilder.with((Object)String.format("< %s", minProperties)).when((ICondition)Conditions.lessThan((String)this.objectPropertiesProperty(instanceVarTag), (int)minProperties)).type(VarValueDef.Type.FAILURE).build());
    }

    private IVarDef objectPropertiesVar(String instanceVarTag, Schema<?> instanceSchema, PropertyCountConstraints constraints) {
        Map propertyDefs = Optional.ofNullable(instanceSchema.getProperties()).orElse(Collections.emptyMap());
        Set notRequiredProperties = Optional.ofNullable(SchemaExtensions.getNotRequired(instanceSchema)).orElse(Collections.emptySet());
        List requiredProperties = Optional.ofNullable(instanceSchema.getRequired()).map(r -> r.stream().filter(p -> !notRequiredProperties.contains(p)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return VarSetBuilder.with((String)"Properties").members(propertyDefs.entrySet().stream().map(propertyDef -> this.objectPropertyVar(instanceVarTag, (String)propertyDef.getKey(), constraints.allRequired() || requiredProperties.contains(propertyDef.getKey()), (Schema)propertyDef.getValue()))).members(new IVarDef[]{this.objectAdditionalVar(instanceVarTag, instanceSchema, constraints)}).build();
    }

    private IVarDef objectPropertyVar(String instanceVarTag, String propertyName, boolean required, Schema<?> propertySchema) {
        return (IVarDef)this.resultFor(propertyName, () -> {
            String propertyVarName = DefUtils.toIdentifier((String)propertyName);
            String propertyVarTag = instanceVarTag + StringUtils.capitalize((String)propertyVarName);
            return this.excludedFromView(propertySchema) ? ((VarSetBuilder)VarSetBuilder.with((String)propertyVarName).has("excludedType", (Object)Optional.ofNullable(propertySchema.getType()).orElse("Not null"))).members(new IVarDef[]{this.instanceDefinedVar(propertyVarTag, Definition.EXCLUDED, new String[0])}).build() : VarSetBuilder.with((String)propertyVarName).members(new IVarDef[]{this.instanceDefinedVar(propertyVarTag, required, this.objectPropertiesProperty(instanceVarTag))}).members(this.instanceSchemaVars(propertyVarTag, propertySchema)).build();
        });
    }

    private IVarDef objectAdditionalVar(String instanceVarTag, Schema<?> instanceSchema, PropertyCountConstraints constraints) {
        boolean allowed = constraints.hasAdditional() && Optional.ofNullable(instanceSchema.getMaxProperties()).orElse(Integer.MAX_VALUE) > 0;
        boolean required = allowed && Optional.ofNullable(instanceSchema.getMinProperties()).map(min -> min > constraints.getTotalCount()).orElse(false) != false;
        Schema<?> propertySchema = SchemaUtils.additionalPropertiesSchema(instanceSchema);
        return propertySchema != null ? this.objectPropertyVar(instanceVarTag, "Additional", required, propertySchema) : VarDefBuilder.with((String)"Additional").values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").type(allowed ? VarValueDef.Type.VALID : VarValueDef.Type.FAILURE).properties(Optional.ofNullable(allowed ? this.objectPropertiesProperty(instanceVarTag) : null)).build(), VarValueDefBuilder.with((Object)"No").type(required ? VarValueDef.Type.FAILURE : VarValueDef.Type.VALID).build()}).build();
    }

    private IVarDef stringValueVar(String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        VarDef valueVar;
        String format = instanceSchema.getFormat();
        Set<FormattedString> enums = this.getFormattedStrings("enumerated", format, this.nullableEnums(CollectionUtils.asOrderedSet((Iterable)instanceSchema.getEnum()), instanceSchema.getNullable()));
        if (!enums.isEmpty()) {
            valueVar = ((VarDefBuilder)((VarDefBuilder)((VarDefBuilder)VarDefBuilder.with((String)"Value").has("format", (Object)format)).has("default", (Object)Objects.toString(this.getFormattedString("default", format, instanceSchema.getDefault()), null))).hasIf("itemEnums", (Iterable)Optional.of(enums).filter(e -> instanceItem).orElse(null))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).values(enums.stream().map(i -> VarValueDefBuilder.with((Object)String.valueOf(i)).build())).values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)this.stringNotEnumerated(enums)).type(VarValueDef.Type.FAILURE).has("excluded", enums)).build()}).build();
            SchemaExtensions.setMaxValues(instanceSchema, enums.size());
        } else {
            VarSetBuilder valueVarSet = ((VarSetBuilder)((VarSetBuilder)VarSetBuilder.with((String)"Value").has("format", (Object)format)).has("default", (Object)this.getFormattedString("default", format, instanceSchema.getDefault()))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)}));
            Integer maxLength = this.maxPatternMatch(instanceSchema, this.maxStringFormat(format, instanceSchema.getMaxLength()));
            Integer minLength = Optional.ofNullable(this.minPatternMatch(instanceSchema, this.minStringFormat(format, instanceSchema.getMinLength()))).map(min -> Optional.ofNullable(maxLength).map(max -> this.adjustedMinOf("Length", min, max)).orElse((Integer)min)).orElse(null);
            Set notEnums = (Set)this.getFormattedStrings("enumerated", format, SchemaExtensions.getNotEnums(instanceSchema)).stream().filter(excluded -> {
                int formattedLength = excluded.toString().length();
                return !(minLength != null && formattedLength < minLength || maxLength != null && formattedLength > maxLength);
            }).collect(CollectionUtils.toOrderedSet());
            Optional<String> notExcludedProperty = Optional.of(this.valueNotExcludedProperty(instanceVarTag)).filter(p -> !notEnums.isEmpty());
            Optional<ICondition> notExcluded = notExcludedProperty.map(p -> Conditions.has((String[])new String[]{p}));
            VarDefBuilder length = VarDefBuilder.with((String)"Length").when(notExcluded);
            if (minLength == null && maxLength == null) {
                length.values(new VarValueDef[]{VarValueDefBuilder.with((Object)"> 0").properties(new String[]{this.validLengthProperty(instanceVarTag)}).properties(new String[]{this.notEmptyProperty(instanceVarTag)}).build()});
                if ((format == null || format.equals("byte") || format.equals("binary") || format.equals("password")) && !notEnums.stream().map(String::valueOf).anyMatch(String::isEmpty)) {
                    length.values(new VarValueDef[]{VarValueDefBuilder.with((Object)0).properties(new String[]{this.validLengthProperty(instanceVarTag)}).build()});
                }
            } else {
                TreeSet<Integer> boundaryValues = new TreeSet<Integer>();
                int effMinLength = Optional.ofNullable(minLength).orElse(0);
                boundaryValues.add(effMinLength);
                boundaryValues.add(effMinLength - 1);
                if (maxLength != null) {
                    boundaryValues.add(maxLength);
                    boundaryValues.add(maxLength + 1);
                }
                for (Integer i2 : boundaryValues) {
                    if (i2 < 0) continue;
                    VarValueDef.Type type = i2 < effMinLength || maxLength != null && i2 > maxLength ? VarValueDef.Type.FAILURE : VarValueDef.Type.VALID;
                    Optional<String> validLength = Optional.of(this.validLengthProperty(instanceVarTag)).filter(p -> type == VarValueDef.Type.VALID);
                    Optional<String> notEmpty = validLength.filter(p -> i2 > 0).map(p -> this.notEmptyProperty(instanceVarTag));
                    length.values(new VarValueDef[]{VarValueDefBuilder.with((Object)i2).type(type).properties(validLength).properties(notEmpty).build()});
                }
                if (minLength == null) {
                    if (maxLength > 1) {
                        length.values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)String.format("< %s", maxLength)).has("rangeMin", (Object)1)).properties(new String[]{this.validLengthProperty(instanceVarTag)}).properties(new String[]{this.notEmptyProperty(instanceVarTag)}).build()});
                    }
                } else if (maxLength == null) {
                    length.values(new VarValueDef[]{VarValueDefBuilder.with((Object)String.format("> %s", minLength)).properties(new String[]{this.validLengthProperty(instanceVarTag)}).properties(new String[]{this.notEmptyProperty(instanceVarTag)}).build()});
                }
            }
            if (instanceItem) {
                length.hasIf("itemMinLength", (Object)Optional.ofNullable(minLength).orElse(0));
                length.hasIf("itemMaxLength", (Object)maxLength);
                length.hasIf("itemNotEnums", (Iterable)notEnums);
                length.hasIf("itemPatterns", SchemaExtensions.getPatterns(instanceSchema));
                length.hasIf("itemNotPatterns", SchemaExtensions.getNotPatterns(instanceSchema));
            }
            VarDef lengthVar = length.build();
            valueVarSet.members(new IVarDef[]{lengthVar});
            String[] patterns = (String[])SchemaExtensions.getPatterns(instanceSchema).stream().toArray(String[]::new);
            String[] notPatterns = (String[])Optional.ofNullable(SchemaExtensions.getNotPatterns(instanceSchema)).orElse(Collections.emptySet()).stream().toArray(String[]::new);
            Optional<ICondition> notEmpty = CollectionUtils.toStream((Iterator)lengthVar.getValidValues()).filter(value -> value.hasProperty(this.notEmptyProperty(instanceVarTag))).findFirst().map(value -> Conditions.has((String[])new String[]{this.notEmptyProperty(instanceVarTag)}));
            if (patterns.length == 1 && notPatterns.length == 0) {
                valueVarSet.members(new IVarDef[]{((VarDefBuilder)VarDefBuilder.with((String)"Matches-Pattern").when((ICondition)Conditions.has((String[])new String[]{this.validLengthProperty(instanceVarTag)})).has("pattern", (Object)patterns[0])).values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").build(), VarValueDefBuilder.with((Object)"No").when(notEmpty).type(VarValueDef.Type.FAILURE).build()}).build()});
            } else if (patterns.length == 0 && notPatterns.length == 1) {
                valueVarSet.members(new IVarDef[]{((VarDefBuilder)VarDefBuilder.with((String)"Matches-Pattern").when((ICondition)Conditions.has((String[])new String[]{this.validLengthProperty(instanceVarTag)})).has("pattern", (Object)notPatterns[0])).values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").when(notEmpty).type(VarValueDef.Type.FAILURE).build(), VarValueDefBuilder.with((Object)"No").build()}).build()});
            } else if (patterns.length > 0 || notPatterns.length > 0) {
                valueVarSet.members(new IVarDef[]{VarSetBuilder.with((String)"Matches-Patterns").when((ICondition)Conditions.has((String[])new String[]{this.validLengthProperty(instanceVarTag)})).members(IntStream.range(0, patterns.length).mapToObj(i -> ((VarDefBuilder)VarDefBuilder.with((String)String.valueOf(i)).has("pattern", (Object)patterns[i])).values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").build(), VarValueDefBuilder.with((Object)"No").when(notEmpty).type(VarValueDef.Type.FAILURE).build()}).build())).members(IntStream.range(0, notPatterns.length).mapToObj(i -> ((VarDefBuilder)VarDefBuilder.with((String)String.valueOf(patterns.length + i)).has("pattern", (Object)notPatterns[i])).values(new VarValueDef[]{VarValueDefBuilder.with((Object)"Yes").when(notEmpty).type(VarValueDef.Type.FAILURE).build(), VarValueDefBuilder.with((Object)"No").build()}).build())).build()});
            }
            if (!notEnums.isEmpty()) {
                valueVarSet.members(new IVarDef[]{VarDefBuilder.with((String)"Is").values(new VarValueDef[]{((VarValueDefBuilder)VarValueDefBuilder.with((Object)"Any").has("excluded", (Iterable)notEnums)).properties(notExcludedProperty).build()}).values(notEnums.stream().map(excluded -> VarValueDefBuilder.with((Object)excluded).type(VarValueDef.Type.FAILURE).build())).build()});
            }
            valueVar = valueVarSet.build();
        }
        return valueVar;
    }

    private IVarDef booleanValueVar(String instanceVarTag, Schema<?> instanceSchema, boolean instanceItem) {
        Set possibleValues = CollectionUtils.asOrderedSet((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        Set<Boolean> excludedValues = this.getBooleanEnum(SchemaExtensions.getNotEnums(instanceSchema));
        Set<Boolean> enumValues = this.nullableEnums(this.getBooleanEnum(instanceSchema), instanceSchema.getNullable());
        List allowedValues = Optional.of(enumValues).filter(enums -> !enums.isEmpty()).orElse(possibleValues).stream().filter(b -> !excludedValues.contains(b)).collect(Collectors.toList());
        if (allowedValues.isEmpty()) {
            throw new IllegalStateException("All possible boolean values have been excluded by this schema");
        }
        SchemaExtensions.setMaxValues(instanceSchema, allowedValues.size());
        return ((VarDefBuilder)((VarDefBuilder)VarDefBuilder.with((String)"Value").has("default", (Object)Objects.toString(instanceSchema.getDefault(), null))).hasIf("itemEnums", (Iterable)Optional.of(allowedValues).filter(e -> instanceItem).orElse(null))).when((ICondition)Conditions.has((String[])new String[]{this.instanceValueProperty(instanceVarTag)})).values(possibleValues.stream().map(b -> VarValueDefBuilder.with((Object)b).type(allowedValues.contains(b) ? VarValueDef.Type.VALID : VarValueDef.Type.FAILURE).build())).build();
    }

    private <T> Set<T> nullableEnums(Set<T> enums, Boolean instanceNullable) {
        if (enums.contains(null) && !Optional.ofNullable(instanceNullable).orElse(false).booleanValue()) {
            this.notifyWarning("'null' is not a valid enumerated value for a non-nullable schema");
        }
        enums.remove(null);
        return enums;
    }

    private Integer maxStringFormat(String format, Integer maxLength) {
        Integer max;
        Integer maxAllowed = OpenApiUtils.stringFormatMax(format);
        if (maxAllowed == null) {
            max = maxLength;
        } else if (maxLength == null) {
            max = maxAllowed;
        } else if (maxLength <= maxAllowed) {
            max = maxLength;
        } else {
            this.notifyWarning(String.format("maxLength=%s exceeds maximum allowed for format=%s -- using maxLength=%s instead", maxLength, format, maxAllowed));
            max = maxAllowed;
        }
        return max;
    }

    private Integer minStringFormat(String format, Integer minLength) {
        return this.minStringFormat(format, minLength, true);
    }

    private Integer minStringFormat(String format, Integer minLength, boolean notify) {
        Integer min;
        Integer minAllowed = OpenApiUtils.stringFormatMin(format);
        if (minAllowed == null) {
            min = minLength;
        } else if (minLength == null) {
            min = minAllowed;
        } else if (minLength >= minAllowed) {
            min = minLength;
        } else {
            if (notify) {
                this.notifyWarning(String.format("minLength=%s is below the minimum allowed for format=%s -- using minLength=%s instead", minLength, format, minAllowed));
            }
            min = minAllowed;
        }
        return min;
    }

    private Integer maxPatternMatch(Schema<?> stringSchema, Integer maxLength) {
        Integer max;
        Integer maxAllowed = SchemaUtils.patternGenerators(stringSchema).map(RegExpGen::getMaxLength).min(Integer::compareTo).map(matchMax -> Bounds.bounded((int)matchMax).orElse(null)).orElse(null);
        if (maxAllowed == null) {
            max = maxLength;
        } else if (maxLength == null) {
            max = maxAllowed;
        } else if (maxLength <= maxAllowed) {
            max = maxLength;
        } else {
            this.notifyWarning(String.format("maxLength=%s exceeds maximum allowed for pattern matches -- using maxLength=%s instead", maxLength, maxAllowed));
            max = maxAllowed;
        }
        return max;
    }

    private Integer minPatternMatch(Schema<?> stringSchema, Integer minLength) {
        Integer min;
        Integer minAllowed = SchemaUtils.patternGenerators(stringSchema).map(RegExpGen::getMinLength).max(Integer::compareTo).orElse(null);
        if (minAllowed == null) {
            min = minLength;
        } else if (minLength == null) {
            min = minAllowed;
        } else if (minLength >= minAllowed) {
            min = minLength;
        } else {
            this.notifyWarning(String.format("minLength=%s is below the minimum allowed for pattern matches -- using minLength=%s instead", minLength, minAllowed));
            min = minAllowed;
        }
        return min;
    }

    private <T extends Comparable<T>> T adjustedMinOf(String description, T min, T max) {
        if (min.compareTo(max) > 0) {
            this.notifyError(String.format("min%s=%s is greater than max%s=%s", description, min, description, max), String.format("Adjusting min%s to max%s", description, description));
            min = max;
        }
        return min;
    }

    private BigDecimal multipleBelow(BigDecimal value, boolean inclusive, BigDecimal multipleOf, Set<BigDecimal> notMultipleOfs) {
        BigDecimal below;
        BigDecimal bigDecimal = below = inclusive && SchemaUtils.isMultipleOf(value, multipleOf) ? value : value.divide(multipleOf, 0, RoundingMode.UP).subtract(BigDecimal.ONE).multiply(multipleOf);
        while (Stream.of(below).filter(b -> notMultipleOfs.stream().anyMatch(m -> SchemaUtils.isMultipleOf(b, m))).findAny().isPresent()) {
            below = below.subtract(multipleOf);
        }
        return below;
    }

    private BigDecimal multipleAbove(BigDecimal value, boolean inclusive, BigDecimal multipleOf, Set<BigDecimal> notMultipleOfs) {
        BigDecimal above;
        BigDecimal bigDecimal = above = inclusive && SchemaUtils.isMultipleOf(value, multipleOf) ? value : value.divide(multipleOf, 0, RoundingMode.DOWN).add(BigDecimal.ONE).multiply(multipleOf);
        while (Stream.of(above).filter(a -> notMultipleOfs.stream().anyMatch(m -> SchemaUtils.isMultipleOf(a, m))).findAny().isPresent()) {
            above = above.add(multipleOf);
        }
        return above;
    }

    private int multiplesBetween(BigDecimal min, BigDecimal max, BigDecimal multipleOf, Set<BigDecimal> notMultipleOfs) {
        int count = 0;
        BigDecimal nextMultiple = min;
        while (nextMultiple.compareTo(max) <= 0) {
            BigDecimal checkValue = nextMultiple;
            if (notMultipleOfs.stream().allMatch(m -> !SchemaUtils.isMultipleOf(checkValue, m))) {
                ++count;
            }
            nextMultiple = nextMultiple.add(multipleOf);
        }
        return count;
    }

    private Integer getMaxAlternativeValues(Schema<?> schema) {
        return Optional.ofNullable(SchemaExtensions.getDnf(schema)).map(dnf -> dnf.getAlternatives().stream()).orElse(Stream.of(schema)).map(s -> SchemaExtensions.getMaxValues(s)).filter(Objects::nonNull).sorted().findFirst().orElse(null);
    }

    static String functionPathName(String pathName) {
        return Arrays.stream(pathName.split("/")).flatMap(p -> InputModeller.pathTemplateIdentifiers(p)).filter(p -> !p.isEmpty()).collect(Collectors.joining("-"));
    }

    private static Stream<String> pathTemplateIdentifiers(String pathElement) {
        Stream.Builder<String> identifiers = Stream.builder();
        Matcher segmentMatcher = uriSegmentPattern_.matcher(pathElement);
        while (segmentMatcher.find()) {
            identifiers.add(DefUtils.toIdentifier((String)segmentMatcher.group().trim()));
        }
        return identifiers.build();
    }

    static String getServerUrl(Server server) {
        StringBuilder url = new StringBuilder();
        Matcher segmentMatcher = uriSegmentPattern_.matcher(server.getUrl());
        while (segmentMatcher.find()) {
            String constantSegment = segmentMatcher.group(1);
            url.append(constantSegment != null ? constantSegment : InputModeller.getServerVarValue(server, segmentMatcher.group(2)));
        }
        return url.toString();
    }

    private static String getServerVarValue(Server server, String varName) {
        return Optional.ofNullable(Optional.ofNullable(server.getVariables()).map(vars -> (ServerVariable)vars.get((Object)varName)).map(var -> Optional.ofNullable(var).map(ServerVariable::getDefault).orElse(null)).orElse(null)).orElseThrow(() -> new IllegalStateException(String.format("No value defined for server variable=%s", varName)));
    }

    private String mediaTypeVarName(String mediaType) {
        return Arrays.stream(mediaType.split("/")).map(part -> DefUtils.toIdentifier((String)part.replace(' ', '.').replace('*', 'W').replace('+', 'S').replace(';', 'P').replace('=', 'E'))).collect(Collectors.joining("-"));
    }

    private String mediaTypeVarTag(String contentVarTag, String mediaType) {
        return contentVarTag.replace("Content", "") + this.mediaTypeVarName(mediaType);
    }

    private String stringNotEnumerated(Set<?> enums) {
        return Stream.of("Other", "Not enumerated", "Not listed", "?").filter(other -> enums.stream().noneMatch(e -> String.valueOf(e).equals(other))).findFirst().orElseThrow(() -> new IllegalStateException("Can't find a name for a non-enumerated value"));
    }

    private ICondition instanceDefinedCondition(String instanceTag, boolean instanceOptional) {
        return instanceOptional ? Conditions.has((String[])new String[]{this.instanceDefinedProperty(instanceTag)}) : null;
    }

    private ICondition instanceDefinedCondition(String instanceTag) {
        return this.instanceDefinedCondition(instanceTag, true);
    }

    private String instanceDefinedProperty(String instanceTag) {
        return instanceTag;
    }

    private String instanceValueProperty(String instanceTag) {
        return instanceTag + "Value";
    }

    private String unboundedValueProperty(String instanceTag) {
        return instanceTag + "Unbounded";
    }

    private String arrayItemsProperty(String instanceTag) {
        return instanceTag + "Items";
    }

    private String arrayItemsNoneProperty(String instanceTag) {
        return this.arrayItemsProperty(instanceTag) + "None";
    }

    private String arrayItemsManyProperty(String instanceTag) {
        return this.arrayItemsProperty(instanceTag) + "Many";
    }

    private String objectPropertiesProperty(String instanceTag) {
        return instanceTag + "Properties";
    }

    private String valueNotExcludedProperty(String instanceTag) {
        return instanceTag + "NotExcluded";
    }

    private String validLengthProperty(String instanceTag) {
        return instanceTag + "LengthValid";
    }

    private String notEmptyProperty(String instanceTag) {
        return instanceTag + "NotEmpty";
    }

    private String statusCodeProperty(String status) {
        return "status" + StringUtils.capitalize((String)status);
    }

    private String alternativeProperty(String instanceTag, int i) {
        return instanceTag + "Alternative" + i;
    }

    private String secReqProperty() {
        return this.secReqProperty(null);
    }

    private String secReqProperty(String secReqTag) {
        return "secRec" + Optional.ofNullable(secReqTag).orElse("");
    }

    private String secSchemeProperty(String secReqTag, String scheme) {
        return this.secReqProperty(secReqTag) + StringUtils.capitalize((String)scheme);
    }

    private Set<BigDecimal> getNumberEnum(Schema<?> schema) {
        return schema instanceof NumberSchema ? CollectionUtils.asOrderedSet((Iterable)((NumberSchema)schema).getEnum()) : this.getNumberEnum(schema.getEnum());
    }

    private Set<BigDecimal> getNumberEnum(Iterable<?> values) {
        return (Set)CollectionUtils.asOrderedSet(values).stream().map(value -> {
            try {
                return value == null ? null : new BigDecimal(value.toString());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Enumerated value=%s is not a number", value));
            }
        }).collect(CollectionUtils.toOrderedSet());
    }

    private Set<Boolean> getBooleanEnum(Schema<?> schema) {
        return schema instanceof BooleanSchema ? CollectionUtils.asOrderedSet((Iterable)((BooleanSchema)schema).getEnum()) : this.getBooleanEnum(schema.getEnum());
    }

    private Set<Boolean> getBooleanEnum(Iterable<?> values) {
        return (Set)CollectionUtils.asOrderedSet(values).stream().map(value -> {
            Boolean booleanValue = null;
            if (value != null) {
                String valueString = value.toString();
                Boolean bl = "true".equalsIgnoreCase(valueString) ? Boolean.TRUE : (booleanValue = "false".equalsIgnoreCase(valueString) ? Boolean.FALSE : null);
                if (booleanValue == null) {
                    throw new IllegalStateException(String.format("Enumerated value=%s is not a boolean", value));
                }
            }
            return booleanValue;
        }).collect(CollectionUtils.toOrderedSet());
    }

    private FormattedString getFormattedString(String description, String format, Object value) {
        try {
            return FormattedString.of(format, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Invalid %s value", description), e);
        }
    }

    private Set<FormattedString> getFormattedStrings(String description, String format, Iterable<?> value) {
        try {
            return CollectionUtils.asOrderedSet(FormattedString.of(format, value));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Invalid %s value", description), e);
        }
    }

    private Schema<?> analyzeSchema(OpenAPI api, Schema<?> schema) {
        return this.analyzer_.analyze(api, schema);
    }

    public Dnf simplified(Dnf dnf) {
        return Optional.of(dnf).map(this::removeFalse).map(this::simplifyTypeChecks).map(this::simplifyNullChecks).get();
    }

    private Dnf removeFalse(Dnf dnf) {
        return Dnf.of(dnf.getAlternatives().stream().filter(s -> !SchemaUtils.isFalse(s)));
    }

    private Dnf simplifyTypeChecks(Dnf dnf) {
        Set<String> types = dnf.getTypes();
        if (types.size() > 1) {
            Schema typeChecked;
            if (types.contains("null")) {
                typeChecked = null;
            } else {
                List typeList = types.stream().collect(Collectors.toList());
                typeChecked = (Schema)dnf.getAlternatives((String)typeList.get(0)).stream().findFirst().get();
                SchemaExtensions.setNotTypes(typeChecked, typeList.subList(1, typeList.size()));
            }
            dnf.getAlternatives().stream().filter(s -> s != typeChecked).forEach(s -> SchemaExtensions.setTypeChecked(s, false));
        }
        return dnf;
    }

    private Dnf simplifyNullChecks(Dnf dnf) {
        Set nullables = dnf.getAlternatives().stream().map(Schema::getNullable).filter(Objects::nonNull).collect(Collectors.toSet());
        boolean nullable = nullables.contains(Boolean.TRUE);
        Dnf simplified = Dnf.of(dnf.getAlternatives().stream().map(s -> {
            s.setNullable(Boolean.valueOf(nullable));
            return s;
        }));
        List<Schema<?>> simplifiedAlternatives = simplified.getAlternatives();
        IntStream.range(0, simplifiedAlternatives.size()).forEach(i -> SchemaExtensions.setNullChecked((Schema)simplifiedAlternatives.get(i), i == 0));
        return simplified;
    }

    public ModelOptions getOptions() {
        return this.options_;
    }

    private static class PropertyCountConstraints {
        private int requiredCount_;
        private int totalCount_;
        private boolean hasAdditional_;
        private boolean requiresAdditional_;
        private boolean allRequired_;

        private PropertyCountConstraints() {
        }

        public void setRequiredCount(int requiredCount) {
            this.requiredCount_ = requiredCount;
        }

        public int getRequiredCount() {
            return this.requiredCount_;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount_ = totalCount;
        }

        public int getTotalCount() {
            return this.totalCount_;
        }

        public void setHasAdditional(boolean hasAdditional) {
            this.hasAdditional_ = hasAdditional;
        }

        public boolean hasAdditional() {
            return this.hasAdditional_;
        }

        public void setRequiresAdditional(boolean requiresAdditional) {
            this.requiresAdditional_ = requiresAdditional;
        }

        public boolean requiresAdditional() {
            return this.requiresAdditional_;
        }

        public void setAllRequired(boolean allRequired) {
            this.allRequired_ = allRequired;
        }

        public boolean allRequired() {
            return this.allRequired_;
        }
    }

    private static enum Definition {
        REQUIRED,
        OPTIONAL,
        EXCLUDED,
        ALWAYS,
        NEVER;

    }

    protected static enum View {
        REQUEST,
        RESPONSE;

    }
}

