/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class FormattedString {
    public static FormattedString of(String format, Object object) {
        return object == null ? new Null() : ("binary".equals(format) ? new Base64(object) : ("byte".equals(format) ? new Base64(object) : ("date".equals(format) ? new Date(object) : ("date-time".equals(format) ? new DateTime(object) : ("uuid".equals(format) ? new Uuid(object) : new Native(object))))));
    }

    public static List<FormattedString> of(String format, Iterable<?> objects) {
        return Optional.ofNullable(objects).map(CollectionUtils::toStream).orElse(Stream.empty()).map(object -> FormattedString.of(format, object)).collect(Collectors.toList());
    }

    public String toString() {
        return this.formatted();
    }

    public abstract String formatted();

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static class Uuid
    extends FormattedString {
        private UUID object_;

        private Uuid(Object object) {
            try {
                this.object_ = (UUID)object;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Value=%s is not a UUID", object));
            }
        }

        @Override
        public String formatted() {
            return this.object_.toString();
        }
    }

    public static class DateTime
    extends FormattedString {
        private java.util.Date object_;

        private DateTime(Object object) {
            try {
                this.object_ = (java.util.Date)object;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Value=%s is not a Date", object));
            }
        }

        @Override
        public String formatted() {
            return DateTime.getDateTimeFormat().format(this.object_);
        }
    }

    public static class Date
    extends FormattedString {
        private java.util.Date object_;

        private Date(Object object) {
            try {
                this.object_ = (java.util.Date)object;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Value=%s is not a Date", object));
            }
        }

        @Override
        public String formatted() {
            return Date.getDateFormat().format(this.object_);
        }
    }

    public static class Base64
    extends FormattedString {
        private byte[] object_;

        private Base64(Object object) {
            try {
                this.object_ = (byte[])object;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Value=%s is not a byte array", object));
            }
        }

        @Override
        public String formatted() {
            return java.util.Base64.getEncoder().encodeToString(this.object_);
        }
    }

    public static class Native
    extends FormattedString {
        private Object object_;

        private Native(Object object) {
            this.object_ = object;
        }

        @Override
        public String formatted() {
            return this.object_.toString();
        }
    }

    public static class Null
    extends FormattedString {
        private Null() {
        }

        @Override
        public String formatted() {
            return null;
        }
    }
}

