/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.ToString;

public abstract class ExecutionContext<E extends RuntimeException> {
    private Deque<String> context_ = new ArrayDeque<String>();

    public <T> T resultFor(String context, Supplier<T> supplier) {
        this.context_.addLast(context);
        try {
            T t = supplier.get();
            return t;
        }
        catch (Throwable e) {
            throw this.whenFailure(e);
        }
        finally {
            this.context_.removeLast();
        }
    }

    public void doFor(String context, Runnable action) {
        this.context_.addLast(context);
        try {
            action.run();
        }
        catch (Throwable e) {
            throw this.whenFailure(e);
        }
        finally {
            this.context_.removeLast();
        }
    }

    protected abstract E whenFailure(Throwable var1);

    public String[] getLocation() {
        return (String[])CollectionUtils.toStream(this.context_.iterator()).toArray(String[]::new);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append((Object[])this.getLocation()).toString();
    }
}

