/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.cornutum.tcases.openapi.SchemaUtils;
import org.cornutum.tcases.util.CollectionUtils;

public class Dnf {
    public static final Dnf NONEXISTENT = null;
    public static final Dnf UNDEFINED = Dnf.of(new Schema[0]);
    private ListValuedMap<String, Schema<?>> alternatives_ = new ArrayListValuedHashMap();

    private void addAlternative(Schema<?> alternative) {
        this.alternatives_.put((Object)String.valueOf(alternative.getType()), alternative);
    }

    public List<Schema<?>> getAlternatives(String type) {
        return Optional.ofNullable(this.alternatives_.get((Object)String.valueOf(type))).orElse(Collections.emptyList());
    }

    public List<Schema<?>> getCompatibleAlternatives(String type) {
        return type == null ? this.getAlternatives() : Stream.concat(this.getAlternatives(type).stream(), this.getAlternatives(null).stream()).collect(Collectors.toList());
    }

    public List<Schema<?>> getAlternatives() {
        return this.alternatives_.values().stream().collect(Collectors.toList());
    }

    public Set<String> getTypes() {
        return this.alternatives_.keySet();
    }

    public static boolean unsatisfiable(Dnf dnf) {
        return Dnf.exists(dnf) && Dnf.undefined(dnf);
    }

    public static boolean exists(Dnf dnf) {
        return dnf != NONEXISTENT;
    }

    public static boolean undefined(Dnf dnf) {
        return dnf.alternatives_.isEmpty();
    }

    public static boolean defined(Dnf dnf) {
        return !Dnf.undefined(dnf);
    }

    public static Dnf of(Schema<?> ... alternatives) {
        return Dnf.of(Arrays.stream(alternatives));
    }

    public static Dnf of(Iterable<Schema<?>> alternatives) {
        return Dnf.of(CollectionUtils.toStream(alternatives));
    }

    public static Dnf of(Stream<Schema<?>> alternatives) {
        Dnf dnf = new Dnf();
        alternatives.forEach(alternative -> dnf.addAlternative((Schema<?>)alternative));
        return dnf;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n').append("Dnf").append('[');
        if (Dnf.undefined(this)) {
            builder.append("Undefined");
        } else {
            this.getTypes().stream().forEach(type -> builder.append("\n  ").append((String)type).append(" [").append("\n    ").append(this.getAlternatives((String)type).stream().map(SchemaUtils::asserts).collect(Collectors.joining("\n    "))).append("\n  ]"));
        }
        return builder.append(']').toString();
    }
}

