/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public interface Characters {
    public static final Any ANY = new Any();
    public static final Ascii ASCII = new Ascii();
    public static final CookieValue COOKIE_VALUE = new CookieValue();
    public static final Token TOKEN = new Token();

    public String getName();

    public boolean allowed(char var1);

    default public boolean allowed(String value) {
        String chars = Objects.toString(value, "");
        return IntStream.range(0, chars.length()).allMatch(i -> this.allowed(chars.charAt(i)));
    }

    default public Optional<String> filtered(String value) {
        String chars = Objects.toString(value, "");
        StringBuilder filtered = new StringBuilder();
        IntStream.range(0, chars.length()).mapToObj(i -> Character.valueOf(chars.charAt(i))).filter(c -> this.allowed(c.charValue())).forEach(c -> filtered.append(c));
        return value == null || filtered.length() == 0 && !chars.isEmpty() ? Optional.empty() : Optional.of(filtered.toString());
    }

    public static Characters delimited(final Characters chars, final char delimiter) {
        return new Base(){

            @Override
            public String getName() {
                return String.format("%s(%s)", chars.getName(), Character.getName(Character.codePointAt(new char[]{delimiter}, 0)));
            }

            @Override
            public boolean allowed(char c) {
                return chars.allowed(c) && c != delimiter;
            }
        };
    }

    public static class Token
    extends Base {
        private static final String separators_ = "()<>@,;:\\\"/[]?={}";
        private static final String token_ = Token.tokenChars();

        @Override
        public String getName() {
            return "TOKEN";
        }

        @Override
        public boolean allowed(char c) {
            return token_.indexOf(c) >= 0;
        }

        private static String tokenChars() {
            String ascii = Ascii.chars();
            StringBuilder tokenChars = new StringBuilder();
            IntStream.range(0, ascii.length()).mapToObj(i -> Character.valueOf(ascii.charAt(i))).filter(c -> separators_.indexOf(c.charValue()) < 0).forEach(c -> tokenChars.append(c));
            return tokenChars.toString();
        }
    }

    public static class CookieValue
    extends Base {
        private static final String excluded_ = " \",;\\";
        private static final String cookieValue_ = CookieValue.cookieValueChars();

        @Override
        public String getName() {
            return "COOKIE_VALUE";
        }

        @Override
        public boolean allowed(char c) {
            return cookieValue_.indexOf(c) >= 0;
        }

        private static String cookieValueChars() {
            String ascii = Ascii.chars();
            StringBuilder cookieValueChars = new StringBuilder();
            IntStream.range(0, ascii.length()).filter(i -> excluded_.indexOf(ascii.charAt(i)) < 0).forEach(i -> cookieValueChars.append(ascii.charAt(i)));
            return cookieValueChars.toString();
        }
    }

    public static class Ascii
    extends Base {
        private static final String ascii_ = Ascii.asciiChars();

        @Override
        public String getName() {
            return "ASCII";
        }

        @Override
        public boolean allowed(char c) {
            return ascii_.indexOf(c) >= 0;
        }

        public static String chars() {
            return ascii_;
        }

        private static String asciiChars() {
            StringBuilder asciiChars = new StringBuilder();
            IntStream.range(0, 128).filter(Any::isPrintable).forEach(codePoint -> asciiChars.appendCodePoint(codePoint));
            return asciiChars.toString();
        }
    }

    public static class Any
    extends Base {
        private static final List<Integer> notVisible_ = Arrays.asList(15, 19, 0);

        @Override
        public String getName() {
            return "ANY";
        }

        @Override
        public boolean allowed(char c) {
            return Any.isPrintable(c);
        }

        public static boolean isPrintable(char c) {
            return c == ' ' || !Character.isSpaceChar(c) && !notVisible_.contains(Character.getType(c));
        }

        public static boolean isPrintable(int codePoint) {
            return Character.toChars(codePoint)[0] == ' ' || !Character.isSpaceChar(codePoint) && !notVisible_.contains(Character.getType(codePoint));
        }
    }

    public static abstract class Base
    implements Characters {
        public String toString() {
            return String.format("Characters[%s]", this.getName());
        }
    }
}

