/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.CommandUtils;
import org.cornutum.tcases.HelpException;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.Tcases;
import org.cornutum.tcases.TcasesIO;
import org.cornutum.tcases.io.TestDefToHtmlFilter;
import org.cornutum.tcases.io.TestDefToJUnitFilter;
import org.cornutum.tcases.io.TransformFilter;
import org.cornutum.tcases.openapi.ModelConditionNotifier;
import org.cornutum.tcases.openapi.ModelOptions;
import org.cornutum.tcases.openapi.Notifier;
import org.cornutum.tcases.openapi.io.TcasesOpenApiIO;
import org.cornutum.tcases.openapi.resolver.ResolverConditionNotifier;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.util.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCommand {
    private static final Logger logger_ = LoggerFactory.getLogger(ApiCommand.class);

    private ApiCommand() {
    }

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            ApiCommand.run(new Options(args));
        }
        catch (HelpException h) {
            exitCode = 1;
        }
        catch (Throwable e) {
            exitCode = 1;
            e.printStackTrace(System.err);
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static void run(Options options) throws Exception {
        SystemInputDef inputDef;
        if (options.showVersion()) {
            System.out.println(CommandUtils.getVersion());
            return;
        }
        logger_.info("{}", (Object)CommandUtils.getVersion());
        File apiDefFile = options.getApiDef();
        if (apiDefFile != null && !apiDefFile.isAbsolute()) {
            apiDefFile = new File(options.getWorkingDir(), apiDefFile.getPath());
        }
        File inputDir = apiDefFile == null ? options.getWorkingDir() : apiDefFile.getParentFile();
        logger_.info("Reading API definition from {}", apiDefFile == null ? "standard input" : apiDefFile);
        logger_.info("Generating an input model based on API {}", (Object)(options.getModelOptions().getSource().equals((Object)ModelOptions.Source.EXAMPLES) ? "examples" : "schemas"));
        SystemInputDef systemInputDef = inputDef = options.isServerTest() ? TcasesOpenApiIO.getRequestInputModel((File)apiDefFile, (String)options.getContentType(), (ModelOptions)options.getModelOptions()) : TcasesOpenApiIO.getResponseInputModel((File)apiDefFile, (String)options.getContentType(), (ModelOptions)options.getModelOptions());
        if (inputDef == null) {
            logger_.warn("No {} defined", (Object)(options.isServerTest() ? "requests" : "responses"));
        } else {
            TestDefToHtmlFilter transformer;
            File outputDir = options.getOutDir();
            File outputFile = options.getOutFile();
            if (outputFile == null && apiDefFile != null) {
                boolean requestTestCases = options.isTests() && options.isRequestCases();
                Object[] objectArray = new Object[4];
                objectArray[0] = Optional.ofNullable(apiDefFile.getParent()).map(p -> p + "/").orElse("");
                objectArray[1] = FilenameUtils.getBaseName((String)apiDefFile.getName());
                Object object = requestTestCases ? "Request" : (objectArray[2] = options.isServerTest() ? "Requests" : "Responses");
                objectArray[3] = requestTestCases ? "Cases" : (options.isTests() ? "Test" : "Input");
                outputFile = new File(String.format("%s%s-%s-%s.json", objectArray));
            }
            if (outputFile != null) {
                if (outputDir == null) {
                    File file = outputDir = outputFile.isAbsolute() ? outputFile.getParentFile() : inputDir;
                }
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new RuntimeException("Can't create output directory=" + outputDir);
                }
                outputFile = new File(outputDir, outputFile.getName());
            }
            if (!options.isTests() || options.getTransformType() == null) {
                transformer = null;
            } else if (options.getTransformType() == Options.TransformType.JUNIT) {
                transformer = new TestDefToJUnitFilter(MapBuilder.of((Object)"system", (Object)inputDef.getName()).build());
                outputFile = Optional.ofNullable(outputFile).map(f -> new File(f.getParentFile(), FilenameUtils.getBaseName((String)f.getName()).replaceAll("\\W+", "") + ".java")).orElse(null);
            } else if (options.getTransformType() == Options.TransformType.HTML) {
                transformer = new TestDefToHtmlFilter();
                outputFile = Optional.ofNullable(outputFile).map(f -> new File(f.getParentFile(), FilenameUtils.getBaseName((String)f.getName()) + ".htm")).orElse(null);
            } else {
                transformer = Optional.ofNullable(options.getTransformDef()).map(transformDefFile -> !transformDefFile.isAbsolute() ? new File(inputDir, transformDefFile.getPath()) : transformDefFile).map(transformDefFile -> new TransformFilter(transformDefFile, options.getTransformParams())).orElse(null);
            }
            if (transformer != null) {
                transformer.setTarget(outputFile);
            }
            OutputStream outputStream = null;
            try {
                outputStream = transformer != null ? transformer.getSource() : (outputFile != null ? new FileOutputStream(outputFile) : null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't open output file=" + outputFile, e);
            }
            logger_.info("Writing results to {}", outputFile == null ? "standard output" : outputFile);
            if (!options.isTests()) {
                TcasesOpenApiIO.writeInputModel((SystemInputDef)inputDef, (OutputStream)outputStream);
            } else if (transformer != null) {
                TcasesIO.writeTests((SystemTestDef)Tcases.getTests((SystemInputDef)inputDef, null, null), (OutputStream)outputStream);
            } else if (options.isRequestCases()) {
                if (options.getRandomSeed() == null) {
                    options.setRandomSeed(options.getDefaultRandomSeed());
                }
                logger_.info("Generating request test cases using random seed={}", (Object)options.getRandomSeed());
                TcasesOpenApiIO.writeRequestCases((SystemTestDef)Tcases.getTests((SystemInputDef)inputDef, null, null), (ResolverContext)options.getResolverContext(), (OutputStream)outputStream);
            } else {
                TcasesOpenApiIO.writeTests((SystemTestDef)Tcases.getTests((SystemInputDef)inputDef, null, null), (OutputStream)outputStream);
            }
        }
    }

    public static class Options {
        private File apiDef_;
        private File outDir_;
        private File outFile_;
        private boolean serverTest_;
        private boolean tests_;
        private boolean requestCases_;
        private TransformType transformType_;
        private File transformDef_;
        private Map<String, Object> transformParams_ = new HashMap<String, Object>();
        private String contentType_;
        private ModelOptions modelOptions_;
        private ResolverContext resolverContext_;
        private File workingDir_;
        private boolean showVersion_;
        private Long randomSeed_;

        public Options() {
            this.setWorkingDir(null);
            this.setServerTest(true);
            this.setTests(true);
            this.setModelOptions(new ModelOptions());
            this.setResolverContext(new ResolverContext(new Random()));
        }

        public Options(String[] args) {
            this();
            int i = 0;
            while (i < args.length && args[i].charAt(0) == '-') {
                i = this.handleOption(args, i);
            }
            this.handleArgs(args, i);
        }

        protected int handleOption(String[] args, int i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.throwHelpException();
            } else if (arg.equals("-o")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutDir(new File(args[i]));
            } else if (arg.equals("-c")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setConditionNotifiers(args[i]);
            } else if (arg.equals("-f")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutFile(new File(args[i]));
            } else if (arg.equals("-R")) {
                this.setReadOnlyEnforced(true);
            } else if (arg.equals("-W")) {
                this.setWriteOnlyEnforced(true);
            } else if (arg.equals("-T")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setContentType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid content type", e);
                }
            } else if (arg.equals("-v")) {
                this.setShowVersion(true);
            } else if (arg.equals("-C")) {
                this.setServerTest(false);
            } else if (arg.equals("-S")) {
                this.setServerTest(true);
            } else if (arg.equals("-D")) {
                this.setRequestCases(true);
            } else if (arg.equals("-X")) {
                this.setSource(ModelOptions.Source.EXAMPLES);
            } else if (arg.equals("-I")) {
                this.setTests(false);
            } else if (arg.equals("-J")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.JUNIT);
            } else if (arg.equals("-H")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.HTML);
            } else if (arg.equals("-x")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.CUSTOM);
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTransformDef(new File(args[i]));
            } else if (arg.equals("-p")) {
                String name;
                String binding;
                int valuePos;
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                if ((valuePos = (binding = args[i]).indexOf(61)) < 0) {
                    CommandUtils.throwUsageException("Invalid -p option: must be name=value");
                }
                if ((name = StringUtils.trimToNull((String)binding.substring(0, valuePos))) == null) {
                    CommandUtils.throwUsageException("Invalid -p option: parameter name undefined");
                }
                String value = binding.substring(valuePos + 1);
                this.getTransformParams().put(name, value);
            } else if (arg.equals("-r")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setRandomSeed(Long.valueOf(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid random seed", e);
                }
            } else if (arg.equals("-m")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setMaxTries(Integer.parseInt(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid max tries", e);
                }
            } else {
                CommandUtils.throwUsageException(String.format("Unknown option: %s", arg));
            }
            return i + 1;
        }

        protected void handleArgs(String[] args, int i) {
            int nargs = args.length - i;
            if (nargs > 1) {
                CommandUtils.throwUsageException(String.format("Unexpected argument: %s", args[i + 1]));
            }
            if (nargs > 0) {
                this.setApiDef(new File(args[i]));
            }
        }

        protected void throwHelpException() {
            this.printUsage();
            throw new HelpException();
        }

        protected void printUsage() {
            for (String line : new String[]{"Usage: tcases-api [option...] [apiDef]", "", "Generates input models and test models for API clients and servers, based on an OpenAPI v3 compliant API definition.", "", "An OpenApi v3 API definition is read from the given apiDef file. If omitted, the API definition is read from standard input.", "If no outFile is specified, output is written to a default file derived from the apiDef or, if no apiDef is", "given, to standard output.", "", "Suppose that the base name of apiDef (less any extension) is B. Then, assuming defaults for all options, output", "will be a test definition for API requests written to a file named 'B-Requests-Test.json'. If -C is specified,", "output will be a test definition for API responses written to a file named 'B-Responses-Test.json'. If -D is", "specified, output will be a list of request test cases written to a file named 'B-Request-Cases.json'. If -I is", "specified, output will be the corresponding input definition, written to either 'B-Requests-Input.json' or", "'B-Responses-Input.json', respectively.", "", "Each option is one of the following:", "", "  -C, -S, -D  If -C is given, produce results to test inputs to an API client, i.e. API responses. If -S is given,", "              produce results to test inputs to an API server, i.e. API requests. If -D is given, produce request", "              test cases for an API server, i.e. API request tests. If none of these is given, the default is -S.", "", "  -X          If specified, test models are generated based on the examples specified in the apiDef. Otherwise,", "              by default, test models are created by generating random input values.", "", "  -I          Produce an input definition file for either an API client (-C) or an API server (-S). If omitted,", "              produce the corresponding test definition file.", "", "  -R          If specified, tests will be generated assuming that the API will strictly enforce exclusion of 'readOnly'", "              properties from request parameters. If omitted, no strict enforcement is assumed.", "", "  -W          If specified, tests will be generated assuming that the API will strictly enforce exclusion of 'writeOnly'", "              properties from responses. If omitted, no strict enforcement is assumed.", "", "  -c M[R]     Defines how input modelling and request case resolution conditions are reported. Both M (for modelling conditions)", "              and R (for resolution conditions) must be one of 'log', 'fail', or 'ignore'. If 'log' is specified, conditions are", "              reported using log messages. If 'fail' is specified, any condition will cause an exception. If 'ignore' is specified,", "              all conditions are silently ignored. If R is omitted, the default is 'log'. If -c is omitted, the default is", "              'log,log'.", "", "  -f outFile  If -f is defined, output is written to the specified outFile, relative to the given outDir.", "              If omitted, the default outFile is derived from the apiDef.", "", "  -o outDir   If -o is defined, output is written to the specified directory. If omitted, the default outDir is", "              the directory containing the apiDef or, if reading from standard input, the current working directory.", "              If an output path cannot be derived, output is written to standard output.", "", "  -J          If -J is defined, test definition output is transformed into Java source", "              code for a JUnit test class. The resulting Java source file is written to", "              the specified outDir.", "", "  -H          If -H is defined, test definition output is transformed into an HTML report", "              that is written to the specified outDir.", "", "  -x xsltDef  If -x is defined, test definition output is transformed according to the", "              XSLT transform defined by the xsltDef file. If relative, the xsltDef path is", "              assumed to be relative to the directory containing the apiDef.", "", "  -p name=value  Defines the value of a transform parameter. Any number of -p options", "              may be specified. This option is meaningful only if the -x or -J option is given.", "", "  -r seed     When -D is specified, use the given random number seed to generate request test case", "              input values. If omitted, the default random number seed is derived from the 'apiDef' name.", "", "  -m maxTries When -D is specified, defines the maximum attempts made to resolve a request test case input", "              value before reporting failure. If omitted, the default value is 10000.", "", "  -T docType  Defines the content type of the OpenApi definition. The 'docType' must be one of 'json', 'yaml',", "              or 'yml'. If omitted, the default content type is derived from the 'apiDef' name. ", "              If the 'apiDef' is read from standard input or does not have a recognized extension, the default", "              content type is 'json'.", "", "  -l logFile  If -l is defined, log output is written to the given file. If omitted,", "              log output is written to a file named tcases-api.log in the current working", "              directory. If logFile is 'stdout', log output is written to standard output.", "", "  -L logLevel Defines the level for log output. If omitted, the default level is INFO.", "              The configuration and levels used for logging are defined by the Logback system.", "", "  -v          Prints the current command version identifier to standard output."}) {
                System.err.println(line);
            }
        }

        public void setOutDir(File outDir) {
            this.outDir_ = outDir;
        }

        public File getOutDir() {
            return this.outDir_;
        }

        public void setOutFile(File outFile) {
            this.outFile_ = outFile;
        }

        public File getOutFile() {
            return this.outFile_;
        }

        public void setServerTest(boolean serverTest) {
            this.serverTest_ = serverTest;
            this.requestCases_ = false;
        }

        public boolean isServerTest() {
            return this.serverTest_;
        }

        public void setTests(boolean tests) {
            this.tests_ = tests;
            if (!tests) {
                this.requestCases_ = false;
            }
        }

        public boolean isTests() {
            return this.tests_;
        }

        public void setRequestCases(boolean requestCases) {
            this.requestCases_ = requestCases;
            if (requestCases) {
                this.serverTest_ = true;
            }
        }

        public boolean isRequestCases() {
            return this.requestCases_;
        }

        public void setSource(ModelOptions.Source source) {
            this.getModelOptions().setSource(source);
        }

        public void setSource(String source) {
            this.setSource(ModelOptions.Source.valueOf((String)String.valueOf(source).toUpperCase()));
        }

        public ModelOptions.Source getSource() {
            return this.getModelOptions().getSource();
        }

        public void setTransformDef(File transformDef) {
            this.transformDef_ = transformDef;
        }

        public File getTransformDef() {
            return this.transformDef_;
        }

        public void setTransformType(TransformType transformType) {
            this.transformType_ = transformType;
        }

        public TransformType getTransformType() {
            return this.transformType_;
        }

        public void setTransformParams(Map<String, Object> params) {
            this.transformParams_ = params;
        }

        public Map<String, Object> getTransformParams() {
            return this.transformParams_;
        }

        public void setContentType(String option) {
            String contentType = Optional.ofNullable(option).map(String::toLowerCase).filter(type -> "json".equals(type) || "yml".equals(type) || "yaml".equals(type)).orElse(null);
            if (option != null && contentType == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid content type", option));
            }
            this.contentType_ = contentType;
        }

        public String getContentType() {
            return this.contentType_;
        }

        public void setModelOptions(ModelOptions modelOptions) {
            this.modelOptions_ = modelOptions;
        }

        public ModelOptions getModelOptions() {
            return this.modelOptions_;
        }

        public void setResolverContext(ResolverContext resolverContext) {
            this.resolverContext_ = resolverContext;
        }

        public ResolverContext getResolverContext() {
            return this.resolverContext_;
        }

        public void setRandomSeed(Long seed) {
            this.randomSeed_ = seed;
            if (seed != null) {
                this.getResolverContext().setRandom(new Random(seed));
            }
        }

        public Long getRandomSeed() {
            return this.randomSeed_;
        }

        public Long getDefaultRandomSeed() {
            return Optional.ofNullable(this.getApiDef()).map(def -> def.getName().hashCode()).orElse(new Random().nextLong());
        }

        public void setMaxTries(int maxTries) {
            this.getResolverContext().setMaxTries(maxTries);
        }

        public int getMaxTries() {
            return this.getResolverContext().getMaxTries();
        }

        public void setConditionNotifiers(String notifierList) {
            String[] notifiers = notifierList.split(",", -1);
            String modelNotifier = notifiers.length > 0 ? StringUtils.trimToNull((String)notifiers[0]) : null;
            this.setOnModellingCondition(modelNotifier);
            String resolveNotifier = notifiers.length > 1 ? StringUtils.trimToNull((String)notifiers[1]) : null;
            this.setOnResolverCondition(resolveNotifier);
        }

        public void setOnModellingCondition(String notifier) {
            this.getModelOptions().setConditionNotifier(Optional.ofNullable(notifier == null || "log".equals(notifier) ? ModelConditionNotifier.log() : ("fail".equals(notifier) ? ModelConditionNotifier.fail() : ("ignore".equals(notifier) ? ModelConditionNotifier.ignore() : null))).orElseThrow(() -> CommandUtils.getUsageException("Unknown condition notifier: " + notifier, null)));
        }

        public void setOnResolverCondition(String notifier) {
            this.getResolverContext().setNotifier((Notifier)Optional.ofNullable(notifier == null || "log".equals(notifier) ? ResolverConditionNotifier.log() : ("fail".equals(notifier) ? ResolverConditionNotifier.fail() : ("ignore".equals(notifier) ? ResolverConditionNotifier.ignore() : null))).orElseThrow(() -> CommandUtils.getUsageException("Unknown condition notifier: " + notifier, null)));
        }

        @Deprecated
        public void setOnCondition(String notifier) {
            this.setOnModellingCondition(notifier);
        }

        public void setReadOnlyEnforced(boolean enforced) {
            this.getModelOptions().setReadOnlyEnforced(enforced);
        }

        public void setWriteOnlyEnforced(boolean enforced) {
            this.getModelOptions().setWriteOnlyEnforced(enforced);
        }

        public void setApiDef(File apiDef) {
            this.apiDef_ = apiDef;
        }

        public File getApiDef() {
            return this.apiDef_;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir_ = workingDir == null ? new File(".") : workingDir;
        }

        public File getWorkingDir() {
            return this.workingDir_;
        }

        public void setShowVersion(boolean showVersion) {
            this.showVersion_ = showVersion;
        }

        public boolean showVersion() {
            return this.showVersion_;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.isRequestCases()) {
                builder.append(" -D");
            } else if (this.isServerTest()) {
                builder.append(" -S");
            } else {
                builder.append(" -C");
            }
            if (ModelOptions.Source.EXAMPLES.equals((Object)this.getSource())) {
                builder.append(" -X");
            }
            if (!this.isTests()) {
                builder.append(" -I");
            }
            if (this.getModelOptions().isReadOnlyEnforced()) {
                builder.append(" -R");
            }
            if (this.getModelOptions().isWriteOnlyEnforced()) {
                builder.append(" -W");
            }
            if (this.getOutFile() != null) {
                builder.append(" -f ").append(this.getOutFile().getPath());
            }
            if (this.getOutDir() != null) {
                builder.append(" -o ").append(this.getOutDir().getPath());
            }
            if (this.getTransformType() == TransformType.JUNIT) {
                builder.append(" -J");
            }
            if (this.getTransformType() == TransformType.HTML) {
                builder.append(" -H");
            }
            if (this.getTransformDef() != null) {
                builder.append(" -x ").append(this.getTransformDef().getPath());
            }
            if (this.getTransformParams() != null) {
                for (String name : this.getTransformParams().keySet()) {
                    builder.append(" -p ").append(name).append('=').append(this.getTransformParams().get(name));
                }
            }
            if (this.isRequestCases()) {
                builder.append(" -m ").append(this.getMaxTries());
                if (this.getRandomSeed() != null) {
                    builder.append(" -r ").append(this.getRandomSeed());
                }
            }
            if (this.getContentType() != null) {
                builder.append(" -T ").append(this.getContentType());
            }
            if (this.showVersion()) {
                builder.append(" -v");
            }
            return builder.toString();
        }

        public static class Builder {
            private Options options_ = new Options();

            public Builder apiDef(File apiDef) {
                this.options_.setApiDef(apiDef);
                return this;
            }

            public Builder outDir(File outDir) {
                this.options_.setOutDir(outDir);
                return this;
            }

            public Builder outFile(File outFile) {
                this.options_.setOutFile(outFile);
                return this;
            }

            public Builder client() {
                this.options_.setServerTest(false);
                return this;
            }

            public Builder server() {
                this.options_.setServerTest(true);
                return this;
            }

            public Builder requestCases() {
                this.options_.setRequestCases(true);
                return this;
            }

            public Builder source(ModelOptions.Source source) {
                this.options_.setSource(source);
                return this;
            }

            public Builder transformType(TransformType transformType) {
                this.options_.setTransformType(transformType);
                return this;
            }

            public Builder transformDef(File transformDef) {
                this.options_.setTransformDef(transformDef);
                return this;
            }

            public Builder transformParam(String name, String value) {
                this.options_.getTransformParams().put(name, value);
                return this;
            }

            public Builder contentType(String type) {
                this.options_.setContentType(type);
                return this;
            }

            public Builder inputDef() {
                this.options_.setTests(false);
                return this;
            }

            public Builder testDef() {
                this.options_.setTests(true);
                return this;
            }

            @Deprecated
            public Builder onCondition(String notifier) {
                return this.onModellingCondition(notifier);
            }

            public Builder onModellingCondition(String notifier) {
                this.options_.setOnModellingCondition(notifier);
                return this;
            }

            public Builder onResolverCondition(String notifier) {
                this.options_.setOnResolverCondition(notifier);
                return this;
            }

            public Builder enforceReadOnly() {
                this.options_.setReadOnlyEnforced(true);
                return this;
            }

            public Builder enforceWriteOnly() {
                this.options_.setWriteOnlyEnforced(true);
                return this;
            }

            public Builder maxTries(int maxTries) {
                this.options_.setMaxTries(maxTries);
                return this;
            }

            public Builder random(Long seed) {
                this.options_.setRandomSeed(seed);
                return this;
            }

            public Options build() {
                return this.options_;
            }
        }

        public static enum TransformType {
            HTML,
            JUNIT,
            CUSTOM;

        }
    }
}

