/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.CommandUtils;
import org.cornutum.tcases.HelpException;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.Tcases;
import org.cornutum.tcases.TcasesIO;
import org.cornutum.tcases.TcasesJson;
import org.cornutum.tcases.generator.GeneratorOptions;
import org.cornutum.tcases.generator.GeneratorSet;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.io.GeneratorSetResource;
import org.cornutum.tcases.io.Resource;
import org.cornutum.tcases.io.SystemInputResource;
import org.cornutum.tcases.io.SystemTestResource;
import org.cornutum.tcases.io.TestDefToHtmlFilter;
import org.cornutum.tcases.io.TestDefToJUnitFilter;
import org.cornutum.tcases.io.TransformFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcasesCommand {
    private static final Logger logger_ = LoggerFactory.getLogger(Tcases.class);

    private TcasesCommand() {
    }

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            TcasesCommand.run(new Options(args));
        }
        catch (HelpException h) {
            exitCode = 1;
        }
        catch (Throwable e) {
            exitCode = 1;
            e.printStackTrace(System.err);
        }
        finally {
            System.exit(exitCode);
        }
    }

    public static void run(Options options) throws Exception {
        File genUpdateFile;
        GeneratorSet genDef;
        File genDefDefault;
        File genDefFile;
        SystemTestDef baseDef;
        Resource.Type outputFileType;
        File outputFile;
        File baseDefFile;
        SystemInputDef inputDef;
        Resource.Type defaultContentType;
        File inputDir;
        block76: {
            File inputDefFile;
            if (options.showVersion()) {
                System.out.println(CommandUtils.getVersion());
                return;
            }
            logger_.info("{}", (Object)CommandUtils.getVersion());
            File inputDefOption = options.getInputDef();
            if (inputDefOption != null && !inputDefOption.isAbsolute()) {
                inputDefOption = new File(options.getWorkingDir(), inputDefOption.getPath());
            }
            if (!((inputDefFile = inputDefOption) == null || inputDefFile.exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.json")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".json")).exists())) {
                throw new RuntimeException("Can't locate input file for path=" + options.getInputDef());
            }
            inputDir = inputDefFile == null ? options.getWorkingDir() : inputDefFile.getParentFile();
            defaultContentType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{options.getContentType(), Resource.Type.of((File)inputDefFile), Resource.Type.XML});
            logger_.info("Reading system input definition={}", (Object)inputDefFile);
            inputDef = null;
            try (SystemInputResource reader = (SystemInputResource)Resource.withDefaultType((Resource)SystemInputResource.of((File)inputDefFile), (Resource.Type)defaultContentType);){
                inputDef = reader.getSystemInputDef();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't read input definition file=" + inputDefFile, e);
            }
            String projectName = CommandUtils.getProjectName(inputDefFile);
            File testDefFile = options.getTestDef();
            if (testDefFile == null && inputDefFile != null) {
                testDefFile = Resource.withDefaultType((File)new File(projectName + "-Test"), (Resource.Type)defaultContentType);
            }
            if ((baseDefFile = testDefFile) != null && !baseDefFile.isAbsolute()) {
                baseDefFile = new File(inputDir, baseDefFile.getPath());
            }
            File outputDir = options.getOutDir();
            outputFile = options.getOutFile();
            if (outputFile == null) {
                File file = options.getTransformType() == Options.TransformType.JUNIT && inputDefFile != null ? new File(projectName.replaceAll("\\W+", "") + "Test.java") : (outputFile = options.getTransformType() == Options.TransformType.HTML && inputDefFile != null ? new File(projectName + "-Test.htm") : testDefFile);
            }
            if (outputFile != null) {
                if (outputDir == null) {
                    File file = outputDir = outputFile.isAbsolute() ? outputFile.getParentFile() : inputDir;
                }
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new RuntimeException("Can't create output directory=" + outputDir);
                }
                outputFile = new File(outputDir, outputFile.isAbsolute() ? outputFile.getName() : outputFile.getPath());
            }
            outputFileType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)Resource.withDefaultType((File)outputFile, (Resource.Type)defaultContentType)), defaultContentType});
            baseDef = null;
            if (options.isExtended() && baseDefFile != null && baseDefFile.exists()) {
                logger_.info("Reading base test definition={}", (Object)baseDefFile);
                try (SystemTestResource reader = (SystemTestResource)Resource.withDefaultType((Resource)SystemTestResource.of((File)baseDefFile), (Resource.Type)defaultContentType);){
                    baseDef = reader.getSystemTestDef();
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't read test definition file=" + baseDefFile, e);
                }
            }
            genDefFile = options.getGenDef();
            genDefDefault = null;
            if (genDefFile != null) {
                if (!genDefFile.isAbsolute()) {
                    genDefFile = new File(inputDir, genDefFile.getPath());
                }
            } else if (inputDefFile != null && (genDefDefault = Resource.withDefaultType((File)new File(inputDir, projectName + "-Generators"), (Resource.Type)defaultContentType)).exists()) {
                genDefFile = genDefDefault;
            }
            genDef = null;
            if (genDefFile != null) {
                logger_.info("Reading generator definition={}", (Object)genDefFile);
                try (GeneratorSetResource reader = (GeneratorSetResource)Resource.withDefaultType((Resource)GeneratorSetResource.of((File)genDefFile), (Resource.Type)defaultContentType);){
                    genDef = reader.getGeneratorSet();
                    break block76;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't read generator definition file=" + genDefFile, e);
                }
            }
            genDef = GeneratorSet.basicGenerator();
        }
        SystemTestDef testDef = Tcases.getTests((SystemInputDef)inputDef, (IGeneratorSet)genDef, baseDef, (GeneratorOptions)options.getGeneratorOptions());
        TransformFilter transformer = null;
        File transformDefFile = options.getTransformDef();
        if (transformDefFile != null) {
            if (!transformDefFile.isAbsolute()) {
                transformDefFile = new File(inputDir, transformDefFile.getPath());
            }
            transformer = new TransformFilter(transformDefFile, options.getTransformParams());
        } else if (options.getTransformType() == Options.TransformType.JUNIT) {
            transformer = new TestDefToJUnitFilter(options.getTransformParams());
        } else if (options.getTransformType() == Options.TransformType.HTML) {
            transformer = new TestDefToHtmlFilter();
        }
        if (transformer != null) {
            if (outputFile != null && outputFile.equals(baseDefFile) && baseDefFile.exists()) {
                throw new RuntimeException("Transformed output will overwrite test definition file=" + baseDefFile);
            }
            transformer.setTarget(outputFile);
            outputFileType = Resource.Type.XML;
        }
        try {
            OutputStream output;
            logger_.info("Updating test definition file={}", (Object)outputFile);
            OutputStream outputStream = transformer != null ? transformer.getSource() : (output = outputFile != null ? new FileOutputStream(outputFile) : null);
            if (outputFileType == Resource.Type.JSON) {
                TcasesJson.writeTests((SystemTestDef)testDef, (OutputStream)output);
            } else {
                TcasesIO.writeTests((SystemTestDef)testDef, (OutputStream)output);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't write test definition file=" + outputFile, e);
        }
        File file = genDefFile != null ? genDefFile : (genUpdateFile = genDefDefault != null ? genDefDefault : null);
        if (genUpdateFile != null && (options.getRandomSeed() != null || options.getDefaultTupleSize() != null)) {
            logger_.info("Updating generator definition={}", (Object)genUpdateFile);
            try {
                Resource.Type genUpdateType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)Resource.withDefaultType((File)genUpdateFile, (Resource.Type)defaultContentType)), defaultContentType});
                if (genUpdateType == Resource.Type.JSON) {
                    TcasesJson.writeGenerators((IGeneratorSet)genDef, (OutputStream)new FileOutputStream(genUpdateFile));
                } else {
                    TcasesIO.writeGenerators((IGeneratorSet)genDef, (OutputStream)new FileOutputStream(genUpdateFile));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't write generator definition file=" + genUpdateFile, e);
            }
        }
    }

    public static class Options {
        private File inputDef_;
        private File outDir_;
        private File outFile_;
        private File testDef_;
        private File genDef_;
        private File transformDef_;
        private Map<String, Object> transformParams_ = new HashMap<String, Object>();
        private TransformType transformType_;
        private boolean extended_;
        private boolean newSeed_;
        private File workingDir_;
        private boolean showVersion_;
        private GeneratorOptions generatorOptions_ = new GeneratorOptions();
        private Resource.Type contentType_;

        public Options() {
            this.setExtended(true);
            this.setWorkingDir(null);
        }

        public Options(String[] args) {
            this();
            int i = 0;
            while (i < args.length && args[i].charAt(0) == '-') {
                i = this.handleOption(args, i);
            }
            this.handleArgs(args, i);
        }

        protected int handleOption(String[] args, int i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.throwHelpException();
            } else if (arg.equals("-o")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutDir(new File(args[i]));
            } else if (arg.equals("-f")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setOutFile(new File(args[i]));
            } else if (arg.equals("-t")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTestDef(new File(args[i]));
            } else if (arg.equals("-T")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setContentType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid content type", e);
                }
            } else if (arg.equals("-v")) {
                this.setShowVersion(true);
            } else if (arg.equals("-g")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setGenDef(new File(args[i]));
            } else if (arg.equals("-r")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setRandomSeed(Long.valueOf(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid random seed", e);
                }
            } else if (arg.equals("-R")) {
                this.setNewSeed(true);
            } else if (arg.equals("-c")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setDefaultTupleSize(Integer.valueOf(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid tuple size", e);
                }
            } else if (arg.equals("-n")) {
                this.setExtended(false);
            } else if (arg.equals("-J")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.JUNIT);
            } else if (arg.equals("-H")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.HTML);
            } else if (arg.equals("-x")) {
                if (this.getTransformType() != null) {
                    CommandUtils.throwUsageException("Can't specify multiple output transforms");
                }
                this.setTransformType(TransformType.CUSTOM);
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTransformDef(new File(args[i]));
            } else if (arg.equals("-p")) {
                String name;
                String binding;
                int valuePos;
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                if ((valuePos = (binding = args[i]).indexOf(61)) < 0) {
                    CommandUtils.throwUsageException("Invalid -p option: must be name=value");
                }
                if ((name = StringUtils.trimToNull((String)binding.substring(0, valuePos))) == null) {
                    CommandUtils.throwUsageException("Invalid -p option: parameter name undefined");
                }
                String value = binding.substring(valuePos + 1);
                this.getTransformParams().put(name, value);
            } else {
                CommandUtils.throwUsageException(String.format("Unknown option: %s", arg));
            }
            return i + 1;
        }

        protected void handleArgs(String[] args, int i) {
            int nargs = args.length - i;
            if (nargs > 1) {
                CommandUtils.throwUsageException(String.format("Unexpected argument: %s", args[i + 1]));
            }
            if (nargs > 0) {
                this.setInputDef(new File(args[i]));
            }
        }

        protected void throwHelpException() {
            this.printUsage();
            throw new HelpException();
        }

        protected void printUsage() {
            for (String line : new String[]{"Usage: tcases [option...] [inputDef]", "", "Generates a set of test cases from a system input definition, according to the given options.", "", "The system input definition is read from the given inputDef. If omitted, the system input", "definition is read from standard input. Otherwise, the system input definition is read from", "the first one of the following files that can be located.", "", "  1. inputDef", "  2. inputDef-Input.xml", "  3. inputDef.xml", "", "Each option is one of the following:", "", "  -c tuples   If -c is defined, use the given default tuple size for all generators.", "              This updates the generator definitions specified by the genDef file.", "", "  -f outFile  If -f is defined, test definition output is written to the specified", "              outFile, relative to the given outDir. If omitted, test definitions are", "              written to the file specified by the -t option. If an output path cannot", "              be derived, output is written to standard output.", "", "  -g genDef   If -g is defined, test definitions are created using the generator(s)", "              specified by the given genDef file. If omitted, the default generator", "              definition is used. The default generator definition is read from the", "              corresponding *-Generators.xml file in the same directory as the inputDef,", "              if it exists. Otherwise, the default TupleGenerator is used for all", "              functions.", "", "  -J          If -J is defined, test definition output is transformed into Java source", "              code for a JUnit test class. The resulting Java source file is written to", "              the specified outDir.", "", "  -H          If -H is defined, test definition output is transformed into an HTML report", "              that is written to the specified outDir.", "", "  -l logFile  If -l is defined, log output is written to the given file. If omitted,", "              log output is written to a file named tcases.log in the current working", "              directory. If logFile is 'stdout', log output is written to standard output.", "", "  -L logLevel Defines the level for log output. If omitted, the default level is INFO.", "              The configuration and levels used for logging are defined by the Logback system.", "", "  -n          If -n is defined, any previous contents of the testDef are ignored.", "              If omitted, new test definitions are based on the previous testDef.", "", "  -o outDir   If -o is defined, test definition output is written to the specified", "              directory. If omitted, the default outDir is the directory containing", "              the inputDef or, if reading from standard input, the current working", "              directory. If an output path cannot be derived, output is written to", "              standard output.", "", "  -p name=value  Defines the value of a transform parameter. Any number of -p options", "              may be specified. This option is meaningful only if the -x or -J option is given.", "", "  -r seed     If -r is defined, use the given random number seed for all generators.", "              This updates the generator definitions specified by the genDef file.", "", "  -R          If -R is defined, choose a new random number seed for all generators.", "              This updates the generator definitions specified by the genDef file.", "", "  -t testDef  If -t is defined, test definition output is written to the specified", "              testDef path, relative to the outDir. If omitted, the default testDef", "              name is derived from the inputDef name. If an output path cannot be", "              derived, output is written to standard output.", "", "  -T contentType  Defines the default content type for the files read and produced.", "              The contentType must be one of 'json' or 'xml'. The default content type is", "              assumed for any file that is not specified explicitly or that does not have a", "              recognized extension. If omitted, the default content type is derived from the", "              inputDef name.", "", "  -v          Shows the current Tcases version. If this option is given, no other", "              action is performed.", "", "  -x xsltDef  If -x is defined, test definition output is transformed according to the", "              XSLT transform defined by the xsltDef file. If relative, the xsltDef path is", "              assumed to be relative to the directory containing the inputDef."}) {
                System.err.println(line);
            }
        }

        public void setOutDir(File outDir) {
            this.outDir_ = outDir;
        }

        public File getOutDir() {
            return this.outDir_;
        }

        public void setOutFile(File outFile) {
            this.outFile_ = outFile;
        }

        public File getOutFile() {
            return this.outFile_;
        }

        public void setTestDef(File testDef) {
            this.testDef_ = testDef;
        }

        public File getTestDef() {
            return this.testDef_;
        }

        public void setGenDef(File genDef) {
            this.genDef_ = genDef;
        }

        public File getGenDef() {
            return this.genDef_;
        }

        public void setTransformDef(File transformDef) {
            this.transformDef_ = transformDef;
        }

        public File getTransformDef() {
            return this.transformDef_;
        }

        public void setTransformType(TransformType transformType) {
            this.transformType_ = transformType;
        }

        public TransformType getTransformType() {
            return this.transformType_;
        }

        public void setTransformParams(Map<String, Object> params) {
            this.transformParams_ = params;
        }

        public Map<String, Object> getTransformParams() {
            return this.transformParams_;
        }

        public void setInputDef(File inputDef) {
            this.inputDef_ = inputDef;
        }

        public File getInputDef() {
            return this.inputDef_;
        }

        public void setExtended(boolean extended) {
            this.extended_ = extended;
        }

        public boolean isExtended() {
            return this.extended_;
        }

        public void setRandomSeed(Long seed) {
            this.getGeneratorOptions().setRandomSeed(seed);
        }

        public Long getRandomSeed() {
            if (this.getGeneratorOptions().getRandomSeed() == null && this.isNewSeed()) {
                this.setRandomSeed((long)(Math.random() * 9.223372036854776E18));
            }
            return this.getGeneratorOptions().getRandomSeed();
        }

        public void setNewSeed(boolean newSeed) {
            this.newSeed_ = newSeed;
        }

        public boolean isNewSeed() {
            return this.newSeed_;
        }

        public void setDefaultTupleSize(Integer tupleSize) {
            this.getGeneratorOptions().setDefaultTupleSize(tupleSize);
        }

        public Integer getDefaultTupleSize() {
            return this.getGeneratorOptions().getDefaultTupleSize();
        }

        public GeneratorOptions getGeneratorOptions() {
            return this.generatorOptions_;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir_ = workingDir == null ? new File(".") : workingDir;
        }

        public File getWorkingDir() {
            return this.workingDir_;
        }

        public void setShowVersion(boolean showVersion) {
            this.showVersion_ = showVersion;
        }

        public boolean showVersion() {
            return this.showVersion_;
        }

        public void setContentType(String option) {
            Resource.Type contentType = Resource.Type.of((String)option);
            if (option != null && contentType == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid content type", option));
            }
            this.setContentType(contentType);
        }

        public void setContentType(Resource.Type contentType) {
            this.contentType_ = contentType;
        }

        public Resource.Type getContentType() {
            return this.contentType_;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.getDefaultTupleSize() != null) {
                builder.append(" -c ").append(this.getDefaultTupleSize());
            }
            if (this.getOutFile() != null) {
                builder.append(" -f ").append(this.getOutFile().getPath());
            }
            if (this.getGenDef() != null) {
                builder.append(" -g ").append(this.getGenDef().getPath());
            }
            if (!this.isExtended()) {
                builder.append(" -n");
            }
            if (this.getOutDir() != null) {
                builder.append(" -o ").append(this.getOutDir().getPath());
            }
            if (this.getTransformParams() != null) {
                for (String name : this.getTransformParams().keySet()) {
                    builder.append(" -p ").append(name).append('=').append(this.getTransformParams().get(name));
                }
            }
            if (this.getRandomSeed() != null) {
                builder.append(" -r ").append(this.getRandomSeed());
            }
            if (this.isNewSeed()) {
                builder.append(" -R");
            }
            if (this.getTestDef() != null) {
                builder.append(" -t ").append(this.getTestDef().getPath());
            }
            if (this.getContentType() != null) {
                builder.append(" -T ").append(this.getContentType());
            }
            if (this.showVersion()) {
                builder.append(" -v");
            }
            if (this.getTransformDef() != null) {
                builder.append(" -x ").append(this.getTransformDef().getPath());
            }
            if (this.getTransformType() == TransformType.JUNIT) {
                builder.append(" -J");
            }
            if (this.getTransformType() == TransformType.HTML) {
                builder.append(" -H");
            }
            return builder.toString();
        }

        public static class Builder {
            private Options options_ = new Options();

            public Builder inputDef(File inputDef) {
                this.options_.setInputDef(inputDef);
                return this;
            }

            public Builder outDir(File outDir) {
                this.options_.setOutDir(outDir);
                return this;
            }

            public Builder outFile(File outFile) {
                this.options_.setOutFile(outFile);
                return this;
            }

            public Builder testDef(File testDef) {
                this.options_.setTestDef(testDef);
                return this;
            }

            public Builder genDef(File genDef) {
                this.options_.setGenDef(genDef);
                return this;
            }

            public Builder transformDef(File transformDef) {
                this.options_.setTransformDef(transformDef);
                return this;
            }

            public Builder transformType(TransformType transformType) {
                this.options_.setTransformType(transformType);
                return this;
            }

            public Builder transformParam(String name, String value) {
                this.options_.getTransformParams().put(name, value);
                return this;
            }

            public Builder newSeed() {
                this.options_.setNewSeed(true);
                return this;
            }

            public Builder extended() {
                this.options_.setExtended(true);
                return this;
            }

            public Builder seed(Long seed) {
                this.options_.setRandomSeed(seed);
                return this;
            }

            public Builder tuples(int tuples) {
                this.options_.setDefaultTupleSize(tuples);
                return this;
            }

            public Builder contentType(String type) {
                this.options_.setContentType(type);
                return this;
            }

            public Options build() {
                return this.options_;
            }
        }

        public static enum TransformType {
            HTML,
            JUNIT,
            CUSTOM;

        }
    }
}

