/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.cornutum.tcases.CommandUtils;
import org.cornutum.tcases.HelpException;
import org.cornutum.tcases.Reducer;
import org.cornutum.tcases.ReducerOptions;
import org.cornutum.tcases.SystemInputDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.TcasesIO;
import org.cornutum.tcases.TcasesJson;
import org.cornutum.tcases.generator.GeneratorSet;
import org.cornutum.tcases.generator.IGeneratorSet;
import org.cornutum.tcases.generator.ITestCaseGenerator;
import org.cornutum.tcases.generator.TupleGenerator;
import org.cornutum.tcases.generator.io.GeneratorSetResource;
import org.cornutum.tcases.io.Resource;
import org.cornutum.tcases.io.SystemInputResource;
import org.cornutum.tcases.io.SystemTestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducerCommand
extends Reducer {
    private static final Logger logger_ = LoggerFactory.getLogger(ReducerCommand.class);

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            ReducerCommand reducer = new ReducerCommand();
            reducer.run(new Options(args));
        }
        catch (HelpException h) {
            exitCode = 1;
        }
        catch (Throwable e) {
            exitCode = 1;
            e.printStackTrace(System.err);
        }
        finally {
            System.exit(exitCode);
        }
    }

    public void run(Options options) throws Exception {
        GeneratorSet genDef;
        File genDefFile;
        SystemTestDef baseDef;
        SystemInputDef inputDef;
        String project;
        Resource.Type defaultContentType;
        block58: {
            File inputDefOption;
            if (options.showVersion()) {
                System.out.println(CommandUtils.getVersion());
                return;
            }
            logger_.info("{}", (Object)CommandUtils.getVersion());
            File inputDefFile = inputDefOption = options.getInputDef();
            if (!(inputDefFile.exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".xml")).exists() || (inputDefFile = new File(inputDefOption.getPath() + "-Input.json")).exists() || (inputDefFile = new File(inputDefOption.getPath() + ".json")).exists())) {
                throw new RuntimeException("Can't locate input file for path=" + inputDefOption);
            }
            defaultContentType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{options.getContentType(), Resource.Type.of((File)inputDefFile), Resource.Type.XML});
            File inputDir = inputDefFile.getParentFile();
            project = CommandUtils.getProjectName(inputDefFile);
            logger_.info("Reading system input definition={}", (Object)inputDefFile);
            inputDef = null;
            try (SystemInputResource reader = (SystemInputResource)Resource.withDefaultType((Resource)SystemInputResource.of((File)inputDefFile), (Resource.Type)defaultContentType);){
                inputDef = reader.getSystemInputDef();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't read input definition file=" + inputDefFile, e);
            }
            File baseDefFile = options.getTestDef();
            if (baseDefFile != null && !baseDefFile.isAbsolute()) {
                baseDefFile = new File(inputDir, baseDefFile.getPath());
            }
            baseDef = null;
            if (baseDefFile != null) {
                logger_.info("Reading base test definition={}", (Object)baseDefFile);
                try (SystemTestResource reader = (SystemTestResource)Resource.withDefaultType((Resource)SystemTestResource.of((File)baseDefFile), (Resource.Type)defaultContentType);){
                    baseDef = reader.getSystemTestDef();
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't read test definition file=" + baseDefFile, e);
                }
            }
            if ((genDefFile = options.getGenDef()) == null) {
                genDefFile = Resource.withDefaultType((File)new File(inputDir, project + "-Generators"), (Resource.Type)defaultContentType);
            } else if (!genDefFile.isAbsolute()) {
                genDefFile = new File(inputDir, genDefFile.getPath());
            }
            genDef = null;
            if (genDefFile.exists()) {
                logger_.info("Reading generator definition={}", (Object)genDefFile);
                try (GeneratorSetResource reader = (GeneratorSetResource)Resource.withDefaultType((Resource)GeneratorSetResource.of((File)genDefFile), (Resource.Type)defaultContentType);){
                    genDef = (GeneratorSet)reader.getGeneratorSet();
                    break block58;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't read generator definition file=" + genDefFile, e);
                }
            }
            GeneratorSet genSet = new GeneratorSet();
            genSet.addGenerator("*", (ITestCaseGenerator)new TupleGenerator());
            genDef = genSet;
        }
        Optional genDefNew = ReducerCommand.reduce((SystemInputDef)inputDef, (GeneratorSet)genDef, (SystemTestDef)baseDef, (ReducerOptions)options.getReducerOptions());
        if (!genDefNew.isPresent()) {
            logger_.info("[{}] Generator definition not changed", (Object)project);
        } else {
            try {
                Resource.Type genDefType = (Resource.Type)ObjectUtils.firstNonNull((Object[])new Resource.Type[]{Resource.Type.of((File)Resource.withDefaultType((File)genDefFile, (Resource.Type)defaultContentType)), defaultContentType});
                if (genDefType == Resource.Type.JSON) {
                    TcasesJson.writeGenerators((IGeneratorSet)((IGeneratorSet)genDefNew.get()), (OutputStream)new FileOutputStream(genDefFile));
                } else {
                    TcasesIO.writeGenerators((IGeneratorSet)((IGeneratorSet)genDefNew.get()), (OutputStream)new FileOutputStream(genDefFile));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can't write generator definition file=" + genDefFile, e);
            }
        }
    }

    public static class Options {
        private File inputDef_;
        private File testDef_;
        private File genDef_;
        private ReducerOptions reducerOptions_ = new ReducerOptions();
        private Resource.Type contentType_;
        private boolean showVersion_;

        public Options() {
            this.setSamples(10);
            this.setResampleFactor(0.0);
        }

        public Options(String[] args) {
            this();
            int i = 0;
            while (i < args.length && args[i].charAt(0) == '-') {
                i = this.handleOption(args, i);
            }
            this.handleArgs(args, i);
        }

        protected int handleOption(String[] args, int i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.throwHelpException();
            } else if (arg.equals("-f")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setFunction(args[i]);
            } else if (arg.equals("-g")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setGenDef(new File(args[i]));
            } else if (arg.equals("-r")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setResampleFactor(Double.parseDouble(args[i]));
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid resample factor", e);
                }
            } else if (arg.equals("-R")) {
                this.setNewSeed(true);
            } else if (arg.equals("-s")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    int samples = Integer.parseInt(args[i]);
                    if (samples <= 0) {
                        throw new IllegalArgumentException("Sample count must be greater than 0");
                    }
                    this.setSamples(samples);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid sample count", e);
                }
            } else if (arg.equals("-t")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                this.setTestDef(new File(args[i]));
            } else if (arg.equals("-T")) {
                if (++i >= args.length) {
                    CommandUtils.throwMissingValue(arg);
                }
                try {
                    this.setContentType(args[i]);
                }
                catch (Exception e) {
                    CommandUtils.throwUsageException("Invalid content type", e);
                }
            } else if (arg.equals("-v")) {
                this.setShowVersion(true);
            } else {
                CommandUtils.throwUsageException(String.format("Unknown option: %s", arg));
            }
            return i + 1;
        }

        protected void handleArgs(String[] args, int i) {
            int nargs = args.length - i;
            if (nargs == 1) {
                this.setInputDef(new File(args[i]));
            } else if (nargs > 1) {
                CommandUtils.throwUsageException(String.format("Unexpected argument: %s", args[i + 1]));
            } else if (!this.showVersion()) {
                CommandUtils.throwUsageException("No input definition file specified");
            }
        }

        protected void throwHelpException() {
            this.printUsage();
            throw new HelpException();
        }

        protected void printUsage() {
            for (String line : new String[]{"Usage: tcases-reducer [option...] inputDef", "", "For a system input definition, updates the associated test case generators to reduce the number", "of generated test cases, using the given command line options.", "", "Each option is one of the following:", "", "  -f function        If -f is defined, update only the test case generator for the given function.", "                     Otherwise, update the test case generators for all functions.", "", "  -g genDef          If -g is defined, update the generator specified in the given genDef file.", "                     Otherwise, update the default generate definition file: the corresponding", "                     *-Generators.xml file in the same directory as the inputDef.", "", "  -l logFile         If -l is defined, log output is written to the given file. If omitted,", "                     log output is written to a file named tcases-reducer.log in the current working", "                     directory. If logFile is 'stdout', log output is written to standard output.", "", "  -L logLevel        Defines the level for log output. If omitted, the default level is INFO.", "                     The configuration and levels used for logging are defined by the Logback system.", "", "  -r resampleFactor  If -r is defined, use the given resampleFactor to determine the number", "                     of samples in the next round of reducing. Depending on the resampleFactor,", "                     the next round may use more or fewer samples. If the previous round called", "                     for N samples and produced a reduction, then the number of samples for the ", "                     next round will be N * ( 1 + resampleFactor). To increase sample count with", "                     each round, define resampleFactor > 0. To decrease sample count with each round,", "                     define -1 < resampleFactor < 0. If resampleFactor is omitted, the default value is 0.", "", "  -R                 If defined, ignore any random seed defined in the genDef file and search for a new seed.", "", "  -s sampleCount     Defines the number of samples for the initial round of reducing. If omitted,", "                     the default sampleCount is 10.", "", "  -t testDef         If -t is defined, generate test cases based on the test definitions in the", "                     specified testDef file, relative to the directory containing the inputDef.", "", "  -T contentType     Defines the default content type for the files read and produced.", "                     The contentType must be one of 'json' or 'xml'. The default content type is", "                     assumed for any file that is not specified explicitly or that does not have a", "                     recognized extension. If omitted, the default content type is derived from the", "                     inputDef name."}) {
                System.err.println(line);
            }
        }

        public void setSamples(int samples) {
            this.getReducerOptions().setSamples(samples);
        }

        public int getSamples() {
            return this.getReducerOptions().getSamples();
        }

        public void setFunction(String function) {
            this.getReducerOptions().setFunction(function);
        }

        public String getFunction() {
            return this.getReducerOptions().getFunction();
        }

        public void setTestDef(File testDef) {
            this.testDef_ = testDef;
        }

        public File getTestDef() {
            return this.testDef_;
        }

        public void setGenDef(File genDef) {
            this.genDef_ = genDef;
        }

        public File getGenDef() {
            return this.genDef_;
        }

        public void setInputDef(File inputDef) {
            this.inputDef_ = inputDef;
        }

        public File getInputDef() {
            return this.inputDef_;
        }

        public void setResampleFactor(double resampleFactor) {
            this.getReducerOptions().setResampleFactor(resampleFactor);
        }

        public double getResampleFactor() {
            return this.getReducerOptions().getResampleFactor();
        }

        public void setNewSeed(boolean newSeed) {
            this.getReducerOptions().setNewSeed(newSeed);
        }

        public boolean isNewSeed() {
            return this.getReducerOptions().isNewSeed();
        }

        public ReducerOptions getReducerOptions() {
            return this.reducerOptions_;
        }

        public void setContentType(String option) {
            Resource.Type contentType = Resource.Type.of((String)option);
            if (option != null && contentType == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid content type", option));
            }
            this.setContentType(contentType);
        }

        public void setContentType(Resource.Type contentType) {
            this.contentType_ = contentType;
        }

        public Resource.Type getContentType() {
            return this.contentType_;
        }

        public void setShowVersion(boolean showVersion) {
            this.showVersion_ = showVersion;
        }

        public boolean showVersion() {
            return this.showVersion_;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.getFunction() != null) {
                builder.append(" -f ").append(this.getFunction());
            }
            if (this.getGenDef() != null) {
                builder.append(" -g ").append(this.getGenDef().getPath());
            }
            builder.append(" -r ").append(this.getResampleFactor());
            builder.append(" -s ").append(this.getSamples());
            if (this.isNewSeed()) {
                builder.append(" -R");
            }
            if (this.getTestDef() != null) {
                builder.append(" -t ").append(this.getTestDef().getPath());
            }
            if (this.getContentType() != null) {
                builder.append(" -T ").append(this.getContentType());
            }
            return builder.toString();
        }

        public static class Builder {
            private Options options_ = new Options();

            public Builder inputDef(File inputDef) {
                this.options_.setInputDef(inputDef);
                return this;
            }

            public Builder testDef(File testDef) {
                this.options_.setTestDef(testDef);
                return this;
            }

            public Builder genDef(File genDef) {
                this.options_.setGenDef(genDef);
                return this;
            }

            public Builder function(String function) {
                this.options_.setFunction(function);
                return this;
            }

            public Builder resampleFactor(double resampleFactor) {
                this.options_.setResampleFactor(resampleFactor);
                return this;
            }

            public Builder newSeed() {
                this.options_.setNewSeed(true);
                return this;
            }

            public Builder samples(int samples) {
                this.options_.setSamples(samples);
                return this;
            }

            public Builder contentType(String type) {
                this.options_.setContentType(type);
                return this;
            }

            public Options build() {
                return this.options_;
            }
        }
    }
}

