/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.cornutum.tcases.Tcases;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static String getVersion() {
        Properties tcasesProperties = new Properties();
        String tcasesPropertyFileName = "/tcases.properties";
        try (InputStream tcasesPropertyFile = Tcases.class.getResourceAsStream(tcasesPropertyFileName);){
            tcasesProperties.load(tcasesPropertyFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't read " + tcasesPropertyFileName, e);
        }
        return String.format("Tcases %s (%s)", tcasesProperties.getProperty("tcases.version"), tcasesProperties.getProperty("tcases.date"));
    }

    public static String getProjectName(File inputDefFile) {
        String projectName = null;
        if (inputDefFile != null) {
            String inputBase = FilenameUtils.getBaseName((String)inputDefFile.getName());
            projectName = inputBase.toLowerCase().endsWith("-input") ? inputBase.substring(0, inputBase.length() - "-input".length()) : inputBase;
        }
        return projectName;
    }

    public static void throwUsageException(String detail) {
        CommandUtils.throwUsageException(detail, null);
    }

    public static void throwUsageException(String detail, Exception cause) {
        throw CommandUtils.getUsageException(detail, cause);
    }

    public static IllegalArgumentException getUsageException(String detail, Exception cause) {
        return new IllegalArgumentException("Invalid command line argument. For all command line details, use the -help option.", new IllegalArgumentException(detail, cause));
    }

    public static void throwMissingValue(String option) {
        CommandUtils.throwUsageException(String.format("No value given for %s option", option));
    }
}

