/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.constretto.ConfigurationStore;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;

public class JsonStore
implements ConfigurationStore {
    private Map<String, TaggedResouce> resources = new HashMap<String, TaggedResouce>();

    public JsonStore() {
    }

    private JsonStore(JsonStore old, String key, TaggedResouce resource) {
        this.resources.putAll(old.resources);
        this.resources.put(key, resource);
    }

    public JsonStore addResource(Resource resource, String key, String ... tags) {
        ArrayList tagList = new ArrayList();
        Collections.addAll(tagList, tags);
        return new JsonStore(this, key, new TaggedResouce(resource, tagList));
    }

    @Override
    public Collection<TaggedPropertySet> parseConfiguration() {
        ArrayList<TaggedPropertySet> properties = new ArrayList<TaggedPropertySet>();
        for (Map.Entry<String, TaggedResouce> entry : this.resources.entrySet()) {
            TaggedResouce taggedResouce = entry.getValue();
            if (!taggedResouce.resource.exists()) continue;
            if (taggedResouce.tags.isEmpty()) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.readJson(taggedResouce.resource));
                properties.add(new TaggedPropertySet(property, JsonStore.class));
                continue;
            }
            for (String tag : taggedResouce.tags) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.readJson(taggedResouce.resource));
                properties.add(new TaggedPropertySet(tag, property, JsonStore.class));
            }
        }
        return properties;
    }

    private String readJson(Resource resource) {
        try {
            int n;
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[4096];
            InputStream inputStream = resource.getInputStream();
            while ((n = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new ConstrettoException("Could not read json file", (Throwable)e);
        }
    }

    private class TaggedResouce {
        public final Resource resource;
        public final List<String> tags = new ArrayList<String>();

        private TaggedResouce(Resource resource, List<String> tags) {
            this.tags.addAll(tags);
            this.resource = resource;
        }
    }
}

