/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.converter;

import java.io.File;
import org.constretto.ValueConverter;
import org.constretto.exception.ConstrettoConversionException;

public class FileValueConverter
implements ValueConverter<File> {
    private final File basedir;
    private final boolean convertToAbsolute;

    public FileValueConverter() {
        this(null);
    }

    public FileValueConverter(File basedir) {
        this(basedir, false);
    }

    public FileValueConverter(File basedir, boolean convertToAbsolute) {
        this.basedir = basedir;
        this.convertToAbsolute = convertToAbsolute;
    }

    public File fromString(String value) throws ConstrettoConversionException {
        File f = new File(value);
        if (this.basedir == null) {
            return this.convertToAbsolute(f);
        }
        if (f.isAbsolute()) {
            return f;
        }
        return this.convertToAbsolute(new File(this.basedir, value));
    }

    private File convertToAbsolute(File f) {
        return this.convertToAbsolute ? f.getAbsoluteFile() : f;
    }
}

