/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.testing;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import libcore.java.security.TestKeyStore;
import org.junit.Assert;

public final class TestUtil {
    private static final Provider JDK_PROVIDER = TestUtil.getDefaultTlsProvider();
    private static final Provider CONSCRYPT_PROVIDER = TestUtil.getConscryptProvider();
    private static final byte[] CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes();
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    public static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    public static final String PROVIDER_PROPERTY = "SSLContext.TLSv1.2";
    public static final String LOCALHOST = "localhost";

    private TestUtil() {
    }

    public static String[] getProtocols() {
        return new String[]{PROTOCOL_TLS_V1_2};
    }

    public static SSLSocketFactory getJdkSocketFactory() {
        return TestUtil.getSocketFactory(JDK_PROVIDER);
    }

    public static SSLServerSocketFactory getJdkServerSocketFactory() {
        return TestUtil.getServerSocketFactory(JDK_PROVIDER);
    }

    public static SSLSocketFactory getConscryptSocketFactory(boolean useEngineSocket) {
        try {
            Class<?> clazz = Class.forName("org.conscrypt.OpenSSLSocketFactoryImpl");
            Method method = clazz.getMethod("setUseEngineSocket", Boolean.TYPE);
            SSLSocketFactory socketFactory = TestUtil.getSocketFactory(CONSCRYPT_PROVIDER);
            method.invoke((Object)socketFactory, useEngineSocket);
            return socketFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLServerSocketFactory getConscryptServerSocketFactory(boolean useEngineSocket) {
        try {
            Class<?> clazz = Class.forName("org.conscrypt.OpenSSLServerSocketFactoryImpl");
            Method method = clazz.getMethod("setUseEngineSocket", Boolean.TYPE);
            SSLServerSocketFactory socketFactory = TestUtil.getServerSocketFactory(CONSCRYPT_PROVIDER);
            method.invoke((Object)socketFactory, useEngineSocket);
            return socketFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SSLSocketFactory getSocketFactory(Provider provider) {
        SSLContext clientContext = TestUtil.initClientSslContext(TestUtil.newContext(provider));
        return clientContext.getSocketFactory();
    }

    private static SSLServerSocketFactory getServerSocketFactory(Provider provider) {
        SSLContext serverContext = TestUtil.initServerSslContext(TestUtil.newContext(provider));
        return serverContext.getServerSocketFactory();
    }

    public static SSLContext newContext(Provider provider) {
        try {
            return SSLContext.getInstance("TLS", provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] newTextMessage(int length) {
        int numChars;
        byte[] msg = new byte[length];
        for (int msgIndex = 0; msgIndex < length; msgIndex += numChars) {
            int remaining = length - msgIndex;
            numChars = Math.min(remaining, CHARS.length);
            System.arraycopy(CHARS, 0, msg, msgIndex, numChars);
        }
        return msg;
    }

    public static SSLEngine initEngine(SSLEngine engine, String cipher, boolean client) {
        engine.setEnabledProtocols(TestUtil.getProtocols());
        engine.setEnabledCipherSuites(new String[]{cipher});
        engine.setUseClientMode(client);
        return engine;
    }

    public static SSLContext initClientSslContext(SSLContext context) {
        return TestUtil.initSslContext(context, TestKeyStore.getClient());
    }

    public static SSLContext initServerSslContext(SSLContext context) {
        return TestUtil.initSslContext(context, TestKeyStore.getServer());
    }

    public static SSLContext initSslContext(SSLContext context, TestKeyStore keyStore) {
        try {
            context.init(keyStore.keyManagers, keyStore.trustManagers, null);
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void doEngineHandshake(SSLEngine clientEngine, SSLEngine serverEngine) throws SSLException {
        ByteBuffer cTOs = ByteBuffer.allocate(clientEngine.getSession().getPacketBufferSize());
        ByteBuffer sTOc = ByteBuffer.allocate(serverEngine.getSession().getPacketBufferSize());
        ByteBuffer serverAppReadBuffer = ByteBuffer.allocate(serverEngine.getSession().getApplicationBufferSize());
        ByteBuffer clientAppReadBuffer = ByteBuffer.allocate(clientEngine.getSession().getApplicationBufferSize());
        clientEngine.beginHandshake();
        serverEngine.beginHandshake();
        ByteBuffer empty = ByteBuffer.allocate(0);
        boolean clientHandshakeFinished = false;
        boolean serverHandshakeFinished = false;
        do {
            int cTOsPos = cTOs.position();
            int sTOcPos = sTOc.position();
            SSLEngineResult clientResult = clientEngine.wrap(empty, cTOs);
            TestUtil.runDelegatedTasks(clientResult, clientEngine);
            SSLEngineResult serverResult = serverEngine.wrap(empty, sTOc);
            TestUtil.runDelegatedTasks(serverResult, serverEngine);
            Assert.assertEquals((long)empty.remaining(), (long)clientResult.bytesConsumed());
            Assert.assertEquals((long)empty.remaining(), (long)serverResult.bytesConsumed());
            Assert.assertEquals((long)(cTOs.position() - cTOsPos), (long)clientResult.bytesProduced());
            Assert.assertEquals((long)(sTOc.position() - sTOcPos), (long)serverResult.bytesProduced());
            cTOs.flip();
            sTOc.flip();
            if (TestUtil.isHandshakeFinished(clientResult)) {
                Assert.assertFalse((boolean)clientHandshakeFinished);
                clientHandshakeFinished = true;
            }
            if (TestUtil.isHandshakeFinished(serverResult)) {
                Assert.assertFalse((boolean)serverHandshakeFinished);
                serverHandshakeFinished = true;
            }
            cTOsPos = cTOs.position();
            sTOcPos = sTOc.position();
            int clientAppReadBufferPos = clientAppReadBuffer.position();
            int serverAppReadBufferPos = serverAppReadBuffer.position();
            clientResult = clientEngine.unwrap(sTOc, clientAppReadBuffer);
            TestUtil.runDelegatedTasks(clientResult, clientEngine);
            serverResult = serverEngine.unwrap(cTOs, serverAppReadBuffer);
            TestUtil.runDelegatedTasks(serverResult, serverEngine);
            Assert.assertEquals((long)(sTOc.position() - sTOcPos), (long)clientResult.bytesConsumed());
            Assert.assertEquals((long)(cTOs.position() - cTOsPos), (long)serverResult.bytesConsumed());
            Assert.assertEquals((long)(clientAppReadBuffer.position() - clientAppReadBufferPos), (long)clientResult.bytesProduced());
            Assert.assertEquals((long)(serverAppReadBuffer.position() - serverAppReadBufferPos), (long)serverResult.bytesProduced());
            cTOs.compact();
            sTOc.compact();
            if (TestUtil.isHandshakeFinished(clientResult)) {
                Assert.assertFalse((boolean)clientHandshakeFinished);
                clientHandshakeFinished = true;
            }
            if (!TestUtil.isHandshakeFinished(serverResult)) continue;
            Assert.assertFalse((boolean)serverHandshakeFinished);
            serverHandshakeFinished = true;
        } while (!clientHandshakeFinished || !serverHandshakeFinished);
    }

    private static boolean isHandshakeFinished(SSLEngineResult result) {
        return result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private static void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task;
            while ((task = engine.getDelegatedTask()) != null) {
                task.run();
            }
        }
    }

    private static Provider getDefaultTlsProvider() {
        for (Provider p : Security.getProviders()) {
            if (p.get(PROVIDER_PROPERTY) == null) continue;
            return p;
        }
        throw new RuntimeException("Unable to find a default provider for SSLContext.TLSv1.2");
    }

    private static final Provider getConscryptProvider() {
        try {
            return (Provider)Class.forName("org.conscrypt.OpenSSLProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

