/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.testing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public final class TestServer {
    private final SSLServerSocket serverSocket;
    private final int messageSize;
    private final byte[] buffer;
    private SSLSocket socket;
    private ExecutorService executor;
    private InputStream inputStream;
    private OutputStream outputStream;
    private volatile boolean stopping;
    private volatile MessageProcessor messageProcessor = new EchoProcessor();

    public TestServer(SSLServerSocket serverSocket, int messageSize) {
        this.serverSocket = serverSocket;
        this.messageSize = messageSize;
        this.buffer = new byte[messageSize];
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public Future<?> start() {
        this.executor = Executors.newSingleThreadExecutor();
        return this.executor.submit(new AcceptTask());
    }

    public void stop() {
        try {
            this.stopping = true;
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.serverSocket.close();
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private final class ProcessTask
    implements Runnable {
        private ProcessTask() {
        }

        @Override
        public void run() {
            try {
                Thread thread = Thread.currentThread();
                while (!TestServer.this.stopping && !thread.isInterrupted()) {
                    int bytesRead = this.readMessage();
                    if (TestServer.this.stopping || thread.isInterrupted()) continue;
                    TestServer.this.messageProcessor.processMessage(TestServer.this.buffer, bytesRead, TestServer.this.outputStream);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private int readMessage() throws IOException {
            int totalBytesRead;
            int bytesRead;
            for (totalBytesRead = 0; totalBytesRead < TestServer.this.messageSize; totalBytesRead += bytesRead) {
                int remaining = TestServer.this.messageSize - totalBytesRead;
                bytesRead = TestServer.this.inputStream.read(TestServer.this.buffer, totalBytesRead, remaining);
                if (bytesRead == -1) break;
            }
            return totalBytesRead;
        }
    }

    private final class AcceptTask
    implements Runnable {
        private AcceptTask() {
        }

        @Override
        public void run() {
            try {
                if (TestServer.this.stopping) {
                    return;
                }
                TestServer.this.socket = (SSLSocket)TestServer.this.serverSocket.accept();
                TestServer.this.inputStream = TestServer.this.socket.getInputStream();
                TestServer.this.outputStream = TestServer.this.socket.getOutputStream();
                if (TestServer.this.stopping) {
                    return;
                }
                TestServer.this.executor.execute(new ProcessTask());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class EchoProcessor
    implements MessageProcessor {
        @Override
        public void processMessage(byte[] message, int numBytes, OutputStream os) {
            try {
                os.write(message, 0, numBytes);
                os.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface MessageProcessor {
        public void processMessage(byte[] var1, int var2, OutputStream var3);
    }
}

