/*
 * Decompiled with CFR 0.152.
 */
package libcore.java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import libcore.java.security.StandardNames;
import libcore.javax.net.ssl.TestKeyManager;
import libcore.javax.net.ssl.TestTrustManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.junit.Assert;

public final class TestKeyStore {
    private static final int DSA_KEY_SIZE_BITS = 1024;
    private static final int EC_KEY_SIZE_BITS = 256;
    private static final int RSA_KEY_SIZE_BITS = 1024;
    private static final BigInteger DH_PARAMS_P = new BigInteger(1, new byte[]{-94, 49, -76, -77, 109, -101, 126, -12, -25, 33, 81, 64, -21, -58, -74, -42, 84, 86, 114, -66, 67, 24, 48, 92, 21, 90, -7, 25, 98, -83, -12, 41, -53, -58, -10, 100, 11, -99, 35, -128, -7, 91, 28, 28, 106, -76, -22, -71, -128, -104, -117, -81, 21, -88, 92, -60, -80, 65, 41, 102, -97, -97, 31, -120, 80, -105, 56, 11, 1, 22, -42, -124, 29, 72, 111, 124, 6, -116, 110, 104, -51, 56, -26, 34, 48, 97, 55, 2, 61, 71, 98, -50, -71, 26, 105, -99, -95, -97, 16, -95, -86, 112, -9, 39, -100, -44, -91, 21, -30, 21, 12, 32, -112, 8, -74, -11, -33, 28, -53, -126, 109, -64, -31, -67, -52, 74, 118, -29});
    private static final BigInteger DH_PARAMS_G = BigInteger.valueOf(2L);
    private static TestKeyStore ROOT_CA;
    private static TestKeyStore INTERMEDIATE_CA;
    private static TestKeyStore INTERMEDIATE_CA_2;
    private static TestKeyStore INTERMEDIATE_CA_EC;
    private static TestKeyStore SERVER;
    private static TestKeyStore CLIENT;
    private static TestKeyStore CLIENT_CERTIFICATE;
    private static TestKeyStore CLIENT_EC_RSA_CERTIFICATE;
    private static TestKeyStore CLIENT_EC_EC_CERTIFICATE;
    private static TestKeyStore CLIENT_2;
    private static final byte[] LOCAL_HOST_ADDRESS;
    private static final String LOCAL_HOST_NAME = "localhost";
    public final KeyStore keyStore;
    public final char[] storePassword;
    public final char[] keyPassword;
    public final KeyManager[] keyManagers;
    public final TrustManager[] trustManagers;
    public final TestTrustManager trustManager;

    private TestKeyStore(KeyStore keyStore, char[] storePassword, char[] keyPassword) {
        this.keyStore = keyStore;
        this.storePassword = storePassword;
        this.keyPassword = keyPassword;
        this.keyManagers = TestKeyStore.createKeyManagers(keyStore, storePassword);
        this.trustManagers = TestKeyStore.createTrustManagers(keyStore);
        this.trustManager = (TestTrustManager)this.trustManagers[0];
    }

    public static KeyManager[] createKeyManagers(KeyStore keyStore, char[] storePassword) {
        try {
            String kmfa = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfa);
            kmf.init(keyStore, storePassword);
            return TestKeyManager.wrap(kmf.getKeyManagers());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TrustManager[] createTrustManagers(KeyStore keyStore) {
        try {
            String tmfa = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfa);
            tmf.init(keyStore);
            return TestTrustManager.wrap(tmf.getTrustManagers());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void initCerts() {
        if (ROOT_CA != null) {
            return;
        }
        ROOT_CA = new Builder().aliasPrefix("RootCA").subject("CN=Test Root Certificate Authority").ca(true).certificateSerialNumber(BigInteger.valueOf(1L)).build();
        INTERMEDIATE_CA_EC = new Builder().aliasPrefix("IntermediateCA-EC").keyAlgorithms("EC").subject("CN=Test Intermediate Certificate Authority ECDSA").ca(true).signer(ROOT_CA.getPrivateKey("RSA", "RSA")).rootCa(ROOT_CA.getRootCertificate("RSA")).certificateSerialNumber(BigInteger.valueOf(2L)).build();
        INTERMEDIATE_CA = new Builder().aliasPrefix("IntermediateCA").subject("CN=Test Intermediate Certificate Authority").ca(true).signer(ROOT_CA.getPrivateKey("RSA", "RSA")).rootCa(ROOT_CA.getRootCertificate("RSA")).certificateSerialNumber(BigInteger.valueOf(2L)).build();
        SERVER = new Builder().aliasPrefix("server").signer(INTERMEDIATE_CA.getPrivateKey("RSA", "RSA")).rootCa(INTERMEDIATE_CA.getRootCertificate("RSA")).addSubjectAltNameIpAddress(LOCAL_HOST_ADDRESS).certificateSerialNumber(BigInteger.valueOf(3L)).build();
        CLIENT = new TestKeyStore(TestKeyStore.createClient(TestKeyStore.INTERMEDIATE_CA.keyStore), null, null);
        CLIENT_EC_RSA_CERTIFICATE = new Builder().aliasPrefix("client-ec").keyAlgorithms("EC").subject("emailAddress=test-ec@user").signer(INTERMEDIATE_CA.getPrivateKey("RSA", "RSA")).rootCa(INTERMEDIATE_CA.getRootCertificate("RSA")).build();
        CLIENT_EC_EC_CERTIFICATE = new Builder().aliasPrefix("client-ec").keyAlgorithms("EC").subject("emailAddress=test-ec@user").signer(INTERMEDIATE_CA_EC.getPrivateKey("EC", "RSA")).rootCa(INTERMEDIATE_CA_EC.getRootCertificate("RSA")).build();
        CLIENT_CERTIFICATE = new Builder().aliasPrefix("client").subject("emailAddress=test@user").signer(INTERMEDIATE_CA.getPrivateKey("RSA", "RSA")).rootCa(INTERMEDIATE_CA.getRootCertificate("RSA")).build();
        TestKeyStore rootCa2 = new Builder().aliasPrefix("RootCA2").subject("CN=Test Root Certificate Authority 2").ca(true).build();
        INTERMEDIATE_CA_2 = new Builder().aliasPrefix("IntermediateCA").subject("CN=Test Intermediate Certificate Authority").ca(true).signer(rootCa2.getPrivateKey("RSA", "RSA")).rootCa(rootCa2.getRootCertificate("RSA")).build();
        CLIENT_2 = new TestKeyStore(TestKeyStore.createClient(rootCa2.keyStore), null, null);
    }

    public static TestKeyStore getRootCa() {
        TestKeyStore.initCerts();
        return ROOT_CA;
    }

    public static TestKeyStore getIntermediateCa() {
        TestKeyStore.initCerts();
        return INTERMEDIATE_CA;
    }

    public static TestKeyStore getIntermediateCa2() {
        TestKeyStore.initCerts();
        return INTERMEDIATE_CA_2;
    }

    public static TestKeyStore getServer() {
        TestKeyStore.initCerts();
        return SERVER;
    }

    public static TestKeyStore getClient() {
        TestKeyStore.initCerts();
        return CLIENT;
    }

    public static TestKeyStore getClientCertificate() {
        TestKeyStore.initCerts();
        return CLIENT_CERTIFICATE;
    }

    public static TestKeyStore getClientEcRsaCertificate() {
        TestKeyStore.initCerts();
        return CLIENT_EC_RSA_CERTIFICATE;
    }

    public static TestKeyStore getClientEcEcCertificate() {
        TestKeyStore.initCerts();
        return CLIENT_EC_EC_CERTIFICATE;
    }

    public static TestKeyStore getClientCA2() {
        TestKeyStore.initCerts();
        return CLIENT_2;
    }

    public static X509Certificate createCa(PublicKey publicKey, PrivateKey privateKey, String subject) {
        try {
            X500Principal principal = new X500Principal(subject);
            return TestKeyStore.createCertificate(publicKey, privateKey, principal, principal, 0, true, new ArrayList<KeyPurposeId>(), new ArrayList<Boolean>(), new ArrayList<GeneralName>(), new ArrayList<GeneralSubtree>(), new ArrayList<GeneralSubtree>(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static X509Certificate createCertificate(PublicKey publicKey, PrivateKey privateKey, X500Principal subject, X500Principal issuer, int keyUsage, boolean ca, List<KeyPurposeId> extendedKeyUsages, List<Boolean> criticalExtendedKeyUsages, List<GeneralName> subjectAltNames, List<GeneralSubtree> permittedNameConstraints, List<GeneralSubtree> excludedNameConstraints, BigInteger serialNumber) throws Exception {
        String signatureAlgorithm;
        long millisPerDay = 86400000L;
        long now = System.currentTimeMillis();
        Date start = new Date(now - millisPerDay);
        Date end = new Date(now + millisPerDay);
        String keyAlgorithm = privateKey.getAlgorithm();
        if (keyAlgorithm.equals("RSA")) {
            signatureAlgorithm = "sha1WithRSA";
        } else if (keyAlgorithm.equals("DSA")) {
            signatureAlgorithm = "sha1WithDSA";
        } else if (keyAlgorithm.equals("EC")) {
            signatureAlgorithm = "sha1WithECDSA";
        } else if (keyAlgorithm.equals("EC_RSA")) {
            signatureAlgorithm = "sha1WithRSA";
        } else {
            throw new IllegalArgumentException("Unknown key algorithm " + keyAlgorithm);
        }
        if (serialNumber == null) {
            byte[] serialBytes = new byte[16];
            new SecureRandom().nextBytes(serialBytes);
            serialNumber = new BigInteger(1, serialBytes);
        }
        X509v3CertificateBuilder x509cg = new X509v3CertificateBuilder(X500Name.getInstance((Object)issuer.getEncoded()), serialNumber, start, end, X500Name.getInstance((Object)subject.getEncoded()), SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
        if (keyUsage != 0) {
            x509cg.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsage));
        }
        if (ca) {
            x509cg.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        }
        for (int i = 0; i < extendedKeyUsages.size(); ++i) {
            KeyPurposeId keyPurposeId = extendedKeyUsages.get(i);
            boolean critical = criticalExtendedKeyUsages.get(i);
            x509cg.addExtension(Extension.extendedKeyUsage, critical, (ASN1Encodable)new ExtendedKeyUsage(keyPurposeId));
        }
        for (GeneralName subjectAltName : subjectAltNames) {
            x509cg.addExtension(Extension.subjectAlternativeName, false, new GeneralNames(subjectAltName).getEncoded());
        }
        if (!permittedNameConstraints.isEmpty() || !excludedNameConstraints.isEmpty()) {
            x509cg.addExtension(Extension.nameConstraints, true, (ASN1Encodable)new NameConstraints(permittedNameConstraints.toArray(new GeneralSubtree[permittedNameConstraints.size()]), excludedNameConstraints.toArray(new GeneralSubtree[excludedNameConstraints.size()])));
        }
        X509CertificateHolder x509holder = x509cg.build(new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey));
        X509Certificate x509c = new JcaX509CertificateConverter().getCertificate(x509holder);
        if (StandardNames.IS_RI) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(x509c.getEncoded());
            Certificate c = cf.generateCertificate(bais);
            x509c = (X509Certificate)c;
        }
        return x509c;
    }

    public static String keyAlgorithm(String algorithm) {
        int index = algorithm.indexOf(95);
        if (index == -1) {
            return algorithm;
        }
        return algorithm.substring(0, index);
    }

    public static String signatureAlgorithm(String algorithm) {
        int index = algorithm.indexOf(95);
        if (index == -1) {
            return algorithm;
        }
        return algorithm.substring(index + 1, algorithm.length());
    }

    public static KeyStore createKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(StandardNames.KEY_STORE_ALGORITHM);
            keyStore.load(null, null);
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStore.PrivateKeyEntry getPrivateKey(String keyAlgorithm, String signatureAlgorithm) {
        return TestKeyStore.privateKey(this.keyStore, this.keyPassword, keyAlgorithm, signatureAlgorithm);
    }

    public static KeyStore.PrivateKeyEntry privateKey(KeyStore keyStore, char[] keyPassword, String keyAlgorithm, String signatureAlgorithm) {
        try {
            KeyStore.PrivateKeyEntry found = null;
            KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(keyPassword);
            for (String alias : Collections.list(keyStore.aliases())) {
                X509Certificate certificate;
                KeyStore.PrivateKeyEntry privateKey;
                if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || !(privateKey = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, password)).getPrivateKey().getAlgorithm().equals(keyAlgorithm) || !(certificate = (X509Certificate)privateKey.getCertificate()).getSigAlgName().contains(signatureAlgorithm)) continue;
                if (found != null) {
                    throw new IllegalStateException("KeyStore has more than one private key for keyAlgorithm: " + keyAlgorithm + " signatureAlgorithm: " + signatureAlgorithm + "\nfirst: " + found.getPrivateKey() + "\nsecond: " + privateKey.getPrivateKey());
                }
                found = privateKey;
            }
            if (found == null) {
                throw new IllegalStateException("KeyStore contained no private key for keyAlgorithm: " + keyAlgorithm + " signatureAlgorithm: " + signatureAlgorithm);
            }
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem getting key for " + keyAlgorithm + " and signature " + signatureAlgorithm, e);
        }
    }

    public Certificate getIssuer(Certificate cert) throws Exception {
        return TestKeyStore.issuer(this.keyStore, cert);
    }

    public static Certificate issuer(KeyStore keyStore, Certificate c) throws Exception {
        if (!(c instanceof X509Certificate)) {
            throw new IllegalStateException("issuer requires an X509Certificate, found " + c);
        }
        X509Certificate cert = (X509Certificate)c;
        Certificate found = null;
        for (String alias : Collections.list(keyStore.aliases())) {
            KeyStore.TrustedCertificateEntry certificateEntry;
            Certificate certificate;
            if (!keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class) || !((certificate = (certificateEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(alias, null)).getTrustedCertificate()) instanceof X509Certificate)) continue;
            X509Certificate x = (X509Certificate)certificate;
            if (!cert.getIssuerDN().equals(x.getSubjectDN())) continue;
            if (found != null) {
                throw new IllegalStateException("KeyStore has more than one issuing CA for " + cert + "\nfirst: " + found + "\nsecond: " + certificate);
            }
            found = certificate;
        }
        if (found == null) {
            throw new IllegalStateException("KeyStore contained no issuing CA for " + cert);
        }
        return found;
    }

    public X509Certificate getRootCertificate(String algorithm) {
        return TestKeyStore.rootCertificate(this.keyStore, algorithm);
    }

    private static OCSPResp generateOCSPResponse(KeyStore.PrivateKeyEntry server, KeyStore.PrivateKeyEntry issuer, CertificateStatus status) throws CertificateException {
        try {
            X509Certificate serverCertJca = (X509Certificate)server.getCertificate();
            X509Certificate caCertJca = (X509Certificate)issuer.getCertificate();
            JcaX509CertificateHolder caCert = new JcaX509CertificateHolder(caCertJca);
            BcDigestCalculatorProvider digCalcProv = new BcDigestCalculatorProvider();
            BasicOCSPRespBuilder basicBuilder = new BasicOCSPRespBuilder(SubjectPublicKeyInfo.getInstance((Object)caCertJca.getPublicKey().getEncoded()), digCalcProv.get(CertificateID.HASH_SHA1));
            CertificateID certId = new CertificateID(digCalcProv.get(CertificateID.HASH_SHA1), (X509CertificateHolder)caCert, serverCertJca.getSerialNumber());
            basicBuilder.addResponse(certId, status);
            BasicOCSPResp resp = basicBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").build(issuer.getPrivateKey()), null, new Date());
            OCSPRespBuilder builder = new OCSPRespBuilder();
            return builder.build(0, (Object)resp);
        }
        catch (Exception e) {
            throw new CertificateException("cannot generate OCSP response", e);
        }
    }

    public static byte[] getOCSPResponseForGood(KeyStore.PrivateKeyEntry server, KeyStore.PrivateKeyEntry issuer) throws CertificateException {
        try {
            return TestKeyStore.generateOCSPResponse(server, issuer, CertificateStatus.GOOD).getEncoded();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public static byte[] getOCSPResponseForRevoked(KeyStore.PrivateKeyEntry server, KeyStore.PrivateKeyEntry issuer) throws CertificateException {
        try {
            return TestKeyStore.generateOCSPResponse(server, issuer, (CertificateStatus)new RevokedStatus(new Date(), 1)).getEncoded();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public static X509Certificate rootCertificate(KeyStore keyStore, String algorithm) {
        try {
            X509Certificate found = null;
            for (String alias : Collections.list(keyStore.aliases())) {
                X509Certificate x;
                KeyStore.TrustedCertificateEntry certificateEntry;
                Certificate certificate;
                if (!keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class) || !(certificate = (certificateEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(alias, null)).getTrustedCertificate()).getPublicKey().getAlgorithm().equals(algorithm) || !(certificate instanceof X509Certificate) || !(x = (X509Certificate)certificate).getIssuerDN().equals(x.getSubjectDN())) continue;
                if (found != null) {
                    throw new IllegalStateException("KeyStore has more than one root CA for " + algorithm + "\nfirst: " + found + "\nsecond: " + certificate);
                }
                found = x;
            }
            if (found == null) {
                throw new IllegalStateException("KeyStore contained no root CA for " + algorithm);
            }
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStore.Entry getEntryByAlias(String alias) {
        return TestKeyStore.entryByAlias(this.keyStore, alias);
    }

    public static KeyStore.Entry entryByAlias(KeyStore keyStore, String alias) {
        try {
            return keyStore.getEntry(alias, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createClient(KeyStore caKeyStore) {
        KeyStore clientKeyStore = TestKeyStore.createKeyStore();
        TestKeyStore.copySelfSignedCertificates(clientKeyStore, caKeyStore);
        return clientKeyStore;
    }

    public static boolean copySelfSignedCertificates(KeyStore dst, KeyStore src) {
        try {
            boolean copied = false;
            for (String alias : Collections.list(src.aliases())) {
                X509Certificate cert;
                if (!src.isCertificateEntry(alias) || !(cert = (X509Certificate)src.getCertificate(alias)).getSubjectDN().equals(cert.getIssuerDN())) continue;
                dst.setCertificateEntry(alias, cert);
                copied = true;
            }
            return copied;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean copyCertificate(Principal subject, KeyStore dst, KeyStore src) throws Exception {
        for (String alias : Collections.list(src.aliases())) {
            X509Certificate cert;
            if (!src.isCertificateEntry(alias) || !(cert = (X509Certificate)src.getCertificate(alias)).getSubjectDN().equals(subject)) continue;
            dst.setCertificateEntry(alias, cert);
            return true;
        }
        return false;
    }

    public void dump(String context) throws KeyStoreException, NoSuchAlgorithmException {
        TestKeyStore.dump(context, this.keyStore, this.keyPassword);
    }

    public static void dump(String context, KeyStore keyStore, char[] keyPassword) throws KeyStoreException, NoSuchAlgorithmException {
        PrintStream out = System.out;
        out.println("context=" + context);
        out.println("\tkeyStore=" + keyStore);
        out.println("\tkeyStore.type=" + keyStore.getType());
        out.println("\tkeyStore.provider=" + keyStore.getProvider());
        out.println("\tkeyPassword=" + (keyPassword == null ? null : new String(keyPassword)));
        out.println("\tsize=" + keyStore.size());
        for (String alias : Collections.list(keyStore.aliases())) {
            out.println("alias=" + alias);
            out.println("\tcreationDate=" + keyStore.getCreationDate(alias));
            if (keyStore.isCertificateEntry(alias)) {
                out.println("\tcertificate:");
                out.println("==========================================");
                out.println(keyStore.getCertificate(alias));
                out.println("==========================================");
                continue;
            }
            if (keyStore.isKeyEntry(alias)) {
                String key;
                out.println("\tkey:");
                out.println("==========================================");
                try {
                    key = "Key retrieved using password\n" + keyStore.getKey(alias, keyPassword);
                }
                catch (UnrecoverableKeyException e1) {
                    try {
                        key = "Key retrieved without password\n" + keyStore.getKey(alias, null);
                    }
                    catch (UnrecoverableKeyException e2) {
                        key = "Key could not be retrieved";
                    }
                }
                out.println(key);
                out.println("==========================================");
                Certificate[] chain = keyStore.getCertificateChain(alias);
                if (chain == null) {
                    out.println("No certificate chain associated with key");
                    out.println("==========================================");
                    continue;
                }
                for (int i = 0; i < chain.length; ++i) {
                    out.println("Certificate chain element #" + i);
                    out.println(chain[i]);
                    out.println("==========================================");
                }
                continue;
            }
            out.println("\tunknown entry type");
        }
    }

    public static void assertChainLength(Object[] chain) {
        Assert.assertEquals((long)3L, (long)chain.length);
    }

    static {
        if (StandardNames.IS_RI) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), Security.getProviders().length + 1);
        } else if (!BouncyCastleProvider.class.getName().startsWith("com.android")) {
            new BouncyCastleProvider();
        }
        LOCAL_HOST_ADDRESS = new byte[]{127, 0, 0, 1};
    }

    public static class Builder {
        private String[] keyAlgorithms = new String[]{"RSA"};
        private char[] storePassword;
        private char[] keyPassword;
        private String aliasPrefix;
        private X500Principal subject;
        private int keyUsage;
        private boolean ca;
        private KeyStore.PrivateKeyEntry privateEntry;
        private KeyStore.PrivateKeyEntry signer;
        private Certificate rootCa;
        private final List<KeyPurposeId> extendedKeyUsages = new ArrayList<KeyPurposeId>();
        private final List<Boolean> criticalExtendedKeyUsages = new ArrayList<Boolean>();
        private final List<GeneralName> subjectAltNames = new ArrayList<GeneralName>();
        private final List<GeneralSubtree> permittedNameConstraints = new ArrayList<GeneralSubtree>();
        private final List<GeneralSubtree> excludedNameConstraints = new ArrayList<GeneralSubtree>();
        private BigInteger certificateSerialNumber = null;

        public Builder() {
            this.subject = this.localhost();
        }

        public Builder keyAlgorithms(String ... keyAlgorithms) {
            this.keyAlgorithms = keyAlgorithms;
            return this;
        }

        public Builder aliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
            return this;
        }

        public Builder subject(X500Principal subject) {
            this.subject = subject;
            return this;
        }

        public Builder subject(String commonName) {
            return this.subject(new X500Principal(commonName));
        }

        public Builder keyUsage(int keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public Builder ca(boolean ca) {
            this.ca = ca;
            return this;
        }

        public Builder privateEntry(KeyStore.PrivateKeyEntry privateEntry) {
            this.privateEntry = privateEntry;
            return this;
        }

        public Builder signer(KeyStore.PrivateKeyEntry signer) {
            this.signer = signer;
            return this;
        }

        public Builder rootCa(Certificate rootCa) {
            this.rootCa = rootCa;
            return this;
        }

        public Builder addExtendedKeyUsage(KeyPurposeId keyPurposeId, boolean critical) {
            this.extendedKeyUsages.add(keyPurposeId);
            this.criticalExtendedKeyUsages.add(critical);
            return this;
        }

        public Builder addSubjectAltName(GeneralName generalName) {
            this.subjectAltNames.add(generalName);
            return this;
        }

        public Builder addSubjectAltNameIpAddress(byte[] ipAddress) {
            return this.addSubjectAltName(new GeneralName(7, (ASN1Encodable)new DEROctetString(ipAddress)));
        }

        private Builder addNameConstraint(boolean permitted, GeneralName generalName) {
            if (permitted) {
                this.permittedNameConstraints.add(new GeneralSubtree(generalName));
            } else {
                this.excludedNameConstraints.add(new GeneralSubtree(generalName));
            }
            return this;
        }

        public Builder addNameConstraint(boolean permitted, byte[] ipAddress) {
            return this.addNameConstraint(permitted, new GeneralName(7, (ASN1Encodable)new DEROctetString(ipAddress)));
        }

        public Builder certificateSerialNumber(BigInteger certificateSerialNumber) {
            this.certificateSerialNumber = certificateSerialNumber;
            return this;
        }

        public TestKeyStore build() {
            try {
                if (StandardNames.IS_RI) {
                    if (this.storePassword == null) {
                        this.storePassword = "password".toCharArray();
                    }
                    if (this.keyPassword == null) {
                        this.keyPassword = "password".toCharArray();
                    }
                }
                if (!(this.privateEntry == null || this.keyAlgorithms.length == 1 && "RSA".equals(this.keyAlgorithms[0]))) {
                    throw new IllegalStateException("Only reusing an existing key is implemented for RSA");
                }
                KeyStore keyStore = TestKeyStore.createKeyStore();
                for (String keyAlgorithm : this.keyAlgorithms) {
                    String publicAlias = this.aliasPrefix + "-public-" + keyAlgorithm;
                    String privateAlias = this.aliasPrefix + "-private-" + keyAlgorithm;
                    if ((keyAlgorithm.equals("EC_RSA") || keyAlgorithm.equals("DH_RSA")) && this.signer == null && this.rootCa == null) {
                        this.createKeys(keyStore, keyAlgorithm, publicAlias, privateAlias, null, TestKeyStore.privateKey(keyStore, this.keyPassword, "RSA", "RSA"));
                        continue;
                    }
                    if (keyAlgorithm.equals("DH_DSA") && this.signer == null && this.rootCa == null) {
                        this.createKeys(keyStore, keyAlgorithm, publicAlias, privateAlias, null, TestKeyStore.privateKey(keyStore, this.keyPassword, "DSA", "DSA"));
                        continue;
                    }
                    this.createKeys(keyStore, keyAlgorithm, publicAlias, privateAlias, this.privateEntry, this.signer);
                }
                if (this.rootCa != null) {
                    keyStore.setCertificateEntry(this.aliasPrefix + "-root-ca-" + this.rootCa.getPublicKey().getAlgorithm(), this.rootCa);
                }
                return new TestKeyStore(keyStore, this.storePassword, this.keyPassword);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private KeyStore createKeys(KeyStore keyStore, String keyAlgorithm, String publicAlias, String privateAlias, KeyStore.PrivateKeyEntry privateEntry, KeyStore.PrivateKeyEntry signer) throws Exception {
            Certificate[] x509cc;
            X509Certificate x509c;
            PrivateKey privateKey;
            X509Certificate[] caCertChain;
            X509Certificate caCert;
            PrivateKey caKey;
            if (signer == null) {
                caKey = null;
                caCert = null;
                caCertChain = null;
            } else {
                caKey = signer.getPrivateKey();
                caCert = (X509Certificate)signer.getCertificate();
                caCertChain = (X509Certificate[])signer.getCertificateChain();
            }
            if (publicAlias == null && privateAlias == null) {
                privateKey = null;
                Object publicKey = null;
                x509c = null;
            } else {
                PublicKey publicKey;
                if (privateEntry == null) {
                    int keySize = -1;
                    DHParameterSpec spec = null;
                    if (keyAlgorithm.equals("RSA")) {
                        keySize = 1024;
                    } else if (keyAlgorithm.equals("DH_RSA")) {
                        spec = new DHParameterSpec(DH_PARAMS_P, DH_PARAMS_G);
                        keyAlgorithm = "DH";
                    } else if (keyAlgorithm.equals("DSA")) {
                        keySize = 1024;
                    } else if (keyAlgorithm.equals("DH_DSA")) {
                        spec = new DHParameterSpec(DH_PARAMS_P, DH_PARAMS_G);
                        keyAlgorithm = "DH";
                    } else if (keyAlgorithm.equals("EC")) {
                        keySize = 256;
                    } else if (keyAlgorithm.equals("EC_RSA")) {
                        keySize = 256;
                        keyAlgorithm = "EC";
                    } else {
                        throw new IllegalArgumentException("Unknown key algorithm " + keyAlgorithm);
                    }
                    KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyAlgorithm);
                    if (spec != null) {
                        kpg.initialize(spec);
                    } else if (keySize != -1) {
                        kpg.initialize(keySize);
                    } else {
                        throw new AssertionError((Object)"Must either have set algorithm parameters or key size!");
                    }
                    KeyPair kp = kpg.generateKeyPair();
                    privateKey = kp.getPrivate();
                    publicKey = kp.getPublic();
                } else {
                    privateKey = privateEntry.getPrivateKey();
                    publicKey = privateEntry.getCertificate().getPublicKey();
                }
                X500Principal issuer = caCert != null ? caCert.getSubjectX500Principal() : this.subject;
                PrivateKey signingKey = caKey == null ? privateKey : caKey;
                x509c = TestKeyStore.createCertificate(publicKey, signingKey, this.subject, issuer, this.keyUsage, this.ca, this.extendedKeyUsages, this.criticalExtendedKeyUsages, this.subjectAltNames, this.permittedNameConstraints, this.excludedNameConstraints, this.certificateSerialNumber);
            }
            if (privateAlias == null) {
                x509cc = null;
            } else if (caCertChain == null) {
                x509cc = new X509Certificate[]{x509c};
            } else {
                x509cc = new X509Certificate[caCertChain.length + 1];
                x509cc[0] = x509c;
                System.arraycopy(caCertChain, 0, x509cc, 1, caCertChain.length);
            }
            if (privateAlias != null) {
                keyStore.setKeyEntry(privateAlias, privateKey, this.keyPassword, x509cc);
            }
            if (publicAlias != null) {
                keyStore.setCertificateEntry(publicAlias, x509c);
            }
            return keyStore;
        }

        private X500Principal localhost() {
            return new X500Principal("CN=localhost");
        }
    }
}

