/*
 * Decompiled with CFR 0.152.
 */
package libcore.java.security;

import java.security.Security;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import libcore.java.security.CpuFeatures;
import org.junit.Assert;

public final class StandardNames {
    public static final boolean IS_RI = !"Dalvik Core Library".equals(System.getProperty("java.specification.name"));
    public static final String JSSE_PROVIDER_NAME = IS_RI ? "SunJSSE" : "AndroidOpenSSL";
    public static final String SECURITY_PROVIDER_NAME = IS_RI ? "SUN" : "BC";
    public static final String KEY_MANAGER_FACTORY_DEFAULT = IS_RI ? "SunX509" : "PKIX";
    public static final String TRUST_MANAGER_FACTORY_DEFAULT = "PKIX";
    public static final String KEY_STORE_ALGORITHM = IS_RI ? "JKS" : "BKS";
    public static final String CIPHER_SUITE_SECURE_RENEGOTIATION = "TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
    public static final String CIPHER_SUITE_FALLBACK = "TLS_FALLBACK_SCSV";
    public static final HashMap<String, HashSet<String>> PROVIDER_ALGORITHMS = new HashMap();
    public static final HashMap<String, HashSet<String>> CIPHER_MODES = new HashMap();
    public static final HashMap<String, HashSet<String>> CIPHER_PADDINGS = new HashMap();
    private static final HashMap<String, String[]> SSL_CONTEXT_PROTOCOLS_ENABLED = new HashMap();
    public static final String SSL_CONTEXT_PROTOCOLS_DEFAULT = "Default";
    public static final Set<String> SSL_CONTEXT_PROTOCOLS;
    public static final String SSL_CONTEXT_PROTOCOL_DEFAULT = "TLS";
    public static final Set<String> KEY_TYPES;
    public static final Set<String> SSL_SOCKET_PROTOCOLS;
    public static final Set<String> SSL_SOCKET_PROTOCOLS_CLIENT_DEFAULT;
    public static final Set<String> SSL_SOCKET_PROTOCOLS_SERVER_DEFAULT;
    public static final Set<String> CLIENT_AUTH_TYPES;
    public static final Set<String> SERVER_AUTH_TYPES;
    public static final String CIPHER_SUITE_INVALID = "SSL_NULL_WITH_NULL_NULL";
    public static final Set<String> CIPHER_SUITES_NEITHER;
    public static final Set<String> CIPHER_SUITES_RI;
    public static final Set<String> CIPHER_SUITES_OPENSSL;
    public static final Set<String> CIPHER_SUITES;
    public static final List<String> CIPHER_SUITES_OBSOLETE_TLS12;
    private static final List<String> CIPHER_SUITES_ANDROID_AES_HARDWARE;
    private static final List<String> CIPHER_SUITES_ANDROID_SOFTWARE;
    public static final List<String> CIPHER_SUITES_DEFAULT;
    public static final List<String> CIPHER_SUITES_DEFAULT_PSK;
    public static final List<String> ELLIPTIC_CURVES_DEFAULT;
    private static final Set<String> PERMITTED_DEFAULT_KEY_EXCHANGE_ALGS;
    private static final Set<String> PERMITTED_DEFAULT_BULK_ENCRYPTION_CIPHERS;
    private static final Set<String> PERMITTED_DEFAULT_MACS;
    public static final Map<String, Class<? extends KeySpec>> PRIVATE_KEY_SPEC_CLASSES;
    public static final Map<String, Class<? extends KeySpec>> PUBLIC_KEY_SPEC_CLASSES;
    public static final Map<String, Integer> MINIMUM_KEY_SIZE;

    private static void provide(String type, String algorithm) {
        HashSet<String> algorithms = PROVIDER_ALGORITHMS.get(type);
        if (algorithms == null) {
            algorithms = new HashSet();
            PROVIDER_ALGORITHMS.put(type, algorithms);
        }
        Assert.assertTrue((String)("Duplicate " + type + " " + algorithm), (boolean)algorithms.add(algorithm.toUpperCase(Locale.ROOT)));
    }

    private static void unprovide(String type, String algorithm) {
        HashSet<String> algorithms = PROVIDER_ALGORITHMS.get(type);
        Assert.assertNotNull(algorithms);
        Assert.assertTrue((String)algorithm, (boolean)algorithms.remove(algorithm.toUpperCase(Locale.ROOT)));
        if (algorithms.isEmpty()) {
            Assert.assertNotNull(PROVIDER_ALGORITHMS.remove(type));
        }
    }

    private static void provideCipherModes(String algorithm, String[] newModes) {
        HashSet<String> modes = CIPHER_MODES.get(algorithm);
        if (modes == null) {
            modes = new HashSet();
            CIPHER_MODES.put(algorithm, modes);
        }
        modes.addAll(Arrays.asList(newModes));
    }

    private static void provideCipherPaddings(String algorithm, String[] newPaddings) {
        HashSet<String> paddings = CIPHER_PADDINGS.get(algorithm);
        if (paddings == null) {
            paddings = new HashSet();
            CIPHER_PADDINGS.put(algorithm, paddings);
        }
        paddings.addAll(Arrays.asList(newPaddings));
    }

    private static void provideSslContextEnabledProtocols(String algorithm, TLSVersion minimum, TLSVersion maximum) {
        if (minimum.ordinal() > maximum.ordinal()) {
            throw new RuntimeException("TLS version: minimum > maximum");
        }
        int versionsLength = maximum.ordinal() - minimum.ordinal() + 1;
        String[] versionNames = new String[versionsLength];
        for (int i = 0; i < versionsLength; ++i) {
            versionNames[i] = TLSVersion.values()[i + minimum.ordinal()].name;
        }
        SSL_CONTEXT_PROTOCOLS_ENABLED.put(algorithm, versionNames);
    }

    private static final void addRi(String cipherSuite) {
        CIPHER_SUITES_RI.add(cipherSuite);
    }

    private static final void addOpenSsl(String cipherSuite) {
        CIPHER_SUITES_OPENSSL.add(cipherSuite);
    }

    private static final void addBoth(String cipherSuite) {
        StandardNames.addRi(cipherSuite);
        StandardNames.addOpenSsl(cipherSuite);
    }

    private static final void addNeither(String cipherSuite) {
        CIPHER_SUITES_NEITHER.add(cipherSuite);
    }

    public static Class<? extends KeySpec> getPrivateKeySpecClass(String algName) {
        return PRIVATE_KEY_SPEC_CLASSES.get(algName);
    }

    public static Class<? extends KeySpec> getPublicKeySpecClass(String algName) {
        return PUBLIC_KEY_SPEC_CLASSES.get(algName);
    }

    public static int getMinimumKeySize(String algName) {
        return MINIMUM_KEY_SIZE.get(algName);
    }

    private static Set<String> assertValidCipherSuites(Set<String> expected, String[] cipherSuites) {
        Assert.assertNotNull((Object)cipherSuites);
        Assert.assertTrue((cipherSuites.length != 0 ? 1 : 0) != 0);
        HashSet<String> remainingCipherSuites = new HashSet<String>(expected);
        HashSet<String> unknownCipherSuites = new HashSet<String>();
        for (String cipherSuite : cipherSuites) {
            boolean removed = remainingCipherSuites.remove(cipherSuite);
            if (removed) continue;
            unknownCipherSuites.add(cipherSuite);
        }
        Assert.assertEquals((String)"Unknown cipher suites", (Object)Collections.EMPTY_SET, unknownCipherSuites);
        return remainingCipherSuites;
    }

    private static void assertSupportedCipherSuites(Set<String> expected, String[] cipherSuites) {
        Set<String> remainingCipherSuites = StandardNames.assertValidCipherSuites(expected, cipherSuites);
        Assert.assertEquals((String)"Missing cipher suites", (Object)Collections.EMPTY_SET, remainingCipherSuites);
        Assert.assertEquals((long)expected.size(), (long)cipherSuites.length);
    }

    private static Set<String> assertValidProtocols(Set<String> expected, String[] protocols) {
        Assert.assertNotNull((Object)protocols);
        Assert.assertTrue((protocols.length != 0 ? 1 : 0) != 0);
        HashSet<String> remainingProtocols = new HashSet<String>(expected);
        HashSet<String> unknownProtocols = new HashSet<String>();
        for (String protocol : protocols) {
            if (remainingProtocols.remove(protocol)) continue;
            unknownProtocols.add(protocol);
        }
        Assert.assertEquals((String)"Unknown protocols", (Object)Collections.EMPTY_SET, unknownProtocols);
        return remainingProtocols;
    }

    private static void assertSupportedProtocols(Set<String> expected, String[] protocols) {
        Set<String> remainingProtocols = StandardNames.assertValidProtocols(expected, protocols);
        Assert.assertEquals((String)"Missing protocols", (Object)Collections.EMPTY_SET, remainingProtocols);
        Assert.assertEquals((long)expected.size(), (long)protocols.length);
    }

    public static void assertSupportedProtocols(String[] protocols) {
        StandardNames.assertSupportedProtocols(SSL_SOCKET_PROTOCOLS, protocols);
    }

    public static void assertValidCipherSuites(String[] cipherSuites) {
        StandardNames.assertValidCipherSuites(CIPHER_SUITES, cipherSuites);
    }

    public static void assertSupportedCipherSuites(String[] cipherSuites) {
        StandardNames.assertSupportedCipherSuites(CIPHER_SUITES, cipherSuites);
    }

    public static void assertDefaultCipherSuites(String[] cipherSuites) {
        StandardNames.assertValidCipherSuites(cipherSuites);
        Assert.assertEquals(CIPHER_SUITES_DEFAULT, Arrays.asList(cipherSuites));
        if (!IS_RI) {
            ArrayList<String> disallowedDefaultCipherSuites = new ArrayList<String>();
            for (String cipherSuite : cipherSuites) {
                if (StandardNames.isPermittedDefaultCipherSuite(cipherSuite)) continue;
                disallowedDefaultCipherSuites.add(cipherSuite);
            }
            Assert.assertEquals((Object)Collections.EMPTY_LIST, disallowedDefaultCipherSuites);
        }
    }

    public static void assertDefaultEllipticCurves(String[] curves) {
        Assert.assertEquals(ELLIPTIC_CURVES_DEFAULT, Arrays.asList(curves));
    }

    public static void assertSSLContextEnabledProtocols(String version, String[] protocols) {
        Assert.assertEquals((String)("For protocol \"" + version + "\""), (Object)Arrays.toString(SSL_CONTEXT_PROTOCOLS_ENABLED.get(version)), (Object)Arrays.toString(protocols));
    }

    private static boolean isPermittedDefaultCipherSuite(String cipherSuite) {
        Assert.assertNotNull((Object)cipherSuite);
        if (CIPHER_SUITE_SECURE_RENEGOTIATION.equals(cipherSuite)) {
            return true;
        }
        Assert.assertTrue((String)cipherSuite, (cipherSuite.startsWith("TLS_") || cipherSuite.startsWith("SSL_") ? 1 : 0) != 0);
        String remainder = cipherSuite.substring("TLS_".length());
        int macDelimiterIndex = remainder.lastIndexOf(95);
        Assert.assertTrue((String)cipherSuite, (macDelimiterIndex != -1 ? 1 : 0) != 0);
        String mac = remainder.substring(macDelimiterIndex + 1);
        remainder = remainder.substring(0, macDelimiterIndex);
        int withDelimiterIndex = remainder.indexOf("_WITH_");
        Assert.assertTrue((String)cipherSuite, (withDelimiterIndex != -1 ? 1 : 0) != 0);
        String keyExchange = remainder.substring(0, withDelimiterIndex);
        String bulkEncryptionCipher = remainder.substring(withDelimiterIndex + "_WITH_".length());
        if (!PERMITTED_DEFAULT_MACS.contains(mac)) {
            return false;
        }
        if (!PERMITTED_DEFAULT_KEY_EXCHANGE_ALGS.contains(keyExchange)) {
            return false;
        }
        return PERMITTED_DEFAULT_BULK_ENCRYPTION_CIPHERS.contains(bulkEncryptionCipher);
    }

    public static Set<String> getModesForCipher(String cipher) {
        return CIPHER_MODES.get(cipher);
    }

    public static Set<String> getPaddingsForCipher(String cipher) {
        return CIPHER_PADDINGS.get(cipher);
    }

    static {
        StandardNames.provide("AlgorithmParameterGenerator", "DSA");
        StandardNames.provide("AlgorithmParameterGenerator", "DiffieHellman");
        StandardNames.provide("AlgorithmParameters", "AES");
        StandardNames.provide("AlgorithmParameters", "Blowfish");
        StandardNames.provide("AlgorithmParameters", "DES");
        StandardNames.provide("AlgorithmParameters", "DESede");
        StandardNames.provide("AlgorithmParameters", "DSA");
        StandardNames.provide("AlgorithmParameters", "DiffieHellman");
        StandardNames.provide("AlgorithmParameters", "GCM");
        StandardNames.provide("AlgorithmParameters", "OAEP");
        StandardNames.provide("AlgorithmParameters", "PBEWithMD5AndDES");
        StandardNames.provide("AlgorithmParameters", "PBEWithMD5AndTripleDES");
        StandardNames.provide("AlgorithmParameters", "PBEWithSHA1AndDESede");
        StandardNames.provide("AlgorithmParameters", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("AlgorithmParameters", "PSS");
        StandardNames.provide("AlgorithmParameters", "RC2");
        StandardNames.provide("CertPathBuilder", TRUST_MANAGER_FACTORY_DEFAULT);
        StandardNames.provide("CertPathValidator", TRUST_MANAGER_FACTORY_DEFAULT);
        StandardNames.provide("CertStore", "Collection");
        StandardNames.provide("CertStore", "LDAP");
        StandardNames.provide("CertificateFactory", "X.509");
        StandardNames.provide("Cipher", "AES");
        StandardNames.provideCipherModes("AES", new String[]{"CBC", "CFB", "CTR", "CTS", "ECB", "OFB"});
        StandardNames.provideCipherPaddings("AES", new String[]{"NoPadding", "PKCS5Padding"});
        StandardNames.provide("Cipher", "AESWrap");
        StandardNames.provide("Cipher", "ARCFOUR");
        StandardNames.provide("Cipher", "Blowfish");
        StandardNames.provide("Cipher", "DES");
        StandardNames.provide("Cipher", "DESede");
        StandardNames.provide("Cipher", "DESedeWrap");
        StandardNames.provide("Cipher", "PBEWithMD5AndDES");
        StandardNames.provide("Cipher", "PBEWithMD5AndTripleDES");
        StandardNames.provide("Cipher", "PBEWithSHA1AndDESede");
        StandardNames.provide("Cipher", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("Cipher", "RC2");
        StandardNames.provide("Cipher", "RSA");
        StandardNames.provideCipherModes("RSA", new String[]{"ECB"});
        StandardNames.provideCipherPaddings("RSA", new String[]{"NoPadding", "PKCS1Padding"});
        StandardNames.provide("Configuration", "JavaLoginConfig");
        StandardNames.provide("KeyAgreement", "DiffieHellman");
        StandardNames.provide("KeyFactory", "DSA");
        StandardNames.provide("KeyFactory", "DiffieHellman");
        StandardNames.provide("KeyFactory", "RSA");
        StandardNames.provide("KeyGenerator", "AES");
        StandardNames.provide("KeyGenerator", "ARCFOUR");
        StandardNames.provide("KeyGenerator", "Blowfish");
        StandardNames.provide("KeyGenerator", "DES");
        StandardNames.provide("KeyGenerator", "DESede");
        StandardNames.provide("KeyGenerator", "HmacMD5");
        StandardNames.provide("KeyGenerator", "HmacSHA1");
        StandardNames.provide("KeyGenerator", "HmacSHA224");
        StandardNames.provide("KeyGenerator", "HmacSHA256");
        StandardNames.provide("KeyGenerator", "HmacSHA384");
        StandardNames.provide("KeyGenerator", "HmacSHA512");
        StandardNames.provide("KeyGenerator", "RC2");
        StandardNames.provide("KeyInfoFactory", "DOM");
        StandardNames.provide("KeyManagerFactory", TRUST_MANAGER_FACTORY_DEFAULT);
        StandardNames.provide("KeyPairGenerator", "DSA");
        StandardNames.provide("KeyPairGenerator", "DiffieHellman");
        StandardNames.provide("KeyPairGenerator", "RSA");
        StandardNames.provide("KeyStore", "JCEKS");
        StandardNames.provide("KeyStore", "JKS");
        StandardNames.provide("KeyStore", "PKCS12");
        StandardNames.provide("Mac", "HmacMD5");
        StandardNames.provide("Mac", "HmacSHA1");
        StandardNames.provide("Mac", "HmacSHA224");
        StandardNames.provide("Mac", "HmacSHA256");
        StandardNames.provide("Mac", "HmacSHA384");
        StandardNames.provide("Mac", "HmacSHA512");
        StandardNames.provide("Mac", "PBEWITHHMACSHA224");
        StandardNames.provide("Mac", "PBEWITHHMACSHA256");
        StandardNames.provide("Mac", "PBEWITHHMACSHA384");
        StandardNames.provide("Mac", "PBEWITHHMACSHA512");
        StandardNames.provide("MessageDigest", "MD2");
        StandardNames.provide("MessageDigest", "MD5");
        StandardNames.provide("MessageDigest", "SHA-224");
        StandardNames.provide("MessageDigest", "SHA-256");
        StandardNames.provide("MessageDigest", "SHA-384");
        StandardNames.provide("MessageDigest", "SHA-512");
        StandardNames.provide("Policy", "JavaPolicy");
        if (IS_RI) {
            StandardNames.provide("SSLContext", "SSLv3");
        }
        StandardNames.provide("SSLContext", "TLSv1");
        StandardNames.provide("SSLContext", "TLSv1.1");
        StandardNames.provide("SSLContext", "TLSv1.2");
        StandardNames.provide("SecretKeyFactory", "DES");
        StandardNames.provide("SecretKeyFactory", "DESede");
        StandardNames.provide("SecretKeyFactory", "PBEWithMD5AndDES");
        StandardNames.provide("SecretKeyFactory", "PBEWithMD5AndTripleDES");
        StandardNames.provide("SecretKeyFactory", "PBEWithSHA1AndDESede");
        StandardNames.provide("SecretKeyFactory", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA1");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA224");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA256");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA384");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA512");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA1And8bit");
        StandardNames.provide("SecureRandom", "SHA1PRNG");
        StandardNames.provide("Signature", "MD2withRSA");
        StandardNames.provide("Signature", "MD5withRSA");
        StandardNames.provide("Signature", "NONEwithDSA");
        StandardNames.provide("Signature", "SHA1withDSA");
        StandardNames.provide("Signature", "SHA224withDSA");
        StandardNames.provide("Signature", "SHA256withDSA");
        StandardNames.provide("Signature", "SHA1withRSA");
        StandardNames.provide("Signature", "SHA224withRSA");
        StandardNames.provide("Signature", "SHA256withRSA");
        StandardNames.provide("Signature", "SHA384withRSA");
        StandardNames.provide("Signature", "SHA512withRSA");
        StandardNames.provide("TerminalFactory", "PC/SC");
        StandardNames.provide("TransformService", "http://www.w3.org/2000/09/xmldsig#base64");
        StandardNames.provide("TransformService", "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        StandardNames.provide("TransformService", "http://www.w3.org/2001/10/xml-exc-c14n#");
        StandardNames.provide("TransformService", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        StandardNames.provide("TransformService", "http://www.w3.org/2002/06/xmldsig-filter2");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/1999/REC-xslt-19991116");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        StandardNames.provide("TrustManagerFactory", TRUST_MANAGER_FACTORY_DEFAULT);
        StandardNames.provide("XMLSignatureFactory", "DOM");
        StandardNames.provide("GssApiMechanism", "1.2.840.113554.1.2.2");
        StandardNames.provide("GssApiMechanism", "1.3.6.1.5.5.2");
        StandardNames.provide("SaslClientFactory", "CRAM-MD5");
        StandardNames.provide("SaslClientFactory", "DIGEST-MD5");
        StandardNames.provide("SaslClientFactory", "EXTERNAL");
        StandardNames.provide("SaslClientFactory", "GSSAPI");
        StandardNames.provide("SaslClientFactory", "PLAIN");
        StandardNames.provide("SaslServerFactory", "CRAM-MD5");
        StandardNames.provide("SaslServerFactory", "DIGEST-MD5");
        StandardNames.provide("SaslServerFactory", "GSSAPI");
        StandardNames.provide("MessageDigest", "SHA");
        StandardNames.provide("SSLContext", SSL_CONTEXT_PROTOCOLS_DEFAULT);
        StandardNames.provide("AlgorithmParameters", "PBE");
        if (IS_RI) {
            StandardNames.provide("SSLContext", "SSL");
        }
        StandardNames.provide("SSLContext", SSL_CONTEXT_PROTOCOL_DEFAULT);
        if (IS_RI) {
            StandardNames.provide("CertStore", "com.sun.security.IndexedCollection");
            StandardNames.provide("KeyGenerator", "SunTlsKeyMaterial");
            StandardNames.provide("KeyGenerator", "SunTlsMasterSecret");
            StandardNames.provide("KeyGenerator", "SunTlsPrf");
            StandardNames.provide("KeyGenerator", "SunTlsRsaPremasterSecret");
            StandardNames.provide("KeyStore", "CaseExactJKS");
            StandardNames.provide("Mac", "HmacPBESHA1");
            StandardNames.provide("Mac", "SslMacMD5");
            StandardNames.provide("Mac", "SslMacSHA1");
            StandardNames.provide("SecureRandom", "NativePRNG");
            StandardNames.provide("Signature", "MD5andSHA1withRSA");
            StandardNames.provide("TrustManagerFactory", "SunX509");
        }
        if (Security.getProvider("SunPKCS11-NSS") != null) {
            StandardNames.provide("Cipher", "AES/CBC/NOPADDING");
            StandardNames.provide("Cipher", "DES/CBC/NOPADDING");
            StandardNames.provide("Cipher", "DESEDE/CBC/NOPADDING");
            StandardNames.provide("Cipher", "RSA/ECB/PKCS1PADDING");
            StandardNames.provide("KeyAgreement", "DH");
            StandardNames.provide("KeyFactory", "DH");
            StandardNames.provide("KeyPairGenerator", "DH");
            StandardNames.provide("KeyStore", "PKCS11");
            StandardNames.provide("MessageDigest", "SHA1");
            StandardNames.provide("SecretKeyFactory", "AES");
            StandardNames.provide("SecretKeyFactory", "ARCFOUR");
            StandardNames.provide("SecureRandom", "PKCS11");
            StandardNames.provide("Signature", "DSA");
            StandardNames.provide("Signature", "RAWDSA");
        }
        if (Security.getProvider("SunPKCS11-NSS") != null || Security.getProvider("SunEC") != null) {
            StandardNames.provide("AlgorithmParameters", "EC");
            StandardNames.provide("KeyAgreement", "ECDH");
            StandardNames.provide("KeyFactory", "EC");
            StandardNames.provide("KeyPairGenerator", "EC");
            StandardNames.provide("Signature", "NONEWITHECDSA");
            StandardNames.provide("Signature", "SHA1WITHECDSA");
            StandardNames.provide("Signature", "SHA224WITHECDSA");
            StandardNames.provide("Signature", "SHA256WITHECDSA");
            StandardNames.provide("Signature", "SHA384WITHECDSA");
            StandardNames.provide("Signature", "SHA512WITHECDSA");
        }
        if (IS_RI) {
            StandardNames.unprovide("SSLContext", "TLSv1.1");
            StandardNames.unprovide("SSLContext", "TLSv1.2");
        }
        if (IS_RI) {
            StandardNames.unprovide("KeyManagerFactory", TRUST_MANAGER_FACTORY_DEFAULT);
            StandardNames.provide("KeyManagerFactory", "SunX509");
            StandardNames.provide("KeyManagerFactory", "NewSunX509");
        }
        if (!IS_RI) {
            PROVIDER_ALGORITHMS.remove("Configuration");
            PROVIDER_ALGORITHMS.remove("GssApiMechanism");
            PROVIDER_ALGORITHMS.remove("KeyInfoFactory");
            PROVIDER_ALGORITHMS.remove("Policy");
            PROVIDER_ALGORITHMS.remove("SaslClientFactory");
            PROVIDER_ALGORITHMS.remove("SaslServerFactory");
            PROVIDER_ALGORITHMS.remove("TerminalFactory");
            PROVIDER_ALGORITHMS.remove("TransformService");
            PROVIDER_ALGORITHMS.remove("XMLSignatureFactory");
            StandardNames.unprovide("AlgorithmParameterGenerator", "DiffieHellman");
            StandardNames.provide("AlgorithmParameterGenerator", "DH");
            StandardNames.unprovide("AlgorithmParameters", "DiffieHellman");
            StandardNames.provide("AlgorithmParameters", "DH");
            StandardNames.unprovide("KeyAgreement", "DiffieHellman");
            StandardNames.provide("KeyAgreement", "DH");
            StandardNames.unprovide("KeyFactory", "DiffieHellman");
            StandardNames.provide("KeyFactory", "DH");
            StandardNames.unprovide("KeyPairGenerator", "DiffieHellman");
            StandardNames.provide("KeyPairGenerator", "DH");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithSHA1AndDESede");
            StandardNames.unprovide("Cipher", "PBEWithSHA1AndDESede");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithSHA1AndDESede");
            StandardNames.provide("AlgorithmParameters", "PKCS12PBE");
            StandardNames.provide("Cipher", "PBEWithSHAAnd3-KEYTripleDES-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWithSHAAnd3-KEYTripleDES-CBC");
            StandardNames.unprovide("MessageDigest", "SHA");
            StandardNames.provide("MessageDigest", "SHA-1");
            StandardNames.provide("Signature", "NONEwithRSA");
            StandardNames.provide("Cipher", "RSA/ECB/NOPADDING");
            StandardNames.provide("Cipher", "RSA/ECB/PKCS1PADDING");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPPadding");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPWithSHA-224AndMGF1Padding");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPWithSHA-384AndMGF1Padding");
            StandardNames.provide("Cipher", "RSA/ECB/OAEPWithSHA-512AndMGF1Padding");
            StandardNames.provide("SecretKeyFactory", "AES");
            StandardNames.provide("SecretKeyFactory", "HmacSHA1");
            StandardNames.provide("SecretKeyFactory", "HmacSHA224");
            StandardNames.provide("SecretKeyFactory", "HmacSHA256");
            StandardNames.provide("SecretKeyFactory", "HmacSHA384");
            StandardNames.provide("SecretKeyFactory", "HmacSHA512");
            StandardNames.provide("Signature", "SHA1withRSA/PSS");
            StandardNames.provide("Signature", "SHA224withRSA/PSS");
            StandardNames.provide("Signature", "SHA256withRSA/PSS");
            StandardNames.provide("Signature", "SHA384withRSA/PSS");
            StandardNames.provide("Signature", "SHA512withRSA/PSS");
            StandardNames.unprovide("Cipher", "ARCFOUR");
            StandardNames.provide("Cipher", "ARC4");
            StandardNames.unprovide("KeyGenerator", "ARCFOUR");
            StandardNames.provide("KeyGenerator", "ARC4");
            StandardNames.unprovide("AlgorithmParameters", "Blowfish");
            StandardNames.provide("AlgorithmParameters", "BLOWFISH");
            StandardNames.unprovide("Cipher", "Blowfish");
            StandardNames.provide("Cipher", "BLOWFISH");
            StandardNames.unprovide("KeyGenerator", "Blowfish");
            StandardNames.provide("KeyGenerator", "BLOWFISH");
            StandardNames.provide("CertificateFactory", "X509");
            StandardNames.unprovide("KeyStore", "JKS");
            StandardNames.provide("KeyStore", "BKS");
            StandardNames.unprovide("KeyStore", "JCEKS");
            StandardNames.provide("KeyStore", "BouncyCastle");
            StandardNames.provide("Cipher", "PBEWITHMD5AND128BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5AND192BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5AND256BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5ANDRC2");
            StandardNames.provide("Cipher", "PBEWITHSHA1ANDDES");
            StandardNames.provide("Cipher", "PBEWITHSHA1ANDRC2");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND128BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND192BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND256BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITRC2-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITRC4");
            StandardNames.provide("Cipher", "PBEWITHSHAAND192BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND256BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND40BITRC2-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND40BITRC4");
            StandardNames.provide("Cipher", "PBEWITHSHAANDTWOFISH-CBC");
            StandardNames.provide("Mac", "PBEWITHHMACSHA");
            StandardNames.provide("Mac", "PBEWITHHMACSHA1");
            StandardNames.provide("SecretKeyFactory", "PBEWITHHMACSHA1");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND128BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND192BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND256BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5ANDRC2");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA1ANDDES");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA1ANDRC2");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND128BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND192BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND256BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITRC2-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITRC4");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND192BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND256BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND40BITRC2-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND40BITRC4");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAANDTWOFISH-CBC");
            StandardNames.provide("Cipher", "AES/CBC/NOPADDING");
            StandardNames.provide("Cipher", "AES/CBC/PKCS5PADDING");
            StandardNames.provide("Cipher", "AES/CBC/PKCS7PADDING");
            StandardNames.provide("Cipher", "AES/CFB/NOPADDING");
            StandardNames.provide("Cipher", "AES/CFB/PKCS5PADDING");
            StandardNames.provide("Cipher", "AES/CFB/PKCS7PADDING");
            StandardNames.provide("Cipher", "AES/CTR/NOPADDING");
            StandardNames.provide("Cipher", "AES/CTR/PKCS5PADDING");
            StandardNames.provide("Cipher", "AES/CTR/PKCS7PADDING");
            StandardNames.provide("Cipher", "AES/ECB/NOPADDING");
            StandardNames.provide("Cipher", "AES/ECB/PKCS5PADDING");
            StandardNames.provide("Cipher", "AES/ECB/PKCS7PADDING");
            StandardNames.provide("Cipher", "AES/GCM/NOPADDING");
            StandardNames.provide("Cipher", "AES/OFB/NOPADDING");
            StandardNames.provide("Cipher", "AES/OFB/PKCS5PADDING");
            StandardNames.provide("Cipher", "AES/OFB/PKCS7PADDING");
            StandardNames.provide("Cipher", "DESEDE/CBC/NOPADDING");
            StandardNames.provide("Cipher", "DESEDE/CBC/PKCS5PADDING");
            StandardNames.provide("Cipher", "DESEDE/CBC/PKCS7PADDING");
            StandardNames.provide("Cipher", "DESEDE/CFB/NOPADDING");
            StandardNames.provide("Cipher", "DESEDE/CFB/PKCS5PADDING");
            StandardNames.provide("Cipher", "DESEDE/CFB/PKCS7PADDING");
            StandardNames.provide("Cipher", "DESEDE/ECB/NOPADDING");
            StandardNames.provide("Cipher", "DESEDE/ECB/PKCS5PADDING");
            StandardNames.provide("Cipher", "DESEDE/ECB/PKCS7PADDING");
            StandardNames.provide("Cipher", "DESEDE/OFB/NOPADDING");
            StandardNames.provide("Cipher", "DESEDE/OFB/PKCS5PADDING");
            StandardNames.provide("Cipher", "DESEDE/OFB/PKCS7PADDING");
            StandardNames.provideCipherPaddings("AES", new String[]{"PKCS7Padding"});
            StandardNames.unprovide("CertStore", "LDAP");
            StandardNames.unprovide("MessageDigest", "MD2");
            StandardNames.unprovide("Signature", "MD2withRSA");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("AlgorithmParameters", "RC2");
            StandardNames.unprovide("Cipher", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("Cipher", "RC2");
            StandardNames.unprovide("KeyGenerator", "RC2");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("Cipher", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("AlgorithmParameters", "PBE");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithMD5AndDES");
            StandardNames.provide("KeyAgreement", "ECDH");
            StandardNames.provide("KeyFactory", "EC");
            StandardNames.provide("KeyPairGenerator", "EC");
            StandardNames.provide("Signature", "NONEWITHECDSA");
            StandardNames.provide("Signature", "SHA1WITHECDSA");
            StandardNames.provide("Signature", "SHA224WITHECDSA");
            StandardNames.provide("Signature", "SHA256WITHECDSA");
            StandardNames.provide("Signature", "SHA384WITHECDSA");
            StandardNames.provide("Signature", "SHA512WITHECDSA");
            StandardNames.provide("KeyStore", "AndroidCAStore");
            if (Security.getProvider("AndroidKeyStore") != null) {
                StandardNames.provide("KeyStore", "AndroidKeyStore");
            }
            if (Security.getProvider("TimaKeyStore") != null) {
                StandardNames.provide("KeyStore", "TimaKeyStore");
            }
        }
        if (IS_RI) {
            StandardNames.provideSslContextEnabledProtocols("SSL", TLSVersion.SSLv3, TLSVersion.TLSv1);
            StandardNames.provideSslContextEnabledProtocols("SSLv3", TLSVersion.SSLv3, TLSVersion.TLSv1);
            StandardNames.provideSslContextEnabledProtocols(SSL_CONTEXT_PROTOCOL_DEFAULT, TLSVersion.SSLv3, TLSVersion.TLSv1);
            StandardNames.provideSslContextEnabledProtocols("TLSv1", TLSVersion.SSLv3, TLSVersion.TLSv1);
            StandardNames.provideSslContextEnabledProtocols("TLSv1.1", TLSVersion.SSLv3, TLSVersion.TLSv11);
            StandardNames.provideSslContextEnabledProtocols("TLSv1.2", TLSVersion.SSLv3, TLSVersion.TLSv12);
            StandardNames.provideSslContextEnabledProtocols(SSL_CONTEXT_PROTOCOLS_DEFAULT, TLSVersion.SSLv3, TLSVersion.TLSv1);
        } else {
            StandardNames.provideSslContextEnabledProtocols(SSL_CONTEXT_PROTOCOL_DEFAULT, TLSVersion.TLSv1, TLSVersion.TLSv12);
            StandardNames.provideSslContextEnabledProtocols("TLSv1", TLSVersion.TLSv1, TLSVersion.TLSv12);
            StandardNames.provideSslContextEnabledProtocols("TLSv1.1", TLSVersion.TLSv1, TLSVersion.TLSv12);
            StandardNames.provideSslContextEnabledProtocols("TLSv1.2", TLSVersion.TLSv1, TLSVersion.TLSv12);
            StandardNames.provideSslContextEnabledProtocols(SSL_CONTEXT_PROTOCOLS_DEFAULT, TLSVersion.TLSv1, TLSVersion.TLSv12);
        }
        SSL_CONTEXT_PROTOCOLS = new HashSet<String>(Arrays.asList(SSL_CONTEXT_PROTOCOLS_DEFAULT, SSL_CONTEXT_PROTOCOL_DEFAULT, "TLSv1", "TLSv1.1", "TLSv1.2"));
        KEY_TYPES = new HashSet<String>(Arrays.asList("RSA", "DSA", "DH_RSA", "DH_DSA", "EC", "EC_EC", "EC_RSA"));
        if (IS_RI) {
            KEY_TYPES.remove("DH_RSA");
            KEY_TYPES.remove("DH_DSA");
        }
        SSL_SOCKET_PROTOCOLS = new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
        SSL_SOCKET_PROTOCOLS_CLIENT_DEFAULT = new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
        SSL_SOCKET_PROTOCOLS_SERVER_DEFAULT = new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
        if (IS_RI) {
            SSL_SOCKET_PROTOCOLS.add("SSLv2Hello");
            SSL_SOCKET_PROTOCOLS_CLIENT_DEFAULT.add("SSLv3");
            SSL_SOCKET_PROTOCOLS_SERVER_DEFAULT.add("SSLv3");
        }
        CLIENT_AUTH_TYPES = new HashSet<String>(Arrays.asList("RSA", "DSA", "EC", "UNKNOWN"));
        SERVER_AUTH_TYPES = new HashSet<String>(Arrays.asList("DHE_DSS", "DHE_DSS_EXPORT", "DHE_RSA", "DHE_RSA_EXPORT", "DH_DSS_EXPORT", "DH_RSA_EXPORT", "DH_anon", "DH_anon_EXPORT", "KRB5", "KRB5_EXPORT", "RSA", "RSA_EXPORT", "RSA_EXPORT1024", "ECDH_ECDSA", "ECDH_RSA", "ECDHE_ECDSA", "ECDHE_RSA", "UNKNOWN"));
        CIPHER_SUITES_NEITHER = new HashSet<String>();
        CIPHER_SUITES_RI = new LinkedHashSet<String>();
        CIPHER_SUITES_OPENSSL = new LinkedHashSet<String>();
        StandardNames.addBoth("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("TLS_RSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addBoth("TLS_RSA_WITH_AES_256_CBC_SHA256");
        StandardNames.addOpenSsl("TLS_RSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addOpenSsl("TLS_RSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        StandardNames.addOpenSsl("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addOpenSsl("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addBoth("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addBoth("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        StandardNames.addOpenSsl("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addOpenSsl("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addBoth("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addBoth("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        StandardNames.addOpenSsl("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addOpenSsl("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addOpenSsl("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        StandardNames.addOpenSsl("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        StandardNames.addOpenSsl("TLS_PSK_WITH_AES_128_CBC_SHA");
        StandardNames.addOpenSsl("TLS_PSK_WITH_AES_256_CBC_SHA");
        StandardNames.addOpenSsl("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA");
        StandardNames.addOpenSsl("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA");
        StandardNames.addOpenSsl("TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256");
        StandardNames.addBoth(CIPHER_SUITE_SECURE_RENEGOTIATION);
        StandardNames.addOpenSsl(CIPHER_SUITE_FALLBACK);
        StandardNames.addRi("TLS_KRB5_WITH_RC4_128_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_RC4_128_MD5");
        StandardNames.addRi("TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_3DES_EDE_CBC_MD5");
        StandardNames.addRi("TLS_KRB5_WITH_DES_CBC_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_DES_CBC_MD5");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_RC4_40_SHA");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5");
        StandardNames.addRi("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addRi("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("SSL_DHE_DSS_WITH_DES_CBC_SHA");
        StandardNames.addRi("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        StandardNames.addRi("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        StandardNames.addNeither("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
        StandardNames.addRi("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        StandardNames.addRi("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        StandardNames.addNeither("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
        StandardNames.addRi("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
        StandardNames.addRi("TLS_ECDHE_RSA_WITH_RC4_128_SHA");
        StandardNames.addRi("SSL_RSA_WITH_RC4_128_SHA");
        StandardNames.addRi("SSL_RSA_WITH_RC4_128_MD5");
        StandardNames.addNeither("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addNeither("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addRi("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addRi("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("SSL_DHE_RSA_WITH_DES_CBC_SHA");
        StandardNames.addRi("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addRi("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addRi("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("SSL_DH_anon_WITH_DES_CBC_SHA");
        StandardNames.addRi("SSL_DH_anon_WITH_RC4_128_MD5");
        StandardNames.addRi("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addRi("SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addRi("SSL_RSA_WITH_DES_CBC_SHA");
        StandardNames.addRi("SSL_RSA_WITH_NULL_MD5");
        StandardNames.addRi("SSL_RSA_WITH_NULL_SHA");
        StandardNames.addRi("TLS_DH_anon_WITH_AES_128_CBC_SHA");
        StandardNames.addRi("TLS_DH_anon_WITH_AES_128_CBC_SHA256");
        StandardNames.addNeither("TLS_DH_anon_WITH_AES_128_GCM_SHA256");
        StandardNames.addRi("TLS_DH_anon_WITH_AES_256_CBC_SHA");
        StandardNames.addRi("TLS_DH_anon_WITH_AES_256_CBC_SHA256");
        StandardNames.addNeither("TLS_DH_anon_WITH_AES_256_GCM_SHA384");
        StandardNames.addRi("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_ECDHE_ECDSA_WITH_NULL_SHA");
        StandardNames.addRi("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_ECDHE_RSA_WITH_NULL_SHA");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_NULL_SHA");
        StandardNames.addRi("TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_NULL_SHA");
        StandardNames.addRi("TLS_ECDH_RSA_WITH_RC4_128_SHA");
        StandardNames.addRi("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
        StandardNames.addRi("TLS_ECDH_anon_WITH_NULL_SHA");
        StandardNames.addRi("TLS_ECDH_anon_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_PSK_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_RSA_WITH_NULL_SHA256");
        StandardNames.addNeither("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA");
        StandardNames.addNeither("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA");
        StandardNames.addNeither("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
        StandardNames.addNeither("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
        StandardNames.addNeither("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
        CIPHER_SUITES = IS_RI ? CIPHER_SUITES_RI : CIPHER_SUITES_OPENSSL;
        CIPHER_SUITES_OBSOLETE_TLS12 = Arrays.asList("SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        CIPHER_SUITES_ANDROID_AES_HARDWARE = Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", CIPHER_SUITE_SECURE_RENEGOTIATION);
        CIPHER_SUITES_ANDROID_SOFTWARE = Arrays.asList("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", CIPHER_SUITE_SECURE_RENEGOTIATION);
        CIPHER_SUITES_DEFAULT = IS_RI ? Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", CIPHER_SUITE_SECURE_RENEGOTIATION) : (CpuFeatures.isAESHardwareAccelerated() ? CIPHER_SUITES_ANDROID_AES_HARDWARE : CIPHER_SUITES_ANDROID_SOFTWARE);
        CIPHER_SUITES_DEFAULT_PSK = Arrays.asList("TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", "TLS_PSK_WITH_AES_128_CBC_SHA", "TLS_PSK_WITH_AES_256_CBC_SHA");
        ELLIPTIC_CURVES_DEFAULT = Arrays.asList("x25519 (29)", "secp256r1 (23)", "secp384r1 (24)", "secp521r1 (25)");
        PERMITTED_DEFAULT_KEY_EXCHANGE_ALGS = new HashSet<String>(Arrays.asList("RSA", "DHE_RSA", "DHE_DSS", "ECDHE_RSA", "ECDHE_ECDSA"));
        PERMITTED_DEFAULT_BULK_ENCRYPTION_CIPHERS = new HashSet<String>(Arrays.asList("AES_128_CBC", "AES_256_CBC", "AES_128_GCM", "AES_256_GCM", "CHACHA20_POLY1305"));
        PERMITTED_DEFAULT_MACS = new HashSet<String>(Arrays.asList("SHA", "SHA256", "SHA384"));
        PRIVATE_KEY_SPEC_CLASSES = new HashMap<String, Class<? extends KeySpec>>();
        PUBLIC_KEY_SPEC_CLASSES = new HashMap<String, Class<? extends KeySpec>>();
        MINIMUM_KEY_SIZE = new HashMap<String, Integer>();
        PRIVATE_KEY_SPEC_CLASSES.put("RSA", RSAPrivateCrtKeySpec.class);
        PUBLIC_KEY_SPEC_CLASSES.put("RSA", RSAPublicKeySpec.class);
        MINIMUM_KEY_SIZE.put("RSA", 512);
        PRIVATE_KEY_SPEC_CLASSES.put("DSA", DSAPrivateKeySpec.class);
        PUBLIC_KEY_SPEC_CLASSES.put("DSA", DSAPublicKeySpec.class);
        MINIMUM_KEY_SIZE.put("DSA", 512);
        PRIVATE_KEY_SPEC_CLASSES.put("DH", DHPrivateKeySpec.class);
        PUBLIC_KEY_SPEC_CLASSES.put("DH", DHPublicKeySpec.class);
        MINIMUM_KEY_SIZE.put("DH", 256);
        PRIVATE_KEY_SPEC_CLASSES.put("EC", ECPrivateKeySpec.class);
        PUBLIC_KEY_SPEC_CLASSES.put("EC", ECPublicKeySpec.class);
        MINIMUM_KEY_SIZE.put("EC", 256);
    }

    private static enum TLSVersion {
        SSLv3("SSLv3"),
        TLSv1("TLSv1"),
        TLSv11("TLSv1.1"),
        TLSv12("TLSv1.2");

        private final String name;

        private TLSVersion(String name) {
            this.name = name;
        }
    }
}

