/*
 * Decompiled with CFR 0.152.
 */
package libcore.java.security;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuFeatures {
    private CpuFeatures() {
    }

    public static boolean isAESHardwareAccelerated() {
        List<String> features = CpuFeatures.getListFromCpuinfo("Features");
        if (features != null && features.contains("aes")) {
            return true;
        }
        List<String> flags = CpuFeatures.getListFromCpuinfo("flags");
        if (flags != null && flags.contains("aes")) {
            return true;
        }
        try {
            Class<?> nativeCrypto = Class.forName("com.android.org.conscrypt.NativeCrypto");
            Method EVP_has_aes_hardware = nativeCrypto.getDeclaredMethod("EVP_has_aes_hardware", new Class[0]);
            return (Integer)EVP_has_aes_hardware.invoke(null, new Object[0]) == 1;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException nativeCrypto) {
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFieldFromCpuinfo(String field) {
        try {
            Pattern p = Pattern.compile(field + "\\s*:\\s*(.*)");
            try (BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));){
                String line;
                Matcher m;
                do {
                    if ((line = br.readLine()) == null) return null;
                } while (!(m = p.matcher(line)).matches());
                String string = m.group(1);
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static List<String> getListFromCpuinfo(String fieldName) {
        String features = CpuFeatures.getFieldFromCpuinfo(fieldName);
        if (features == null) {
            return null;
        }
        return Arrays.asList(features.split("\\s"));
    }
}

