/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.spec.GCMParameterSpec;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.AbstractConscryptSocket;
import org.conscrypt.ActiveSession;
import org.conscrypt.AddressUtils;
import org.conscrypt.ConscryptEngine;
import org.conscrypt.DelegatingExtendedSSLSession;
import org.conscrypt.GCMParameters;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.SSLParametersImpl;
import sun.security.x509.AlgorithmId;

final class Platform {
    private static final boolean JAVA8;
    private static final Method GET_CURVE_NAME_METHOD;
    private static final Method SET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final Method GET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final Method SET_SERVER_NAMES_METHOD;
    private static final Method GET_SERVER_NAMES_METHOD;
    private static final Method GET_TYPE_METHOD;
    private static final Method GET_ASCII_NAME_METHOD;
    private static final Constructor<?> SNI_HOST_NAME_CONSTRUCTOR;

    private Platform() {
    }

    static void setup() {
    }

    static FileDescriptor getFileDescriptor(Socket s) {
        try {
            SocketChannel channel = s.getChannel();
            if (channel != null) {
                Field f_fd = channel.getClass().getDeclaredField("fd");
                f_fd.setAccessible(true);
                return (FileDescriptor)f_fd.get(channel);
            }
        }
        catch (Exception channel) {
            // empty catch block
        }
        try {
            Field f_impl = Socket.class.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(s);
            Field f_fd = SocketImpl.class.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    static FileDescriptor getFileDescriptorFromSSLSocket(AbstractConscryptSocket socket) {
        return Platform.getFileDescriptor(socket);
    }

    static String getCurveName(ECParameterSpec spec) {
        if (GET_CURVE_NAME_METHOD != null) {
            try {
                return (String)GET_CURVE_NAME_METHOD.invoke((Object)spec, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static void setCurveName(ECParameterSpec spec, String curveName) {
    }

    static void setSocketWriteTimeout(Socket s, long timeoutMillis) throws SocketException {
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        block5: {
            impl.setEndpointIdentificationAlgorithm(params.getEndpointIdentificationAlgorithm());
            if (JAVA8) {
                try {
                    impl.setUseCipherSuitesOrder((Boolean)GET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)params, new Object[0]));
                    List serverNames = (List)GET_SERVER_NAMES_METHOD.invoke((Object)params, new Object[0]);
                    int hostNameType = 0;
                    if (serverNames == null) break block5;
                    for (Object serverName : serverNames) {
                        if ((Integer)GET_TYPE_METHOD.invoke(serverName, new Object[0]) != hostNameType) continue;
                        socket.setHostname((String)GET_ASCII_NAME_METHOD.invoke(serverName, new Object[0]));
                        break;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        params.setEndpointIdentificationAlgorithm(impl.getEndpointIdentificationAlgorithm());
        if (JAVA8) {
            try {
                SET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)params, impl.getUseCipherSuitesOrder());
                if (impl.getUseSni() && AddressUtils.isValidSniHostname(socket.getHostname())) {
                    SET_SERVER_NAMES_METHOD.invoke((Object)params, Collections.singletonList(SNI_HOST_NAME_CONSTRUCTOR.newInstance(socket.getHostname())));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    public static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        block5: {
            impl.setEndpointIdentificationAlgorithm(params.getEndpointIdentificationAlgorithm());
            if (JAVA8) {
                try {
                    impl.setUseCipherSuitesOrder((Boolean)GET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)params, new Object[0]));
                    List serverNames = (List)GET_SERVER_NAMES_METHOD.invoke((Object)params, new Object[0]);
                    int hostNameType = 0;
                    if (serverNames == null) break block5;
                    for (Object serverName : serverNames) {
                        if ((Integer)GET_TYPE_METHOD.invoke(serverName, new Object[0]) != hostNameType) continue;
                        engine.setHostname((String)GET_ASCII_NAME_METHOD.invoke(serverName, new Object[0]));
                        break;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    public static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        params.setEndpointIdentificationAlgorithm(impl.getEndpointIdentificationAlgorithm());
        if (JAVA8) {
            try {
                SET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)params, impl.getUseCipherSuitesOrder());
                if (impl.getUseSni() && AddressUtils.isValidSniHostname(engine.getHostname())) {
                    SET_SERVER_NAMES_METHOD.invoke((Object)params, Collections.singletonList(SNI_HOST_NAME_CONSTRUCTOR.newInstance(engine.getHostname())));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    static void setEndpointIdentificationAlgorithm(SSLParameters params, String endpointIdentificationAlgorithm) {
        params.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
    }

    static String getEndpointIdentificationAlgorithm(SSLParameters params) {
        return params.getEndpointIdentificationAlgorithm();
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkClientTrusted(chain, authType, socket);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkServerTrusted(chain, authType, socket);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkClientTrusted(chain, authType, engine);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (tm instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509etm = (X509ExtendedTrustManager)tm;
            x509etm.checkServerTrusted(chain, authType, engine);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static OpenSSLKey wrapRsaKey(PrivateKey javaKey) {
        return null;
    }

    static void logEvent(String message) {
    }

    static boolean isLiteralIpAddress(String hostname) {
        return AddressUtils.isLiteralIpAddress(hostname);
    }

    static boolean isSniEnabledByDefault() {
        return true;
    }

    static SSLSocketFactory wrapSocketFactoryIfNeeded(OpenSSLSocketFactoryImpl factory) {
        return factory;
    }

    static GCMParameters fromGCMParameterSpec(AlgorithmParameterSpec params) {
        if (params instanceof GCMParameterSpec) {
            GCMParameterSpec gcmParams = (GCMParameterSpec)params;
            return new GCMParameters(gcmParams.getTLen(), gcmParams.getIV());
        }
        return null;
    }

    static AlgorithmParameterSpec toGCMParameterSpec(int tagLenInBits, byte[] iv) {
        return new GCMParameterSpec(tagLenInBits, iv);
    }

    static Object closeGuardGet() {
        return null;
    }

    static void closeGuardOpen(Object guardObj, String message) {
    }

    static void closeGuardClose(Object guardObj) {
    }

    static void closeGuardWarnIfOpen(Object guardObj) {
    }

    static void blockGuardOnNetwork() {
    }

    static String oidToAlgorithmName(String oid) {
        try {
            return AlgorithmId.get(oid).getName();
        }
        catch (NoSuchAlgorithmException e) {
            return oid;
        }
    }

    static SSLSession wrapSSLSession(ActiveSession sslSession) {
        return new DelegatingExtendedSSLSession(sslSession);
    }

    static SSLSession unwrapSSLSession(SSLSession sslSession) {
        if (sslSession instanceof DelegatingExtendedSSLSession) {
            return ((DelegatingExtendedSSLSession)sslSession).getDelegate();
        }
        return sslSession;
    }

    static String getHostStringFromInetSocketAddress(InetSocketAddress addr) {
        return addr.getHostString();
    }

    static boolean isCTVerificationRequired(String hostname) {
        if (hostname == null) {
            return false;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property.toLowerCase()).booleanValue()) {
            return false;
        }
        List<String> parts = Arrays.asList(hostname.split("\\."));
        Collections.reverse(parts);
        boolean enable = false;
        StringBuilder propertyName = new StringBuilder("conscrypt.ct.enforce");
        for (String part : parts) {
            property = Security.getProperty(propertyName + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property.toLowerCase());
            }
            propertyName.append(".").append(part);
        }
        property = Security.getProperty(propertyName.toString());
        if (property != null) {
            enable = Boolean.valueOf(property.toLowerCase());
        }
        return enable;
    }

    static {
        Method getCurveNameMethod = null;
        try {
            getCurveNameMethod = ECParameterSpec.class.getDeclaredMethod("getCurveName", new Class[0]);
            getCurveNameMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_CURVE_NAME_METHOD = getCurveNameMethod;
        boolean java8 = false;
        Method setUseCipherSuitesOrderMethod = null;
        Method getUseCipherSuitesOrderMethod = null;
        Method setServerNamesMethod = null;
        Method getServerNamesMethod = null;
        Method getTypeMethod = null;
        Method getAsciiNameMethod = null;
        Constructor<?> sniHostNameConstructor = null;
        try {
            setUseCipherSuitesOrderMethod = SSLParameters.class.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            getUseCipherSuitesOrderMethod = SSLParameters.class.getMethod("getUseCipherSuitesOrder", new Class[0]);
            setServerNamesMethod = SSLParameters.class.getMethod("setServerNames", List.class);
            getServerNamesMethod = SSLParameters.class.getMethod("getServerNames", new Class[0]);
            Class<?> sniHostNameClass = Class.forName("javax.net.ssl.SNIHostName");
            getTypeMethod = sniHostNameClass.getMethod("getType", new Class[0]);
            getAsciiNameMethod = sniHostNameClass.getMethod("getAsciiName", new Class[0]);
            sniHostNameConstructor = sniHostNameClass.getConstructor(String.class);
            java8 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SET_USE_CIPHER_SUITES_ORDER_METHOD = java8 ? setUseCipherSuitesOrderMethod : null;
        GET_USE_CIPHER_SUITES_ORDER_METHOD = java8 ? getUseCipherSuitesOrderMethod : null;
        SET_SERVER_NAMES_METHOD = java8 ? setServerNamesMethod : null;
        GET_SERVER_NAMES_METHOD = java8 ? getServerNamesMethod : null;
        GET_TYPE_METHOD = java8 ? getTypeMethod : null;
        GET_ASCII_NAME_METHOD = java8 ? getAsciiNameMethod : null;
        SNI_HOST_NAME_CONSTRUCTOR = java8 ? sniHostNameConstructor : null;
        JAVA8 = java8;
    }
}

