/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.LinkedHashSet;
import java.util.Locale;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeLibraryLoader;

final class NativeCryptoJni {
    private static final String LIB_NAME = "conscrypt_openjdk_jni";
    private static final String UNKNOWN = "unknown";
    private static final String LINUX = "linux";

    public static void init() {
        String os = NativeCryptoJni.normalizeOs(System.getProperty("os.name", ""));
        String arch = NativeCryptoJni.normalizeArch(System.getProperty("os.arch", ""));
        LinkedHashSet<String> libNames = new LinkedHashSet<String>(3);
        libNames.add("conscrypt_openjdk_jni-" + os + '-' + arch);
        if (LINUX.equalsIgnoreCase(os)) {
            libNames.add("conscrypt_openjdk_jni-" + os + '-' + arch + "-fedora");
        }
        libNames.add(LIB_NAME);
        NativeLibraryLoader.loadFirstAvailable(NativeCrypto.class.getClassLoader(), libNames.toArray(new String[libNames.size()]));
    }

    private NativeCryptoJni() {
    }

    private static String normalizeOs(String value) {
        if ((value = NativeCryptoJni.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith(LINUX)) {
            return LINUX;
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = NativeCryptoJni.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

