/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.crypto.spec.GCMParameterSpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.AbstractConscryptSocket;
import org.conscrypt.ActiveSession;
import org.conscrypt.AddressUtils;
import org.conscrypt.ConscryptEngine;
import org.conscrypt.ConscryptSocketBase;
import org.conscrypt.GCMParameters;
import org.conscrypt.Java7PlatformUtil;
import org.conscrypt.Java8PlatformUtil;
import org.conscrypt.Java9PlatformUtil;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.SSLParametersImpl;
import sun.security.x509.AlgorithmId;

final class Platform {
    private static final int JAVA_VERSION = Platform.javaVersion0();
    private static final Method GET_CURVE_NAME_METHOD;

    private Platform() {
    }

    static void setup() {
    }

    static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException();
        }
        long time = System.currentTimeMillis();
        prefix = new File(prefix).getName();
        IOException suppressed = null;
        for (int i = 0; i < 10000; ++i) {
            File tempFile;
            String tempName = String.format(Locale.US, "%s%d%04d%s", prefix, time, i, suffix);
            if (!tempName.equals((tempFile = new File(directory, tempName)).getName())) {
                throw new IOException("Unable to create temporary file: " + tempFile);
            }
            try {
                if (!tempFile.createNewFile()) continue;
                return tempFile.getCanonicalFile();
            }
            catch (IOException e) {
                suppressed = e;
            }
        }
        if (suppressed != null) {
            throw suppressed;
        }
        throw new IOException("Unable to create temporary file");
    }

    static String getDefaultProviderName() {
        return "Conscrypt";
    }

    static boolean canExecuteExecutable(File file) throws IOException {
        if (JAVA_VERSION >= 7) {
            return Java7PlatformUtil.canExecuteExecutable(file);
        }
        return true;
    }

    static void addSuppressed(Throwable t, Throwable suppressed) {
        if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.addSuppressed(t, suppressed);
        }
    }

    static FileDescriptor getFileDescriptor(Socket s) {
        try {
            SocketChannel channel = s.getChannel();
            if (channel != null) {
                Field f_fd = channel.getClass().getDeclaredField("fd");
                f_fd.setAccessible(true);
                return (FileDescriptor)f_fd.get(channel);
            }
        }
        catch (Exception channel) {
            // empty catch block
        }
        try {
            Field f_impl = Socket.class.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(s);
            Field f_fd = SocketImpl.class.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    static FileDescriptor getFileDescriptorFromSSLSocket(AbstractConscryptSocket socket) {
        return Platform.getFileDescriptor(socket);
    }

    static String getCurveName(ECParameterSpec spec) {
        if (GET_CURVE_NAME_METHOD != null) {
            try {
                return (String)GET_CURVE_NAME_METHOD.invoke((Object)spec, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static void setCurveName(ECParameterSpec spec, String curveName) {
    }

    static void setSocketWriteTimeout(Socket s, long timeoutMillis) throws SocketException {
    }

    static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        if (JAVA_VERSION >= 9) {
            Java9PlatformUtil.setSSLParameters(params, impl, socket);
        } else if (JAVA_VERSION >= 8) {
            Java8PlatformUtil.setSSLParameters(params, impl, socket);
        } else if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.setSSLParameters(params, impl);
        }
    }

    static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, AbstractConscryptSocket socket) {
        if (JAVA_VERSION >= 9) {
            Java9PlatformUtil.getSSLParameters(params, impl, socket);
        } else if (JAVA_VERSION >= 8) {
            Java8PlatformUtil.getSSLParameters(params, impl, socket);
        } else if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.getSSLParameters(params, impl);
        }
    }

    static void setSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        if (JAVA_VERSION >= 9) {
            Java9PlatformUtil.setSSLParameters(params, impl, engine);
        } else if (JAVA_VERSION >= 8) {
            Java8PlatformUtil.setSSLParameters(params, impl, engine);
        } else if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.setSSLParameters(params, impl);
        }
    }

    static void getSSLParameters(SSLParameters params, SSLParametersImpl impl, ConscryptEngine engine) {
        if (JAVA_VERSION >= 9) {
            Java9PlatformUtil.getSSLParameters(params, impl, engine);
        } else if (JAVA_VERSION >= 8) {
            Java8PlatformUtil.getSSLParameters(params, impl, engine);
        } else if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.getSSLParameters(params, impl);
        }
    }

    static void setEndpointIdentificationAlgorithm(SSLParameters params, String endpointIdentificationAlgorithm) {
        params.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
    }

    static String getEndpointIdentificationAlgorithm(SSLParameters params) {
        return params.getEndpointIdentificationAlgorithm();
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.checkClientTrusted(tm, chain, authType, socket);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, AbstractConscryptSocket socket) throws CertificateException {
        if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.checkServerTrusted(tm, chain, authType, socket);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static void checkClientTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.checkClientTrusted(tm, chain, authType, engine);
        } else {
            tm.checkClientTrusted(chain, authType);
        }
    }

    static void checkServerTrusted(X509TrustManager tm, X509Certificate[] chain, String authType, ConscryptEngine engine) throws CertificateException {
        if (JAVA_VERSION >= 7) {
            Java7PlatformUtil.checkServerTrusted(tm, chain, authType, engine);
        } else {
            tm.checkServerTrusted(chain, authType);
        }
    }

    static OpenSSLKey wrapRsaKey(PrivateKey javaKey) {
        return null;
    }

    static void logEvent(String message) {
    }

    static boolean isLiteralIpAddress(String hostname) {
        return AddressUtils.isLiteralIpAddress(hostname);
    }

    static boolean isSniEnabledByDefault() {
        return true;
    }

    static SSLEngine wrapEngine(ConscryptEngine engine) {
        if (JAVA_VERSION >= 8) {
            return Java8PlatformUtil.wrapEngine(engine);
        }
        return engine;
    }

    static SSLEngine unwrapEngine(SSLEngine engine) {
        if (JAVA_VERSION >= 8) {
            return Java8PlatformUtil.unwrapEngine(engine);
        }
        return engine;
    }

    static SSLSocket wrapSocket(ConscryptSocketBase socket) {
        if (JAVA_VERSION >= 8) {
            return Java8PlatformUtil.wrapSocket(socket);
        }
        return socket;
    }

    static SSLSocket unwrapSocket(SSLSocket socket) {
        if (JAVA_VERSION >= 8) {
            return Java8PlatformUtil.unwrapSocket(socket);
        }
        return socket;
    }

    static SSLSocketFactory wrapSocketFactoryIfNeeded(OpenSSLSocketFactoryImpl factory) {
        return factory;
    }

    static GCMParameters fromGCMParameterSpec(AlgorithmParameterSpec params) {
        if (params instanceof GCMParameterSpec) {
            GCMParameterSpec gcmParams = (GCMParameterSpec)params;
            return new GCMParameters(gcmParams.getTLen(), gcmParams.getIV());
        }
        return null;
    }

    static AlgorithmParameterSpec toGCMParameterSpec(int tagLenInBits, byte[] iv) {
        return new GCMParameterSpec(tagLenInBits, iv);
    }

    static Object closeGuardGet() {
        return null;
    }

    static void closeGuardOpen(Object guardObj, String message) {
    }

    static void closeGuardClose(Object guardObj) {
    }

    static void closeGuardWarnIfOpen(Object guardObj) {
    }

    static void blockGuardOnNetwork() {
    }

    static String oidToAlgorithmName(String oid) {
        try {
            return AlgorithmId.get(oid).getName();
        }
        catch (NoSuchAlgorithmException e) {
            return oid;
        }
    }

    static SSLSession wrapSSLSession(ActiveSession sslSession) {
        if (JAVA_VERSION >= 7) {
            return Java7PlatformUtil.wrapSSLSession(sslSession);
        }
        return sslSession;
    }

    static SSLSession unwrapSSLSession(SSLSession sslSession) {
        if (JAVA_VERSION >= 7) {
            return Java7PlatformUtil.unwrapSSLSession(sslSession);
        }
        return sslSession;
    }

    public static String getOriginalHostNameFromInetAddress(InetAddress addr) {
        try {
            Method getHolder = InetAddress.class.getDeclaredMethod("holder", new Class[0]);
            getHolder.setAccessible(true);
            Method getOriginalHostName = Class.forName("java.net.InetAddress$InetAddressHolder").getDeclaredMethod("getOriginalHostName", new Class[0]);
            getOriginalHostName.setAccessible(true);
            String originalHostName = (String)getOriginalHostName.invoke(getHolder.invoke((Object)addr, new Object[0]), new Object[0]);
            if (originalHostName == null) {
                return addr.getHostAddress();
            }
            return originalHostName;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to get originalHostName", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return addr.getHostAddress();
    }

    static String getHostStringFromInetSocketAddress(InetSocketAddress addr) {
        if (JAVA_VERSION >= 7) {
            return Java7PlatformUtil.getHostStringFromInetSocketAddress(addr);
        }
        return null;
    }

    static boolean isCTVerificationRequired(String hostname) {
        if (hostname == null) {
            return false;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property.toLowerCase()).booleanValue()) {
            return false;
        }
        List<String> parts = Arrays.asList(hostname.split("\\."));
        Collections.reverse(parts);
        boolean enable = false;
        StringBuilder propertyName = new StringBuilder("conscrypt.ct.enforce");
        for (String part : parts) {
            property = Security.getProperty(propertyName + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property.toLowerCase());
            }
            propertyName.append(".").append(part);
        }
        property = Security.getProperty(propertyName.toString());
        if (property != null) {
            enable = Boolean.valueOf(property.toLowerCase());
        }
        return enable;
    }

    private static boolean isAndroid() {
        boolean android;
        try {
            Class.forName("android.app.Application", false, Platform.getSystemClassLoader());
            android = true;
        }
        catch (Throwable ignored) {
            android = false;
        }
        return android;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int majorVersion = Platform.isAndroid() ? 6 : Platform.majorVersionFromJavaSpecificationVersion();
        return majorVersion;
    }

    private static int majorVersionFromJavaSpecificationVersion() {
        return Platform.majorVersion(System.getProperty("java.specification.version", "1.6"));
    }

    private static int majorVersion(String javaSpecVersion) {
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            assert (version[1] >= 6);
            return version[1];
        }
        return version[0];
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static {
        Method getCurveNameMethod = null;
        try {
            getCurveNameMethod = ECParameterSpec.class.getDeclaredMethod("getCurveName", new Class[0]);
            getCurveNameMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_CURVE_NAME_METHOD = getCurveNameMethod;
    }
}

