/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class FilterDoclet
extends Standard {
    public static void main(String[] args) throws FileNotFoundException {
        String name = FilterDoclet.class.getName();
        Main.execute((String)name, (String[])args);
    }

    public static boolean start(RootDoc rootDoc) {
        return Standard.start((RootDoc)((RootDoc)FilterDoclet.filterHidden(rootDoc, RootDoc.class)));
    }

    private static boolean hasHideAnnotation(Doc doc) {
        String comment = doc.getRawCommentText();
        return comment.contains("@hide");
    }

    private static boolean isHidden(Doc doc) {
        if (doc instanceof MemberDoc) {
            return FilterDoclet.hasHideAnnotation(doc);
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            if (FilterDoclet.hasHideAnnotation((Doc)classDoc.containingPackage())) {
                return true;
            }
            ClassDoc current = classDoc;
            do {
                if (!FilterDoclet.hasHideAnnotation((Doc)current)) continue;
                return true;
            } while ((current = current.containingClass()) != null);
        }
        return false;
    }

    private static Object filterHidden(Object o, Class<?> expected) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)new HideHandler(o));
        }
        if (o instanceof Object[]) {
            Class<?> componentType = expected.getComponentType();
            if (componentType == null) {
                return o;
            }
            Object[] array = (Object[])o;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Object entry : array) {
                if (entry instanceof Doc && FilterDoclet.isHidden((Doc)entry)) continue;
                list.add(FilterDoclet.filterHidden(entry, componentType));
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return o;
    }

    private static class HideHandler
    implements InvocationHandler {
        private final Object target;

        public HideHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (args != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = HideHandler.unwrap(args[0]);
            }
            try {
                return FilterDoclet.filterHidden(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw e.getTargetException();
            }
        }

        private static Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((HideHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }
    }
}

