/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import org.conscrypt.NativeCrypto;

abstract class NativeRef {
    final long context;

    NativeRef(long ctx) {
        if (ctx == 0L) {
            throw new NullPointerException("ctx == 0");
        }
        this.context = ctx;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NativeRef)) {
            return false;
        }
        return ((NativeRef)o).context == this.context;
    }

    public int hashCode() {
        return (int)this.context;
    }

    static class HMAC_CTX
    extends NativeRef {
        HMAC_CTX(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.HMAC_CTX_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EVP_PKEY_CTX
    extends NativeRef {
        EVP_PKEY_CTX(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_PKEY_CTX_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EVP_PKEY
    extends NativeRef {
        EVP_PKEY(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_PKEY_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EVP_MD_CTX
    extends NativeRef {
        EVP_MD_CTX(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_MD_CTX_destroy(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EVP_CIPHER_CTX
    extends NativeRef {
        EVP_CIPHER_CTX(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_CIPHER_CTX_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EC_POINT
    extends NativeRef {
        EC_POINT(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EC_POINT_clear_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }

    static class EC_GROUP
    extends NativeRef {
        EC_GROUP(long ctx) {
            super(ctx);
        }

        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EC_GROUP_clear_free(this.context);
            }
            finally {
                super.finalize();
            }
        }
    }
}

