/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSessionImpl;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.PSKKeyManager;
import org.conscrypt.Platform;
import org.conscrypt.SSLNullSession;
import org.conscrypt.SSLParametersImpl;
import org.conscrypt.SSLUtils;

public final class OpenSSLEngineImpl
extends SSLEngine
implements NativeCrypto.SSLHandshakeCallbacks,
SSLParametersImpl.AliasChooser,
SSLParametersImpl.PSKCallbacks {
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private static final ByteBuffer EMPTY = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_ADDR = NativeCrypto.getDirectBufferAddress(EMPTY);
    private final SSLParametersImpl sslParameters;
    private final Object stateLock = new Object();
    private EngineState engineState = EngineState.NEW;
    private boolean handshakeFinished;
    private long sslNativePointer;
    private long networkBio;
    private AbstractOpenSSLSession sslSession;
    private AbstractOpenSSLSession handshakeSession;
    OpenSSLKey channelIdPrivateKey;
    private int maxWrapOverhead;
    private HandshakeListener handshakeListener;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];

    public OpenSSLEngineImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
    }

    public OpenSSLEngineImpl(String host, int port, SSLParametersImpl sslParameters) {
        super(host, port);
        this.sslParameters = sslParameters;
    }

    public final int calculateMaxLengthForWrap(int plaintextLength) {
        int amt = this.maxWrapOverhead + plaintextLength;
        return amt < 0 ? Integer.MAX_VALUE : amt;
    }

    public OpenSSLEngineImpl setHandshakeListener(HandshakeListener handshakeListener) {
        switch (this.engineState) {
            case NEW: 
            case MODE_SET: {
                break;
            }
            default: {
                throw new IllegalStateException("Handshake listener must be set before starting the handshake.");
            }
        }
        this.handshakeListener = handshakeListener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginHandshake() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.beginHandshakeInternal();
        }
    }

    private void beginHandshakeInternal() throws SSLException {
        switch (this.engineState) {
            case MODE_SET: {
                break;
            }
            case HANDSHAKE_STARTED: {
                throw new IllegalStateException("Handshake has already been started");
            }
            case CLOSED_INBOUND: 
            case CLOSED_OUTBOUND: 
            case CLOSED: {
                throw new IllegalStateException("Engine has already been closed");
            }
            default: {
                throw new IllegalStateException("Client/server mode must be set before handshake");
            }
        }
        this.engineState = EngineState.HANDSHAKE_STARTED;
        boolean releaseResources = true;
        try {
            AbstractSessionContext sessionContext = this.sslParameters.getSessionContext();
            long sslCtxNativePointer = sessionContext.sslCtxNativePointer;
            this.sslParameters.setSSLCtxParameters(sslCtxNativePointer);
            this.sslNativePointer = NativeCrypto.SSL_new(sslCtxNativePointer);
            this.networkBio = NativeCrypto.SSL_BIO_new(this.sslNativePointer);
            this.sslSession = this.sslParameters.getSessionToReuse(this.sslNativePointer, this.getPeerHost(), this.getPeerPort());
            this.sslParameters.setSSLParameters(this.sslNativePointer, this, this, this.getPeerHost());
            this.sslParameters.setCertificateValidation(this.sslNativePointer);
            this.sslParameters.setTlsChannelId(this.sslNativePointer, this.channelIdPrivateKey);
            if (this.getUseClientMode()) {
                NativeCrypto.SSL_set_connect_state(this.sslNativePointer);
            } else {
                NativeCrypto.SSL_set_accept_state(this.sslNativePointer);
            }
            this.maxWrapOverhead = NativeCrypto.SSL_max_seal_overhead(this.sslNativePointer);
            this.handshake();
            releaseResources = false;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message.contains("unexpected CCS")) {
                String logMessage = String.format("ssl_unexpected_ccs: host=%s", this.getPeerHost());
                Platform.logEvent(logMessage);
            }
            throw new SSLException(e);
        }
        finally {
            if (releaseResources) {
                this.engineState = EngineState.CLOSED;
                this.shutdownAndFreeSslNative();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInbound() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED) {
                return;
            }
            this.engineState = this.engineState == EngineState.CLOSED_OUTBOUND ? EngineState.CLOSED : EngineState.CLOSED_INBOUND;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOutbound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND) {
                return;
            }
            if (this.engineState != EngineState.MODE_SET && this.engineState != EngineState.NEW) {
                this.shutdownAndFreeSslNative();
            }
            this.engineState = this.engineState == EngineState.CLOSED_INBOUND ? EngineState.CLOSED : EngineState.CLOSED_OUTBOUND;
        }
        this.shutdown();
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.getHandshakeStatusInternal();
        }
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatusInternal() {
        if (this.handshakeFinished) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        switch (this.engineState) {
            case HANDSHAKE_STARTED: {
                return OpenSSLEngineImpl.pendingStatus(this.pendingOutboundEncryptedBytes());
            }
            case HANDSHAKE_COMPLETED: {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            case NEW: 
            case MODE_SET: 
            case CLOSED_INBOUND: 
            case CLOSED_OUTBOUND: 
            case CLOSED: 
            case READY: 
            case READY_HANDSHAKE_CUT_THROUGH: {
                return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        throw new IllegalStateException("Unexpected engine state: " + (Object)((Object)this.engineState));
    }

    private int pendingOutboundEncryptedBytes() {
        return NativeCrypto.SSL_pending_written_bytes_in_BIO(this.networkBio);
    }

    private int pendingInboundCleartextBytes() {
        return NativeCrypto.SSL_pending_readable_bytes(this.sslNativePointer);
    }

    private int pendingInboundCleartextBytes(SSLEngineResult.HandshakeStatus handshakeStatus) {
        return handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED ? this.pendingInboundCleartextBytes() : 0;
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int pendingOutboundBytes) {
        return pendingOutboundBytes > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public SSLSession getSession() {
        if (this.sslSession == null) {
            return this.handshakeSession != null ? this.handshakeSession : SSLNullSession.getNullSession();
        }
        return this.sslSession;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_INBOUND;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 1) != 0;
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setEnabledCipherSuites(suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseClientMode(boolean mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState != EngineState.MODE_SET && this.engineState != EngineState.NEW) {
                throw new IllegalArgumentException("Can not change mode after handshake: engineState == " + (Object)((Object)this.engineState));
            }
            this.engineState = EngineState.MODE_SET;
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), this.singleDstBuffer(dst));
                this.resetSingleSrcBuffer();
                this.resetSingleDstBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                this.resetSingleDstBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), dsts);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.unwrap(this.singleSrcBuffer(src), 0, 1, dsts, offset, length);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    public SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dsts) throws SSLException {
        OpenSSLEngineImpl.checkNotNull(srcs, "srcs", new Object[0]);
        OpenSSLEngineImpl.checkNotNull(dsts, "dsts", new Object[0]);
        return this.unwrap(srcs, 0, srcs.length, dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        OpenSSLEngineImpl.checkNotNull(srcs, "srcs", new Object[0]);
        OpenSSLEngineImpl.checkNotNull(dsts, "dsts", new Object[0]);
        OpenSSLEngineImpl.checkIndex(srcs.length, srcsOffset, srcsLength, "srcs");
        OpenSSLEngineImpl.checkIndex(dsts.length, dstsOffset, dstsLength, "dsts");
        int capacity = 0;
        int endOffset = dstsOffset + dstsLength;
        for (int i = 0; i < dsts.length; ++i) {
            ByteBuffer dst = dsts[i];
            OpenSSLEngineImpl.checkNotNull(dst, "one of the dst", new Object[0]);
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            if (i < dstsOffset || i >= dstsOffset + dstsLength) continue;
            capacity += dst.remaining();
        }
        int srcsEndOffset = srcsOffset + srcsLength;
        long len = 0L;
        for (int i = srcsOffset; i < srcsEndOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException("srcs[" + i + "] is null");
            }
            len += (long)src.remaining();
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.engineState) {
                case MODE_SET: {
                    this.beginHandshakeInternal();
                    break;
                }
                case CLOSED_INBOUND: 
                case CLOSED: {
                    return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatusInternal(), 0, 0);
                }
                case NEW: {
                    throw new IllegalStateException("Client/server mode must be set before calling unwrap");
                }
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (!this.handshakeFinished) {
                handshakeStatus = this.handshake();
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return NEED_WRAP_OK;
                }
                if (this.engineState == EngineState.CLOSED) {
                    return NEED_WRAP_CLOSED;
                }
            }
            if (len < 5L) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
            }
            int packetLength = SSLUtils.getEncryptedPacketLength(srcs, srcsOffset);
            if (packetLength < 0) {
                throw new SSLException("Unable to parse TLS packet header");
            }
            if (len < (long)packetLength) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
            }
            int bytesConsumed = 0;
            if (srcsOffset < srcsEndOffset) {
                int packetLengthRemaining = packetLength;
                do {
                    ByteBuffer src;
                    int remaining;
                    if ((remaining = (src = srcs[srcsOffset]).remaining()) == 0) {
                        ++srcsOffset;
                        continue;
                    }
                    int written = this.writeEncryptedData(src, Math.min(packetLengthRemaining, remaining));
                    if (written > 0) {
                        if ((packetLengthRemaining -= written) == 0 || written != remaining) break;
                        ++srcsOffset;
                        continue;
                    }
                    NativeCrypto.SSL_clear_error();
                    break;
                } while (srcsOffset < srcsEndOffset);
                bytesConsumed = packetLength - packetLengthRemaining;
            }
            int bytesProduced = 0;
            if (capacity > 0) {
                for (int idx = dstsOffset; idx < endOffset; ++idx) {
                    ByteBuffer dst = dsts[idx];
                    if (!dst.hasRemaining()) continue;
                    int bytesRead = this.readPlaintextData(dst);
                    if (bytesRead > 0) {
                        bytesProduced += bytesRead;
                        if (!dst.hasRemaining()) continue;
                        return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
                    }
                    int sslError = NativeCrypto.SSL_get_error(this.sslNativePointer, bytesRead);
                    switch (sslError) {
                        case 6: {
                            this.closeAll();
                            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
                        }
                        case 2: 
                        case 3: {
                            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
                        }
                    }
                    return this.sslReadErrorResult(NativeCrypto.SSL_get_last_error_number(), bytesConsumed, bytesProduced);
                }
            } else {
                try {
                    int err;
                    if (NativeCrypto.ENGINE_SSL_read_direct(this.sslNativePointer, EMPTY_ADDR, 0, this) <= 0 && (err = NativeCrypto.SSL_get_last_error_number()) != 0) {
                        return this.sslReadErrorResult(err, bytesConsumed, bytesProduced);
                    }
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
            if (this.pendingInboundCleartextBytes(handshakeStatus) > 0) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED ? handshakeStatus : this.getHandshakeStatusInternal()), bytesConsumed, bytesProduced);
            }
            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
        }
    }

    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        long sslSessionCtx = 0L;
        try {
            int code = NativeCrypto.ENGINE_SSL_do_handshake(this.sslNativePointer, this);
            if (code <= 0) {
                int sslError = NativeCrypto.SSL_get_error(this.sslNativePointer, code);
                switch (sslError) {
                    case 2: 
                    case 3: {
                        SSLEngineResult.HandshakeStatus handshakeStatus = OpenSSLEngineImpl.pendingStatus(this.pendingOutboundEncryptedBytes());
                        return handshakeStatus;
                    }
                }
                throw this.shutdownWithError("SSL_do_handshake");
            }
            sslSessionCtx = NativeCrypto.SSL_get1_session(this.sslNativePointer);
            if (sslSessionCtx == 0L) {
                throw this.shutdownWithError("Failed to obtain session after handshake completed");
            }
            this.sslSession = this.sslParameters.setupSession(sslSessionCtx, this.sslNativePointer, this.sslSession, this.getPeerHost(), this.getPeerPort(), true);
            this.engineState = this.sslSession != null && this.engineState == EngineState.HANDSHAKE_STARTED ? EngineState.READY_HANDSHAKE_CUT_THROUGH : EngineState.READY;
            this.finishHandshake();
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            return handshakeStatus;
        }
        catch (SSLHandshakeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Handshake failed").initCause(e);
        }
        finally {
            if (this.sslSession == null && sslSessionCtx != 0L) {
                NativeCrypto.SSL_SESSION_free(sslSessionCtx);
            }
        }
    }

    private void finishHandshake() throws SSLException {
        this.handshakeFinished = true;
        if (this.handshakeListener != null) {
            this.handshakeListener.onHandshakeFinished();
        }
    }

    private int writePlaintextData(ByteBuffer src, int len) throws SSLException {
        try {
            int sslWrote;
            int pos = src.position();
            if (src.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(src) + (long)pos;
                sslWrote = NativeCrypto.ENGINE_SSL_write_direct(this.sslNativePointer, addr, len, this);
            } else {
                ByteBuffer heapSrc = this.toHeapBuffer(src, len);
                sslWrote = NativeCrypto.ENGINE_SSL_write_heap(this.sslNativePointer, heapSrc.array(), heapSrc.arrayOffset() + heapSrc.position(), len, this);
            }
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
            }
            return sslWrote;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private int readPlaintextData(ByteBuffer dst) throws SSLException {
        try {
            int sslRead;
            int pos = dst.position();
            int limit = dst.limit();
            int len = Math.min(16709, limit - pos);
            if (dst.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(dst) + (long)pos;
                sslRead = NativeCrypto.ENGINE_SSL_read_direct(this.sslNativePointer, addr, len, this);
                if (sslRead > 0) {
                    dst.position(pos + sslRead);
                }
            } else if (dst.hasArray()) {
                sslRead = NativeCrypto.ENGINE_SSL_read_heap(this.sslNativePointer, dst.array(), dst.arrayOffset() + pos, len, this);
                if (sslRead > 0) {
                    dst.position(pos + sslRead);
                }
            } else {
                byte[] data = new byte[len];
                sslRead = NativeCrypto.ENGINE_SSL_read_heap(this.sslNativePointer, data, 0, len, this);
                if (sslRead > 0) {
                    dst.put(data, 0, sslRead);
                }
            }
            return sslRead;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private int writeEncryptedData(ByteBuffer src, int len) throws SSLException {
        try {
            int netWrote;
            int pos = src.position();
            if (src.isDirect()) {
                long addr = NativeCrypto.getDirectBufferAddress(src) + (long)pos;
                netWrote = NativeCrypto.ENGINE_SSL_write_BIO_direct(this.sslNativePointer, this.networkBio, addr, len, this);
            } else {
                ByteBuffer heapSrc = this.toHeapBuffer(src, len);
                netWrote = NativeCrypto.ENGINE_SSL_write_BIO_heap(this.sslNativePointer, this.networkBio, heapSrc.array(), heapSrc.arrayOffset() + heapSrc.position(), len, this);
            }
            if (netWrote >= 0) {
                src.position(pos + netWrote);
            }
            return netWrote;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private SSLEngineResult readPendingBytesFromBIO(ByteBuffer dst, int bytesConsumed, int bytesProduced, SSLEngineResult.HandshakeStatus status) throws SSLException {
        int pendingNet = this.pendingOutboundEncryptedBytes();
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatus(pendingNet)), bytesConsumed, bytesProduced);
            }
            int produced = this.readEncryptedData(dst, pendingNet);
            if (produced <= 0) {
                NativeCrypto.SSL_clear_error();
            } else {
                bytesProduced += produced;
                pendingNet -= produced;
            }
            return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatus(pendingNet)), bytesConsumed, bytesProduced);
        }
        return null;
    }

    private int readEncryptedData(ByteBuffer dst, int pending) throws SSLException {
        try {
            int bioRead = 0;
            if (dst.remaining() >= pending) {
                int pos = dst.position();
                int limit = dst.limit();
                int len = Math.min(pending, limit - pos);
                if (dst.isDirect()) {
                    long addr = NativeCrypto.getDirectBufferAddress(dst) + (long)pos;
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_direct(this.sslNativePointer, this.networkBio, addr, len, this);
                    if (bioRead > 0) {
                        dst.position(pos + bioRead);
                        return bioRead;
                    }
                } else if (dst.hasArray()) {
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_heap(this.sslNativePointer, this.networkBio, dst.array(), dst.arrayOffset() + pos, pending, this);
                    if (bioRead > 0) {
                        dst.position(pos + bioRead);
                        return bioRead;
                    }
                } else {
                    byte[] data = new byte[len];
                    bioRead = NativeCrypto.ENGINE_SSL_read_BIO_heap(this.sslNativePointer, this.networkBio, data, 0, pending, this);
                    if (bioRead > 0) {
                        dst.put(data, 0, bioRead);
                        return bioRead;
                    }
                }
            }
            return bioRead;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus status) throws SSLException {
        if (!this.handshakeFinished && status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return this.handshake();
        }
        return status;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int pending) {
        return !this.handshakeFinished ? OpenSSLEngineImpl.pendingStatus(pending) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.Status getEngineStatus() {
        switch (this.engineState) {
            case CLOSED_INBOUND: 
            case CLOSED_OUTBOUND: 
            case CLOSED: {
                return SSLEngineResult.Status.CLOSED;
            }
        }
        return SSLEngineResult.Status.OK;
    }

    private void closeAll() throws SSLException {
        this.closeOutbound();
        this.closeInbound();
    }

    private SSLEngineResult sslReadErrorResult(int err, int bytesConsumed, int bytesProduced) throws SSLException {
        if (!this.handshakeFinished && this.pendingOutboundEncryptedBytes() > 0) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
        }
        throw this.shutdownWithError(NativeCrypto.SSL_get_error_string(err));
    }

    private SSLException shutdownWithError(String err) {
        this.shutdown();
        if (this.getHandshakeStatusInternal() == SSLEngineResult.HandshakeStatus.FINISHED) {
            return new SSLException(err);
        }
        return new SSLHandshakeException(err);
    }

    private SSLEngineResult newResult(int bytesConsumed, int bytesProduced, SSLEngineResult.HandshakeStatus status) throws SSLException {
        return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(status == SSLEngineResult.HandshakeStatus.FINISHED ? status : this.getHandshakeStatusInternal()), bytesConsumed, bytesProduced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult sSLEngineResult;
            try {
                sSLEngineResult = this.wrap(this.singleSrcBuffer(src), dst);
                this.resetSingleSrcBuffer();
            }
            catch (Throwable throwable) {
                this.resetSingleSrcBuffer();
                throw throwable;
            }
            return sSLEngineResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        OpenSSLEngineImpl.checkNotNull(srcs, "srcs", new Object[0]);
        OpenSSLEngineImpl.checkNotNull(dst, "dst", new Object[0]);
        OpenSSLEngineImpl.checkIndex(srcs.length, offset, length, "srcs");
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            SSLEngineResult pendingNetResult;
            switch (this.engineState) {
                case MODE_SET: {
                    this.beginHandshakeInternal();
                    break;
                }
                case CLOSED_OUTBOUND: 
                case CLOSED: {
                    return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatusInternal(), 0, 0);
                }
                case NEW: {
                    throw new IllegalStateException("Client/server mode must be set before calling wrap");
                }
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (!this.handshakeFinished) {
                handshakeStatus = this.handshake();
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return NEED_UNWRAP_OK;
                }
                if (this.engineState == EngineState.CLOSED) {
                    return NEED_UNWRAP_CLOSED;
                }
            }
            int srcsLen = 0;
            int endOffset = offset + length;
            for (int i = offset; i < endOffset; ++i) {
                ByteBuffer src = srcs[i];
                if (src == null) {
                    throw new IllegalArgumentException("srcs[" + i + "] is null");
                }
                if (srcsLen == 16384 || (srcsLen += src.remaining()) <= 16384 && srcsLen >= 0) continue;
                srcsLen = 16384;
            }
            if (dst.remaining() < SSLUtils.calculateOutNetBufSize(srcsLen)) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatusInternal(), 0, 0);
            }
            int bytesProduced = 0;
            int bytesConsumed = 0;
            block14: for (int i = offset; i < endOffset; ++i) {
                ByteBuffer src = srcs[i];
                OpenSSLEngineImpl.checkNotNull(src, "srcs[%d] is null", i);
                while (src.hasRemaining()) {
                    SSLEngineResult pendingNetResult2;
                    int result = this.writePlaintextData(src, Math.min(src.remaining(), 16384 - bytesConsumed));
                    if (result > 0) {
                        pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed += result, bytesProduced, handshakeStatus);
                        if (pendingNetResult2 != null) {
                            if (pendingNetResult2.getStatus() != SSLEngineResult.Status.OK) {
                                return pendingNetResult2;
                            }
                            bytesProduced = pendingNetResult2.bytesProduced();
                        }
                        if (bytesConsumed != 16384) continue;
                        break block14;
                    }
                    int sslError = NativeCrypto.SSL_get_error(this.sslNativePointer, result);
                    switch (sslError) {
                        case 6: {
                            this.closeAll();
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : CLOSED_NOT_HANDSHAKING;
                        }
                        case 2: {
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, bytesConsumed, bytesProduced);
                        }
                        case 3: {
                            pendingNetResult2 = this.readPendingBytesFromBIO(dst, bytesConsumed, bytesProduced, handshakeStatus);
                            return pendingNetResult2 != null ? pendingNetResult2 : NEED_WRAP_CLOSED;
                        }
                    }
                    throw this.shutdownWithError("SSL_write");
                }
            }
            if (bytesConsumed == 0 && (pendingNetResult = this.readPendingBytesFromBIO(dst, 0, bytesProduced, handshakeStatus)) != null) {
                return pendingNetResult;
            }
            return this.newResult(bytesConsumed, bytesProduced, handshakeStatus);
        }
    }

    @Override
    public int clientPSKKeyRequested(String identityHint, byte[] identity, byte[] key) {
        return this.sslParameters.clientPSKKeyRequested(identityHint, identity, key, this);
    }

    @Override
    public int serverPSKKeyRequested(String identityHint, String identity, byte[] key) {
        return this.sslParameters.serverPSKKeyRequested(identityHint, identity, key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSSLStateChange(int type, int val) {
        Object object = this.stateLock;
        synchronized (object) {
            switch (type) {
                case 32: {
                    if (this.engineState != EngineState.HANDSHAKE_STARTED && this.engineState != EngineState.READY_HANDSHAKE_CUT_THROUGH) {
                        throw new IllegalStateException("Completed handshake while in mode " + (Object)((Object)this.engineState));
                    }
                    this.engineState = EngineState.HANDSHAKE_COMPLETED;
                    break;
                }
                case 16: {
                    this.engineState = EngineState.HANDSHAKE_STARTED;
                }
            }
        }
    }

    @Override
    public void verifyCertificateChain(long[] certRefs, String authMethod) throws CertificateException {
        try {
            X509TrustManager x509tm = this.sslParameters.getX509TrustManager();
            if (x509tm == null) {
                throw new CertificateException("No X.509 TrustManager");
            }
            if (certRefs == null || certRefs.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertChain = OpenSSLX509Certificate.createCertChain(certRefs);
            byte[] ocspData = NativeCrypto.SSL_get_ocsp_response(this.sslNativePointer);
            byte[] tlsSctData = NativeCrypto.SSL_get_signed_cert_timestamp_list(this.sslNativePointer);
            this.handshakeSession = new OpenSSLSessionImpl(NativeCrypto.SSL_get1_session(this.sslNativePointer), null, peerCertChain, ocspData, tlsSctData, this.getPeerHost(), this.getPeerPort(), null);
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                Platform.checkServerTrusted(x509tm, peerCertChain, authMethod, this);
            } else {
                String authType = ((OpenSSLX509Certificate)peerCertChain[0]).getPublicKey().getAlgorithm();
                Platform.checkClientTrusted(x509tm, peerCertChain, authType, this);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        finally {
            this.handshakeSession = null;
        }
    }

    @Override
    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        this.sslParameters.chooseClientCertificate(keyTypeBytes, asn1DerEncodedPrincipals, this.sslNativePointer, this);
    }

    private void shutdown() {
        try {
            NativeCrypto.ENGINE_SSL_shutdown(this.sslNativePointer, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void shutdownAndFreeSslNative() {
        try {
            this.shutdown();
        }
        finally {
            this.free();
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        NativeCrypto.BIO_free_all(this.networkBio);
        this.sslNativePointer = 0L;
        this.networkBio = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public String chooseServerAlias(X509KeyManager keyManager, String keyType) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineServerAlias(keyType, null, this);
        }
        return keyManager.chooseServerAlias(keyType, null, null);
    }

    @Override
    public String chooseClientAlias(X509KeyManager keyManager, X500Principal[] issuers, String[] keyTypes) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineClientAlias(keyTypes, issuers, this);
        }
        return keyManager.chooseClientAlias(keyTypes, issuers, null);
    }

    @Override
    public String chooseServerPSKIdentityHint(PSKKeyManager keyManager) {
        return keyManager.chooseServerKeyIdentityHint(this);
    }

    @Override
    public String chooseClientPSKIdentity(PSKKeyManager keyManager, String identityHint) {
        return keyManager.chooseClientKeyIdentity(identityHint, this);
    }

    @Override
    public SecretKey getPSKKey(PSKKeyManager keyManager, String identityHint, String identity) {
        return keyManager.getKey(identityHint, identity, this);
    }

    public void setUseSessionTickets(boolean useSessionTickets) {
        this.sslParameters.useSessionTickets = useSessionTickets;
    }

    public void setNpnProtocols(byte[] npnProtocols) {
    }

    public void setAlpnProtocols(byte[] alpnProtocols) {
        if (alpnProtocols != null && alpnProtocols.length == 0) {
            throw new IllegalArgumentException("alpnProtocols.length == 0");
        }
        this.sslParameters.alpnProtocols = alpnProtocols;
    }

    public byte[] getNpnSelectedProtocol() {
        return null;
    }

    public byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.SSL_get0_alpn_selected(this.sslNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer toHeapBuffer(ByteBuffer buffer, int len) {
        if (buffer.hasArray()) {
            return buffer;
        }
        ByteBuffer heapBuffer = ByteBuffer.allocate(len);
        int pos = buffer.position();
        int limit = buffer.limit();
        buffer.limit(pos + len);
        try {
            heapBuffer.put(buffer);
            heapBuffer.flip();
            ByteBuffer byteBuffer = heapBuffer;
            return byteBuffer;
        }
        finally {
            buffer.limit(limit);
            buffer.position(pos);
        }
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer src) {
        this.singleSrcBuffer[0] = src;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer src) {
        this.singleDstBuffer[0] = src;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    private static void checkIndex(int arrayLength, int offset, int length, String arrayName) {
        if ((offset | length) < 0 || offset + length > arrayLength) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + " (expected: offset <= offset + length <= " + arrayName + ".length (" + arrayLength + "))");
        }
    }

    private static <T> T checkNotNull(T obj, String fmt, Object ... args) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format(fmt, args));
        }
        return obj;
    }

    private static enum EngineState {
        NEW,
        MODE_SET,
        HANDSHAKE_STARTED,
        HANDSHAKE_COMPLETED,
        READY_HANDSHAKE_CUT_THROUGH,
        READY,
        CLOSED_INBOUND,
        CLOSED_OUTBOUND,
        CLOSED;

    }

    public static interface HandshakeListener {
        public void onHandshakeFinished() throws SSLException;
    }
}

