/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import org.conscrypt.AbstractSessionContext;

public abstract class AbstractOpenSSLSession
implements SSLSession {
    private final Map<String, Object> values = new HashMap<String, Object>();
    private volatile javax.security.cert.X509Certificate[] peerCertificateChain;
    private AbstractSessionContext sessionContext;
    private boolean isValid = true;

    protected AbstractOpenSSLSession(AbstractSessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    protected abstract X509Certificate[] getX509PeerCertificates() throws SSLPeerUnverifiedException;

    protected abstract X509Certificate[] getX509LocalCertificates();

    private void checkPeerCertificatesPresent() throws SSLPeerUnverifiedException {
        X509Certificate[] peerCertificates = this.getX509PeerCertificates();
        if (peerCertificates == null || peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.getX509PeerCertificates();
    }

    @Override
    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        javax.security.cert.X509Certificate[] result = this.peerCertificateChain;
        if (result == null) {
            result = this.createPeerCertificateChain();
            this.peerCertificateChain = result;
        }
        return result;
    }

    private javax.security.cert.X509Certificate[] createPeerCertificateChain() throws SSLPeerUnverifiedException {
        X509Certificate[] peerCertificates = this.getX509PeerCertificates();
        try {
            javax.security.cert.X509Certificate[] chain = new javax.security.cert.X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                byte[] encoded = peerCertificates[i].getEncoded();
                chain[i] = javax.security.cert.X509Certificate.getInstance(encoded);
            }
            return chain;
        }
        catch (CertificateEncodingException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
        catch (CertificateException e) {
            SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
            exception.initCause(exception);
            throw exception;
        }
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.getX509PeerCertificates()[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        X509Certificate[] localCertificates = this.getX509LocalCertificates();
        if (localCertificates != null && localCertificates.length > 0) {
            return localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.getX509LocalCertificates();
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public int getPacketBufferSize() {
        return 16709;
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        return this.values.get(name);
    }

    @Override
    public String[] getValueNames() {
        return this.values.keySet().toArray(new String[this.values.size()]);
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name == null || value == null");
        }
        Object old = this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        Object old = this.values.remove(name);
        if (old instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)old;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        SSLSessionContext context = this.getSessionContext();
        if (context == null) {
            return true;
        }
        int timeoutSeconds = context.getSessionTimeout();
        if (timeoutSeconds == 0) {
            return true;
        }
        long creationTimestampMillis = this.getCreationTime();
        long ageSeconds = (System.currentTimeMillis() - creationTimestampMillis) / 1000L;
        if (ageSeconds >= (long)timeoutSeconds || ageSeconds < 0L) {
            this.isValid = false;
            return false;
        }
        return true;
    }

    @Override
    public void invalidate() {
        this.isValid = false;
        this.sessionContext = null;
    }

    public abstract String getRequestedServerName();

    public abstract List<byte[]> getStatusResponses();

    public abstract byte[] getTlsSctData();

    public abstract void setLastAccessedTime(long var1);

    abstract void resetId();
}

