/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.HashMap;
import java.util.Map;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.SSLClientSessionCache;
import org.conscrypt.SSLParametersImpl;
import org.conscrypt.SslSessionWrapper;

public final class ClientSessionContext
extends AbstractSessionContext {
    private final Map<HostAndPort, SslSessionWrapper> sessionsByHostAndPort = new HashMap<HostAndPort, SslSessionWrapper>();
    private SSLClientSessionCache persistentCache;

    ClientSessionContext() {
        super(10);
    }

    public void setPersistentCache(SSLClientSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    SslSessionWrapper getCachedSession(String hostName, int port, SSLParametersImpl sslParameters) {
        if (hostName == null) {
            return null;
        }
        SslSessionWrapper session = this.getSession(hostName, port);
        if (session == null) {
            return null;
        }
        String protocol = session.getProtocol();
        boolean protocolFound = false;
        for (String enabledProtocol : sslParameters.enabledProtocols) {
            if (!protocol.equals(enabledProtocol)) continue;
            protocolFound = true;
            break;
        }
        if (!protocolFound) {
            return null;
        }
        String cipherSuite = session.getCipherSuite();
        boolean cipherSuiteFound = false;
        for (String enabledCipherSuite : sslParameters.enabledCipherSuites) {
            if (!cipherSuite.equals(enabledCipherSuite)) continue;
            cipherSuiteFound = true;
            break;
        }
        if (!cipherSuiteFound) {
            return null;
        }
        return session;
    }

    int size() {
        return this.sessionsByHostAndPort.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SslSessionWrapper getSession(String host, int port) {
        byte[] data;
        SslSessionWrapper session;
        if (host == null) {
            return null;
        }
        HostAndPort key = new HostAndPort(host, port);
        Map<HostAndPort, SslSessionWrapper> map = this.sessionsByHostAndPort;
        synchronized (map) {
            session = this.sessionsByHostAndPort.get(key);
        }
        if (session != null && session.isValid()) {
            return session;
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(host, port)) != null && (session = SslSessionWrapper.newInstance(this, data, host, port)) != null && session.isValid()) {
            Map<HostAndPort, SslSessionWrapper> map2 = this.sessionsByHostAndPort;
            synchronized (map2) {
                this.sessionsByHostAndPort.put(key, session);
            }
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onBeforeAddSession(SslSessionWrapper session) {
        byte[] data;
        String host = session.getPeerHost();
        int port = session.getPeerPort();
        if (host == null) {
            return;
        }
        HostAndPort key = new HostAndPort(host, port);
        Map<HostAndPort, SslSessionWrapper> map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.put(key, session);
        }
        if (this.persistentCache != null && (data = session.toBytes()) != null) {
            this.persistentCache.putSessionData(session.toSSLSession(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onBeforeRemoveSession(SslSessionWrapper session) {
        String host = session.getPeerHost();
        if (host == null) {
            return;
        }
        int port = session.getPeerPort();
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map<HostAndPort, SslSessionWrapper> map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.remove(hostAndPortKey);
        }
    }

    @Override
    SslSessionWrapper getSessionFromPersistentCache(byte[] sessionId) {
        return null;
    }

    private static final class HostAndPort {
        final String host;
        final int port;

        HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode() * 31 + this.port;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostAndPort)) {
                return false;
            }
            HostAndPort lhs = (HostAndPort)o;
            return this.host.equals(lhs.host) && this.port == lhs.port;
        }
    }
}

