/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.web.provider;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.concordion.cubano.config.Config;
import org.concordion.cubano.config.PropertyLoader;
import org.concordion.cubano.config.ProxyConfig;
import org.concordion.cubano.driver.web.config.WebDriverConfig;
import org.concordion.cubano.driver.web.provider.BrowserProvider;
import org.concordion.cubano.driver.web.provider.CheckForUpdates;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

public abstract class LocalBrowserProvider
implements BrowserProvider {
    private PropertyLoader propertyLoader = Config.getInstance().getPropertyLoader();
    private ProxyConfig proxyConfig = Config.getInstance().getProxyConfig();
    private WebDriverConfig config = WebDriverConfig.getInstance();
    protected String driverPath = null;

    protected abstract String getBrowserName();

    protected void setupBrowserManager(WebDriverManager instance) {
        Map result = this.propertyLoader.getPropertiesStartingWith("wdm.");
        Map override = this.propertyLoader.getPropertiesStartingWith(this.getBrowserName() + ".wdm.");
        for (String key : override.keySet()) {
            result.put(key.substring(this.getBrowserName().length() + 1), override.get(key));
        }
        block11: for (String key : result.keySet()) {
            String value = (String)result.get(key);
            switch (key.toLowerCase()) {
                case "wdm.architecture": {
                    instance.architecture(Architecture.valueOf((String)value));
                    break;
                }
                case "wdm.checkforupdates": {
                    String prefKey;
                    CheckForUpdates check = CheckForUpdates.valueOf(value.toUpperCase());
                    if (check == CheckForUpdates.ALWAYS) continue block11;
                    Preferences prefs = Preferences.userNodeForPackage(LocalBrowserProvider.class);
                    Date lastChecked = new Date(prefs.getLong(prefKey = this.getBrowserName() + ".last_checked_time", new Date(0L).getTime()));
                    if (check.recheckIsRequired(lastChecked)) {
                        prefs.putLong(prefKey, new Date().getTime());
                        try {
                            prefs.flush();
                            break;
                        }
                        catch (BackingStoreException e) {
                            throw new RuntimeException("Unable to update last checked date", e);
                        }
                    }
                    instance.forceCache();
                    break;
                }
                default: {
                    System.setProperty(key, value);
                }
            }
        }
        if (!this.proxyConfig.getProxyAddress().isEmpty()) {
            instance.proxy(this.proxyConfig.getProxyAddress());
            instance.proxyUser(this.proxyConfig.getProxyUsername());
            instance.proxyPass(this.proxyConfig.getProxyPassword());
        }
        instance.setup();
        this.driverPath = instance.getBinaryPath();
    }

    public String getBrowserExe() {
        String localBrowserExe = this.propertyLoader.getProperty(this.getBrowserName() + ".exe", null);
        if (!localBrowserExe.isEmpty()) {
            return localBrowserExe.replace("%USERPROFILE%", System.getProperty("USERPROFILE", ""));
        }
        return "";
    }

    protected void addProxyCapabilities(MutableCapabilities capabilities) {
        if (!this.proxyConfig.isProxyRequired()) {
            return;
        }
        String browserProxy = this.proxyConfig.getProxyAddress();
        String browserNonProxyHosts = this.proxyConfig.getNonProxyHosts();
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        proxy.setHttpProxy(browserProxy);
        proxy.setFtpProxy(browserProxy);
        proxy.setSslProxy(browserProxy);
        if (!browserNonProxyHosts.isEmpty()) {
            proxy.setNoProxy(browserNonProxyHosts);
        }
        capabilities.setCapability("proxy", (Object)proxy);
        capabilities.setCapability("acceptSslCerts", true);
    }

    protected void setBrowserSizeAndLocation(WebDriver driver) {
        if (this.config.isBrowserMaximized()) {
            driver.manage().window().maximize();
        } else {
            if (!this.config.getBrowserDimension().isEmpty()) {
                driver.manage().window().setSize(this.getBrowserDimension());
            }
            if (!this.config.getBrowserPosition().isEmpty()) {
                driver.manage().window().setPosition(this.getBrowserPosition());
            }
        }
    }

    private Dimension getBrowserDimension() {
        String width = this.config.getBrowserDimension().substring(0, this.config.getBrowserDimension().indexOf("x")).trim();
        String height = this.config.getBrowserDimension().substring(this.config.getBrowserDimension().indexOf("x") + 1).trim();
        return new Dimension(Integer.parseInt(width), Integer.parseInt(height));
    }

    private Point getBrowserPosition() {
        String x = this.config.getBrowserPosition().substring(0, this.config.getBrowserPosition().indexOf("x")).trim();
        String y = this.config.getBrowserPosition().substring(this.config.getBrowserPosition().indexOf("x") + 1).trim();
        return new Point(Integer.parseInt(x), Integer.parseInt(y));
    }

    protected String getProperty(String key, String defaultValue) {
        return this.propertyLoader.getProperty(this.getBrowserName() + "." + key, defaultValue);
    }

    protected boolean getPropertyAsBoolean(String key, String defaultValue) {
        return this.propertyLoader.getPropertyAsBoolean(this.getBrowserName() + "." + key, defaultValue);
    }

    protected int getPropertyAsInteger(String key, String defaultValue) {
        return this.propertyLoader.getPropertyAsInteger(this.getBrowserName() + "." + key, defaultValue);
    }

    protected Map<String, String> getPropertiesStartingWith(String key) {
        return this.propertyLoader.getPropertiesStartingWith(this.getBrowserName() + "." + key, true);
    }

    protected Object toObject(String value) {
        Class<?> valueClass = this.getClassOfValue(value);
        if (valueClass == null) {
            return null;
        }
        if (valueClass == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (valueClass == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        return value;
    }

    protected Class<?> getClassOfValue(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return Boolean.class;
        }
        if (value.matches("^-?\\d+$")) {
            return Integer.TYPE;
        }
        return String.class;
    }

    public void cleanup() {
        if (this.driverPath != null) {
            try {
                Runtime.getRuntime().exec("taskkill /F /IM " + new File(this.driverPath).getName());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close browser driver", e);
            }
        }
    }
}

