/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.footnotes;

import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.footnotes.internal.FootnoteBlockParser;
import org.commonmark.ext.footnotes.internal.FootnoteHtmlNodeRenderer;
import org.commonmark.ext.footnotes.internal.FootnoteLinkProcessor;
import org.commonmark.ext.footnotes.internal.FootnoteMarkdownNodeRenderer;
import org.commonmark.parser.Parser;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import org.commonmark.renderer.markdown.MarkdownRenderer;

public class FootnotesExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
MarkdownRenderer.MarkdownRendererExtension {
    private final boolean inlineFootnotes;

    private FootnotesExtension(boolean inlineFootnotes) {
        this.inlineFootnotes = inlineFootnotes;
    }

    public static Extension create() {
        return FootnotesExtension.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customBlockParserFactory((BlockParserFactory)new FootnoteBlockParser.Factory()).linkProcessor((LinkProcessor)new FootnoteLinkProcessor());
        if (this.inlineFootnotes) {
            parserBuilder.linkMarker(Character.valueOf('^'));
        }
    }

    public void extend(HtmlRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(FootnoteHtmlNodeRenderer::new);
    }

    public void extend(MarkdownRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(new MarkdownNodeRendererFactory(){

            public NodeRenderer create(MarkdownNodeRendererContext context) {
                return new FootnoteMarkdownNodeRenderer(context);
            }

            public Set<Character> getSpecialCharacters() {
                return Set.of();
            }
        });
    }

    public static class Builder {
        private boolean inlineFootnotes = false;

        public Builder inlineFootnotes(boolean inlineFootnotes) {
            this.inlineFootnotes = inlineFootnotes;
            return this;
        }

        public FootnotesExtension build() {
            return new FootnotesExtension(this.inlineFootnotes);
        }
    }
}

