/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.json.ser;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.commonjava.web.json.ser.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServletSerializerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletSerializerUtils.class);

    private ServletSerializerUtils() {
    }

    public static <T> T fromRequestBody(HttpServletRequest req, JsonSerializer serializer, Class<T> type) {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return serializer.fromStream((InputStream)req.getInputStream(), encoding, type);
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize type: {} from HttpServletRequest body. Error: {}", new Object[]{e, type.getName(), e.getMessage()});
            throw new RuntimeException("Cannot read request.");
        }
    }

    public static <T> T fromRequestBody(HttpServletRequest req, JsonSerializer serializer, TypeToken<T> token) {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return serializer.fromStream((InputStream)req.getInputStream(), encoding, token);
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize type: {} from HttpServletRequest body. Error: {}", new Object[]{e, token.getType(), e.getMessage()});
            throw new RuntimeException("Cannot read request.");
        }
    }
}

