/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.MultiMap;

public class HttpHeadersAdapter
implements MultiMap {
    private final HttpHeaders headers;

    public HttpHeadersAdapter(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.entries();
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.headers.names();
    }

    @Override
    public MultiMap add(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public MultiMap add(String name, Iterable<String> values) {
        this.headers.add(name, values);
        return this;
    }

    @Override
    public MultiMap add(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap add(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap set(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public MultiMap set(String name, Iterable<String> values) {
        this.headers.set(name, values);
        return this;
    }

    @Override
    public MultiMap set(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap remove(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public MultiMap clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.iterator();
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public MultiMap set(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

