/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config;

import java.util.HashMap;
import java.util.Map;
import org.commonjava.util.logging.Logger;
import org.commonjava.web.config.ConfigUtils;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.ConfigurationListener;
import org.commonjava.web.config.annotation.SectionName;
import org.commonjava.web.config.section.BeanSectionListener;
import org.commonjava.web.config.section.ConfigurationSectionListener;
import org.commonjava.web.config.section.TypedConfigurationSectionListener;

public class DefaultConfigurationListener
implements ConfigurationListener {
    private final Logger logger = new Logger(this.getClass());
    private final Map<String, ConfigurationSectionListener<?>> sectionListeners = new HashMap();

    public DefaultConfigurationListener() {
    }

    public DefaultConfigurationListener(Class<?> ... sectionTypes) throws ConfigurationException {
        for (Class<?> type : sectionTypes) {
            this.processSectionAnnotation(type, null);
        }
    }

    public DefaultConfigurationListener(ConfigurationSectionListener<?> ... sectionTypes) throws ConfigurationException {
        for (ConfigurationSectionListener<?> type : sectionTypes) {
            if (!(type instanceof TypedConfigurationSectionListener)) {
                throw new ConfigurationException("Cannot automatically register section listener: %s", type);
            }
            Class cls = ((TypedConfigurationSectionListener)type).getConfigurationType();
            this.processSectionAnnotation(cls, type);
        }
    }

    private void processSectionAnnotation(Class cls, ConfigurationSectionListener listener) throws ConfigurationException {
        String key = ConfigUtils.getSectionName(cls);
        this.registerListener(key, listener == null ? new BeanSectionListener<Class>(cls) : listener);
    }

    private void registerListener(String key, ConfigurationSectionListener listener) throws ConfigurationException {
        ConfigurationSectionListener<?> existing = this.sectionListeners.get(key);
        if (existing != null && listener != existing) {
            throw new ConfigurationException("Section collision! More than one ConfigurationParser bound to section: %s\n\t%s\n\t%s", key, this.sectionListeners.get(key), listener);
        }
        this.sectionListeners.put(key, listener);
    }

    @Override
    public Map<String, ConfigurationSectionListener<?>> getSectionListeners() {
        return this.sectionListeners;
    }

    public DefaultConfigurationListener with(ConfigurationSectionListener<?> ... listeners) throws ConfigurationException {
        for (ConfigurationSectionListener<?> listener : listeners) {
            this.processSectionAnnotation(listener.getClass(), listener);
        }
        return this;
    }

    public DefaultConfigurationListener with(ConfigurationSectionListener<?> listener) throws ConfigurationException {
        return this.with(null, (Object)listener);
    }

    public DefaultConfigurationListener with(String sectionName, ConfigurationSectionListener<?> listener) throws ConfigurationException {
        String key = sectionName == null ? ConfigUtils.getSectionName(listener.getClass()) : sectionName;
        this.logger.info("+section (listener): %s (%s)", key, listener);
        this.registerListener(key, listener);
        return this;
    }

    public <T> DefaultConfigurationListener with(Class<T> beanCls) throws ConfigurationException {
        return this.with(null, (T)beanCls);
    }

    public <T> DefaultConfigurationListener with(String sectionName, Class<T> beanCls) throws ConfigurationException {
        String key = sectionName == null ? ConfigUtils.getSectionName(beanCls) : sectionName;
        this.logger.info("+section (class): %s (%s)", key, beanCls.getName());
        this.registerListener(key, new BeanSectionListener<Class<T>>(beanCls));
        return this;
    }

    public <T> DefaultConfigurationListener with(T bean) throws ConfigurationException {
        return this.with(null, bean);
    }

    public <T> DefaultConfigurationListener with(String sectionName, T bean) throws ConfigurationException {
        String key = sectionName == null ? ConfigUtils.getSectionName(bean.getClass()) : sectionName;
        this.logger.info("+section (bean): %s (%s)", key, bean);
        this.registerListener(key, new BeanSectionListener<T>(bean));
        return this;
    }

    @Override
    public void configurationComplete() throws ConfigurationException {
    }

    public <T> T getConfiguration(String sectionName, Class<T> type) {
        ConfigurationSectionListener<?> listener = this.sectionListeners.get(sectionName);
        return listener == null ? null : (T)type.cast(listener.getConfiguration());
    }

    public <T> T getConfiguration(Class<T> type) throws ConfigurationException {
        SectionName secName = type.getAnnotation(SectionName.class);
        if (secName == null) {
            throw new ConfigurationException("Cannot find @SectionName annotation for: %s. Cannot lookup configuration section.", type.getName());
        }
        ConfigurationSectionListener<?> listener = this.sectionListeners.get(secName.value());
        Object configuration = listener == null ? null : listener.getConfiguration();
        return configuration == null ? null : (T)type.cast(configuration);
    }
}

