/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.data;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.data.FreekiStore;
import org.commonjava.freeki.data.TemplateException;
import org.commonjava.freeki.model.Template;
import org.commonjava.freeki.model.TemplateAction;
import org.commonjava.util.logging.Logger;

public class TemplateController {
    private final Logger logger = new Logger(this.getClass());
    private final FreekiConfig conf;
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private final FreekiStore store;

    public TemplateController(FreekiStore store, FreekiConfig conf) {
        this.store = store;
        this.conf = conf;
        this.loadTemplates();
    }

    private void loadTemplates() {
        File dir = this.conf.getTemplatesDir();
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.getName().startsWith(".") || !file.isDirectory()) continue;
                String label = file.getName();
                File html = new File(file, label + ".html");
                File script = new File(file, label + ".groovy");
                this.templates.put(label, new Template(label, html, script));
            }
        }
    }

    public List<String> getTemplateLabels() {
        ArrayList<String> labels = new ArrayList<String>(this.templates.keySet());
        Collections.sort(labels);
        return labels;
    }

    public File getTemplateHtml(String label) {
        Template template = this.templates.get(label);
        if (template != null) {
            return template.getHtml();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runTemplateAction(String label, Map<String, String> params) throws TemplateException {
        String string;
        block10: {
            Template template = this.templates.get(label);
            if (template == null) {
                throw new TemplateException("Cannot find template: '%s'", label);
            }
            File templateFile = template.getScript();
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(params);
            GroovyClassLoader gcl = null;
            try {
                gcl = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());
                TemplateAction action = null;
                try {
                    Class scriptCls = gcl.parseClass(templateFile);
                    action = (TemplateAction)TemplateAction.class.cast(scriptCls.newInstance());
                }
                catch (IOException | IllegalAccessException | InstantiationException | CompilationFailedException e) {
                    throw new TemplateException("Failed to read/compile/instantiate template action from script: %s. Reason: %s", (Throwable)e, templateFile, e.getMessage());
                }
                this.logger.info("Running action: %s from: %s\nwith params:\n\n%s", action, templateFile, params);
                string = action.run(params, this.store);
                if (gcl == null) break block10;
            }
            catch (Throwable throwable) {
                if (gcl != null) {
                    try {
                        gcl.close();
                    }
                    catch (IOException e) {
                        this.logger.error("POTENTIAL RESOURCE LEAK: Failed to close GroovyClassLoader for template: %s. Reason: %s", e, label, e.getMessage());
                    }
                }
                throw throwable;
            }
            try {
                gcl.close();
            }
            catch (IOException e) {
                this.logger.error("POTENTIAL RESOURCE LEAK: Failed to close GroovyClassLoader for template: %s. Reason: %s", e, label, e.getMessage());
            }
        }
        return string;
    }
}

