/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.conf;

import java.io.File;
import org.kohsuke.args4j.Option;

public class FreekiConfig {
    private static final String USER_HOME = System.getProperty("user.home");
    public static final File DEFAULT_CONTENT_DIR = new File(USER_HOME, "freeki");
    public static final String DEFAULT_BRANDING_SUBPATH = ".branding";
    public static final String DEFAULT_TEMPLATE_SUBPATH = ".templates";
    public static final String DEFAULT_STATIC_SUBPATH = "static";
    public static final String DEFAULT_LISTEN = "localhost";
    public static final Integer DEFAULT_PORT = 8080;
    @Option(name="-h", aliases={"--help"}, usage="Show this help screen")
    private Boolean help;
    @Option(name="-p", aliases={"--port"}, usage="Port to listen on (default: 8080)")
    private Integer port;
    @Option(name="-l", aliases={"--listen"}, usage="Host or IP address to listen on (default: localhost)")
    private String listen;
    @Option(name="-c", aliases={"--content"}, usage="Content directory (default: $HOME/freeki)")
    private File contentDir;
    @Option(name="-b", aliases={"--branding"}, usage="Branding content directory (default: $HOME/freeki/.branding)")
    private File brandingDir;
    @Option(name="-r", aliases={"--read-only"}, usage="Prohibit modification of content; view only.")
    private Boolean readOnly;
    @Option(name="-s", aliases={"--static"}, usage="Static content directory (default: $HOME/freeki/.branding/static)")
    private File staticDir;
    @Option(name="-t", aliases={"--templates"}, usage="Templates directory (default: $HOME/freeki/.templates)")
    private File templatesDir;

    public FreekiConfig() {
    }

    public FreekiConfig(File storageDir) {
        this(storageDir, null, null, null);
    }

    public FreekiConfig(File contentDir, File brandingDir, File staticDir, File templatesDir) {
        this.contentDir = contentDir;
        this.brandingDir = brandingDir;
        this.staticDir = staticDir;
        this.templatesDir = templatesDir;
    }

    public File getContentDir() {
        return this.contentDir == null ? DEFAULT_CONTENT_DIR : this.contentDir;
    }

    public void setContentDir(File contentDir) {
        this.contentDir = contentDir;
    }

    public File getBrandingDir() {
        return this.brandingDir == null ? new File(this.getContentDir(), DEFAULT_BRANDING_SUBPATH) : this.brandingDir;
    }

    public void setBrandingDir(File brandingDir) {
        this.brandingDir = brandingDir;
    }

    public File getTemplatesDir() {
        return this.templatesDir == null ? new File(this.getContentDir(), DEFAULT_TEMPLATE_SUBPATH) : this.templatesDir;
    }

    public void setTemplatesDir(File templatesDir) {
        this.templatesDir = templatesDir;
    }

    public File getStaticDir() {
        return this.staticDir == null ? new File(this.getBrandingDir(), DEFAULT_STATIC_SUBPATH) : this.staticDir;
    }

    public void setStaticDir(File staticDir) {
        this.staticDir = staticDir;
    }

    public boolean isHelp() {
        return this.help == null ? false : this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isReadOnly() {
        return this.readOnly == null ? false : this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getListen() {
        return this.listen == null ? DEFAULT_LISTEN : this.listen;
    }

    public void setListen(String listen) {
        this.listen = listen;
    }

    public int getPort() {
        return this.port == null ? DEFAULT_PORT : this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void overrideWith(FreekiConfig overrides) {
        if (overrides.help != null) {
            this.help = overrides.help;
        }
        if (overrides.brandingDir != null) {
            this.brandingDir = overrides.brandingDir;
        }
        if (overrides.contentDir != null) {
            this.contentDir = overrides.contentDir;
        }
        if (overrides.listen != null) {
            this.listen = overrides.listen;
        }
        if (overrides.port != null) {
            this.port = overrides.port;
        }
        if (overrides.staticDir != null) {
            this.staticDir = overrides.staticDir;
        }
        if (overrides.templatesDir != null) {
            this.templatesDir = overrides.templatesDir;
        }
        if (overrides.readOnly != null) {
            this.readOnly = overrides.readOnly;
        }
    }
}

