/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import java.util.List;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorUtils {
    private ErrorUtils() {
    }

    static Matcher findProperLabelMatcher(MatcherPath matcherPath, int n) {
        Matcher matcher;
        Preconditions.checkArgNotNull(matcherPath, "path");
        Matcher matcher2 = matcher = matcherPath.parent != null ? ErrorUtils.findProperLabelMatcher(matcherPath.parent, n) : null;
        if (matcher != null) {
            return matcher;
        }
        if (matcherPath.element.startIndex == n && matcherPath.element.matcher.hasCustomLabel()) {
            return matcherPath.element.matcher;
        }
        return null;
    }

    public static String printParseErrors(ParsingResult<?> parsingResult) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        return ErrorUtils.printParseErrors(parsingResult.parseErrors);
    }

    public static String printParseErrors(List<ParseError> list) {
        Preconditions.checkArgNotNull(list, "errors");
        StringBuilder stringBuilder = new StringBuilder();
        for (ParseError parseError : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("---\n");
            }
            stringBuilder.append(ErrorUtils.printParseError(parseError));
        }
        return stringBuilder.toString();
    }

    public static String printParseError(ParseError parseError) {
        Preconditions.checkArgNotNull(parseError, "error");
        return ErrorUtils.printParseError(parseError, new DefaultInvalidInputErrorFormatter());
    }

    public static String printParseError(ParseError parseError, Formatter<InvalidInputError> formatter) {
        Preconditions.checkArgNotNull(parseError, "error");
        Preconditions.checkArgNotNull(formatter, "formatter");
        String string = parseError.getErrorMessage() != null ? parseError.getErrorMessage() : (parseError instanceof InvalidInputError ? formatter.format((InvalidInputError)parseError) : parseError.getClass().getSimpleName());
        return ErrorUtils.printErrorMessage("%s (line %s, pos %s):", string, parseError.getStartIndex(), parseError.getEndIndex(), parseError.getInputBuffer());
    }

    public static String printErrorMessage(String string, String string2, int n, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        return ErrorUtils.printErrorMessage(string, string2, n, n + 1, inputBuffer);
    }

    public static String printErrorMessage(String string, String string2, int n, int n2, InputBuffer inputBuffer) {
        int n3;
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        Preconditions.checkArgument(n <= n2);
        Position position = inputBuffer.getPosition(n);
        StringBuilder stringBuilder = new StringBuilder(String.format(string, string2, position.line, position.column));
        stringBuilder.append('\n');
        String string3 = inputBuffer.extractLine(position.line);
        stringBuilder.append(string3);
        stringBuilder.append('\n');
        int n4 = Math.max(Math.min(n2 - n, StringUtils.length(string3) - position.column + 2), 1);
        for (n3 = 0; n3 < position.column - 1; ++n3) {
            stringBuilder.append(' ');
        }
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuilder.append('^');
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

