/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.json.ser;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.commonjava.util.logging.Logger;
import org.commonjava.web.json.ser.JsonSerializer;

public final class ServletSerializerUtils {
    private static final Logger LOGGER = new Logger(ServletSerializerUtils.class);

    private ServletSerializerUtils() {
    }

    public static <T> T fromRequestBody(HttpServletRequest req, JsonSerializer serializer, Class<T> type) {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return serializer.fromStream((InputStream)req.getInputStream(), encoding, type);
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize type: %s from HttpServletRequest body. Error: %s", e, type.getName(), e.getMessage());
            throw new RuntimeException("Cannot read request.");
        }
    }

    public static <T> T fromRequestBody(HttpServletRequest req, JsonSerializer serializer, TypeToken<T> token) {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return serializer.fromStream((InputStream)req.getInputStream(), encoding, token);
        }
        catch (IOException e) {
            LOGGER.error("Failed to deserialize type: %s from HttpServletRequest body. Error: %s", e, token.getType(), e.getMessage());
            throw new RuntimeException("Cannot read request.");
        }
    }
}

