/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.model;

import java.io.File;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.commonjava.freeki.infra.anno.RenderKey;
import org.commonjava.freeki.model.ChildRef;

@RenderKey(key="group", contentTemplate="${data.name}")
public class Group
implements Comparable<Group> {
    private String name;
    private String parent;
    private SortedSet<ChildRef> children;

    public Group() {
    }

    public Group(String name) {
        this.name = name;
        this.parent = new File(name).getParent();
    }

    public Group(String name, Collection<ChildRef> children) {
        this.children = new TreeSet<ChildRef>(children);
        this.name = name;
        this.parent = new File(name).getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Group other) {
        return this.name.compareTo(other.name);
    }

    public SortedSet<ChildRef> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ChildRef> pages) {
        this.children = new TreeSet<ChildRef>(pages);
    }

    public static String nameFor(String subgroup, String fname) {
        String n = fname;
        if (subgroup != null) {
            n = new File(subgroup, fname).getPath();
        }
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return n;
    }

    public void setChildren(SortedSet<ChildRef> children) {
        this.children = children;
    }

    public String toString() {
        return String.format("Group [%s]", this.name);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }
}

