/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.infra.render.tmpl;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.freeki.conf.GTemplateConfig;
import org.commonjava.freeki.infra.render.ContentRenderer;
import org.commonjava.freeki.infra.render.RenderUtils;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.util.ContentType;

public class GTTextRenderer
implements ContentRenderer {
    private static final ContentType[] TYPES = new ContentType[]{ContentType.TEXT_PLAIN};
    private final GStringTemplateEngine engine;
    private final GTemplateConfig config;

    public GTTextRenderer(GStringTemplateEngine engine, GTemplateConfig config) {
        this.engine = engine;
        this.config = config;
    }

    @Override
    public ContentType[] getContentTypes() {
        return TYPES;
    }

    @Override
    public String render(Object data, Map<String, String> requestParams) throws RenderingException {
        String path = this.config.getTemplate(ContentType.TEXT_PLAIN, RenderUtils.getTemplateKey(data));
        try {
            Template template;
            File templateFile = new File(this.config.getBrandingDir(), path);
            if (templateFile.exists() && !templateFile.isDirectory()) {
                template = this.engine.createTemplate(templateFile);
            } else {
                URL u = Thread.currentThread().getContextClassLoader().getResource(path);
                Template template2 = template = u == null ? null : this.engine.createTemplate(u);
            }
            if (template == null) {
                throw new RenderingException("Failed to locate template: %s", path);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", data);
            map.put("readOnly", this.config.isReadOnly());
            map.put("params", requestParams);
            Writable output = template.make(map);
            StringWriter writer = new StringWriter();
            output.writeTo(writer);
            return writer.toString();
        }
        catch (IOException | ClassNotFoundException | CompilationFailedException e) {
            throw new RenderingException("Failed to load template: %s. Reason: %s", (Throwable)e, path, e.getMessage());
        }
    }
}

